#include "src/ast/ast.h"
#include "src/builtins/builtins-array-gen.h"
#include "src/builtins/builtins-bigint-gen.h"
#include "src/builtins/builtins-call-gen.h"
#include "src/builtins/builtins-collections-gen.h"
#include "src/builtins/builtins-constructor-gen.h"
#include "src/builtins/builtins-data-view-gen.h"
#include "src/builtins/builtins-iterator-gen.h"
#include "src/builtins/builtins-object-gen.h"
#include "src/builtins/builtins-promise-gen.h"
#include "src/builtins/builtins-promise.h"
#include "src/builtins/builtins-proxy-gen.h"
#include "src/builtins/builtins-regexp-gen.h"
#include "src/builtins/builtins-string-gen.h"
#include "src/builtins/builtins-typed-array-gen.h"
#include "src/builtins/builtins-utils-gen.h"
#include "src/builtins/builtins-wasm-gen.h"
#include "src/builtins/builtins.h"
#include "src/codegen/code-factory.h"
#include "src/debug/debug-wasm-objects.h"
#include "src/heap/factory-inl.h"
#include "src/ic/binary-op-assembler.h"
#include "src/ic/handler-configuration-inl.h"
#include "src/objects/arguments.h"
#include "src/objects/bigint.h"
#include "src/objects/call-site-info.h"
#include "src/objects/elements-kind.h"
#include "src/objects/free-space.h"
#include "src/objects/intl-objects.h"
#include "src/objects/js-atomics-synchronization.h"
#include "src/objects/js-break-iterator.h"
#include "src/objects/js-collator.h"
#include "src/objects/js-date-time-format.h"
#include "src/objects/js-display-names.h"
#include "src/objects/js-duration-format.h"
#include "src/objects/js-function.h"
#include "src/objects/js-generator.h"
#include "src/objects/js-iterator-helpers.h"
#include "src/objects/js-list-format.h"
#include "src/objects/js-locale.h"
#include "src/objects/js-number-format.h"
#include "src/objects/js-objects.h"
#include "src/objects/js-plural-rules.h"
#include "src/objects/js-promise.h"
#include "src/objects/js-raw-json.h"
#include "src/objects/js-regexp-string-iterator.h"
#include "src/objects/js-relative-time-format.h"
#include "src/objects/js-segment-iterator.h"
#include "src/objects/js-segmenter.h"
#include "src/objects/js-segments.h"
#include "src/objects/js-shadow-realm.h"
#include "src/objects/js-shared-array.h"
#include "src/objects/js-struct.h"
#include "src/objects/js-temporal-objects.h"
#include "src/objects/js-weak-refs.h"
#include "src/objects/objects.h"
#include "src/objects/ordered-hash-table.h"
#include "src/objects/property-array.h"
#include "src/objects/property-descriptor-object.h"
#include "src/objects/source-text-module.h"
#include "src/objects/swiss-hash-table-helpers.h"
#include "src/objects/swiss-name-dictionary.h"
#include "src/objects/synthetic-module.h"
#include "src/objects/template-objects.h"
#include "src/objects/torque-defined-classes.h"
#include "src/objects/turbofan-types.h"
#include "src/objects/turboshaft-types.h"
#include "src/torque/runtime-support.h"
#include "src/wasm/wasm-linkage.h"
#include "src/codegen/code-stub-assembler-inl.h"
// Required Builtins:
#include "torque-generated/src/builtins/js-to-js-tq-csa.h"
#include "torque-generated/src/builtins/array-join-tq-csa.h"
#include "torque-generated/src/builtins/base-tq-csa.h"
#include "torque-generated/src/builtins/cast-tq-csa.h"
#include "torque-generated/src/builtins/convert-tq-csa.h"
#include "torque-generated/src/builtins/frame-arguments-tq-csa.h"
#include "torque-generated/src/builtins/torque-internal-tq-csa.h"
#include "torque-generated/src/objects/contexts-tq-csa.h"
#include "torque-generated/src/objects/fixed-array-tq-csa.h"
#include "torque-generated/src/builtins/js-to-js-tq-csa.h"
#include "torque-generated/src/builtins/js-to-wasm-tq-csa.h"
#include "torque-generated/src/builtins/wasm-tq-csa.h"
#include "torque-generated/src/builtins/wasm-to-js-tq-csa.h"
#include "torque-generated/src/wasm/wasm-objects-tq-csa.h"

namespace v8 {
namespace internal {

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-js.tq?l=18&c=1
TNode<Object> ConvertToAndFromWasm_0(compiler::CodeAssemblerState* state_, TNode<Context> p_context, TNode<Int32T> p_wasmType, TNode<Object> p_value) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block8(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block7(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block3(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block9(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block12(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block13(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block10(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block15(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block16(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block18(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block19(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block28(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block29(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block30(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block31(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block32(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block33(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object> block1(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block34(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<BoolT> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI32.raw_bit_field());
    tmp1 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{p_wasmType}, TNode<Int32T>{tmp0});
    ca_.Branch(tmp1, &block2, std::vector<compiler::Node*>{}, &block3, std::vector<compiler::Node*>{});
  }

  TNode<Smi> tmp2;
  if (block2.is_used()) {
    ca_.Bind(&block2);
    compiler::CodeAssemblerLabel label3(&ca_);
    tmp2 = Cast_Smi_0(state_, TNode<Object>{p_value}, &label3);
    ca_.Goto(&block7);
    if (label3.is_used()) {
      ca_.Bind(&label3);
      ca_.Goto(&block8);
    }
  }

  TNode<Int32T> tmp4;
  TNode<Number> tmp5;
  if (block8.is_used()) {
    ca_.Bind(&block8);
    tmp4 = ca_.CallBuiltin<Int32T>(Builtin::kWasmTaggedNonSmiToInt32, p_context, ca_.UncheckedCast<HeapObject>(p_value));
    tmp5 = Convert_Number_int32_0(state_, TNode<Int32T>{tmp4});
    ca_.Goto(&block1, tmp5);
  }

  if (block7.is_used()) {
    ca_.Bind(&block7);
    ca_.Goto(&block1, tmp2);
  }

  TNode<Int32T> tmp6;
  TNode<BoolT> tmp7;
  if (block3.is_used()) {
    ca_.Bind(&block3);
    tmp6 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI64.raw_bit_field());
    tmp7 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{p_wasmType}, TNode<Int32T>{tmp6});
    ca_.Branch(tmp7, &block9, std::vector<compiler::Node*>{}, &block10, std::vector<compiler::Node*>{});
  }

  if (block9.is_used()) {
    ca_.Bind(&block9);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block12);
    } else {
      ca_.Goto(&block13);
    }
  }

  TNode<IntPtrT> tmp8;
  TNode<BigInt> tmp9;
  if (block12.is_used()) {
    ca_.Bind(&block12);
    tmp8 = TruncateBigIntToI64_0(state_, TNode<Context>{p_context}, TNode<Object>{p_value});
    tmp9 = ca_.CallBuiltin<BigInt>(Builtin::kI64ToBigInt, TNode<Object>(), tmp8);
    ca_.Goto(&block1, tmp9);
  }

  TNode<BigInt> tmp10;
  TNode<UintPtrT> tmp11;
  TNode<UintPtrT> tmp12;
  TNode<IntPtrT> tmp13;
  TNode<IntPtrT> tmp14;
  TNode<BigInt> tmp15;
  if (block13.is_used()) {
    ca_.Bind(&block13);
    tmp10 = CodeStubAssembler(state_).ToBigInt(TNode<Context>{p_context}, TNode<Object>{p_value});
    std::tie(tmp11, tmp12) = CodeStubAssembler(state_).BigIntToRawBytes(TNode<BigInt>{tmp10}).Flatten();
    tmp13 = CodeStubAssembler(state_).Signed(TNode<UintPtrT>{tmp11});
    tmp14 = CodeStubAssembler(state_).Signed(TNode<UintPtrT>{tmp12});
    tmp15 = ca_.CallBuiltin<BigInt>(Builtin::kI32PairToBigInt, TNode<Object>(), tmp13, tmp14);
    ca_.Goto(&block1, tmp15);
  }

  TNode<Int32T> tmp16;
  TNode<BoolT> tmp17;
  if (block10.is_used()) {
    ca_.Bind(&block10);
    tmp16 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF32.raw_bit_field());
    tmp17 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{p_wasmType}, TNode<Int32T>{tmp16});
    ca_.Branch(tmp17, &block15, std::vector<compiler::Node*>{}, &block16, std::vector<compiler::Node*>{});
  }

  TNode<Float32T> tmp18;
  TNode<Number> tmp19;
  if (block15.is_used()) {
    ca_.Bind(&block15);
    tmp18 = ca_.CallBuiltin<Float32T>(Builtin::kWasmTaggedToFloat32, p_context, p_value);
    tmp19 = Convert_Number_float32_0(state_, TNode<Float32T>{tmp18});
    ca_.Goto(&block1, tmp19);
  }

  TNode<Int32T> tmp20;
  TNode<BoolT> tmp21;
  if (block16.is_used()) {
    ca_.Bind(&block16);
    tmp20 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF64.raw_bit_field());
    tmp21 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{p_wasmType}, TNode<Int32T>{tmp20});
    ca_.Branch(tmp21, &block18, std::vector<compiler::Node*>{}, &block19, std::vector<compiler::Node*>{});
  }

  TNode<Float64T> tmp22;
  TNode<Number> tmp23;
  if (block18.is_used()) {
    ca_.Bind(&block18);
    tmp22 = ca_.CallBuiltin<Float64T>(Builtin::kWasmTaggedToFloat64, p_context, p_value);
    tmp23 = Convert_Number_float64_0(state_, TNode<Float64T>{tmp22});
    ca_.Goto(&block1, tmp23);
  }

  TNode<Int32T> tmp24;
  TNode<Int32T> tmp25;
  TNode<Null> tmp26;
  TNode<BoolT> tmp27;
  if (block19.is_used()) {
    ca_.Bind(&block19);
    tmp24 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmValueKindBitsMask);
    tmp25 = CodeStubAssembler(state_).Word32And(TNode<Int32T>{p_wasmType}, TNode<Int32T>{tmp24});
    tmp26 = Null_0(state_);
    tmp27 = CodeStubAssembler(state_).TaggedEqual(TNode<Object>{p_value}, TNode<HeapObject>{tmp26});
    ca_.Branch(tmp27, &block28, std::vector<compiler::Node*>{}, &block29, std::vector<compiler::Node*>{});
  }

  if (block28.is_used()) {
    ca_.Bind(&block28);
    ca_.Goto(&block1, p_value);
  }

  TNode<Int32T> tmp28;
  TNode<Int32T> tmp29;
  TNode<Int32T> tmp30;
  TNode<Int32T> tmp31;
  TNode<Int32T> tmp32;
  TNode<BoolT> tmp33;
  if (block29.is_used()) {
    ca_.Bind(&block29);
    tmp28 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::ValueType::kKindBits);
    tmp29 = CodeStubAssembler(state_).Word32Sar(TNode<Int32T>{p_wasmType}, TNode<Int32T>{tmp28});
    tmp30 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmHeapTypeBitsMask);
    tmp31 = CodeStubAssembler(state_).Word32And(TNode<Int32T>{tmp29}, TNode<Int32T>{tmp30});
    tmp32 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kFunc);
    tmp33 = CodeStubAssembler(state_).Word32NotEqual(TNode<Int32T>{tmp31}, TNode<Int32T>{tmp32});
    ca_.Branch(tmp33, &block30, std::vector<compiler::Node*>{}, &block31, std::vector<compiler::Node*>{});
  }

  if (block30.is_used()) {
    ca_.Bind(&block30);
    ca_.Goto(&block1, p_value);
  }

  TNode<Smi> tmp34;
  TNode<Boolean> tmp35;
  TNode<True> tmp36;
  TNode<BoolT> tmp37;
  if (block31.is_used()) {
    ca_.Bind(&block31);
    tmp34 = kNoContext_0(state_);
    tmp35 = TORQUE_CAST(CodeStubAssembler(state_).CallRuntime(Runtime::kIsWasmExternalFunction, tmp34, p_value)); 
    tmp36 = True_0(state_);
    tmp37 = CodeStubAssembler(state_).TaggedNotEqual(TNode<HeapObject>{tmp35}, TNode<HeapObject>{tmp36});
    ca_.Branch(tmp37, &block32, std::vector<compiler::Node*>{}, &block33, std::vector<compiler::Node*>{});
  }

  if (block32.is_used()) {
    ca_.Bind(&block32);
    CodeStubAssembler(state_).ThrowTypeError(TNode<Context>{p_context}, MessageTemplate::kWasmTrapJSTypeError);
  }

  if (block33.is_used()) {
    ca_.Bind(&block33);
    ca_.Goto(&block1, p_value);
  }

  TNode<Object> phi_bb1_3;
  if (block1.is_used()) {
    ca_.Bind(&block1, &phi_bb1_3);
    ca_.Goto(&block34);
  }

    ca_.Bind(&block34);
  return TNode<Object>{phi_bb1_3};
}

TF_BUILTIN(JSToJSWrapperInvalidSig, CodeStubAssembler) {
  compiler::CodeAssemblerState* state_ = state();  compiler::CodeAssembler ca_(state());
  TNode<NativeContext> parameter0 = UncheckedParameter<NativeContext>(Descriptor::kContext);
  USE(parameter0);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  if (block0.is_used()) {
    ca_.Bind(&block0);
    CodeStubAssembler(state_).CallRuntime(Runtime::kWasmThrowJSTypeError, parameter0);
    CodeStubAssembler(state_).Unreachable();
  }
}

TF_BUILTIN(JSToJSWrapper, CodeStubAssembler) {
  compiler::CodeAssemblerState* state_ = state();  compiler::CodeAssembler ca_(state());
  TNode<Word32T> argc = UncheckedParameter<Word32T>(Descriptor::kJSActualArgumentsCount);
  TNode<IntPtrT> arguments_length(ChangeInt32ToIntPtr(UncheckedCast<Int32T>(argc)));
  TNode<RawPtrT> arguments_frame = UncheckedCast<RawPtrT>(LoadFramePointer());
  TorqueStructArguments torque_arguments(GetFrameArguments(arguments_frame, arguments_length, FrameArgumentsArgcType::kCountIncludesReceiver));
  CodeStubArguments arguments(this, torque_arguments);
  TNode<NativeContext> parameter0 = UncheckedParameter<NativeContext>(Descriptor::kContext);
  USE(parameter0);
  TNode<Object> parameter1 = arguments.GetReceiver();
  USE(parameter1);
  TNode<JSFunction> parameter2 = UncheckedParameter<JSFunction>(Descriptor::kJSTarget);
USE(parameter2);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block4(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block3(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block8(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block7(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block13(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block14(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT> block19(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT> block17(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block26(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block27(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT> block18(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT> block34(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT> block35(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT> block37(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT> block38(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT> block43(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT> block41(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block49(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block50(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block58(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block59(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT> block42(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, Object> block39(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, Object> block36(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, Object> block62(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, Object, IntPtrT> block63(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<IntPtrT> tmp0;
  TNode<SharedFunctionInfo> tmp1;
  TNode<IntPtrT> tmp2;
  TNode<Object> tmp3;
  TNode<WasmFunctionData> tmp4;
  TNode<IntPtrT> tmp5;
  TNode<WasmInternalFunction> tmp6;
  TNode<ExposedTrustedObject> tmp7;
  TNode<WasmApiFunctionRef> tmp8;
  TNode<IntPtrT> tmp9;
  TNode<ByteArray> tmp10;
  TNode<Object> tmp11;
  TNode<IntPtrT> tmp12;
  TNode<IntPtrT> tmp13;
  TNode<IntPtrT> tmp14;
  TNode<IntPtrT> tmp15;
  TNode<Object> tmp16;
  TNode<IntPtrT> tmp17;
  TNode<IntPtrT> tmp18;
  TNode<Object> tmp19;
  TNode<IntPtrT> tmp20;
  TNode<Int32T> tmp21;
  TNode<IntPtrT> tmp22;
  TNode<IntPtrT> tmp23;
  TNode<IntPtrT> tmp24;
  TNode<IntPtrT> tmp25;
  TNode<IntPtrT> tmp26;
  TNode<Object> tmp27;
  TNode<IntPtrT> tmp28;
  TNode<IntPtrT> tmp29;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = FromConstexpr_intptr_constexpr_int31_0(state_, 32);
    tmp1 = CodeStubAssembler(state_).LoadReference<SharedFunctionInfo>(CodeStubAssembler::Reference{parameter2, tmp0});
    tmp2 = FromConstexpr_intptr_constexpr_int31_0(state_, 8);
    tmp3 = CodeStubAssembler(state_).LoadReference<Object>(CodeStubAssembler::Reference{tmp1, tmp2});
    tmp4 = UnsafeCast_WasmFunctionData_0(state_, TNode<Context>{parameter0}, TNode<Object>{tmp3});
    tmp5 = FromConstexpr_intptr_constexpr_int31_0(state_, 16);
    tmp6 = CodeStubAssembler(state_).LoadReference<WasmInternalFunction>(CodeStubAssembler::Reference{tmp4, tmp5});
    tmp7 = CodeStubAssembler(state_).LoadRefFromWasmInternalFunction(TNode<WasmInternalFunction>{tmp6});
    tmp8 = UnsafeCast_WasmApiFunctionRef_0(state_, TNode<Context>{parameter0}, TNode<Object>{tmp7});
    tmp9 = FromConstexpr_intptr_constexpr_int31_0(state_, 56);
    tmp10 = CodeStubAssembler(state_).LoadReference<ByteArray>(CodeStubAssembler::Reference{tmp8, tmp9});
    std::tie(tmp11, tmp12, tmp13) = FieldSliceByteArrayBytes_0(state_, TNode<ByteArray>{tmp10}).Flatten();
    tmp14 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_int32_0(state_)));
    tmp15 = CodeStubAssembler(state_).IntPtrDiv(TNode<IntPtrT>{tmp13}, TNode<IntPtrT>{tmp14});
    std::tie(tmp16, tmp17, tmp18) = NewConstSlice_int32_0(state_, TNode<Object>{tmp11}, TNode<IntPtrT>{tmp12}, TNode<IntPtrT>{tmp15}).Flatten();
    std::tie(tmp19, tmp20) = NewReference_int32_0(state_, TNode<Object>{tmp16}, TNode<IntPtrT>{tmp17}).Flatten();
    tmp21 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp19, tmp20});
    tmp22 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp21});
    tmp23 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{tmp18}, TNode<IntPtrT>{tmp22});
    tmp24 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp25 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{tmp23}, TNode<IntPtrT>{tmp24});
    tmp26 = Convert_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    compiler::CodeAssemblerLabel label30(&ca_);
    std::tie(tmp27, tmp28, tmp29) = Subslice_int32_0(state_, TorqueStructSlice_int32_ConstReference_int32_0{TNode<Object>{tmp16}, TNode<IntPtrT>{tmp17}, TNode<IntPtrT>{tmp18}, TorqueStructUnsafe_0{}}, TNode<IntPtrT>{tmp26}, TNode<IntPtrT>{tmp22}, &label30).Flatten();
    ca_.Goto(&block3);
    if (label30.is_used()) {
      ca_.Bind(&label30);
      ca_.Goto(&block4);
    }
  }

  if (block4.is_used()) {
    ca_.Bind(&block4);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> tmp31;
  TNode<IntPtrT> tmp32;
  TNode<Object> tmp33;
  TNode<IntPtrT> tmp34;
  TNode<IntPtrT> tmp35;
  if (block3.is_used()) {
    ca_.Bind(&block3);
    tmp31 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp32 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp22}, TNode<IntPtrT>{tmp31});
    compiler::CodeAssemblerLabel label36(&ca_);
    std::tie(tmp33, tmp34, tmp35) = Subslice_int32_0(state_, TorqueStructSlice_int32_ConstReference_int32_0{TNode<Object>{tmp16}, TNode<IntPtrT>{tmp17}, TNode<IntPtrT>{tmp18}, TorqueStructUnsafe_0{}}, TNode<IntPtrT>{tmp32}, TNode<IntPtrT>{tmp25}, &label36).Flatten();
    ca_.Goto(&block7);
    if (label36.is_used()) {
      ca_.Bind(&label36);
      ca_.Goto(&block8);
    }
  }

  if (block8.is_used()) {
    ca_.Bind(&block8);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> tmp37;
  TNode<IntPtrT> tmp38;
  TNode<FixedArray> tmp39;
  TNode<IntPtrT> tmp40;
  TNode<Object> tmp41;
  TNode<IntPtrT> tmp42;
  TNode<IntPtrT> tmp43;
  TNode<IntPtrT> tmp44;
  TNode<IntPtrT> tmp45;
  TNode<UintPtrT> tmp46;
  TNode<UintPtrT> tmp47;
  TNode<BoolT> tmp48;
  if (block7.is_used()) {
    ca_.Bind(&block7);
    tmp37 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp38 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp25}, TNode<IntPtrT>{tmp37});
    tmp39 = ca_.CallBuiltin<FixedArray>(Builtin::kWasmAllocateZeroedFixedArray, TNode<Object>(), tmp38);
    tmp40 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    std::tie(tmp41, tmp42, tmp43) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp39}).Flatten();
    tmp44 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp45 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp40}, TNode<IntPtrT>{tmp44});
    tmp46 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp40});
    tmp47 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp43});
    tmp48 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp46}, TNode<UintPtrT>{tmp47});
    ca_.Branch(tmp48, &block13, std::vector<compiler::Node*>{}, &block14, std::vector<compiler::Node*>{});
  }

  TNode<IntPtrT> tmp49;
  TNode<IntPtrT> tmp50;
  TNode<Object> tmp51;
  TNode<IntPtrT> tmp52;
  TNode<Undefined> tmp53;
  TNode<IntPtrT> tmp54;
  if (block13.is_used()) {
    ca_.Bind(&block13);
    tmp49 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{tmp40});
    tmp50 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp42}, TNode<IntPtrT>{tmp49});
    std::tie(tmp51, tmp52) = NewReference_Object_0(state_, TNode<Object>{tmp41}, TNode<IntPtrT>{tmp50}).Flatten();
    tmp53 = Undefined_0(state_);
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp51, tmp52}, tmp53);
    tmp54 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    ca_.Goto(&block19, tmp45, tmp54);
  }

  if (block14.is_used()) {
    ca_.Bind(&block14);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb19_25;
  TNode<IntPtrT> phi_bb19_26;
  TNode<BoolT> tmp55;
  if (block19.is_used()) {
    ca_.Bind(&block19, &phi_bb19_25, &phi_bb19_26);
    tmp55 = CodeStubAssembler(state_).IntPtrLessThan(TNode<IntPtrT>{phi_bb19_26}, TNode<IntPtrT>{tmp25});
    ca_.Branch(tmp55, &block17, std::vector<compiler::Node*>{phi_bb19_25, phi_bb19_26}, &block18, std::vector<compiler::Node*>{phi_bb19_25, phi_bb19_26});
  }

  TNode<IntPtrT> phi_bb17_25;
  TNode<IntPtrT> phi_bb17_26;
  TNode<Object> tmp56;
  TNode<IntPtrT> tmp57;
  TNode<IntPtrT> tmp58;
  TNode<Object> tmp59;
  TNode<IntPtrT> tmp60;
  TNode<Int32T> tmp61;
  TNode<Object> tmp62;
  TNode<IntPtrT> tmp63;
  TNode<IntPtrT> tmp64;
  TNode<IntPtrT> tmp65;
  TNode<IntPtrT> tmp66;
  TNode<UintPtrT> tmp67;
  TNode<UintPtrT> tmp68;
  TNode<BoolT> tmp69;
  if (block17.is_used()) {
    ca_.Bind(&block17, &phi_bb17_25, &phi_bb17_26);
    tmp56 = CodeStubAssembler(state_).GetArgumentValue(TorqueStructArguments{TNode<RawPtrT>{torque_arguments.frame}, TNode<RawPtrT>{torque_arguments.base}, TNode<IntPtrT>{torque_arguments.length}, TNode<IntPtrT>{torque_arguments.actual_count}}, TNode<IntPtrT>{phi_bb17_26});
    tmp57 = TimesSizeOf_int32_0(state_, TNode<IntPtrT>{phi_bb17_26});
    tmp58 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp34}, TNode<IntPtrT>{tmp57});
    std::tie(tmp59, tmp60) = NewReference_int32_0(state_, TNode<Object>{tmp33}, TNode<IntPtrT>{tmp58}).Flatten();
    tmp61 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp59, tmp60});
    std::tie(tmp62, tmp63, tmp64) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp39}).Flatten();
    tmp65 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp66 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb17_25}, TNode<IntPtrT>{tmp65});
    tmp67 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb17_25});
    tmp68 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp64});
    tmp69 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp67}, TNode<UintPtrT>{tmp68});
    ca_.Branch(tmp69, &block26, std::vector<compiler::Node*>{phi_bb17_26, phi_bb17_25, phi_bb17_25, phi_bb17_25, phi_bb17_25}, &block27, std::vector<compiler::Node*>{phi_bb17_26, phi_bb17_25, phi_bb17_25, phi_bb17_25, phi_bb17_25});
  }

  TNode<IntPtrT> phi_bb26_26;
  TNode<IntPtrT> phi_bb26_33;
  TNode<IntPtrT> phi_bb26_34;
  TNode<IntPtrT> phi_bb26_38;
  TNode<IntPtrT> phi_bb26_39;
  TNode<IntPtrT> tmp70;
  TNode<IntPtrT> tmp71;
  TNode<Object> tmp72;
  TNode<IntPtrT> tmp73;
  TNode<Object> tmp74;
  TNode<IntPtrT> tmp75;
  TNode<IntPtrT> tmp76;
  if (block26.is_used()) {
    ca_.Bind(&block26, &phi_bb26_26, &phi_bb26_33, &phi_bb26_34, &phi_bb26_38, &phi_bb26_39);
    tmp70 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb26_39});
    tmp71 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp63}, TNode<IntPtrT>{tmp70});
    std::tie(tmp72, tmp73) = NewReference_Object_0(state_, TNode<Object>{tmp62}, TNode<IntPtrT>{tmp71}).Flatten();
    tmp74 = ConvertToAndFromWasm_0(state_, TNode<Context>{parameter0}, TNode<Int32T>{tmp61}, TNode<Object>{tmp56});
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp72, tmp73}, tmp74);
    tmp75 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp76 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb26_26}, TNode<IntPtrT>{tmp75});
    ca_.Goto(&block19, tmp66, tmp76);
  }

  TNode<IntPtrT> phi_bb27_26;
  TNode<IntPtrT> phi_bb27_33;
  TNode<IntPtrT> phi_bb27_34;
  TNode<IntPtrT> phi_bb27_38;
  TNode<IntPtrT> phi_bb27_39;
  if (block27.is_used()) {
    ca_.Bind(&block27, &phi_bb27_26, &phi_bb27_33, &phi_bb27_34, &phi_bb27_38, &phi_bb27_39);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb18_25;
  TNode<IntPtrT> phi_bb18_26;
  TNode<IntPtrT> tmp77;
  TNode<HeapObject> tmp78;
  TNode<Int32T> tmp79;
  TNode<Int32T> tmp80;
  TNode<Object> tmp81;
  TNode<IntPtrT> tmp82;
  TNode<BoolT> tmp83;
  if (block18.is_used()) {
    ca_.Bind(&block18, &phi_bb18_25, &phi_bb18_26);
    tmp77 = FromConstexpr_intptr_constexpr_int31_0(state_, 16);
    tmp78 = CodeStubAssembler(state_).LoadReference<HeapObject>(CodeStubAssembler::Reference{tmp8, tmp77});
    tmp79 = Convert_int32_intptr_0(state_, TNode<IntPtrT>{tmp38});
    tmp80 = FromConstexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp81 = ca_.CallBuiltin<Object>(Builtin::kCallVarargs, parameter0, tmp78, tmp80, tmp79, tmp39);
    tmp82 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp83 = CodeStubAssembler(state_).WordEqual(TNode<IntPtrT>{tmp22}, TNode<IntPtrT>{tmp82});
    ca_.Branch(tmp83, &block34, std::vector<compiler::Node*>{phi_bb18_25}, &block35, std::vector<compiler::Node*>{phi_bb18_25});
  }

  TNode<IntPtrT> phi_bb34_25;
  TNode<Undefined> tmp84;
  if (block34.is_used()) {
    ca_.Bind(&block34, &phi_bb34_25);
    tmp84 = Undefined_0(state_);
    ca_.Goto(&block36, phi_bb34_25, tmp84);
  }

  TNode<IntPtrT> phi_bb35_25;
  TNode<IntPtrT> tmp85;
  TNode<BoolT> tmp86;
  if (block35.is_used()) {
    ca_.Bind(&block35, &phi_bb35_25);
    tmp85 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp86 = CodeStubAssembler(state_).WordEqual(TNode<IntPtrT>{tmp22}, TNode<IntPtrT>{tmp85});
    ca_.Branch(tmp86, &block37, std::vector<compiler::Node*>{phi_bb35_25}, &block38, std::vector<compiler::Node*>{phi_bb35_25});
  }

  TNode<IntPtrT> phi_bb37_25;
  TNode<IntPtrT> tmp87;
  TNode<IntPtrT> tmp88;
  TNode<IntPtrT> tmp89;
  TNode<Object> tmp90;
  TNode<IntPtrT> tmp91;
  TNode<Int32T> tmp92;
  TNode<Object> tmp93;
  if (block37.is_used()) {
    ca_.Bind(&block37, &phi_bb37_25);
    tmp87 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp88 = TimesSizeOf_int32_0(state_, TNode<IntPtrT>{tmp87});
    tmp89 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp28}, TNode<IntPtrT>{tmp88});
    std::tie(tmp90, tmp91) = NewReference_int32_0(state_, TNode<Object>{tmp27}, TNode<IntPtrT>{tmp89}).Flatten();
    tmp92 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp90, tmp91});
    tmp93 = ConvertToAndFromWasm_0(state_, TNode<Context>{parameter0}, TNode<Int32T>{tmp92}, TNode<Object>{tmp81});
    ca_.Goto(&block39, phi_bb37_25, tmp93);
  }

  TNode<IntPtrT> phi_bb38_25;
  TNode<Smi> tmp94;
  TNode<FixedArray> tmp95;
  TNode<Smi> tmp96;
  TNode<JSArray> tmp97;
  TNode<IntPtrT> tmp98;
  TNode<FixedArrayBase> tmp99;
  TNode<FixedArray> tmp100;
  TNode<IntPtrT> tmp101;
  if (block38.is_used()) {
    ca_.Bind(&block38, &phi_bb38_25);
    tmp94 = Convert_Smi_intptr_0(state_, TNode<IntPtrT>{tmp22});
    tmp95 = ca_.CallBuiltin<FixedArray>(Builtin::kIterableToFixedArrayForWasm, parameter0, tmp81, tmp94);
    tmp96 = Convert_Smi_intptr_0(state_, TNode<IntPtrT>{tmp22});
    tmp97 = ca_.CallBuiltin<JSArray>(Builtin::kWasmAllocateJSArray, parameter0, tmp96);
    tmp98 = FromConstexpr_intptr_constexpr_int31_0(state_, 16);
    tmp99 = CodeStubAssembler(state_).LoadReference<FixedArrayBase>(CodeStubAssembler::Reference{tmp97, tmp98});
    tmp100 = UnsafeCast_FixedArray_0(state_, TNode<Context>{parameter0}, TNode<Object>{tmp99});
    tmp101 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    ca_.Goto(&block43, phi_bb38_25, tmp101);
  }

  TNode<IntPtrT> phi_bb43_25;
  TNode<IntPtrT> phi_bb43_31;
  TNode<BoolT> tmp102;
  if (block43.is_used()) {
    ca_.Bind(&block43, &phi_bb43_25, &phi_bb43_31);
    tmp102 = CodeStubAssembler(state_).IntPtrLessThan(TNode<IntPtrT>{phi_bb43_31}, TNode<IntPtrT>{tmp22});
    ca_.Branch(tmp102, &block41, std::vector<compiler::Node*>{phi_bb43_25, phi_bb43_31}, &block42, std::vector<compiler::Node*>{phi_bb43_25, phi_bb43_31});
  }

  TNode<IntPtrT> phi_bb41_25;
  TNode<IntPtrT> phi_bb41_31;
  TNode<Object> tmp103;
  TNode<IntPtrT> tmp104;
  TNode<IntPtrT> tmp105;
  TNode<UintPtrT> tmp106;
  TNode<UintPtrT> tmp107;
  TNode<BoolT> tmp108;
  if (block41.is_used()) {
    ca_.Bind(&block41, &phi_bb41_25, &phi_bb41_31);
    std::tie(tmp103, tmp104, tmp105) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp95}).Flatten();
    tmp106 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb41_31});
    tmp107 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp105});
    tmp108 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp106}, TNode<UintPtrT>{tmp107});
    ca_.Branch(tmp108, &block49, std::vector<compiler::Node*>{phi_bb41_25, phi_bb41_31, phi_bb41_31, phi_bb41_31, phi_bb41_31, phi_bb41_31}, &block50, std::vector<compiler::Node*>{phi_bb41_25, phi_bb41_31, phi_bb41_31, phi_bb41_31, phi_bb41_31, phi_bb41_31});
  }

  TNode<IntPtrT> phi_bb49_25;
  TNode<IntPtrT> phi_bb49_31;
  TNode<IntPtrT> phi_bb49_36;
  TNode<IntPtrT> phi_bb49_37;
  TNode<IntPtrT> phi_bb49_41;
  TNode<IntPtrT> phi_bb49_42;
  TNode<IntPtrT> tmp109;
  TNode<IntPtrT> tmp110;
  TNode<Object> tmp111;
  TNode<IntPtrT> tmp112;
  TNode<Object> tmp113;
  TNode<Object> tmp114;
  TNode<IntPtrT> tmp115;
  TNode<IntPtrT> tmp116;
  TNode<Object> tmp117;
  TNode<IntPtrT> tmp118;
  TNode<Int32T> tmp119;
  TNode<Object> tmp120;
  TNode<IntPtrT> tmp121;
  TNode<IntPtrT> tmp122;
  TNode<UintPtrT> tmp123;
  TNode<UintPtrT> tmp124;
  TNode<BoolT> tmp125;
  if (block49.is_used()) {
    ca_.Bind(&block49, &phi_bb49_25, &phi_bb49_31, &phi_bb49_36, &phi_bb49_37, &phi_bb49_41, &phi_bb49_42);
    tmp109 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb49_42});
    tmp110 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp104}, TNode<IntPtrT>{tmp109});
    std::tie(tmp111, tmp112) = NewReference_Object_0(state_, TNode<Object>{tmp103}, TNode<IntPtrT>{tmp110}).Flatten();
    tmp113 = CodeStubAssembler(state_).LoadReference<Object>(CodeStubAssembler::Reference{tmp111, tmp112});
    tmp114 = UnsafeCast_JSAny_0(state_, TNode<Context>{parameter0}, TNode<Object>{tmp113});
    tmp115 = TimesSizeOf_int32_0(state_, TNode<IntPtrT>{phi_bb49_31});
    tmp116 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp28}, TNode<IntPtrT>{tmp115});
    std::tie(tmp117, tmp118) = NewReference_int32_0(state_, TNode<Object>{tmp27}, TNode<IntPtrT>{tmp116}).Flatten();
    tmp119 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp117, tmp118});
    std::tie(tmp120, tmp121, tmp122) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp100}).Flatten();
    tmp123 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb49_31});
    tmp124 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp122});
    tmp125 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp123}, TNode<UintPtrT>{tmp124});
    ca_.Branch(tmp125, &block58, std::vector<compiler::Node*>{phi_bb49_25, phi_bb49_31, phi_bb49_31, phi_bb49_31, phi_bb49_31, phi_bb49_31}, &block59, std::vector<compiler::Node*>{phi_bb49_25, phi_bb49_31, phi_bb49_31, phi_bb49_31, phi_bb49_31, phi_bb49_31});
  }

  TNode<IntPtrT> phi_bb50_25;
  TNode<IntPtrT> phi_bb50_31;
  TNode<IntPtrT> phi_bb50_36;
  TNode<IntPtrT> phi_bb50_37;
  TNode<IntPtrT> phi_bb50_41;
  TNode<IntPtrT> phi_bb50_42;
  if (block50.is_used()) {
    ca_.Bind(&block50, &phi_bb50_25, &phi_bb50_31, &phi_bb50_36, &phi_bb50_37, &phi_bb50_41, &phi_bb50_42);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb58_25;
  TNode<IntPtrT> phi_bb58_31;
  TNode<IntPtrT> phi_bb58_38;
  TNode<IntPtrT> phi_bb58_39;
  TNode<IntPtrT> phi_bb58_43;
  TNode<IntPtrT> phi_bb58_44;
  TNode<IntPtrT> tmp126;
  TNode<IntPtrT> tmp127;
  TNode<Object> tmp128;
  TNode<IntPtrT> tmp129;
  TNode<Object> tmp130;
  TNode<IntPtrT> tmp131;
  TNode<IntPtrT> tmp132;
  if (block58.is_used()) {
    ca_.Bind(&block58, &phi_bb58_25, &phi_bb58_31, &phi_bb58_38, &phi_bb58_39, &phi_bb58_43, &phi_bb58_44);
    tmp126 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb58_44});
    tmp127 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp121}, TNode<IntPtrT>{tmp126});
    std::tie(tmp128, tmp129) = NewReference_Object_0(state_, TNode<Object>{tmp120}, TNode<IntPtrT>{tmp127}).Flatten();
    tmp130 = ConvertToAndFromWasm_0(state_, TNode<Context>{parameter0}, TNode<Int32T>{tmp119}, TNode<Object>{tmp114});
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp128, tmp129}, tmp130);
    tmp131 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp132 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb58_31}, TNode<IntPtrT>{tmp131});
    ca_.Goto(&block43, phi_bb58_25, tmp132);
  }

  TNode<IntPtrT> phi_bb59_25;
  TNode<IntPtrT> phi_bb59_31;
  TNode<IntPtrT> phi_bb59_38;
  TNode<IntPtrT> phi_bb59_39;
  TNode<IntPtrT> phi_bb59_43;
  TNode<IntPtrT> phi_bb59_44;
  if (block59.is_used()) {
    ca_.Bind(&block59, &phi_bb59_25, &phi_bb59_31, &phi_bb59_38, &phi_bb59_39, &phi_bb59_43, &phi_bb59_44);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb42_25;
  TNode<IntPtrT> phi_bb42_31;
  if (block42.is_used()) {
    ca_.Bind(&block42, &phi_bb42_25, &phi_bb42_31);
    ca_.Goto(&block39, phi_bb42_25, tmp97);
  }

  TNode<IntPtrT> phi_bb39_25;
  TNode<Object> phi_bb39_27;
  if (block39.is_used()) {
    ca_.Bind(&block39, &phi_bb39_25, &phi_bb39_27);
    ca_.Goto(&block36, phi_bb39_25, phi_bb39_27);
  }

  TNode<IntPtrT> phi_bb36_25;
  TNode<Object> phi_bb36_27;
  TNode<BoolT> tmp133;
  if (block36.is_used()) {
    ca_.Bind(&block36, &phi_bb36_25, &phi_bb36_27);
    tmp133 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{tmp25}, TNode<IntPtrT>{torque_arguments.length});
    ca_.Branch(tmp133, &block62, std::vector<compiler::Node*>{phi_bb36_25, phi_bb36_27}, &block63, std::vector<compiler::Node*>{phi_bb36_25, phi_bb36_27, torque_arguments.length});
  }

  TNode<IntPtrT> phi_bb62_25;
  TNode<Object> phi_bb62_27;
  if (block62.is_used()) {
    ca_.Bind(&block62, &phi_bb62_25, &phi_bb62_27);
    ca_.Goto(&block63, phi_bb62_25, phi_bb62_27, tmp25);
  }

  TNode<IntPtrT> phi_bb63_25;
  TNode<Object> phi_bb63_27;
  TNode<IntPtrT> phi_bb63_28;
  TNode<IntPtrT> tmp134;
  TNode<IntPtrT> tmp135;
  if (block63.is_used()) {
    ca_.Bind(&block63, &phi_bb63_25, &phi_bb63_27, &phi_bb63_28);
    tmp134 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp135 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb63_28}, TNode<IntPtrT>{tmp134});
    CodeStubAssembler(state_).PopAndReturn(TNode<IntPtrT>{tmp135}, TNode<Object>{phi_bb63_27});
  }
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-js.tq?l=75&c=7
TNode<WasmFunctionData> UnsafeCast_WasmFunctionData_0(compiler::CodeAssemblerState* state_, TNode<Context> p_context, TNode<Object> p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block6(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<WasmFunctionData> tmp0;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = TORQUE_CAST(TNode<Object>{p_o});
    ca_.Goto(&block6);
  }

    ca_.Bind(&block6);
  return TNode<WasmFunctionData>{tmp0};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-js.tq?l=76&c=15
TNode<WasmApiFunctionRef> UnsafeCast_WasmApiFunctionRef_0(compiler::CodeAssemblerState* state_, TNode<Context> p_context, TNode<Object> p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block6(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<WasmApiFunctionRef> tmp0;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = TORQUE_CAST(TNode<Object>{p_o});
    ca_.Goto(&block6);
  }

    ca_.Bind(&block6);
  return TNode<WasmApiFunctionRef>{tmp0};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-js.tq?l=81&c=29
int31_t SizeOf_int32_0(compiler::CodeAssemblerState* state_) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  if (block0.is_used()) {
    ca_.Bind(&block0);
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return kInt32Size;
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-js.tq?l=79&c=25
TorqueStructSlice_int32_ConstReference_int32_0 NewConstSlice_int32_0(compiler::CodeAssemblerState* state_, TNode<Object> p_object, TNode<IntPtrT> p_offset, TNode<IntPtrT> p_length) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Object> tmp0;
  TNode<IntPtrT> tmp1;
  TNode<IntPtrT> tmp2;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    std::tie(tmp0, tmp1, tmp2) = (TorqueStructSlice_int32_ConstReference_int32_0{TNode<Object>{p_object}, TNode<IntPtrT>{p_offset}, TNode<IntPtrT>{p_length}, TorqueStructUnsafe_0{}}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructSlice_int32_ConstReference_int32_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp1}, TNode<IntPtrT>{tmp2}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-js.tq?l=83&c=24
TorqueStructReference_int32_0 NewReference_int32_0(compiler::CodeAssemblerState* state_, TNode<Object> p_object, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Object> tmp0;
  TNode<IntPtrT> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    std::tie(tmp0, tmp1) = (TorqueStructReference_int32_0{TNode<Object>{p_object}, TNode<IntPtrT>{p_offset}, TorqueStructUnsafe_0{}}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_int32_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp1}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-js.tq?l=86&c=23
TorqueStructSlice_int32_ConstReference_int32_0 Subslice_int32_0(compiler::CodeAssemblerState* state_, TorqueStructSlice_int32_ConstReference_int32_0 p_slice, TNode<IntPtrT> p_start, TNode<IntPtrT> p_length, compiler::CodeAssemblerLabel* label_OutOfBounds) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block3(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block4(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block5(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block6(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block1(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block7(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<UintPtrT> tmp0;
  TNode<UintPtrT> tmp1;
  TNode<BoolT> tmp2;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).Unsigned(TNode<IntPtrT>{p_length});
    tmp1 = CodeStubAssembler(state_).Unsigned(TNode<IntPtrT>{p_slice.length});
    tmp2 = CodeStubAssembler(state_).UintPtrGreaterThan(TNode<UintPtrT>{tmp0}, TNode<UintPtrT>{tmp1});
    ca_.Branch(tmp2, &block3, std::vector<compiler::Node*>{}, &block4, std::vector<compiler::Node*>{});
  }

  if (block3.is_used()) {
    ca_.Bind(&block3);
    ca_.Goto(&block1);
  }

  TNode<UintPtrT> tmp3;
  TNode<IntPtrT> tmp4;
  TNode<UintPtrT> tmp5;
  TNode<BoolT> tmp6;
  if (block4.is_used()) {
    ca_.Bind(&block4);
    tmp3 = CodeStubAssembler(state_).Unsigned(TNode<IntPtrT>{p_start});
    tmp4 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{p_slice.length}, TNode<IntPtrT>{p_length});
    tmp5 = CodeStubAssembler(state_).Unsigned(TNode<IntPtrT>{tmp4});
    tmp6 = CodeStubAssembler(state_).UintPtrGreaterThan(TNode<UintPtrT>{tmp3}, TNode<UintPtrT>{tmp5});
    ca_.Branch(tmp6, &block5, std::vector<compiler::Node*>{}, &block6, std::vector<compiler::Node*>{});
  }

  if (block5.is_used()) {
    ca_.Bind(&block5);
    ca_.Goto(&block1);
  }

  TNode<IntPtrT> tmp7;
  TNode<IntPtrT> tmp8;
  TNode<Object> tmp9;
  TNode<IntPtrT> tmp10;
  TNode<IntPtrT> tmp11;
  if (block6.is_used()) {
    ca_.Bind(&block6);
    tmp7 = TimesSizeOf_int32_0(state_, TNode<IntPtrT>{p_start});
    tmp8 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{p_slice.offset}, TNode<IntPtrT>{tmp7});
    std::tie(tmp9, tmp10, tmp11) = NewConstSlice_int32_0(state_, TNode<Object>{p_slice.object}, TNode<IntPtrT>{tmp8}, TNode<IntPtrT>{p_length}).Flatten();
    ca_.Goto(&block7);
  }

  if (block1.is_used()) {
    ca_.Bind(&block1);
    ca_.Goto(label_OutOfBounds);
  }

    ca_.Bind(&block7);
  return TorqueStructSlice_int32_ConstReference_int32_0{TNode<Object>{tmp9}, TNode<IntPtrT>{tmp10}, TNode<IntPtrT>{tmp11}, TorqueStructUnsafe_0{}};
}

} // namespace internal
} // namespace v8
