#include "src/ast/ast.h"
#include "src/builtins/builtins-array-gen.h"
#include "src/builtins/builtins-bigint-gen.h"
#include "src/builtins/builtins-call-gen.h"
#include "src/builtins/builtins-collections-gen.h"
#include "src/builtins/builtins-constructor-gen.h"
#include "src/builtins/builtins-data-view-gen.h"
#include "src/builtins/builtins-iterator-gen.h"
#include "src/builtins/builtins-object-gen.h"
#include "src/builtins/builtins-promise-gen.h"
#include "src/builtins/builtins-promise.h"
#include "src/builtins/builtins-proxy-gen.h"
#include "src/builtins/builtins-regexp-gen.h"
#include "src/builtins/builtins-string-gen.h"
#include "src/builtins/builtins-typed-array-gen.h"
#include "src/builtins/builtins-utils-gen.h"
#include "src/builtins/builtins-wasm-gen.h"
#include "src/builtins/builtins.h"
#include "src/codegen/code-factory.h"
#include "src/debug/debug-wasm-objects.h"
#include "src/heap/factory-inl.h"
#include "src/ic/binary-op-assembler.h"
#include "src/ic/handler-configuration-inl.h"
#include "src/objects/arguments.h"
#include "src/objects/bigint.h"
#include "src/objects/call-site-info.h"
#include "src/objects/elements-kind.h"
#include "src/objects/free-space.h"
#include "src/objects/intl-objects.h"
#include "src/objects/js-atomics-synchronization.h"
#include "src/objects/js-break-iterator.h"
#include "src/objects/js-collator.h"
#include "src/objects/js-date-time-format.h"
#include "src/objects/js-display-names.h"
#include "src/objects/js-duration-format.h"
#include "src/objects/js-function.h"
#include "src/objects/js-generator.h"
#include "src/objects/js-iterator-helpers.h"
#include "src/objects/js-list-format.h"
#include "src/objects/js-locale.h"
#include "src/objects/js-number-format.h"
#include "src/objects/js-objects.h"
#include "src/objects/js-plural-rules.h"
#include "src/objects/js-promise.h"
#include "src/objects/js-raw-json.h"
#include "src/objects/js-regexp-string-iterator.h"
#include "src/objects/js-relative-time-format.h"
#include "src/objects/js-segment-iterator.h"
#include "src/objects/js-segmenter.h"
#include "src/objects/js-segments.h"
#include "src/objects/js-shadow-realm.h"
#include "src/objects/js-shared-array.h"
#include "src/objects/js-struct.h"
#include "src/objects/js-temporal-objects.h"
#include "src/objects/js-weak-refs.h"
#include "src/objects/objects.h"
#include "src/objects/ordered-hash-table.h"
#include "src/objects/property-array.h"
#include "src/objects/property-descriptor-object.h"
#include "src/objects/source-text-module.h"
#include "src/objects/swiss-hash-table-helpers.h"
#include "src/objects/swiss-name-dictionary.h"
#include "src/objects/synthetic-module.h"
#include "src/objects/template-objects.h"
#include "src/objects/torque-defined-classes.h"
#include "src/objects/turbofan-types.h"
#include "src/objects/turboshaft-types.h"
#include "src/torque/runtime-support.h"
#include "src/wasm/wasm-linkage.h"
#include "src/codegen/code-stub-assembler-inl.h"
// Required Builtins:
#include "torque-generated/src/builtins/js-to-wasm-tq-csa.h"
#include "torque-generated/src/builtins/array-join-tq-csa.h"
#include "torque-generated/src/builtins/array-splice-tq-csa.h"
#include "torque-generated/src/builtins/base-tq-csa.h"
#include "torque-generated/src/builtins/builtins-bigint-tq-csa.h"
#include "torque-generated/src/builtins/builtins-string-tq-csa.h"
#include "torque-generated/src/builtins/cast-tq-csa.h"
#include "torque-generated/src/builtins/convert-tq-csa.h"
#include "torque-generated/src/builtins/frames-tq-csa.h"
#include "torque-generated/src/builtins/frame-arguments-tq-csa.h"
#include "torque-generated/src/builtins/torque-internal-tq-csa.h"
#include "torque-generated/src/objects/contexts-tq-csa.h"
#include "torque-generated/src/objects/fixed-array-tq-csa.h"
#include "torque-generated/src/builtins/js-to-js-tq-csa.h"
#include "torque-generated/src/builtins/js-to-wasm-tq-csa.h"
#include "torque-generated/src/builtins/wasm-tq-csa.h"
#include "torque-generated/src/builtins/wasm-to-js-tq-csa.h"
#include "torque-generated/src/wasm/wasm-objects-tq-csa.h"

namespace v8 {
namespace internal {

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=67&c=1
TNode<Int32T> FromConstexpr_ValueKind_constexpr_kRef_0(compiler::CodeAssemblerState* state_, wasm::ValueKind p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=67&c=1
TNode<Int32T> FromConstexpr_ValueKind_constexpr_kRefNull_0(compiler::CodeAssemblerState* state_, wasm::ValueKind p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kExtern_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kNoExtern_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kString_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kEq_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kI31_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kStruct_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kArray_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kAny_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kNone_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kFunc_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kNoFunc_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kExn_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=73&c=1
TNode<Int32T> FromConstexpr_HeapType_constexpr_kNoExn_0(compiler::CodeAssemblerState* state_, wasm::HeapType::Representation p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = ca_.Int32Constant(CastToUnderlyingTypeIfEnum(p_o));
    tmp1 = (TNode<Int32T>{tmp0});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{tmp1};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=139&c=1
TNode<Uint32T> Bitcast_uint32_float32_0(compiler::CodeAssemblerState* state_, TNode<Float32T> p_v) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Uint32T> tmp0;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).BitcastFloat32ToInt32(TNode<Float32T>{p_v});
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Uint32T>{tmp0};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=148&c=1
TNode<IntPtrT> TruncateBigIntToI64_0(compiler::CodeAssemblerState* state_, TNode<Context> p_context, TNode<Object> p_input) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block6(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block7(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block8(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block9(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT> block1(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT> block10(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<BigInt> tmp0;
  TNode<IntPtrT> tmp1;
  TNode<IntPtrT> tmp2;
  TNode<BoolT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).ToBigInt(TNode<Context>{p_context}, TNode<Object>{p_input});
    tmp1 = BigIntBuiltinsAssembler(state_).ReadBigIntLength(TNode<BigInt>{tmp0});
    tmp2 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp3 = CodeStubAssembler(state_).WordEqual(TNode<IntPtrT>{tmp1}, TNode<IntPtrT>{tmp2});
    ca_.Branch(tmp3, &block6, std::vector<compiler::Node*>{}, &block7, std::vector<compiler::Node*>{});
  }

  TNode<IntPtrT> tmp4;
  if (block6.is_used()) {
    ca_.Bind(&block6);
    tmp4 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    ca_.Goto(&block1, tmp4);
  }

  TNode<IntPtrT> tmp5;
  TNode<UintPtrT> tmp6;
  TNode<Uint32T> tmp7;
  TNode<Uint32T> tmp8;
  TNode<BoolT> tmp9;
  if (block7.is_used()) {
    ca_.Bind(&block7);
    tmp5 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp6 = CodeStubAssembler(state_).LoadBigIntDigit(TNode<BigInt>{tmp0}, TNode<IntPtrT>{tmp5});
    tmp7 = BigIntBuiltinsAssembler(state_).ReadBigIntSign(TNode<BigInt>{tmp0});
    tmp8 = kPositiveSign_0(state_);
    tmp9 = CodeStubAssembler(state_).Word32Equal(TNode<Uint32T>{tmp7}, TNode<Uint32T>{tmp8});
    ca_.Branch(tmp9, &block8, std::vector<compiler::Node*>{}, &block9, std::vector<compiler::Node*>{});
  }

  TNode<IntPtrT> tmp10;
  if (block8.is_used()) {
    ca_.Bind(&block8);
    tmp10 = CodeStubAssembler(state_).Signed(TNode<UintPtrT>{tmp6});
    ca_.Goto(&block1, tmp10);
  }

  TNode<IntPtrT> tmp11;
  TNode<IntPtrT> tmp12;
  TNode<IntPtrT> tmp13;
  if (block9.is_used()) {
    ca_.Bind(&block9);
    tmp11 = CodeStubAssembler(state_).Signed(TNode<UintPtrT>{tmp6});
    tmp12 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp13 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{tmp12}, TNode<IntPtrT>{tmp11});
    ca_.Goto(&block1, tmp13);
  }

  TNode<IntPtrT> phi_bb1_2;
  if (block1.is_used()) {
    ca_.Bind(&block1, &phi_bb1_2);
    ca_.Goto(&block10, phi_bb1_2);
  }

  TNode<IntPtrT> phi_bb10_2;
    ca_.Bind(&block10, &phi_bb10_2);
  return TNode<IntPtrT>{phi_bb10_2};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=250&c=1
TorqueStructReturnSlotAllocator_0 NewReturnSlotAllocator_0(compiler::CodeAssemblerState* state_) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<IntPtrT> tmp0;
  TNode<IntPtrT> tmp1;
  TNode<IntPtrT> tmp2;
  TNode<BoolT> tmp3;
  TNode<BoolT> tmp4;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = FromConstexpr_intptr_constexpr_intptr_0(state_, arraysize(wasm::kGpReturnRegisters));
    tmp1 = FromConstexpr_intptr_constexpr_intptr_0(state_, arraysize(wasm::kFpReturnRegisters));
    tmp2 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp3 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    tmp4 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReturnSlotAllocator_0{TNode<IntPtrT>{tmp0}, TNode<IntPtrT>{tmp1}, TNode<BoolT>{tmp3}, TNode<BoolT>{tmp4}, TNode<IntPtrT>{tmp2}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=376&c=1
TorqueStructLocationAllocator_0 LocationAllocatorForParams_0(compiler::CodeAssemblerState* state_, TorqueStructReference_intptr_0 p_paramBuffer) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block3(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT> block4(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block9(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<IntPtrT> tmp0;
  TNode<IntPtrT> tmp1;
  TNode<IntPtrT> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).UniqueIntPtrConstant(arraysize(wasm::kGpParamRegisters) - 1);
    tmp1 = CodeStubAssembler(state_).UniqueIntPtrConstant(arraysize(wasm::kFpParamRegisters));
    tmp2 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp3 = CodeStubAssembler(state_).IntPtrMul(TNode<IntPtrT>{tmp0}, TNode<IntPtrT>{tmp2});
    if (((CodeStubAssembler(state_).ConstexprBoolNot((CodeStubAssembler(state_).Is64()))))) {
      ca_.Goto(&block2);
    } else {
      ca_.Goto(&block3);
    }
  }

  TNode<IntPtrT> tmp4;
  TNode<IntPtrT> tmp5;
  TNode<IntPtrT> tmp6;
  if (block2.is_used()) {
    ca_.Bind(&block2);
    tmp4 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp5 = CodeStubAssembler(state_).WordAnd(TNode<IntPtrT>{tmp3}, TNode<IntPtrT>{tmp4});
    tmp6 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp3}, TNode<IntPtrT>{tmp5});
    ca_.Goto(&block4, tmp6);
  }

  if (block3.is_used()) {
    ca_.Bind(&block3);
    ca_.Goto(&block4, tmp3);
  }

  TNode<IntPtrT> phi_bb4_6;
  TNode<IntPtrT> tmp7;
  TNode<IntPtrT> tmp8;
  TNode<IntPtrT> tmp9;
  TNode<IntPtrT> tmp10;
  TNode<IntPtrT> tmp11;
  TNode<BoolT> tmp12;
  if (block4.is_used()) {
    ca_.Bind(&block4, &phi_bb4_6);
    tmp7 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb4_6}, TNode<IntPtrT>{p_paramBuffer.offset});
    tmp8 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_float64_0(state_)));
    tmp9 = CodeStubAssembler(state_).IntPtrMul(TNode<IntPtrT>{tmp1}, TNode<IntPtrT>{tmp8});
    tmp10 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp7}, TNode<IntPtrT>{tmp9});
    tmp11 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp12 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block9);
  }

    ca_.Bind(&block9);
  return TorqueStructLocationAllocator_0{TNode<Object>{p_paramBuffer.object}, TNode<IntPtrT>{tmp0}, TNode<IntPtrT>{tmp1}, TNode<IntPtrT>{p_paramBuffer.offset}, TNode<IntPtrT>{tmp7}, TNode<IntPtrT>{tmp10}, TNode<IntPtrT>{tmp10}, TNode<IntPtrT>{tmp11}, TNode<BoolT>{tmp12}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=397&c=1
TorqueStructLocationAllocator_0 LocationAllocatorForReturns_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_gpRegs, TNode<RawPtrT> p_fpRegs, TNode<RawPtrT> p_stack) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<TaggedIndex> tmp0;
  TNode<IntPtrT> tmp1;
  TNode<IntPtrT> tmp2;
  TNode<IntPtrT> tmp3;
  TNode<IntPtrT> tmp4;
  TNode<IntPtrT> tmp5;
  TNode<IntPtrT> tmp6;
  TNode<IntPtrT> tmp7;
  TNode<IntPtrT> tmp8;
  TNode<IntPtrT> tmp9;
  TNode<IntPtrT> tmp10;
  TNode<IntPtrT> tmp11;
  TNode<IntPtrT> tmp12;
  TNode<BoolT> tmp13;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = kZeroBitPattern_0(state_);
    tmp1 = FromConstexpr_intptr_constexpr_intptr_0(state_, arraysize(wasm::kGpReturnRegisters));
    tmp2 = FromConstexpr_intptr_constexpr_intptr_0(state_, arraysize(wasm::kFpReturnRegisters));
    tmp3 = Convert_intptr_RawPtr_0(state_, TNode<RawPtrT>{p_gpRegs});
    tmp4 = FromConstexpr_intptr_constexpr_int31_0(state_, kHeapObjectTag);
    tmp5 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp3}, TNode<IntPtrT>{tmp4});
    tmp6 = Convert_intptr_RawPtr_0(state_, TNode<RawPtrT>{p_fpRegs});
    tmp7 = FromConstexpr_intptr_constexpr_int31_0(state_, kHeapObjectTag);
    tmp8 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp6}, TNode<IntPtrT>{tmp7});
    tmp9 = Convert_intptr_RawPtr_0(state_, TNode<RawPtrT>{p_stack});
    tmp10 = FromConstexpr_intptr_constexpr_int31_0(state_, kHeapObjectTag);
    tmp11 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp9}, TNode<IntPtrT>{tmp10});
    tmp12 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp13 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructLocationAllocator_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp1}, TNode<IntPtrT>{tmp2}, TNode<IntPtrT>{tmp5}, TNode<IntPtrT>{tmp8}, TNode<IntPtrT>{tmp11}, TNode<IntPtrT>{tmp11}, TNode<IntPtrT>{tmp12}, TNode<BoolT>{tmp13}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=412&c=1
TNode<Object> JSToWasmObject_0(compiler::CodeAssemblerState* state_, TNode<NativeContext> p_context, TNode<HeapObject> p_trustedInstanceDataOrUndefined, TNode<Int32T> p_targetType, TNode<Object> p_value) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block4(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block5(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block6(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block9(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block10(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block11(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block7(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block8(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block3(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block12(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block14(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block15(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block16(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block17(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block18(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block20(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block21(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block19(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block13(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object> block1(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object> block23(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  TNode<Int32T> tmp2;
  TNode<Int32T> tmp3;
  TNode<Int32T> tmp4;
  TNode<Int32T> tmp5;
  TNode<Int32T> tmp6;
  TNode<BoolT> tmp7;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::ValueType::kKindBits);
    tmp1 = CodeStubAssembler(state_).Word32Sar(TNode<Int32T>{p_targetType}, TNode<Int32T>{tmp0});
    tmp2 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmHeapTypeBitsMask);
    tmp3 = CodeStubAssembler(state_).Word32And(TNode<Int32T>{tmp1}, TNode<Int32T>{tmp2});
    tmp4 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmValueKindBitsMask);
    tmp5 = CodeStubAssembler(state_).Word32And(TNode<Int32T>{p_targetType}, TNode<Int32T>{tmp4});
    tmp6 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kExtern);
    tmp7 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp3}, TNode<Int32T>{tmp6});
    ca_.Branch(tmp7, &block4, std::vector<compiler::Node*>{}, &block5, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp8;
  if (block4.is_used()) {
    ca_.Bind(&block4);
    tmp8 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block6, tmp8);
  }

  TNode<Int32T> tmp9;
  TNode<BoolT> tmp10;
  if (block5.is_used()) {
    ca_.Bind(&block5);
    tmp9 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kNoExtern);
    tmp10 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp3}, TNode<Int32T>{tmp9});
    ca_.Goto(&block6, tmp10);
  }

  TNode<BoolT> phi_bb6_7;
  if (block6.is_used()) {
    ca_.Bind(&block6, &phi_bb6_7);
    ca_.Branch(phi_bb6_7, &block2, std::vector<compiler::Node*>{}, &block3, std::vector<compiler::Node*>{});
  }

  TNode<Int32T> tmp11;
  TNode<BoolT> tmp12;
  if (block2.is_used()) {
    ca_.Bind(&block2);
    tmp11 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::ValueKind::kRef);
    tmp12 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp11});
    ca_.Branch(tmp12, &block9, std::vector<compiler::Node*>{}, &block10, std::vector<compiler::Node*>{});
  }

  TNode<Null> tmp13;
  TNode<BoolT> tmp14;
  if (block9.is_used()) {
    ca_.Bind(&block9);
    tmp13 = Null_0(state_);
    tmp14 = CodeStubAssembler(state_).TaggedEqual(TNode<Object>{p_value}, TNode<HeapObject>{tmp13});
    ca_.Goto(&block11, tmp14);
  }

  TNode<BoolT> tmp15;
  if (block10.is_used()) {
    ca_.Bind(&block10);
    tmp15 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block11, tmp15);
  }

  TNode<BoolT> phi_bb11_7;
  if (block11.is_used()) {
    ca_.Bind(&block11, &phi_bb11_7);
    ca_.Branch(phi_bb11_7, &block7, std::vector<compiler::Node*>{}, &block8, std::vector<compiler::Node*>{});
  }

  if (block7.is_used()) {
    ca_.Bind(&block7);
    CodeStubAssembler(state_).ThrowTypeError(TNode<Context>{p_context}, MessageTemplate::kWasmTrapJSTypeError);
  }

  if (block8.is_used()) {
    ca_.Bind(&block8);
    ca_.Goto(&block1, p_value);
  }

  TNode<Int32T> tmp16;
  TNode<BoolT> tmp17;
  if (block3.is_used()) {
    ca_.Bind(&block3);
    tmp16 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kString);
    tmp17 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp3}, TNode<Int32T>{tmp16});
    ca_.Branch(tmp17, &block12, std::vector<compiler::Node*>{}, &block13, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp18;
  if (block12.is_used()) {
    ca_.Bind(&block12);
    tmp18 = CodeStubAssembler(state_).TaggedIsSmi(TNode<Object>{p_value});
    ca_.Branch(tmp18, &block14, std::vector<compiler::Node*>{}, &block15, std::vector<compiler::Node*>{});
  }

  if (block14.is_used()) {
    ca_.Bind(&block14);
    CodeStubAssembler(state_).ThrowTypeError(TNode<Context>{p_context}, MessageTemplate::kWasmTrapJSTypeError);
  }

  TNode<HeapObject> tmp19;
  TNode<BoolT> tmp20;
  if (block15.is_used()) {
    ca_.Bind(&block15);
    tmp19 = UnsafeCast_HeapObject_0(state_, TNode<Context>{p_context}, TNode<Object>{p_value});
    tmp20 = CodeStubAssembler(state_).IsString(TNode<HeapObject>{tmp19});
    ca_.Branch(tmp20, &block16, std::vector<compiler::Node*>{}, &block17, std::vector<compiler::Node*>{});
  }

  if (block16.is_used()) {
    ca_.Bind(&block16);
    ca_.Goto(&block1, p_value);
  }

  TNode<Null> tmp21;
  TNode<BoolT> tmp22;
  if (block17.is_used()) {
    ca_.Bind(&block17);
    tmp21 = Null_0(state_);
    tmp22 = CodeStubAssembler(state_).TaggedEqual(TNode<Object>{p_value}, TNode<HeapObject>{tmp21});
    ca_.Branch(tmp22, &block18, std::vector<compiler::Node*>{}, &block19, std::vector<compiler::Node*>{});
  }

  TNode<Int32T> tmp23;
  TNode<BoolT> tmp24;
  if (block18.is_used()) {
    ca_.Bind(&block18);
    tmp23 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::ValueKind::kRef);
    tmp24 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp23});
    ca_.Branch(tmp24, &block20, std::vector<compiler::Node*>{}, &block21, std::vector<compiler::Node*>{});
  }

  if (block20.is_used()) {
    ca_.Bind(&block20);
    CodeStubAssembler(state_).ThrowTypeError(TNode<Context>{p_context}, MessageTemplate::kWasmTrapJSTypeError);
  }

  TNode<WasmNull> tmp25;
  if (block21.is_used()) {
    ca_.Bind(&block21);
    tmp25 = kWasmNull_0(state_);
    ca_.Goto(&block1, tmp25);
  }

  if (block19.is_used()) {
    ca_.Bind(&block19);
    CodeStubAssembler(state_).ThrowTypeError(TNode<Context>{p_context}, MessageTemplate::kWasmTrapJSTypeError);
  }

  TNode<Smi> tmp26;
  TNode<Object> tmp27;
  if (block13.is_used()) {
    ca_.Bind(&block13);
    tmp26 = Convert_Smi_int32_0(state_, TNode<Int32T>{p_targetType});
    tmp27 = CodeStubAssembler(state_).CallRuntime(Runtime::kWasmGenericJSToWasmObject, p_context, p_trustedInstanceDataOrUndefined, p_value, tmp26); 
    ca_.Goto(&block1, tmp27);
  }

  TNode<Object> phi_bb1_4;
  if (block1.is_used()) {
    ca_.Bind(&block1, &phi_bb1_4);
    ca_.Goto(&block23, phi_bb1_4);
  }

  TNode<Object> phi_bb23_4;
    ca_.Bind(&block23, &phi_bb23_4);
  return TNode<Object>{phi_bb23_4};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=445&c=1
void JSToWasmWrapperHelper_0(compiler::CodeAssemblerState* state_, TNode<NativeContext> p_context, TNode<Object> p__receiver, TNode<JSFunction> p_target, TorqueStructArguments p_arguments, bool p_switchStack) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block1(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block4(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block5(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block3(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block6(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block11(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block10(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block15(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block13(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block24(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block28(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block29(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block31(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block32(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block34(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block35(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block36(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block33(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block27(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block25(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block37(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block41(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block42(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block44(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block45(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block47(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block48(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block49(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block46(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block40(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block50(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block54(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block55(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block57(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block58(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block60(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block61(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block62(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block59(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block53(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block51(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block52(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block38(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block63(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block67(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block68(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block70(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block71(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block73(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block74(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block75(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block72(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block66(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block64(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block76(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block80(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block81(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block82(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block83(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block84(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block79(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block77(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block93(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block94(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block96(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block97(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block99(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block100(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block101(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block98(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block92(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block78(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block65(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block39(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block26(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block14(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block103(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT> block104(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, IntPtrT, IntPtrT> block102(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT> block7(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT> block109(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT> block108(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT> block110(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT> block111(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, Object, IntPtrT> block112(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT> block113(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT> block114(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, BoolT, Int32T> block115(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block118(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block116(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block121(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block125(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block126(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block128(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block129(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block131(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block132(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block127(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block124(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block136(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block135(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block133(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block122(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block137(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block141(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block142(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block144(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block145(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block147(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block148(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block143(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block140(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block138(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block149(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block153(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block154(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block155(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block159(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block160(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block162(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block163(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block158(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block156(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block152(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block150(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block164(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block167(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block171(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block172(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block174(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block175(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block177(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block178(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block173(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block170(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block168(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block180(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block181(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block183(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block184(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block186(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block187(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block182(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block179(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block189(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block190(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block192(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block193(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block195(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block196(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT, Object, IntPtrT> block191(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT, Object, IntPtrT> block188(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block169(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block165(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block166(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block151(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block139(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block123(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block117(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block204(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block207(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block208(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block209(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block213(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block214(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block216(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block217(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block219(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block220(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block215(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object, IntPtrT> block212(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block210(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block211(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Int32T> block223(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Int32T> block221(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Int32T> block227(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Int32T> block228(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Int32T, BoolT> block229(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Int32T> block225(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Int32T> block226(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block231(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block232(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block234(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block235(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block237(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T> block238(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Object, IntPtrT> block233(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Object, IntPtrT> block230(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Int32T, Int32T> block222(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block205(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, IntPtrT> block241(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, IntPtrT> block242(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block243(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block244(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, Object> block245(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T> block246(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, BoolT, Int32T, IntPtrT> block247(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<IntPtrT> tmp0;
  TNode<SharedFunctionInfo> tmp1;
  TNode<IntPtrT> tmp2;
  TNode<Object> tmp3;
  TNode<WasmExportedFunctionData> tmp4;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = FromConstexpr_intptr_constexpr_int31_0(state_, 32);
    tmp1 = CodeStubAssembler(state_).LoadReference<SharedFunctionInfo>(CodeStubAssembler::Reference{p_target, tmp0});
    tmp2 = FromConstexpr_intptr_constexpr_int31_0(state_, 8);
    tmp3 = CodeStubAssembler(state_).LoadReference<Object>(CodeStubAssembler::Reference{tmp1, tmp2});
    tmp4 = UnsafeCast_WasmExportedFunctionData_0(state_, TNode<Context>{p_context}, TNode<Object>{tmp3});
    if (((CodeStubAssembler(state_).ConstexprBoolNot(p_switchStack)))) {
      ca_.Goto(&block1);
    } else {
      ca_.Goto(&block2);
    }
  }

  TNode<IntPtrT> tmp5;
  TNode<IntPtrT> tmp6;
  TNode<Smi> tmp7;
  TNode<Smi> tmp8;
  TNode<Smi> tmp9;
  TNode<IntPtrT> tmp10;
  TNode<Smi> tmp11;
  TNode<Smi> tmp12;
  TNode<BoolT> tmp13;
  if (block1.is_used()) {
    ca_.Bind(&block1);
    tmp5 = FromConstexpr_intptr_constexpr_int31_0(state_, 48);
    tmp6 = FromConstexpr_intptr_constexpr_int31_0(state_, 48);
    tmp7 = CodeStubAssembler(state_).LoadReference<Smi>(CodeStubAssembler::Reference{tmp4, tmp6});
    tmp8 = FromConstexpr_Smi_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp9 = CodeStubAssembler(state_).SmiSub(TNode<Smi>{tmp7}, TNode<Smi>{tmp8});
    CodeStubAssembler(state_).StoreReference<Smi>(CodeStubAssembler::Reference{tmp4, tmp5}, tmp9);
    tmp10 = FromConstexpr_intptr_constexpr_int31_0(state_, 48);
    tmp11 = CodeStubAssembler(state_).LoadReference<Smi>(CodeStubAssembler::Reference{tmp4, tmp10});
    tmp12 = FromConstexpr_Smi_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp13 = CodeStubAssembler(state_).SmiEqual(TNode<Smi>{tmp11}, TNode<Smi>{tmp12});
    ca_.Branch(tmp13, &block4, std::vector<compiler::Node*>{}, &block5, std::vector<compiler::Node*>{});
  }

  TNode<Smi> tmp14;
  TNode<Object> tmp15;
  if (block4.is_used()) {
    ca_.Bind(&block4);
    tmp14 = kNoContext_0(state_);
    tmp15 = CodeStubAssembler(state_).CallRuntime(Runtime::kWasmCompileWrapper, tmp14, tmp4); 
    ca_.Goto(&block5);
  }

  if (block5.is_used()) {
    ca_.Bind(&block5);
    ca_.Goto(&block3);
  }

  if (block2.is_used()) {
    ca_.Bind(&block2);
    ca_.Goto(&block3);
  }

  TNode<RawPtrT> tmp16;
  TNode<IntPtrT> tmp17;
  TNode<WasmInstanceObject> tmp18;
  TNode<WasmTrustedInstanceData> tmp19;
  TNode<IntPtrT> tmp20;
  TNode<Object> tmp21;
  TNode<IntPtrT> tmp22;
  TNode<Int32T> tmp23;
  TNode<IntPtrT> tmp24;
  TNode<Object> tmp25;
  TNode<IntPtrT> tmp26;
  TNode<Int32T> tmp27;
  TNode<IntPtrT> tmp28;
  TNode<Object> tmp29;
  TNode<IntPtrT> tmp30;
  TNode<RawPtrT> tmp31;
  TNode<RawPtrT> tmp32;
  TNode<Int32T> tmp33;
  TNode<IntPtrT> tmp34;
  TNode<Object> tmp35;
  TNode<IntPtrT> tmp36;
  TNode<IntPtrT> tmp37;
  TNode<Undefined> tmp38;
  TNode<IntPtrT> tmp39;
  TNode<BoolT> tmp40;
  TNode<Int32T> tmp41;
  TNode<BoolT> tmp42;
  if (block3.is_used()) {
    ca_.Bind(&block3);
    tmp16 = CodeStubAssembler(state_).LoadWasmExportedFunctionDataSigPtr(TNode<WasmExportedFunctionData>{tmp4});
    tmp17 = FromConstexpr_intptr_constexpr_int31_0(state_, 32);
    tmp18 = CodeStubAssembler(state_).LoadReference<WasmInstanceObject>(CodeStubAssembler::Reference{tmp4, tmp17});
    tmp19 = WasmBuiltinsAssembler(state_).LoadTrustedDataFromInstance(TNode<WasmInstanceObject>{tmp18});
    tmp20 = FromConstexpr_intptr_constexpr_intptr_0(state_, wasm::FunctionSig::kParameterCountOffset);
    std::tie(tmp21, tmp22) = GetRefAt_int32_RawPtr_0(state_, TNode<RawPtrT>{tmp16}, TNode<IntPtrT>{tmp20}).Flatten();
    tmp23 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp21, tmp22});
    tmp24 = FromConstexpr_intptr_constexpr_intptr_0(state_, wasm::FunctionSig::kReturnCountOffset);
    std::tie(tmp25, tmp26) = GetRefAt_int32_RawPtr_0(state_, TNode<RawPtrT>{tmp16}, TNode<IntPtrT>{tmp24}).Flatten();
    tmp27 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp25, tmp26});
    tmp28 = FromConstexpr_intptr_constexpr_intptr_0(state_, wasm::FunctionSig::kRepsOffset);
    std::tie(tmp29, tmp30) = GetRefAt_RawPtr_RawPtr_0(state_, TNode<RawPtrT>{tmp16}, TNode<IntPtrT>{tmp28}).Flatten();
    tmp31 = CodeStubAssembler(state_).LoadReference<RawPtrT>(CodeStubAssembler::Reference{tmp29, tmp30});
    tmp32 = (TNode<RawPtrT>{tmp31});
    tmp33 = CodeStubAssembler(state_).Int32Add(TNode<Int32T>{tmp23}, TNode<Int32T>{tmp27});
    tmp34 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp33});
    std::tie(tmp35, tmp36, tmp37) = NewOffHeapConstSlice_int32_0(state_, TNode<RawPtrT>{tmp32}, TNode<IntPtrT>{tmp34}).Flatten();
    tmp38 = Undefined_0(state_);
    tmp39 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp40 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    tmp41 = FromConstexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp42 = CodeStubAssembler(state_).Int32GreaterThan(TNode<Int32T>{tmp27}, TNode<Int32T>{tmp41});
    ca_.Branch(tmp42, &block6, std::vector<compiler::Node*>{}, &block7, std::vector<compiler::Node*>{tmp38, tmp39, tmp40});
  }

  TNode<Smi> tmp43;
  TNode<JSArray> tmp44;
  TNode<IntPtrT> tmp45;
  TNode<IntPtrT> tmp46;
  TNode<Object> tmp47;
  TNode<IntPtrT> tmp48;
  TNode<IntPtrT> tmp49;
  if (block6.is_used()) {
    ca_.Bind(&block6);
    tmp43 = Convert_Smi_int32_0(state_, TNode<Int32T>{tmp27});
    tmp44 = ca_.CallBuiltin<JSArray>(Builtin::kWasmAllocateJSArray, p_context, tmp43);
    tmp45 = Convert_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp46 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp27});
    compiler::CodeAssemblerLabel label50(&ca_);
    std::tie(tmp47, tmp48, tmp49) = Subslice_int32_0(state_, TorqueStructSlice_int32_ConstReference_int32_0{TNode<Object>{tmp35}, TNode<IntPtrT>{tmp36}, TNode<IntPtrT>{tmp37}, TorqueStructUnsafe_0{}}, TNode<IntPtrT>{tmp45}, TNode<IntPtrT>{tmp46}, &label50).Flatten();
    ca_.Goto(&block10);
    if (label50.is_used()) {
      ca_.Bind(&label50);
      ca_.Goto(&block11);
    }
  }

  if (block11.is_used()) {
    ca_.Bind(&block11);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> tmp51;
  TNode<IntPtrT> tmp52;
  TNode<IntPtrT> tmp53;
  TNode<IntPtrT> tmp54;
  TNode<BoolT> tmp55;
  TNode<BoolT> tmp56;
  TNode<IntPtrT> tmp57;
  if (block10.is_used()) {
    ca_.Bind(&block10);
    tmp51 = TimesSizeOf_int32_0(state_, TNode<IntPtrT>{tmp49});
    tmp52 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp48}, TNode<IntPtrT>{tmp51});
    std::tie(tmp53, tmp54, tmp55, tmp56, tmp57) = NewReturnSlotAllocator_0(state_).Flatten();
    ca_.Goto(&block15, tmp40, tmp48, tmp53, tmp54, tmp55, tmp56, tmp57);
  }

  TNode<BoolT> phi_bb15_18;
  TNode<IntPtrT> phi_bb15_23;
  TNode<IntPtrT> phi_bb15_25;
  TNode<IntPtrT> phi_bb15_26;
  TNode<BoolT> phi_bb15_27;
  TNode<BoolT> phi_bb15_28;
  TNode<IntPtrT> phi_bb15_29;
  TNode<BoolT> tmp58;
  TNode<BoolT> tmp59;
  if (block15.is_used()) {
    ca_.Bind(&block15, &phi_bb15_18, &phi_bb15_23, &phi_bb15_25, &phi_bb15_26, &phi_bb15_27, &phi_bb15_28, &phi_bb15_29);
    tmp58 = CodeStubAssembler(state_).WordEqual(TNode<IntPtrT>{phi_bb15_23}, TNode<IntPtrT>{tmp52});
    tmp59 = CodeStubAssembler(state_).Word32BinaryNot(TNode<BoolT>{tmp58});
    ca_.Branch(tmp59, &block13, std::vector<compiler::Node*>{phi_bb15_18, phi_bb15_23, phi_bb15_25, phi_bb15_26, phi_bb15_27, phi_bb15_28, phi_bb15_29}, &block14, std::vector<compiler::Node*>{phi_bb15_18, phi_bb15_23, phi_bb15_25, phi_bb15_26, phi_bb15_27, phi_bb15_28, phi_bb15_29});
  }

  TNode<BoolT> phi_bb13_18;
  TNode<IntPtrT> phi_bb13_23;
  TNode<IntPtrT> phi_bb13_25;
  TNode<IntPtrT> phi_bb13_26;
  TNode<BoolT> phi_bb13_27;
  TNode<BoolT> phi_bb13_28;
  TNode<IntPtrT> phi_bb13_29;
  TNode<Object> tmp60;
  TNode<IntPtrT> tmp61;
  TNode<IntPtrT> tmp62;
  TNode<IntPtrT> tmp63;
  TNode<Int32T> tmp64;
  TNode<Int32T> tmp65;
  TNode<BoolT> tmp66;
  if (block13.is_used()) {
    ca_.Bind(&block13, &phi_bb13_18, &phi_bb13_23, &phi_bb13_25, &phi_bb13_26, &phi_bb13_27, &phi_bb13_28, &phi_bb13_29);
    std::tie(tmp60, tmp61) = NewReference_int32_0(state_, TNode<Object>{tmp47}, TNode<IntPtrT>{phi_bb13_23}).Flatten();
    tmp62 = FromConstexpr_intptr_constexpr_int31_0(state_, kInt32Size);
    tmp63 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb13_23}, TNode<IntPtrT>{tmp62});
    tmp64 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp60, tmp61});
    tmp65 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI32.raw_bit_field());
    tmp66 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp64}, TNode<Int32T>{tmp65});
    ca_.Branch(tmp66, &block24, std::vector<compiler::Node*>{phi_bb13_18, phi_bb13_25, phi_bb13_26, phi_bb13_27, phi_bb13_28, phi_bb13_29}, &block25, std::vector<compiler::Node*>{phi_bb13_18, phi_bb13_25, phi_bb13_26, phi_bb13_27, phi_bb13_28, phi_bb13_29});
  }

  TNode<BoolT> phi_bb24_18;
  TNode<IntPtrT> phi_bb24_25;
  TNode<IntPtrT> phi_bb24_26;
  TNode<BoolT> phi_bb24_27;
  TNode<BoolT> phi_bb24_28;
  TNode<IntPtrT> phi_bb24_29;
  TNode<IntPtrT> tmp67;
  TNode<BoolT> tmp68;
  if (block24.is_used()) {
    ca_.Bind(&block24, &phi_bb24_18, &phi_bb24_25, &phi_bb24_26, &phi_bb24_27, &phi_bb24_28, &phi_bb24_29);
    tmp67 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp68 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb24_25}, TNode<IntPtrT>{tmp67});
    ca_.Branch(tmp68, &block28, std::vector<compiler::Node*>{phi_bb24_18, phi_bb24_25, phi_bb24_26, phi_bb24_27, phi_bb24_28, phi_bb24_29}, &block29, std::vector<compiler::Node*>{phi_bb24_18, phi_bb24_25, phi_bb24_26, phi_bb24_27, phi_bb24_28, phi_bb24_29});
  }

  TNode<BoolT> phi_bb28_18;
  TNode<IntPtrT> phi_bb28_25;
  TNode<IntPtrT> phi_bb28_26;
  TNode<BoolT> phi_bb28_27;
  TNode<BoolT> phi_bb28_28;
  TNode<IntPtrT> phi_bb28_29;
  TNode<IntPtrT> tmp69;
  TNode<IntPtrT> tmp70;
  if (block28.is_used()) {
    ca_.Bind(&block28, &phi_bb28_18, &phi_bb28_25, &phi_bb28_26, &phi_bb28_27, &phi_bb28_28, &phi_bb28_29);
    tmp69 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp70 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb28_25}, TNode<IntPtrT>{tmp69});
    ca_.Goto(&block27, phi_bb28_18, tmp70, phi_bb28_26, phi_bb28_27, phi_bb28_28, phi_bb28_29);
  }

  TNode<BoolT> phi_bb29_18;
  TNode<IntPtrT> phi_bb29_25;
  TNode<IntPtrT> phi_bb29_26;
  TNode<BoolT> phi_bb29_27;
  TNode<BoolT> phi_bb29_28;
  TNode<IntPtrT> phi_bb29_29;
  if (block29.is_used()) {
    ca_.Bind(&block29, &phi_bb29_18, &phi_bb29_25, &phi_bb29_26, &phi_bb29_27, &phi_bb29_28, &phi_bb29_29);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block31, phi_bb29_18, phi_bb29_25, phi_bb29_26, phi_bb29_27, phi_bb29_28, phi_bb29_29);
    } else {
      ca_.Goto(&block32, phi_bb29_18, phi_bb29_25, phi_bb29_26, phi_bb29_27, phi_bb29_28, phi_bb29_29);
    }
  }

  TNode<BoolT> phi_bb31_18;
  TNode<IntPtrT> phi_bb31_25;
  TNode<IntPtrT> phi_bb31_26;
  TNode<BoolT> phi_bb31_27;
  TNode<BoolT> phi_bb31_28;
  TNode<IntPtrT> phi_bb31_29;
  TNode<IntPtrT> tmp71;
  TNode<IntPtrT> tmp72;
  if (block31.is_used()) {
    ca_.Bind(&block31, &phi_bb31_18, &phi_bb31_25, &phi_bb31_26, &phi_bb31_27, &phi_bb31_28, &phi_bb31_29);
    tmp71 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp72 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb31_29}, TNode<IntPtrT>{tmp71});
    ca_.Goto(&block33, phi_bb31_18, phi_bb31_25, phi_bb31_26, phi_bb31_27, phi_bb31_28, tmp72);
  }

  TNode<BoolT> phi_bb32_18;
  TNode<IntPtrT> phi_bb32_25;
  TNode<IntPtrT> phi_bb32_26;
  TNode<BoolT> phi_bb32_27;
  TNode<BoolT> phi_bb32_28;
  TNode<IntPtrT> phi_bb32_29;
  if (block32.is_used()) {
    ca_.Bind(&block32, &phi_bb32_18, &phi_bb32_25, &phi_bb32_26, &phi_bb32_27, &phi_bb32_28, &phi_bb32_29);
    ca_.Branch(phi_bb32_27, &block34, std::vector<compiler::Node*>{phi_bb32_18, phi_bb32_25, phi_bb32_26, phi_bb32_27, phi_bb32_28, phi_bb32_29}, &block35, std::vector<compiler::Node*>{phi_bb32_18, phi_bb32_25, phi_bb32_26, phi_bb32_27, phi_bb32_28, phi_bb32_29});
  }

  TNode<BoolT> phi_bb34_18;
  TNode<IntPtrT> phi_bb34_25;
  TNode<IntPtrT> phi_bb34_26;
  TNode<BoolT> phi_bb34_27;
  TNode<BoolT> phi_bb34_28;
  TNode<IntPtrT> phi_bb34_29;
  TNode<BoolT> tmp73;
  TNode<BoolT> tmp74;
  if (block34.is_used()) {
    ca_.Bind(&block34, &phi_bb34_18, &phi_bb34_25, &phi_bb34_26, &phi_bb34_27, &phi_bb34_28, &phi_bb34_29);
    tmp73 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    tmp74 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block36, phi_bb34_18, phi_bb34_25, phi_bb34_26, tmp73, tmp74, phi_bb34_29);
  }

  TNode<BoolT> phi_bb35_18;
  TNode<IntPtrT> phi_bb35_25;
  TNode<IntPtrT> phi_bb35_26;
  TNode<BoolT> phi_bb35_27;
  TNode<BoolT> phi_bb35_28;
  TNode<IntPtrT> phi_bb35_29;
  TNode<IntPtrT> tmp75;
  TNode<IntPtrT> tmp76;
  TNode<BoolT> tmp77;
  TNode<BoolT> tmp78;
  if (block35.is_used()) {
    ca_.Bind(&block35, &phi_bb35_18, &phi_bb35_25, &phi_bb35_26, &phi_bb35_27, &phi_bb35_28, &phi_bb35_29);
    tmp75 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x2ull));
    tmp76 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb35_29}, TNode<IntPtrT>{tmp75});
    tmp77 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    tmp78 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block36, phi_bb35_18, phi_bb35_25, phi_bb35_26, tmp77, tmp78, tmp76);
  }

  TNode<BoolT> phi_bb36_18;
  TNode<IntPtrT> phi_bb36_25;
  TNode<IntPtrT> phi_bb36_26;
  TNode<BoolT> phi_bb36_27;
  TNode<BoolT> phi_bb36_28;
  TNode<IntPtrT> phi_bb36_29;
  if (block36.is_used()) {
    ca_.Bind(&block36, &phi_bb36_18, &phi_bb36_25, &phi_bb36_26, &phi_bb36_27, &phi_bb36_28, &phi_bb36_29);
    ca_.Goto(&block33, phi_bb36_18, phi_bb36_25, phi_bb36_26, phi_bb36_27, phi_bb36_28, phi_bb36_29);
  }

  TNode<BoolT> phi_bb33_18;
  TNode<IntPtrT> phi_bb33_25;
  TNode<IntPtrT> phi_bb33_26;
  TNode<BoolT> phi_bb33_27;
  TNode<BoolT> phi_bb33_28;
  TNode<IntPtrT> phi_bb33_29;
  if (block33.is_used()) {
    ca_.Bind(&block33, &phi_bb33_18, &phi_bb33_25, &phi_bb33_26, &phi_bb33_27, &phi_bb33_28, &phi_bb33_29);
    ca_.Goto(&block27, phi_bb33_18, phi_bb33_25, phi_bb33_26, phi_bb33_27, phi_bb33_28, phi_bb33_29);
  }

  TNode<BoolT> phi_bb27_18;
  TNode<IntPtrT> phi_bb27_25;
  TNode<IntPtrT> phi_bb27_26;
  TNode<BoolT> phi_bb27_27;
  TNode<BoolT> phi_bb27_28;
  TNode<IntPtrT> phi_bb27_29;
  if (block27.is_used()) {
    ca_.Bind(&block27, &phi_bb27_18, &phi_bb27_25, &phi_bb27_26, &phi_bb27_27, &phi_bb27_28, &phi_bb27_29);
    ca_.Goto(&block26, phi_bb27_18, phi_bb27_25, phi_bb27_26, phi_bb27_27, phi_bb27_28, phi_bb27_29);
  }

  TNode<BoolT> phi_bb25_18;
  TNode<IntPtrT> phi_bb25_25;
  TNode<IntPtrT> phi_bb25_26;
  TNode<BoolT> phi_bb25_27;
  TNode<BoolT> phi_bb25_28;
  TNode<IntPtrT> phi_bb25_29;
  TNode<Int32T> tmp79;
  TNode<BoolT> tmp80;
  if (block25.is_used()) {
    ca_.Bind(&block25, &phi_bb25_18, &phi_bb25_25, &phi_bb25_26, &phi_bb25_27, &phi_bb25_28, &phi_bb25_29);
    tmp79 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI64.raw_bit_field());
    tmp80 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp64}, TNode<Int32T>{tmp79});
    ca_.Branch(tmp80, &block37, std::vector<compiler::Node*>{phi_bb25_18, phi_bb25_25, phi_bb25_26, phi_bb25_27, phi_bb25_28, phi_bb25_29}, &block38, std::vector<compiler::Node*>{phi_bb25_18, phi_bb25_25, phi_bb25_26, phi_bb25_27, phi_bb25_28, phi_bb25_29});
  }

  TNode<BoolT> phi_bb37_18;
  TNode<IntPtrT> phi_bb37_25;
  TNode<IntPtrT> phi_bb37_26;
  TNode<BoolT> phi_bb37_27;
  TNode<BoolT> phi_bb37_28;
  TNode<IntPtrT> phi_bb37_29;
  TNode<IntPtrT> tmp81;
  TNode<BoolT> tmp82;
  if (block37.is_used()) {
    ca_.Bind(&block37, &phi_bb37_18, &phi_bb37_25, &phi_bb37_26, &phi_bb37_27, &phi_bb37_28, &phi_bb37_29);
    tmp81 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp82 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb37_25}, TNode<IntPtrT>{tmp81});
    ca_.Branch(tmp82, &block41, std::vector<compiler::Node*>{phi_bb37_18, phi_bb37_25, phi_bb37_26, phi_bb37_27, phi_bb37_28, phi_bb37_29}, &block42, std::vector<compiler::Node*>{phi_bb37_18, phi_bb37_25, phi_bb37_26, phi_bb37_27, phi_bb37_28, phi_bb37_29});
  }

  TNode<BoolT> phi_bb41_18;
  TNode<IntPtrT> phi_bb41_25;
  TNode<IntPtrT> phi_bb41_26;
  TNode<BoolT> phi_bb41_27;
  TNode<BoolT> phi_bb41_28;
  TNode<IntPtrT> phi_bb41_29;
  TNode<IntPtrT> tmp83;
  TNode<IntPtrT> tmp84;
  if (block41.is_used()) {
    ca_.Bind(&block41, &phi_bb41_18, &phi_bb41_25, &phi_bb41_26, &phi_bb41_27, &phi_bb41_28, &phi_bb41_29);
    tmp83 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp84 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb41_25}, TNode<IntPtrT>{tmp83});
    ca_.Goto(&block40, phi_bb41_18, tmp84, phi_bb41_26, phi_bb41_27, phi_bb41_28, phi_bb41_29);
  }

  TNode<BoolT> phi_bb42_18;
  TNode<IntPtrT> phi_bb42_25;
  TNode<IntPtrT> phi_bb42_26;
  TNode<BoolT> phi_bb42_27;
  TNode<BoolT> phi_bb42_28;
  TNode<IntPtrT> phi_bb42_29;
  if (block42.is_used()) {
    ca_.Bind(&block42, &phi_bb42_18, &phi_bb42_25, &phi_bb42_26, &phi_bb42_27, &phi_bb42_28, &phi_bb42_29);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block44, phi_bb42_18, phi_bb42_25, phi_bb42_26, phi_bb42_27, phi_bb42_28, phi_bb42_29);
    } else {
      ca_.Goto(&block45, phi_bb42_18, phi_bb42_25, phi_bb42_26, phi_bb42_27, phi_bb42_28, phi_bb42_29);
    }
  }

  TNode<BoolT> phi_bb44_18;
  TNode<IntPtrT> phi_bb44_25;
  TNode<IntPtrT> phi_bb44_26;
  TNode<BoolT> phi_bb44_27;
  TNode<BoolT> phi_bb44_28;
  TNode<IntPtrT> phi_bb44_29;
  TNode<IntPtrT> tmp85;
  TNode<IntPtrT> tmp86;
  if (block44.is_used()) {
    ca_.Bind(&block44, &phi_bb44_18, &phi_bb44_25, &phi_bb44_26, &phi_bb44_27, &phi_bb44_28, &phi_bb44_29);
    tmp85 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp86 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb44_29}, TNode<IntPtrT>{tmp85});
    ca_.Goto(&block46, phi_bb44_18, phi_bb44_25, phi_bb44_26, phi_bb44_27, phi_bb44_28, tmp86);
  }

  TNode<BoolT> phi_bb45_18;
  TNode<IntPtrT> phi_bb45_25;
  TNode<IntPtrT> phi_bb45_26;
  TNode<BoolT> phi_bb45_27;
  TNode<BoolT> phi_bb45_28;
  TNode<IntPtrT> phi_bb45_29;
  if (block45.is_used()) {
    ca_.Bind(&block45, &phi_bb45_18, &phi_bb45_25, &phi_bb45_26, &phi_bb45_27, &phi_bb45_28, &phi_bb45_29);
    ca_.Branch(phi_bb45_27, &block47, std::vector<compiler::Node*>{phi_bb45_18, phi_bb45_25, phi_bb45_26, phi_bb45_27, phi_bb45_28, phi_bb45_29}, &block48, std::vector<compiler::Node*>{phi_bb45_18, phi_bb45_25, phi_bb45_26, phi_bb45_27, phi_bb45_28, phi_bb45_29});
  }

  TNode<BoolT> phi_bb47_18;
  TNode<IntPtrT> phi_bb47_25;
  TNode<IntPtrT> phi_bb47_26;
  TNode<BoolT> phi_bb47_27;
  TNode<BoolT> phi_bb47_28;
  TNode<IntPtrT> phi_bb47_29;
  TNode<BoolT> tmp87;
  TNode<BoolT> tmp88;
  if (block47.is_used()) {
    ca_.Bind(&block47, &phi_bb47_18, &phi_bb47_25, &phi_bb47_26, &phi_bb47_27, &phi_bb47_28, &phi_bb47_29);
    tmp87 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    tmp88 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block49, phi_bb47_18, phi_bb47_25, phi_bb47_26, tmp87, tmp88, phi_bb47_29);
  }

  TNode<BoolT> phi_bb48_18;
  TNode<IntPtrT> phi_bb48_25;
  TNode<IntPtrT> phi_bb48_26;
  TNode<BoolT> phi_bb48_27;
  TNode<BoolT> phi_bb48_28;
  TNode<IntPtrT> phi_bb48_29;
  TNode<IntPtrT> tmp89;
  TNode<IntPtrT> tmp90;
  TNode<BoolT> tmp91;
  TNode<BoolT> tmp92;
  if (block48.is_used()) {
    ca_.Bind(&block48, &phi_bb48_18, &phi_bb48_25, &phi_bb48_26, &phi_bb48_27, &phi_bb48_28, &phi_bb48_29);
    tmp89 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x2ull));
    tmp90 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb48_29}, TNode<IntPtrT>{tmp89});
    tmp91 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    tmp92 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block49, phi_bb48_18, phi_bb48_25, phi_bb48_26, tmp91, tmp92, tmp90);
  }

  TNode<BoolT> phi_bb49_18;
  TNode<IntPtrT> phi_bb49_25;
  TNode<IntPtrT> phi_bb49_26;
  TNode<BoolT> phi_bb49_27;
  TNode<BoolT> phi_bb49_28;
  TNode<IntPtrT> phi_bb49_29;
  if (block49.is_used()) {
    ca_.Bind(&block49, &phi_bb49_18, &phi_bb49_25, &phi_bb49_26, &phi_bb49_27, &phi_bb49_28, &phi_bb49_29);
    ca_.Goto(&block46, phi_bb49_18, phi_bb49_25, phi_bb49_26, phi_bb49_27, phi_bb49_28, phi_bb49_29);
  }

  TNode<BoolT> phi_bb46_18;
  TNode<IntPtrT> phi_bb46_25;
  TNode<IntPtrT> phi_bb46_26;
  TNode<BoolT> phi_bb46_27;
  TNode<BoolT> phi_bb46_28;
  TNode<IntPtrT> phi_bb46_29;
  if (block46.is_used()) {
    ca_.Bind(&block46, &phi_bb46_18, &phi_bb46_25, &phi_bb46_26, &phi_bb46_27, &phi_bb46_28, &phi_bb46_29);
    ca_.Goto(&block40, phi_bb46_18, phi_bb46_25, phi_bb46_26, phi_bb46_27, phi_bb46_28, phi_bb46_29);
  }

  TNode<BoolT> phi_bb40_18;
  TNode<IntPtrT> phi_bb40_25;
  TNode<IntPtrT> phi_bb40_26;
  TNode<BoolT> phi_bb40_27;
  TNode<BoolT> phi_bb40_28;
  TNode<IntPtrT> phi_bb40_29;
  if (block40.is_used()) {
    ca_.Bind(&block40, &phi_bb40_18, &phi_bb40_25, &phi_bb40_26, &phi_bb40_27, &phi_bb40_28, &phi_bb40_29);
    if (((CodeStubAssembler(state_).ConstexprBoolNot((CodeStubAssembler(state_).Is64()))))) {
      ca_.Goto(&block50, phi_bb40_18, phi_bb40_25, phi_bb40_26, phi_bb40_27, phi_bb40_28, phi_bb40_29);
    } else {
      ca_.Goto(&block51, phi_bb40_18, phi_bb40_25, phi_bb40_26, phi_bb40_27, phi_bb40_28, phi_bb40_29);
    }
  }

  TNode<BoolT> phi_bb50_18;
  TNode<IntPtrT> phi_bb50_25;
  TNode<IntPtrT> phi_bb50_26;
  TNode<BoolT> phi_bb50_27;
  TNode<BoolT> phi_bb50_28;
  TNode<IntPtrT> phi_bb50_29;
  TNode<IntPtrT> tmp93;
  TNode<BoolT> tmp94;
  if (block50.is_used()) {
    ca_.Bind(&block50, &phi_bb50_18, &phi_bb50_25, &phi_bb50_26, &phi_bb50_27, &phi_bb50_28, &phi_bb50_29);
    tmp93 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp94 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb50_25}, TNode<IntPtrT>{tmp93});
    ca_.Branch(tmp94, &block54, std::vector<compiler::Node*>{phi_bb50_18, phi_bb50_25, phi_bb50_26, phi_bb50_27, phi_bb50_28, phi_bb50_29}, &block55, std::vector<compiler::Node*>{phi_bb50_18, phi_bb50_25, phi_bb50_26, phi_bb50_27, phi_bb50_28, phi_bb50_29});
  }

  TNode<BoolT> phi_bb54_18;
  TNode<IntPtrT> phi_bb54_25;
  TNode<IntPtrT> phi_bb54_26;
  TNode<BoolT> phi_bb54_27;
  TNode<BoolT> phi_bb54_28;
  TNode<IntPtrT> phi_bb54_29;
  TNode<IntPtrT> tmp95;
  TNode<IntPtrT> tmp96;
  if (block54.is_used()) {
    ca_.Bind(&block54, &phi_bb54_18, &phi_bb54_25, &phi_bb54_26, &phi_bb54_27, &phi_bb54_28, &phi_bb54_29);
    tmp95 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp96 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb54_25}, TNode<IntPtrT>{tmp95});
    ca_.Goto(&block53, phi_bb54_18, tmp96, phi_bb54_26, phi_bb54_27, phi_bb54_28, phi_bb54_29);
  }

  TNode<BoolT> phi_bb55_18;
  TNode<IntPtrT> phi_bb55_25;
  TNode<IntPtrT> phi_bb55_26;
  TNode<BoolT> phi_bb55_27;
  TNode<BoolT> phi_bb55_28;
  TNode<IntPtrT> phi_bb55_29;
  if (block55.is_used()) {
    ca_.Bind(&block55, &phi_bb55_18, &phi_bb55_25, &phi_bb55_26, &phi_bb55_27, &phi_bb55_28, &phi_bb55_29);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block57, phi_bb55_18, phi_bb55_25, phi_bb55_26, phi_bb55_27, phi_bb55_28, phi_bb55_29);
    } else {
      ca_.Goto(&block58, phi_bb55_18, phi_bb55_25, phi_bb55_26, phi_bb55_27, phi_bb55_28, phi_bb55_29);
    }
  }

  TNode<BoolT> phi_bb57_18;
  TNode<IntPtrT> phi_bb57_25;
  TNode<IntPtrT> phi_bb57_26;
  TNode<BoolT> phi_bb57_27;
  TNode<BoolT> phi_bb57_28;
  TNode<IntPtrT> phi_bb57_29;
  TNode<IntPtrT> tmp97;
  TNode<IntPtrT> tmp98;
  if (block57.is_used()) {
    ca_.Bind(&block57, &phi_bb57_18, &phi_bb57_25, &phi_bb57_26, &phi_bb57_27, &phi_bb57_28, &phi_bb57_29);
    tmp97 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp98 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb57_29}, TNode<IntPtrT>{tmp97});
    ca_.Goto(&block59, phi_bb57_18, phi_bb57_25, phi_bb57_26, phi_bb57_27, phi_bb57_28, tmp98);
  }

  TNode<BoolT> phi_bb58_18;
  TNode<IntPtrT> phi_bb58_25;
  TNode<IntPtrT> phi_bb58_26;
  TNode<BoolT> phi_bb58_27;
  TNode<BoolT> phi_bb58_28;
  TNode<IntPtrT> phi_bb58_29;
  if (block58.is_used()) {
    ca_.Bind(&block58, &phi_bb58_18, &phi_bb58_25, &phi_bb58_26, &phi_bb58_27, &phi_bb58_28, &phi_bb58_29);
    ca_.Branch(phi_bb58_27, &block60, std::vector<compiler::Node*>{phi_bb58_18, phi_bb58_25, phi_bb58_26, phi_bb58_27, phi_bb58_28, phi_bb58_29}, &block61, std::vector<compiler::Node*>{phi_bb58_18, phi_bb58_25, phi_bb58_26, phi_bb58_27, phi_bb58_28, phi_bb58_29});
  }

  TNode<BoolT> phi_bb60_18;
  TNode<IntPtrT> phi_bb60_25;
  TNode<IntPtrT> phi_bb60_26;
  TNode<BoolT> phi_bb60_27;
  TNode<BoolT> phi_bb60_28;
  TNode<IntPtrT> phi_bb60_29;
  TNode<BoolT> tmp99;
  TNode<BoolT> tmp100;
  if (block60.is_used()) {
    ca_.Bind(&block60, &phi_bb60_18, &phi_bb60_25, &phi_bb60_26, &phi_bb60_27, &phi_bb60_28, &phi_bb60_29);
    tmp99 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    tmp100 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block62, phi_bb60_18, phi_bb60_25, phi_bb60_26, tmp99, tmp100, phi_bb60_29);
  }

  TNode<BoolT> phi_bb61_18;
  TNode<IntPtrT> phi_bb61_25;
  TNode<IntPtrT> phi_bb61_26;
  TNode<BoolT> phi_bb61_27;
  TNode<BoolT> phi_bb61_28;
  TNode<IntPtrT> phi_bb61_29;
  TNode<IntPtrT> tmp101;
  TNode<IntPtrT> tmp102;
  TNode<BoolT> tmp103;
  TNode<BoolT> tmp104;
  if (block61.is_used()) {
    ca_.Bind(&block61, &phi_bb61_18, &phi_bb61_25, &phi_bb61_26, &phi_bb61_27, &phi_bb61_28, &phi_bb61_29);
    tmp101 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x2ull));
    tmp102 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb61_29}, TNode<IntPtrT>{tmp101});
    tmp103 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    tmp104 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block62, phi_bb61_18, phi_bb61_25, phi_bb61_26, tmp103, tmp104, tmp102);
  }

  TNode<BoolT> phi_bb62_18;
  TNode<IntPtrT> phi_bb62_25;
  TNode<IntPtrT> phi_bb62_26;
  TNode<BoolT> phi_bb62_27;
  TNode<BoolT> phi_bb62_28;
  TNode<IntPtrT> phi_bb62_29;
  if (block62.is_used()) {
    ca_.Bind(&block62, &phi_bb62_18, &phi_bb62_25, &phi_bb62_26, &phi_bb62_27, &phi_bb62_28, &phi_bb62_29);
    ca_.Goto(&block59, phi_bb62_18, phi_bb62_25, phi_bb62_26, phi_bb62_27, phi_bb62_28, phi_bb62_29);
  }

  TNode<BoolT> phi_bb59_18;
  TNode<IntPtrT> phi_bb59_25;
  TNode<IntPtrT> phi_bb59_26;
  TNode<BoolT> phi_bb59_27;
  TNode<BoolT> phi_bb59_28;
  TNode<IntPtrT> phi_bb59_29;
  if (block59.is_used()) {
    ca_.Bind(&block59, &phi_bb59_18, &phi_bb59_25, &phi_bb59_26, &phi_bb59_27, &phi_bb59_28, &phi_bb59_29);
    ca_.Goto(&block53, phi_bb59_18, phi_bb59_25, phi_bb59_26, phi_bb59_27, phi_bb59_28, phi_bb59_29);
  }

  TNode<BoolT> phi_bb53_18;
  TNode<IntPtrT> phi_bb53_25;
  TNode<IntPtrT> phi_bb53_26;
  TNode<BoolT> phi_bb53_27;
  TNode<BoolT> phi_bb53_28;
  TNode<IntPtrT> phi_bb53_29;
  if (block53.is_used()) {
    ca_.Bind(&block53, &phi_bb53_18, &phi_bb53_25, &phi_bb53_26, &phi_bb53_27, &phi_bb53_28, &phi_bb53_29);
    ca_.Goto(&block52, phi_bb53_18, phi_bb53_25, phi_bb53_26, phi_bb53_27, phi_bb53_28, phi_bb53_29);
  }

  TNode<BoolT> phi_bb51_18;
  TNode<IntPtrT> phi_bb51_25;
  TNode<IntPtrT> phi_bb51_26;
  TNode<BoolT> phi_bb51_27;
  TNode<BoolT> phi_bb51_28;
  TNode<IntPtrT> phi_bb51_29;
  if (block51.is_used()) {
    ca_.Bind(&block51, &phi_bb51_18, &phi_bb51_25, &phi_bb51_26, &phi_bb51_27, &phi_bb51_28, &phi_bb51_29);
    ca_.Goto(&block52, phi_bb51_18, phi_bb51_25, phi_bb51_26, phi_bb51_27, phi_bb51_28, phi_bb51_29);
  }

  TNode<BoolT> phi_bb52_18;
  TNode<IntPtrT> phi_bb52_25;
  TNode<IntPtrT> phi_bb52_26;
  TNode<BoolT> phi_bb52_27;
  TNode<BoolT> phi_bb52_28;
  TNode<IntPtrT> phi_bb52_29;
  if (block52.is_used()) {
    ca_.Bind(&block52, &phi_bb52_18, &phi_bb52_25, &phi_bb52_26, &phi_bb52_27, &phi_bb52_28, &phi_bb52_29);
    ca_.Goto(&block39, phi_bb52_18, phi_bb52_25, phi_bb52_26, phi_bb52_27, phi_bb52_28, phi_bb52_29);
  }

  TNode<BoolT> phi_bb38_18;
  TNode<IntPtrT> phi_bb38_25;
  TNode<IntPtrT> phi_bb38_26;
  TNode<BoolT> phi_bb38_27;
  TNode<BoolT> phi_bb38_28;
  TNode<IntPtrT> phi_bb38_29;
  TNode<Int32T> tmp105;
  TNode<BoolT> tmp106;
  if (block38.is_used()) {
    ca_.Bind(&block38, &phi_bb38_18, &phi_bb38_25, &phi_bb38_26, &phi_bb38_27, &phi_bb38_28, &phi_bb38_29);
    tmp105 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF32.raw_bit_field());
    tmp106 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp64}, TNode<Int32T>{tmp105});
    ca_.Branch(tmp106, &block63, std::vector<compiler::Node*>{phi_bb38_18, phi_bb38_25, phi_bb38_26, phi_bb38_27, phi_bb38_28, phi_bb38_29}, &block64, std::vector<compiler::Node*>{phi_bb38_18, phi_bb38_25, phi_bb38_26, phi_bb38_27, phi_bb38_28, phi_bb38_29});
  }

  TNode<BoolT> phi_bb63_18;
  TNode<IntPtrT> phi_bb63_25;
  TNode<IntPtrT> phi_bb63_26;
  TNode<BoolT> phi_bb63_27;
  TNode<BoolT> phi_bb63_28;
  TNode<IntPtrT> phi_bb63_29;
  TNode<IntPtrT> tmp107;
  TNode<BoolT> tmp108;
  if (block63.is_used()) {
    ca_.Bind(&block63, &phi_bb63_18, &phi_bb63_25, &phi_bb63_26, &phi_bb63_27, &phi_bb63_28, &phi_bb63_29);
    tmp107 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp108 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb63_26}, TNode<IntPtrT>{tmp107});
    ca_.Branch(tmp108, &block67, std::vector<compiler::Node*>{phi_bb63_18, phi_bb63_25, phi_bb63_26, phi_bb63_27, phi_bb63_28, phi_bb63_29}, &block68, std::vector<compiler::Node*>{phi_bb63_18, phi_bb63_25, phi_bb63_26, phi_bb63_27, phi_bb63_28, phi_bb63_29});
  }

  TNode<BoolT> phi_bb67_18;
  TNode<IntPtrT> phi_bb67_25;
  TNode<IntPtrT> phi_bb67_26;
  TNode<BoolT> phi_bb67_27;
  TNode<BoolT> phi_bb67_28;
  TNode<IntPtrT> phi_bb67_29;
  TNode<IntPtrT> tmp109;
  TNode<IntPtrT> tmp110;
  if (block67.is_used()) {
    ca_.Bind(&block67, &phi_bb67_18, &phi_bb67_25, &phi_bb67_26, &phi_bb67_27, &phi_bb67_28, &phi_bb67_29);
    tmp109 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp110 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb67_26}, TNode<IntPtrT>{tmp109});
    ca_.Goto(&block66, phi_bb67_18, phi_bb67_25, tmp110, phi_bb67_27, phi_bb67_28, phi_bb67_29);
  }

  TNode<BoolT> phi_bb68_18;
  TNode<IntPtrT> phi_bb68_25;
  TNode<IntPtrT> phi_bb68_26;
  TNode<BoolT> phi_bb68_27;
  TNode<BoolT> phi_bb68_28;
  TNode<IntPtrT> phi_bb68_29;
  if (block68.is_used()) {
    ca_.Bind(&block68, &phi_bb68_18, &phi_bb68_25, &phi_bb68_26, &phi_bb68_27, &phi_bb68_28, &phi_bb68_29);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block70, phi_bb68_18, phi_bb68_25, phi_bb68_26, phi_bb68_27, phi_bb68_28, phi_bb68_29);
    } else {
      ca_.Goto(&block71, phi_bb68_18, phi_bb68_25, phi_bb68_26, phi_bb68_27, phi_bb68_28, phi_bb68_29);
    }
  }

  TNode<BoolT> phi_bb70_18;
  TNode<IntPtrT> phi_bb70_25;
  TNode<IntPtrT> phi_bb70_26;
  TNode<BoolT> phi_bb70_27;
  TNode<BoolT> phi_bb70_28;
  TNode<IntPtrT> phi_bb70_29;
  TNode<IntPtrT> tmp111;
  TNode<IntPtrT> tmp112;
  if (block70.is_used()) {
    ca_.Bind(&block70, &phi_bb70_18, &phi_bb70_25, &phi_bb70_26, &phi_bb70_27, &phi_bb70_28, &phi_bb70_29);
    tmp111 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp112 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb70_29}, TNode<IntPtrT>{tmp111});
    ca_.Goto(&block72, phi_bb70_18, phi_bb70_25, phi_bb70_26, phi_bb70_27, phi_bb70_28, tmp112);
  }

  TNode<BoolT> phi_bb71_18;
  TNode<IntPtrT> phi_bb71_25;
  TNode<IntPtrT> phi_bb71_26;
  TNode<BoolT> phi_bb71_27;
  TNode<BoolT> phi_bb71_28;
  TNode<IntPtrT> phi_bb71_29;
  if (block71.is_used()) {
    ca_.Bind(&block71, &phi_bb71_18, &phi_bb71_25, &phi_bb71_26, &phi_bb71_27, &phi_bb71_28, &phi_bb71_29);
    ca_.Branch(phi_bb71_27, &block73, std::vector<compiler::Node*>{phi_bb71_18, phi_bb71_25, phi_bb71_26, phi_bb71_27, phi_bb71_28, phi_bb71_29}, &block74, std::vector<compiler::Node*>{phi_bb71_18, phi_bb71_25, phi_bb71_26, phi_bb71_27, phi_bb71_28, phi_bb71_29});
  }

  TNode<BoolT> phi_bb73_18;
  TNode<IntPtrT> phi_bb73_25;
  TNode<IntPtrT> phi_bb73_26;
  TNode<BoolT> phi_bb73_27;
  TNode<BoolT> phi_bb73_28;
  TNode<IntPtrT> phi_bb73_29;
  TNode<BoolT> tmp113;
  TNode<BoolT> tmp114;
  if (block73.is_used()) {
    ca_.Bind(&block73, &phi_bb73_18, &phi_bb73_25, &phi_bb73_26, &phi_bb73_27, &phi_bb73_28, &phi_bb73_29);
    tmp113 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    tmp114 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block75, phi_bb73_18, phi_bb73_25, phi_bb73_26, tmp113, tmp114, phi_bb73_29);
  }

  TNode<BoolT> phi_bb74_18;
  TNode<IntPtrT> phi_bb74_25;
  TNode<IntPtrT> phi_bb74_26;
  TNode<BoolT> phi_bb74_27;
  TNode<BoolT> phi_bb74_28;
  TNode<IntPtrT> phi_bb74_29;
  TNode<IntPtrT> tmp115;
  TNode<IntPtrT> tmp116;
  TNode<BoolT> tmp117;
  TNode<BoolT> tmp118;
  if (block74.is_used()) {
    ca_.Bind(&block74, &phi_bb74_18, &phi_bb74_25, &phi_bb74_26, &phi_bb74_27, &phi_bb74_28, &phi_bb74_29);
    tmp115 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x2ull));
    tmp116 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb74_29}, TNode<IntPtrT>{tmp115});
    tmp117 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    tmp118 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block75, phi_bb74_18, phi_bb74_25, phi_bb74_26, tmp117, tmp118, tmp116);
  }

  TNode<BoolT> phi_bb75_18;
  TNode<IntPtrT> phi_bb75_25;
  TNode<IntPtrT> phi_bb75_26;
  TNode<BoolT> phi_bb75_27;
  TNode<BoolT> phi_bb75_28;
  TNode<IntPtrT> phi_bb75_29;
  if (block75.is_used()) {
    ca_.Bind(&block75, &phi_bb75_18, &phi_bb75_25, &phi_bb75_26, &phi_bb75_27, &phi_bb75_28, &phi_bb75_29);
    ca_.Goto(&block72, phi_bb75_18, phi_bb75_25, phi_bb75_26, phi_bb75_27, phi_bb75_28, phi_bb75_29);
  }

  TNode<BoolT> phi_bb72_18;
  TNode<IntPtrT> phi_bb72_25;
  TNode<IntPtrT> phi_bb72_26;
  TNode<BoolT> phi_bb72_27;
  TNode<BoolT> phi_bb72_28;
  TNode<IntPtrT> phi_bb72_29;
  if (block72.is_used()) {
    ca_.Bind(&block72, &phi_bb72_18, &phi_bb72_25, &phi_bb72_26, &phi_bb72_27, &phi_bb72_28, &phi_bb72_29);
    ca_.Goto(&block66, phi_bb72_18, phi_bb72_25, phi_bb72_26, phi_bb72_27, phi_bb72_28, phi_bb72_29);
  }

  TNode<BoolT> phi_bb66_18;
  TNode<IntPtrT> phi_bb66_25;
  TNode<IntPtrT> phi_bb66_26;
  TNode<BoolT> phi_bb66_27;
  TNode<BoolT> phi_bb66_28;
  TNode<IntPtrT> phi_bb66_29;
  if (block66.is_used()) {
    ca_.Bind(&block66, &phi_bb66_18, &phi_bb66_25, &phi_bb66_26, &phi_bb66_27, &phi_bb66_28, &phi_bb66_29);
    ca_.Goto(&block65, phi_bb66_18, phi_bb66_25, phi_bb66_26, phi_bb66_27, phi_bb66_28, phi_bb66_29);
  }

  TNode<BoolT> phi_bb64_18;
  TNode<IntPtrT> phi_bb64_25;
  TNode<IntPtrT> phi_bb64_26;
  TNode<BoolT> phi_bb64_27;
  TNode<BoolT> phi_bb64_28;
  TNode<IntPtrT> phi_bb64_29;
  TNode<Int32T> tmp119;
  TNode<BoolT> tmp120;
  if (block64.is_used()) {
    ca_.Bind(&block64, &phi_bb64_18, &phi_bb64_25, &phi_bb64_26, &phi_bb64_27, &phi_bb64_28, &phi_bb64_29);
    tmp119 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF64.raw_bit_field());
    tmp120 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp64}, TNode<Int32T>{tmp119});
    ca_.Branch(tmp120, &block76, std::vector<compiler::Node*>{phi_bb64_18, phi_bb64_25, phi_bb64_26, phi_bb64_27, phi_bb64_28, phi_bb64_29}, &block77, std::vector<compiler::Node*>{phi_bb64_18, phi_bb64_25, phi_bb64_26, phi_bb64_27, phi_bb64_28, phi_bb64_29});
  }

  TNode<BoolT> phi_bb76_18;
  TNode<IntPtrT> phi_bb76_25;
  TNode<IntPtrT> phi_bb76_26;
  TNode<BoolT> phi_bb76_27;
  TNode<BoolT> phi_bb76_28;
  TNode<IntPtrT> phi_bb76_29;
  TNode<IntPtrT> tmp121;
  TNode<BoolT> tmp122;
  if (block76.is_used()) {
    ca_.Bind(&block76, &phi_bb76_18, &phi_bb76_25, &phi_bb76_26, &phi_bb76_27, &phi_bb76_28, &phi_bb76_29);
    tmp121 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp122 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb76_26}, TNode<IntPtrT>{tmp121});
    ca_.Branch(tmp122, &block80, std::vector<compiler::Node*>{phi_bb76_18, phi_bb76_25, phi_bb76_26, phi_bb76_27, phi_bb76_28, phi_bb76_29}, &block81, std::vector<compiler::Node*>{phi_bb76_18, phi_bb76_25, phi_bb76_26, phi_bb76_27, phi_bb76_28, phi_bb76_29});
  }

  TNode<BoolT> phi_bb80_18;
  TNode<IntPtrT> phi_bb80_25;
  TNode<IntPtrT> phi_bb80_26;
  TNode<BoolT> phi_bb80_27;
  TNode<BoolT> phi_bb80_28;
  TNode<IntPtrT> phi_bb80_29;
  TNode<IntPtrT> tmp123;
  TNode<IntPtrT> tmp124;
  if (block80.is_used()) {
    ca_.Bind(&block80, &phi_bb80_18, &phi_bb80_25, &phi_bb80_26, &phi_bb80_27, &phi_bb80_28, &phi_bb80_29);
    tmp123 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp124 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb80_26}, TNode<IntPtrT>{tmp123});
    ca_.Goto(&block79, phi_bb80_18, phi_bb80_25, tmp124, phi_bb80_27, phi_bb80_28, phi_bb80_29);
  }

  TNode<BoolT> phi_bb81_18;
  TNode<IntPtrT> phi_bb81_25;
  TNode<IntPtrT> phi_bb81_26;
  TNode<BoolT> phi_bb81_27;
  TNode<BoolT> phi_bb81_28;
  TNode<IntPtrT> phi_bb81_29;
  if (block81.is_used()) {
    ca_.Bind(&block81, &phi_bb81_18, &phi_bb81_25, &phi_bb81_26, &phi_bb81_27, &phi_bb81_28, &phi_bb81_29);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block82, phi_bb81_18, phi_bb81_25, phi_bb81_26, phi_bb81_27, phi_bb81_28, phi_bb81_29);
    } else {
      ca_.Goto(&block83, phi_bb81_18, phi_bb81_25, phi_bb81_26, phi_bb81_27, phi_bb81_28, phi_bb81_29);
    }
  }

  TNode<BoolT> phi_bb82_18;
  TNode<IntPtrT> phi_bb82_25;
  TNode<IntPtrT> phi_bb82_26;
  TNode<BoolT> phi_bb82_27;
  TNode<BoolT> phi_bb82_28;
  TNode<IntPtrT> phi_bb82_29;
  TNode<IntPtrT> tmp125;
  TNode<IntPtrT> tmp126;
  if (block82.is_used()) {
    ca_.Bind(&block82, &phi_bb82_18, &phi_bb82_25, &phi_bb82_26, &phi_bb82_27, &phi_bb82_28, &phi_bb82_29);
    tmp125 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp126 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb82_29}, TNode<IntPtrT>{tmp125});
    ca_.Goto(&block84, phi_bb82_18, phi_bb82_25, phi_bb82_26, phi_bb82_27, phi_bb82_28, tmp126);
  }

  TNode<BoolT> phi_bb83_18;
  TNode<IntPtrT> phi_bb83_25;
  TNode<IntPtrT> phi_bb83_26;
  TNode<BoolT> phi_bb83_27;
  TNode<BoolT> phi_bb83_28;
  TNode<IntPtrT> phi_bb83_29;
  TNode<IntPtrT> tmp127;
  TNode<IntPtrT> tmp128;
  TNode<BoolT> tmp129;
  if (block83.is_used()) {
    ca_.Bind(&block83, &phi_bb83_18, &phi_bb83_25, &phi_bb83_26, &phi_bb83_27, &phi_bb83_28, &phi_bb83_29);
    tmp127 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x2ull));
    tmp128 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb83_29}, TNode<IntPtrT>{tmp127});
    tmp129 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block84, phi_bb83_18, phi_bb83_25, phi_bb83_26, phi_bb83_27, tmp129, tmp128);
  }

  TNode<BoolT> phi_bb84_18;
  TNode<IntPtrT> phi_bb84_25;
  TNode<IntPtrT> phi_bb84_26;
  TNode<BoolT> phi_bb84_27;
  TNode<BoolT> phi_bb84_28;
  TNode<IntPtrT> phi_bb84_29;
  if (block84.is_used()) {
    ca_.Bind(&block84, &phi_bb84_18, &phi_bb84_25, &phi_bb84_26, &phi_bb84_27, &phi_bb84_28, &phi_bb84_29);
    ca_.Goto(&block79, phi_bb84_18, phi_bb84_25, phi_bb84_26, phi_bb84_27, phi_bb84_28, phi_bb84_29);
  }

  TNode<BoolT> phi_bb79_18;
  TNode<IntPtrT> phi_bb79_25;
  TNode<IntPtrT> phi_bb79_26;
  TNode<BoolT> phi_bb79_27;
  TNode<BoolT> phi_bb79_28;
  TNode<IntPtrT> phi_bb79_29;
  if (block79.is_used()) {
    ca_.Bind(&block79, &phi_bb79_18, &phi_bb79_25, &phi_bb79_26, &phi_bb79_27, &phi_bb79_28, &phi_bb79_29);
    ca_.Goto(&block78, phi_bb79_18, phi_bb79_25, phi_bb79_26, phi_bb79_27, phi_bb79_28, phi_bb79_29);
  }

  TNode<BoolT> phi_bb77_18;
  TNode<IntPtrT> phi_bb77_25;
  TNode<IntPtrT> phi_bb77_26;
  TNode<BoolT> phi_bb77_27;
  TNode<BoolT> phi_bb77_28;
  TNode<IntPtrT> phi_bb77_29;
  TNode<Int32T> tmp130;
  TNode<Int32T> tmp131;
  TNode<BoolT> tmp132;
  TNode<IntPtrT> tmp133;
  TNode<BoolT> tmp134;
  if (block77.is_used()) {
    ca_.Bind(&block77, &phi_bb77_18, &phi_bb77_25, &phi_bb77_26, &phi_bb77_27, &phi_bb77_28, &phi_bb77_29);
    tmp130 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmValueKindBitsMask);
    tmp131 = CodeStubAssembler(state_).Word32And(TNode<Int32T>{tmp64}, TNode<Int32T>{tmp130});
    tmp132 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    tmp133 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp134 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb77_25}, TNode<IntPtrT>{tmp133});
    ca_.Branch(tmp134, &block93, std::vector<compiler::Node*>{phi_bb77_25, phi_bb77_26, phi_bb77_27, phi_bb77_28, phi_bb77_29}, &block94, std::vector<compiler::Node*>{phi_bb77_25, phi_bb77_26, phi_bb77_27, phi_bb77_28, phi_bb77_29});
  }

  TNode<IntPtrT> phi_bb93_25;
  TNode<IntPtrT> phi_bb93_26;
  TNode<BoolT> phi_bb93_27;
  TNode<BoolT> phi_bb93_28;
  TNode<IntPtrT> phi_bb93_29;
  TNode<IntPtrT> tmp135;
  TNode<IntPtrT> tmp136;
  if (block93.is_used()) {
    ca_.Bind(&block93, &phi_bb93_25, &phi_bb93_26, &phi_bb93_27, &phi_bb93_28, &phi_bb93_29);
    tmp135 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp136 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb93_25}, TNode<IntPtrT>{tmp135});
    ca_.Goto(&block92, tmp136, phi_bb93_26, phi_bb93_27, phi_bb93_28, phi_bb93_29);
  }

  TNode<IntPtrT> phi_bb94_25;
  TNode<IntPtrT> phi_bb94_26;
  TNode<BoolT> phi_bb94_27;
  TNode<BoolT> phi_bb94_28;
  TNode<IntPtrT> phi_bb94_29;
  if (block94.is_used()) {
    ca_.Bind(&block94, &phi_bb94_25, &phi_bb94_26, &phi_bb94_27, &phi_bb94_28, &phi_bb94_29);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block96, phi_bb94_25, phi_bb94_26, phi_bb94_27, phi_bb94_28, phi_bb94_29);
    } else {
      ca_.Goto(&block97, phi_bb94_25, phi_bb94_26, phi_bb94_27, phi_bb94_28, phi_bb94_29);
    }
  }

  TNode<IntPtrT> phi_bb96_25;
  TNode<IntPtrT> phi_bb96_26;
  TNode<BoolT> phi_bb96_27;
  TNode<BoolT> phi_bb96_28;
  TNode<IntPtrT> phi_bb96_29;
  TNode<IntPtrT> tmp137;
  TNode<IntPtrT> tmp138;
  if (block96.is_used()) {
    ca_.Bind(&block96, &phi_bb96_25, &phi_bb96_26, &phi_bb96_27, &phi_bb96_28, &phi_bb96_29);
    tmp137 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp138 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb96_29}, TNode<IntPtrT>{tmp137});
    ca_.Goto(&block98, phi_bb96_25, phi_bb96_26, phi_bb96_27, phi_bb96_28, tmp138);
  }

  TNode<IntPtrT> phi_bb97_25;
  TNode<IntPtrT> phi_bb97_26;
  TNode<BoolT> phi_bb97_27;
  TNode<BoolT> phi_bb97_28;
  TNode<IntPtrT> phi_bb97_29;
  if (block97.is_used()) {
    ca_.Bind(&block97, &phi_bb97_25, &phi_bb97_26, &phi_bb97_27, &phi_bb97_28, &phi_bb97_29);
    ca_.Branch(phi_bb97_27, &block99, std::vector<compiler::Node*>{phi_bb97_25, phi_bb97_26, phi_bb97_27, phi_bb97_28, phi_bb97_29}, &block100, std::vector<compiler::Node*>{phi_bb97_25, phi_bb97_26, phi_bb97_27, phi_bb97_28, phi_bb97_29});
  }

  TNode<IntPtrT> phi_bb99_25;
  TNode<IntPtrT> phi_bb99_26;
  TNode<BoolT> phi_bb99_27;
  TNode<BoolT> phi_bb99_28;
  TNode<IntPtrT> phi_bb99_29;
  TNode<BoolT> tmp139;
  TNode<BoolT> tmp140;
  if (block99.is_used()) {
    ca_.Bind(&block99, &phi_bb99_25, &phi_bb99_26, &phi_bb99_27, &phi_bb99_28, &phi_bb99_29);
    tmp139 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    tmp140 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block101, phi_bb99_25, phi_bb99_26, tmp139, tmp140, phi_bb99_29);
  }

  TNode<IntPtrT> phi_bb100_25;
  TNode<IntPtrT> phi_bb100_26;
  TNode<BoolT> phi_bb100_27;
  TNode<BoolT> phi_bb100_28;
  TNode<IntPtrT> phi_bb100_29;
  TNode<IntPtrT> tmp141;
  TNode<IntPtrT> tmp142;
  TNode<BoolT> tmp143;
  TNode<BoolT> tmp144;
  if (block100.is_used()) {
    ca_.Bind(&block100, &phi_bb100_25, &phi_bb100_26, &phi_bb100_27, &phi_bb100_28, &phi_bb100_29);
    tmp141 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x2ull));
    tmp142 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb100_29}, TNode<IntPtrT>{tmp141});
    tmp143 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    tmp144 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block101, phi_bb100_25, phi_bb100_26, tmp143, tmp144, tmp142);
  }

  TNode<IntPtrT> phi_bb101_25;
  TNode<IntPtrT> phi_bb101_26;
  TNode<BoolT> phi_bb101_27;
  TNode<BoolT> phi_bb101_28;
  TNode<IntPtrT> phi_bb101_29;
  if (block101.is_used()) {
    ca_.Bind(&block101, &phi_bb101_25, &phi_bb101_26, &phi_bb101_27, &phi_bb101_28, &phi_bb101_29);
    ca_.Goto(&block98, phi_bb101_25, phi_bb101_26, phi_bb101_27, phi_bb101_28, phi_bb101_29);
  }

  TNode<IntPtrT> phi_bb98_25;
  TNode<IntPtrT> phi_bb98_26;
  TNode<BoolT> phi_bb98_27;
  TNode<BoolT> phi_bb98_28;
  TNode<IntPtrT> phi_bb98_29;
  if (block98.is_used()) {
    ca_.Bind(&block98, &phi_bb98_25, &phi_bb98_26, &phi_bb98_27, &phi_bb98_28, &phi_bb98_29);
    ca_.Goto(&block92, phi_bb98_25, phi_bb98_26, phi_bb98_27, phi_bb98_28, phi_bb98_29);
  }

  TNode<IntPtrT> phi_bb92_25;
  TNode<IntPtrT> phi_bb92_26;
  TNode<BoolT> phi_bb92_27;
  TNode<BoolT> phi_bb92_28;
  TNode<IntPtrT> phi_bb92_29;
  if (block92.is_used()) {
    ca_.Bind(&block92, &phi_bb92_25, &phi_bb92_26, &phi_bb92_27, &phi_bb92_28, &phi_bb92_29);
    ca_.Goto(&block78, tmp132, phi_bb92_25, phi_bb92_26, phi_bb92_27, phi_bb92_28, phi_bb92_29);
  }

  TNode<BoolT> phi_bb78_18;
  TNode<IntPtrT> phi_bb78_25;
  TNode<IntPtrT> phi_bb78_26;
  TNode<BoolT> phi_bb78_27;
  TNode<BoolT> phi_bb78_28;
  TNode<IntPtrT> phi_bb78_29;
  if (block78.is_used()) {
    ca_.Bind(&block78, &phi_bb78_18, &phi_bb78_25, &phi_bb78_26, &phi_bb78_27, &phi_bb78_28, &phi_bb78_29);
    ca_.Goto(&block65, phi_bb78_18, phi_bb78_25, phi_bb78_26, phi_bb78_27, phi_bb78_28, phi_bb78_29);
  }

  TNode<BoolT> phi_bb65_18;
  TNode<IntPtrT> phi_bb65_25;
  TNode<IntPtrT> phi_bb65_26;
  TNode<BoolT> phi_bb65_27;
  TNode<BoolT> phi_bb65_28;
  TNode<IntPtrT> phi_bb65_29;
  if (block65.is_used()) {
    ca_.Bind(&block65, &phi_bb65_18, &phi_bb65_25, &phi_bb65_26, &phi_bb65_27, &phi_bb65_28, &phi_bb65_29);
    ca_.Goto(&block39, phi_bb65_18, phi_bb65_25, phi_bb65_26, phi_bb65_27, phi_bb65_28, phi_bb65_29);
  }

  TNode<BoolT> phi_bb39_18;
  TNode<IntPtrT> phi_bb39_25;
  TNode<IntPtrT> phi_bb39_26;
  TNode<BoolT> phi_bb39_27;
  TNode<BoolT> phi_bb39_28;
  TNode<IntPtrT> phi_bb39_29;
  if (block39.is_used()) {
    ca_.Bind(&block39, &phi_bb39_18, &phi_bb39_25, &phi_bb39_26, &phi_bb39_27, &phi_bb39_28, &phi_bb39_29);
    ca_.Goto(&block26, phi_bb39_18, phi_bb39_25, phi_bb39_26, phi_bb39_27, phi_bb39_28, phi_bb39_29);
  }

  TNode<BoolT> phi_bb26_18;
  TNode<IntPtrT> phi_bb26_25;
  TNode<IntPtrT> phi_bb26_26;
  TNode<BoolT> phi_bb26_27;
  TNode<BoolT> phi_bb26_28;
  TNode<IntPtrT> phi_bb26_29;
  if (block26.is_used()) {
    ca_.Bind(&block26, &phi_bb26_18, &phi_bb26_25, &phi_bb26_26, &phi_bb26_27, &phi_bb26_28, &phi_bb26_29);
    ca_.Goto(&block15, phi_bb26_18, tmp63, phi_bb26_25, phi_bb26_26, phi_bb26_27, phi_bb26_28, phi_bb26_29);
  }

  TNode<BoolT> phi_bb14_18;
  TNode<IntPtrT> phi_bb14_23;
  TNode<IntPtrT> phi_bb14_25;
  TNode<IntPtrT> phi_bb14_26;
  TNode<BoolT> phi_bb14_27;
  TNode<BoolT> phi_bb14_28;
  TNode<IntPtrT> phi_bb14_29;
  if (block14.is_used()) {
    ca_.Bind(&block14, &phi_bb14_18, &phi_bb14_23, &phi_bb14_25, &phi_bb14_26, &phi_bb14_27, &phi_bb14_28, &phi_bb14_29);
    ca_.Branch(phi_bb14_28, &block103, std::vector<compiler::Node*>{phi_bb14_18, phi_bb14_23, phi_bb14_25, phi_bb14_26, phi_bb14_27, phi_bb14_28, phi_bb14_29}, &block104, std::vector<compiler::Node*>{phi_bb14_18, phi_bb14_23, phi_bb14_25, phi_bb14_26, phi_bb14_27, phi_bb14_28, phi_bb14_29});
  }

  TNode<BoolT> phi_bb103_18;
  TNode<IntPtrT> phi_bb103_23;
  TNode<IntPtrT> phi_bb103_25;
  TNode<IntPtrT> phi_bb103_26;
  TNode<BoolT> phi_bb103_27;
  TNode<BoolT> phi_bb103_28;
  TNode<IntPtrT> phi_bb103_29;
  TNode<IntPtrT> tmp145;
  TNode<IntPtrT> tmp146;
  if (block103.is_used()) {
    ca_.Bind(&block103, &phi_bb103_18, &phi_bb103_23, &phi_bb103_25, &phi_bb103_26, &phi_bb103_27, &phi_bb103_28, &phi_bb103_29);
    tmp145 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp146 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb103_29}, TNode<IntPtrT>{tmp145});
    ca_.Goto(&block102, phi_bb103_18, phi_bb103_23, phi_bb103_25, phi_bb103_26, phi_bb103_27, phi_bb103_28, phi_bb103_29, tmp146);
  }

  TNode<BoolT> phi_bb104_18;
  TNode<IntPtrT> phi_bb104_23;
  TNode<IntPtrT> phi_bb104_25;
  TNode<IntPtrT> phi_bb104_26;
  TNode<BoolT> phi_bb104_27;
  TNode<BoolT> phi_bb104_28;
  TNode<IntPtrT> phi_bb104_29;
  if (block104.is_used()) {
    ca_.Bind(&block104, &phi_bb104_18, &phi_bb104_23, &phi_bb104_25, &phi_bb104_26, &phi_bb104_27, &phi_bb104_28, &phi_bb104_29);
    ca_.Goto(&block102, phi_bb104_18, phi_bb104_23, phi_bb104_25, phi_bb104_26, phi_bb104_27, phi_bb104_28, phi_bb104_29, phi_bb104_29);
  }

  TNode<BoolT> phi_bb102_18;
  TNode<IntPtrT> phi_bb102_23;
  TNode<IntPtrT> phi_bb102_25;
  TNode<IntPtrT> phi_bb102_26;
  TNode<BoolT> phi_bb102_27;
  TNode<BoolT> phi_bb102_28;
  TNode<IntPtrT> phi_bb102_29;
  TNode<IntPtrT> phi_bb102_30;
  if (block102.is_used()) {
    ca_.Bind(&block102, &phi_bb102_18, &phi_bb102_23, &phi_bb102_25, &phi_bb102_26, &phi_bb102_27, &phi_bb102_28, &phi_bb102_29, &phi_bb102_30);
    ca_.Goto(&block7, tmp44, phi_bb102_30, phi_bb102_18);
  }

  TNode<Object> phi_bb7_16;
  TNode<IntPtrT> phi_bb7_17;
  TNode<BoolT> phi_bb7_18;
  TNode<IntPtrT> tmp147;
  TNode<IntPtrT> tmp148;
  TNode<Object> tmp149;
  TNode<IntPtrT> tmp150;
  TNode<IntPtrT> tmp151;
  if (block7.is_used()) {
    ca_.Bind(&block7, &phi_bb7_16, &phi_bb7_17, &phi_bb7_18);
    tmp147 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp27});
    tmp148 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp23});
    compiler::CodeAssemblerLabel label152(&ca_);
    std::tie(tmp149, tmp150, tmp151) = Subslice_int32_0(state_, TorqueStructSlice_int32_ConstReference_int32_0{TNode<Object>{tmp35}, TNode<IntPtrT>{tmp36}, TNode<IntPtrT>{tmp37}, TorqueStructUnsafe_0{}}, TNode<IntPtrT>{tmp147}, TNode<IntPtrT>{tmp148}, &label152).Flatten();
    ca_.Goto(&block108, phi_bb7_16, phi_bb7_17, phi_bb7_18);
    if (label152.is_used()) {
      ca_.Bind(&label152);
      ca_.Goto(&block109, phi_bb7_16, phi_bb7_17, phi_bb7_18);
    }
  }

  TNode<Object> phi_bb109_16;
  TNode<IntPtrT> phi_bb109_17;
  TNode<BoolT> phi_bb109_18;
  if (block109.is_used()) {
    ca_.Bind(&block109, &phi_bb109_16, &phi_bb109_17, &phi_bb109_18);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<Object> phi_bb108_16;
  TNode<IntPtrT> phi_bb108_17;
  TNode<BoolT> phi_bb108_18;
  TNode<Int32T> tmp153;
  TNode<BoolT> tmp154;
  if (block108.is_used()) {
    ca_.Bind(&block108, &phi_bb108_16, &phi_bb108_17, &phi_bb108_18);
    tmp153 = FromConstexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0xaull));
    tmp154 = CodeStubAssembler(state_).Int32LessThanOrEqual(TNode<Int32T>{tmp23}, TNode<Int32T>{tmp153});
    ca_.Branch(tmp154, &block110, std::vector<compiler::Node*>{phi_bb108_16, phi_bb108_17, phi_bb108_18}, &block111, std::vector<compiler::Node*>{phi_bb108_16, phi_bb108_17, phi_bb108_18});
  }

  TNode<Object> phi_bb110_16;
  TNode<IntPtrT> phi_bb110_17;
  TNode<BoolT> phi_bb110_18;
  TNode<RawPtrT> tmp155;
  TNode<RawPtrT> tmp156;
  TNode<Object> tmp157;
  TNode<IntPtrT> tmp158;
  if (block110.is_used()) {
    ca_.Bind(&block110, &phi_bb110_16, &phi_bb110_17, &phi_bb110_18);
    tmp155 = CodeStubAssembler(state_).StackSlotPtr((FromConstexpr_constexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x90ull))), (SizeOf_float64_0(state_)));
    tmp156 = (TNode<RawPtrT>{tmp155});
    std::tie(tmp157, tmp158) = NewOffHeapReference_intptr_0(state_, TNode<RawPtrT>{tmp156}).Flatten();
    ca_.Goto(&block112, phi_bb110_16, phi_bb110_17, phi_bb110_18, tmp157, tmp158);
  }

  TNode<Object> phi_bb111_16;
  TNode<IntPtrT> phi_bb111_17;
  TNode<BoolT> phi_bb111_18;
  TNode<IntPtrT> tmp159;
  TNode<IntPtrT> tmp160;
  TNode<IntPtrT> tmp161;
  TNode<IntPtrT> tmp162;
  TNode<IntPtrT> tmp163;
  TNode<IntPtrT> tmp164;
  TNode<IntPtrT> tmp165;
  TNode<IntPtrT> tmp166;
  TNode<IntPtrT> tmp167;
  TNode<IntPtrT> tmp168;
  TNode<UintPtrT> tmp169;
  TNode<ByteArray> tmp170;
  TNode<Object> tmp171;
  TNode<IntPtrT> tmp172;
  TNode<IntPtrT> tmp173;
  TNode<Object> tmp174;
  TNode<IntPtrT> tmp175;
  if (block111.is_used()) {
    ca_.Bind(&block111, &phi_bb111_16, &phi_bb111_17, &phi_bb111_18);
    tmp159 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_float64_0(state_)));
    tmp160 = CodeStubAssembler(state_).UniqueIntPtrConstant(arraysize(wasm::kGpParamRegisters) - 1);
    tmp161 = Convert_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp162 = CodeStubAssembler(state_).IntPtrMul(TNode<IntPtrT>{tmp160}, TNode<IntPtrT>{tmp161});
    tmp163 = CodeStubAssembler(state_).UniqueIntPtrConstant(arraysize(wasm::kFpParamRegisters));
    tmp164 = CodeStubAssembler(state_).IntPtrMul(TNode<IntPtrT>{tmp163}, TNode<IntPtrT>{tmp159});
    tmp165 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp162}, TNode<IntPtrT>{tmp164});
    tmp166 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp23});
    tmp167 = CodeStubAssembler(state_).IntPtrMul(TNode<IntPtrT>{tmp166}, TNode<IntPtrT>{tmp159});
    tmp168 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp165}, TNode<IntPtrT>{tmp167});
    tmp169 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp168});
    tmp170 = CodeStubAssembler(state_).AllocateByteArray(TNode<UintPtrT>{tmp169});
    std::tie(tmp171, tmp172, tmp173) = FieldSliceByteArrayBytes_0(state_, TNode<ByteArray>{tmp170}).Flatten();
    std::tie(tmp174, tmp175) = NewReference_intptr_0(state_, TNode<Object>{tmp171}, TNode<IntPtrT>{tmp172}).Flatten();
    ca_.Goto(&block112, phi_bb111_16, phi_bb111_17, phi_bb111_18, tmp174, tmp175);
  }

  TNode<Object> phi_bb112_16;
  TNode<IntPtrT> phi_bb112_17;
  TNode<BoolT> phi_bb112_18;
  TNode<Object> phi_bb112_22;
  TNode<IntPtrT> phi_bb112_23;
  TNode<Object> tmp176;
  TNode<IntPtrT> tmp177;
  TNode<IntPtrT> tmp178;
  TNode<IntPtrT> tmp179;
  TNode<IntPtrT> tmp180;
  TNode<IntPtrT> tmp181;
  TNode<IntPtrT> tmp182;
  TNode<IntPtrT> tmp183;
  TNode<BoolT> tmp184;
  TNode<BoolT> tmp185;
  TNode<Int32T> tmp186;
  if (block112.is_used()) {
    ca_.Bind(&block112, &phi_bb112_16, &phi_bb112_17, &phi_bb112_18, &phi_bb112_22, &phi_bb112_23);
    std::tie(tmp176, tmp177, tmp178, tmp179, tmp180, tmp181, tmp182, tmp183, tmp184) = LocationAllocatorForParams_0(state_, TorqueStructReference_intptr_0{TNode<Object>{phi_bb112_22}, TNode<IntPtrT>{phi_bb112_23}, TorqueStructUnsafe_0{}}).Flatten();
    tmp185 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    tmp186 = FromConstexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    if ((p_switchStack)) {
      ca_.Goto(&block113, phi_bb112_16, phi_bb112_17, phi_bb112_18);
    } else {
      ca_.Goto(&block114, phi_bb112_16, phi_bb112_17, phi_bb112_18);
    }
  }

  TNode<Object> phi_bb113_16;
  TNode<IntPtrT> phi_bb113_17;
  TNode<BoolT> phi_bb113_18;
  TNode<Int32T> tmp187;
  TNode<Int32T> tmp188;
  TNode<BoolT> tmp189;
  if (block113.is_used()) {
    ca_.Bind(&block113, &phi_bb113_16, &phi_bb113_17, &phi_bb113_18);
    tmp187 = FromConstexpr_int32_constexpr_int31_0(state_, 1);
    tmp188 = CodeStubAssembler(state_).Int32Add(TNode<Int32T>{tmp186}, TNode<Int32T>{tmp187});
    tmp189 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block115, phi_bb113_16, phi_bb113_17, phi_bb113_18, tmp189, tmp188);
  }

  TNode<Object> phi_bb114_16;
  TNode<IntPtrT> phi_bb114_17;
  TNode<BoolT> phi_bb114_18;
  if (block114.is_used()) {
    ca_.Bind(&block114, &phi_bb114_16, &phi_bb114_17, &phi_bb114_18);
    ca_.Goto(&block115, phi_bb114_16, phi_bb114_17, phi_bb114_18, tmp185, tmp186);
  }

  TNode<Object> phi_bb115_16;
  TNode<IntPtrT> phi_bb115_17;
  TNode<BoolT> phi_bb115_18;
  TNode<BoolT> phi_bb115_33;
  TNode<Int32T> phi_bb115_34;
  TNode<Int32T> tmp190;
  if (block115.is_used()) {
    ca_.Bind(&block115, &phi_bb115_16, &phi_bb115_17, &phi_bb115_18, &phi_bb115_33, &phi_bb115_34);
    tmp190 = FromConstexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    ca_.Goto(&block118, phi_bb115_16, phi_bb115_17, phi_bb115_18, tmp177, tmp178, tmp179, tmp180, tmp181, tmp183, tmp184, phi_bb115_33, phi_bb115_34, tmp190);
  }

  TNode<Object> phi_bb118_16;
  TNode<IntPtrT> phi_bb118_17;
  TNode<BoolT> phi_bb118_18;
  TNode<IntPtrT> phi_bb118_25;
  TNode<IntPtrT> phi_bb118_26;
  TNode<IntPtrT> phi_bb118_27;
  TNode<IntPtrT> phi_bb118_28;
  TNode<IntPtrT> phi_bb118_29;
  TNode<IntPtrT> phi_bb118_31;
  TNode<BoolT> phi_bb118_32;
  TNode<BoolT> phi_bb118_33;
  TNode<Int32T> phi_bb118_34;
  TNode<Int32T> phi_bb118_35;
  TNode<BoolT> tmp191;
  if (block118.is_used()) {
    ca_.Bind(&block118, &phi_bb118_16, &phi_bb118_17, &phi_bb118_18, &phi_bb118_25, &phi_bb118_26, &phi_bb118_27, &phi_bb118_28, &phi_bb118_29, &phi_bb118_31, &phi_bb118_32, &phi_bb118_33, &phi_bb118_34, &phi_bb118_35);
    tmp191 = CodeStubAssembler(state_).Int32LessThan(TNode<Int32T>{phi_bb118_34}, TNode<Int32T>{tmp23});
    ca_.Branch(tmp191, &block116, std::vector<compiler::Node*>{phi_bb118_16, phi_bb118_17, phi_bb118_18, phi_bb118_25, phi_bb118_26, phi_bb118_27, phi_bb118_28, phi_bb118_29, phi_bb118_31, phi_bb118_32, phi_bb118_33, phi_bb118_34, phi_bb118_35}, &block117, std::vector<compiler::Node*>{phi_bb118_16, phi_bb118_17, phi_bb118_18, phi_bb118_25, phi_bb118_26, phi_bb118_27, phi_bb118_28, phi_bb118_29, phi_bb118_31, phi_bb118_32, phi_bb118_33, phi_bb118_34, phi_bb118_35});
  }

  TNode<Object> phi_bb116_16;
  TNode<IntPtrT> phi_bb116_17;
  TNode<BoolT> phi_bb116_18;
  TNode<IntPtrT> phi_bb116_25;
  TNode<IntPtrT> phi_bb116_26;
  TNode<IntPtrT> phi_bb116_27;
  TNode<IntPtrT> phi_bb116_28;
  TNode<IntPtrT> phi_bb116_29;
  TNode<IntPtrT> phi_bb116_31;
  TNode<BoolT> phi_bb116_32;
  TNode<BoolT> phi_bb116_33;
  TNode<Int32T> phi_bb116_34;
  TNode<Int32T> phi_bb116_35;
  TNode<IntPtrT> tmp192;
  TNode<Object> tmp193;
  TNode<Int32T> tmp194;
  TNode<Int32T> tmp195;
  TNode<IntPtrT> tmp196;
  TNode<IntPtrT> tmp197;
  TNode<IntPtrT> tmp198;
  TNode<Object> tmp199;
  TNode<IntPtrT> tmp200;
  TNode<Int32T> tmp201;
  TNode<Int32T> tmp202;
  TNode<BoolT> tmp203;
  if (block116.is_used()) {
    ca_.Bind(&block116, &phi_bb116_16, &phi_bb116_17, &phi_bb116_18, &phi_bb116_25, &phi_bb116_26, &phi_bb116_27, &phi_bb116_28, &phi_bb116_29, &phi_bb116_31, &phi_bb116_32, &phi_bb116_33, &phi_bb116_34, &phi_bb116_35);
    tmp192 = Convert_intptr_int32_0(state_, TNode<Int32T>{phi_bb116_35});
    tmp193 = CodeStubAssembler(state_).GetArgumentValue(TorqueStructArguments{TNode<RawPtrT>{p_arguments.frame}, TNode<RawPtrT>{p_arguments.base}, TNode<IntPtrT>{p_arguments.length}, TNode<IntPtrT>{p_arguments.actual_count}}, TNode<IntPtrT>{tmp192});
    tmp194 = FromConstexpr_int32_constexpr_int31_0(state_, 1);
    tmp195 = CodeStubAssembler(state_).Int32Add(TNode<Int32T>{phi_bb116_34}, TNode<Int32T>{tmp194});
    tmp196 = Convert_intptr_int32_0(state_, TNode<Int32T>{phi_bb116_34});
    tmp197 = TimesSizeOf_int32_0(state_, TNode<IntPtrT>{tmp196});
    tmp198 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp150}, TNode<IntPtrT>{tmp197});
    std::tie(tmp199, tmp200) = NewReference_int32_0(state_, TNode<Object>{tmp149}, TNode<IntPtrT>{tmp198}).Flatten();
    tmp201 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp199, tmp200});
    tmp202 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI32.raw_bit_field());
    tmp203 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp201}, TNode<Int32T>{tmp202});
    ca_.Branch(tmp203, &block121, std::vector<compiler::Node*>{phi_bb116_16, phi_bb116_17, phi_bb116_18, phi_bb116_25, phi_bb116_26, phi_bb116_27, phi_bb116_28, phi_bb116_29, phi_bb116_31, phi_bb116_32, phi_bb116_33, phi_bb116_35}, &block122, std::vector<compiler::Node*>{phi_bb116_16, phi_bb116_17, phi_bb116_18, phi_bb116_25, phi_bb116_26, phi_bb116_27, phi_bb116_28, phi_bb116_29, phi_bb116_31, phi_bb116_32, phi_bb116_33, phi_bb116_35});
  }

  TNode<Object> phi_bb121_16;
  TNode<IntPtrT> phi_bb121_17;
  TNode<BoolT> phi_bb121_18;
  TNode<IntPtrT> phi_bb121_25;
  TNode<IntPtrT> phi_bb121_26;
  TNode<IntPtrT> phi_bb121_27;
  TNode<IntPtrT> phi_bb121_28;
  TNode<IntPtrT> phi_bb121_29;
  TNode<IntPtrT> phi_bb121_31;
  TNode<BoolT> phi_bb121_32;
  TNode<BoolT> phi_bb121_33;
  TNode<Int32T> phi_bb121_35;
  TNode<IntPtrT> tmp204;
  TNode<IntPtrT> tmp205;
  TNode<IntPtrT> tmp206;
  TNode<BoolT> tmp207;
  if (block121.is_used()) {
    ca_.Bind(&block121, &phi_bb121_16, &phi_bb121_17, &phi_bb121_18, &phi_bb121_25, &phi_bb121_26, &phi_bb121_27, &phi_bb121_28, &phi_bb121_29, &phi_bb121_31, &phi_bb121_32, &phi_bb121_33, &phi_bb121_35);
    tmp204 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp205 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb121_25}, TNode<IntPtrT>{tmp204});
    tmp206 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp207 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb121_25}, TNode<IntPtrT>{tmp206});
    ca_.Branch(tmp207, &block125, std::vector<compiler::Node*>{phi_bb121_16, phi_bb121_17, phi_bb121_18, phi_bb121_26, phi_bb121_27, phi_bb121_28, phi_bb121_29, phi_bb121_31, phi_bb121_32, phi_bb121_33, phi_bb121_35}, &block126, std::vector<compiler::Node*>{phi_bb121_16, phi_bb121_17, phi_bb121_18, phi_bb121_26, phi_bb121_27, phi_bb121_28, phi_bb121_29, phi_bb121_31, phi_bb121_32, phi_bb121_33, phi_bb121_35});
  }

  TNode<Object> phi_bb125_16;
  TNode<IntPtrT> phi_bb125_17;
  TNode<BoolT> phi_bb125_18;
  TNode<IntPtrT> phi_bb125_26;
  TNode<IntPtrT> phi_bb125_27;
  TNode<IntPtrT> phi_bb125_28;
  TNode<IntPtrT> phi_bb125_29;
  TNode<IntPtrT> phi_bb125_31;
  TNode<BoolT> phi_bb125_32;
  TNode<BoolT> phi_bb125_33;
  TNode<Int32T> phi_bb125_35;
  TNode<Object> tmp208;
  TNode<IntPtrT> tmp209;
  TNode<IntPtrT> tmp210;
  TNode<IntPtrT> tmp211;
  if (block125.is_used()) {
    ca_.Bind(&block125, &phi_bb125_16, &phi_bb125_17, &phi_bb125_18, &phi_bb125_26, &phi_bb125_27, &phi_bb125_28, &phi_bb125_29, &phi_bb125_31, &phi_bb125_32, &phi_bb125_33, &phi_bb125_35);
    std::tie(tmp208, tmp209) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb125_27}).Flatten();
    tmp210 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp211 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb125_27}, TNode<IntPtrT>{tmp210});
    ca_.Goto(&block124, phi_bb125_16, phi_bb125_17, phi_bb125_18, phi_bb125_26, tmp211, phi_bb125_28, phi_bb125_29, phi_bb125_31, phi_bb125_32, phi_bb125_33, phi_bb125_35, tmp208, tmp209);
  }

  TNode<Object> phi_bb126_16;
  TNode<IntPtrT> phi_bb126_17;
  TNode<BoolT> phi_bb126_18;
  TNode<IntPtrT> phi_bb126_26;
  TNode<IntPtrT> phi_bb126_27;
  TNode<IntPtrT> phi_bb126_28;
  TNode<IntPtrT> phi_bb126_29;
  TNode<IntPtrT> phi_bb126_31;
  TNode<BoolT> phi_bb126_32;
  TNode<BoolT> phi_bb126_33;
  TNode<Int32T> phi_bb126_35;
  if (block126.is_used()) {
    ca_.Bind(&block126, &phi_bb126_16, &phi_bb126_17, &phi_bb126_18, &phi_bb126_26, &phi_bb126_27, &phi_bb126_28, &phi_bb126_29, &phi_bb126_31, &phi_bb126_32, &phi_bb126_33, &phi_bb126_35);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block128, phi_bb126_16, phi_bb126_17, phi_bb126_18, phi_bb126_26, phi_bb126_27, phi_bb126_28, phi_bb126_29, phi_bb126_31, phi_bb126_32, phi_bb126_33, phi_bb126_35);
    } else {
      ca_.Goto(&block129, phi_bb126_16, phi_bb126_17, phi_bb126_18, phi_bb126_26, phi_bb126_27, phi_bb126_28, phi_bb126_29, phi_bb126_31, phi_bb126_32, phi_bb126_33, phi_bb126_35);
    }
  }

  TNode<Object> phi_bb128_16;
  TNode<IntPtrT> phi_bb128_17;
  TNode<BoolT> phi_bb128_18;
  TNode<IntPtrT> phi_bb128_26;
  TNode<IntPtrT> phi_bb128_27;
  TNode<IntPtrT> phi_bb128_28;
  TNode<IntPtrT> phi_bb128_29;
  TNode<IntPtrT> phi_bb128_31;
  TNode<BoolT> phi_bb128_32;
  TNode<BoolT> phi_bb128_33;
  TNode<Int32T> phi_bb128_35;
  TNode<Object> tmp212;
  TNode<IntPtrT> tmp213;
  TNode<IntPtrT> tmp214;
  TNode<IntPtrT> tmp215;
  if (block128.is_used()) {
    ca_.Bind(&block128, &phi_bb128_16, &phi_bb128_17, &phi_bb128_18, &phi_bb128_26, &phi_bb128_27, &phi_bb128_28, &phi_bb128_29, &phi_bb128_31, &phi_bb128_32, &phi_bb128_33, &phi_bb128_35);
    std::tie(tmp212, tmp213) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb128_29}).Flatten();
    tmp214 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp215 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb128_29}, TNode<IntPtrT>{tmp214});
    ca_.Goto(&block127, phi_bb128_16, phi_bb128_17, phi_bb128_18, phi_bb128_26, phi_bb128_27, phi_bb128_28, tmp215, phi_bb128_31, phi_bb128_32, phi_bb128_33, phi_bb128_35, tmp212, tmp213);
  }

  TNode<Object> phi_bb129_16;
  TNode<IntPtrT> phi_bb129_17;
  TNode<BoolT> phi_bb129_18;
  TNode<IntPtrT> phi_bb129_26;
  TNode<IntPtrT> phi_bb129_27;
  TNode<IntPtrT> phi_bb129_28;
  TNode<IntPtrT> phi_bb129_29;
  TNode<IntPtrT> phi_bb129_31;
  TNode<BoolT> phi_bb129_32;
  TNode<BoolT> phi_bb129_33;
  TNode<Int32T> phi_bb129_35;
  TNode<IntPtrT> tmp216;
  TNode<BoolT> tmp217;
  if (block129.is_used()) {
    ca_.Bind(&block129, &phi_bb129_16, &phi_bb129_17, &phi_bb129_18, &phi_bb129_26, &phi_bb129_27, &phi_bb129_28, &phi_bb129_29, &phi_bb129_31, &phi_bb129_32, &phi_bb129_33, &phi_bb129_35);
    tmp216 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp217 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb129_31}, TNode<IntPtrT>{tmp216});
    ca_.Branch(tmp217, &block131, std::vector<compiler::Node*>{phi_bb129_16, phi_bb129_17, phi_bb129_18, phi_bb129_26, phi_bb129_27, phi_bb129_28, phi_bb129_29, phi_bb129_31, phi_bb129_32, phi_bb129_33, phi_bb129_35}, &block132, std::vector<compiler::Node*>{phi_bb129_16, phi_bb129_17, phi_bb129_18, phi_bb129_26, phi_bb129_27, phi_bb129_28, phi_bb129_29, phi_bb129_31, phi_bb129_32, phi_bb129_33, phi_bb129_35});
  }

  TNode<Object> phi_bb131_16;
  TNode<IntPtrT> phi_bb131_17;
  TNode<BoolT> phi_bb131_18;
  TNode<IntPtrT> phi_bb131_26;
  TNode<IntPtrT> phi_bb131_27;
  TNode<IntPtrT> phi_bb131_28;
  TNode<IntPtrT> phi_bb131_29;
  TNode<IntPtrT> phi_bb131_31;
  TNode<BoolT> phi_bb131_32;
  TNode<BoolT> phi_bb131_33;
  TNode<Int32T> phi_bb131_35;
  TNode<Object> tmp218;
  TNode<IntPtrT> tmp219;
  TNode<IntPtrT> tmp220;
  TNode<BoolT> tmp221;
  if (block131.is_used()) {
    ca_.Bind(&block131, &phi_bb131_16, &phi_bb131_17, &phi_bb131_18, &phi_bb131_26, &phi_bb131_27, &phi_bb131_28, &phi_bb131_29, &phi_bb131_31, &phi_bb131_32, &phi_bb131_33, &phi_bb131_35);
    std::tie(tmp218, tmp219) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb131_31}).Flatten();
    tmp220 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp221 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block127, phi_bb131_16, phi_bb131_17, phi_bb131_18, phi_bb131_26, phi_bb131_27, phi_bb131_28, phi_bb131_29, tmp220, tmp221, phi_bb131_33, phi_bb131_35, tmp218, tmp219);
  }

  TNode<Object> phi_bb132_16;
  TNode<IntPtrT> phi_bb132_17;
  TNode<BoolT> phi_bb132_18;
  TNode<IntPtrT> phi_bb132_26;
  TNode<IntPtrT> phi_bb132_27;
  TNode<IntPtrT> phi_bb132_28;
  TNode<IntPtrT> phi_bb132_29;
  TNode<IntPtrT> phi_bb132_31;
  TNode<BoolT> phi_bb132_32;
  TNode<BoolT> phi_bb132_33;
  TNode<Int32T> phi_bb132_35;
  TNode<Object> tmp222;
  TNode<IntPtrT> tmp223;
  TNode<IntPtrT> tmp224;
  TNode<IntPtrT> tmp225;
  TNode<IntPtrT> tmp226;
  TNode<IntPtrT> tmp227;
  TNode<BoolT> tmp228;
  if (block132.is_used()) {
    ca_.Bind(&block132, &phi_bb132_16, &phi_bb132_17, &phi_bb132_18, &phi_bb132_26, &phi_bb132_27, &phi_bb132_28, &phi_bb132_29, &phi_bb132_31, &phi_bb132_32, &phi_bb132_33, &phi_bb132_35);
    std::tie(tmp222, tmp223) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb132_29}).Flatten();
    tmp224 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp225 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb132_29}, TNode<IntPtrT>{tmp224});
    tmp226 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp227 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp225}, TNode<IntPtrT>{tmp226});
    tmp228 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block127, phi_bb132_16, phi_bb132_17, phi_bb132_18, phi_bb132_26, phi_bb132_27, phi_bb132_28, tmp227, tmp225, tmp228, phi_bb132_33, phi_bb132_35, tmp222, tmp223);
  }

  TNode<Object> phi_bb127_16;
  TNode<IntPtrT> phi_bb127_17;
  TNode<BoolT> phi_bb127_18;
  TNode<IntPtrT> phi_bb127_26;
  TNode<IntPtrT> phi_bb127_27;
  TNode<IntPtrT> phi_bb127_28;
  TNode<IntPtrT> phi_bb127_29;
  TNode<IntPtrT> phi_bb127_31;
  TNode<BoolT> phi_bb127_32;
  TNode<BoolT> phi_bb127_33;
  TNode<Int32T> phi_bb127_35;
  TNode<Object> phi_bb127_38;
  TNode<IntPtrT> phi_bb127_39;
  if (block127.is_used()) {
    ca_.Bind(&block127, &phi_bb127_16, &phi_bb127_17, &phi_bb127_18, &phi_bb127_26, &phi_bb127_27, &phi_bb127_28, &phi_bb127_29, &phi_bb127_31, &phi_bb127_32, &phi_bb127_33, &phi_bb127_35, &phi_bb127_38, &phi_bb127_39);
    ca_.Goto(&block124, phi_bb127_16, phi_bb127_17, phi_bb127_18, phi_bb127_26, phi_bb127_27, phi_bb127_28, phi_bb127_29, phi_bb127_31, phi_bb127_32, phi_bb127_33, phi_bb127_35, phi_bb127_38, phi_bb127_39);
  }

  TNode<Object> phi_bb124_16;
  TNode<IntPtrT> phi_bb124_17;
  TNode<BoolT> phi_bb124_18;
  TNode<IntPtrT> phi_bb124_26;
  TNode<IntPtrT> phi_bb124_27;
  TNode<IntPtrT> phi_bb124_28;
  TNode<IntPtrT> phi_bb124_29;
  TNode<IntPtrT> phi_bb124_31;
  TNode<BoolT> phi_bb124_32;
  TNode<BoolT> phi_bb124_33;
  TNode<Int32T> phi_bb124_35;
  TNode<Object> phi_bb124_38;
  TNode<IntPtrT> phi_bb124_39;
  TNode<Smi> tmp229;
  if (block124.is_used()) {
    ca_.Bind(&block124, &phi_bb124_16, &phi_bb124_17, &phi_bb124_18, &phi_bb124_26, &phi_bb124_27, &phi_bb124_28, &phi_bb124_29, &phi_bb124_31, &phi_bb124_32, &phi_bb124_33, &phi_bb124_35, &phi_bb124_38, &phi_bb124_39);
    compiler::CodeAssemblerLabel label230(&ca_);
    tmp229 = Cast_Smi_0(state_, TNode<Object>{tmp193}, &label230);
    ca_.Goto(&block135, phi_bb124_16, phi_bb124_17, phi_bb124_18, phi_bb124_26, phi_bb124_27, phi_bb124_28, phi_bb124_29, phi_bb124_31, phi_bb124_32, phi_bb124_33, phi_bb124_35, phi_bb124_38, phi_bb124_39);
    if (label230.is_used()) {
      ca_.Bind(&label230);
      ca_.Goto(&block136, phi_bb124_16, phi_bb124_17, phi_bb124_18, phi_bb124_26, phi_bb124_27, phi_bb124_28, phi_bb124_29, phi_bb124_31, phi_bb124_32, phi_bb124_33, phi_bb124_35, phi_bb124_38, phi_bb124_39);
    }
  }

  TNode<Object> phi_bb136_16;
  TNode<IntPtrT> phi_bb136_17;
  TNode<BoolT> phi_bb136_18;
  TNode<IntPtrT> phi_bb136_26;
  TNode<IntPtrT> phi_bb136_27;
  TNode<IntPtrT> phi_bb136_28;
  TNode<IntPtrT> phi_bb136_29;
  TNode<IntPtrT> phi_bb136_31;
  TNode<BoolT> phi_bb136_32;
  TNode<BoolT> phi_bb136_33;
  TNode<Int32T> phi_bb136_35;
  TNode<Object> phi_bb136_38;
  TNode<IntPtrT> phi_bb136_39;
  TNode<Int32T> tmp231;
  TNode<Uint32T> tmp232;
  TNode<IntPtrT> tmp233;
  if (block136.is_used()) {
    ca_.Bind(&block136, &phi_bb136_16, &phi_bb136_17, &phi_bb136_18, &phi_bb136_26, &phi_bb136_27, &phi_bb136_28, &phi_bb136_29, &phi_bb136_31, &phi_bb136_32, &phi_bb136_33, &phi_bb136_35, &phi_bb136_38, &phi_bb136_39);
    tmp231 = ca_.CallBuiltin<Int32T>(Builtin::kWasmTaggedNonSmiToInt32, p_context, ca_.UncheckedCast<HeapObject>(tmp193));
    tmp232 = CodeStubAssembler(state_).Unsigned(TNode<Int32T>{tmp231});
    tmp233 = Convert_intptr_uint32_0(state_, TNode<Uint32T>{tmp232});
    CodeStubAssembler(state_).StoreReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb136_38, phi_bb136_39}, tmp233);
    ca_.Goto(&block133, phi_bb136_16, phi_bb136_17, phi_bb136_18, phi_bb136_26, phi_bb136_27, phi_bb136_28, phi_bb136_29, phi_bb136_31, phi_bb136_32, phi_bb136_33, phi_bb136_35, phi_bb136_38, phi_bb136_39);
  }

  TNode<Object> phi_bb135_16;
  TNode<IntPtrT> phi_bb135_17;
  TNode<BoolT> phi_bb135_18;
  TNode<IntPtrT> phi_bb135_26;
  TNode<IntPtrT> phi_bb135_27;
  TNode<IntPtrT> phi_bb135_28;
  TNode<IntPtrT> phi_bb135_29;
  TNode<IntPtrT> phi_bb135_31;
  TNode<BoolT> phi_bb135_32;
  TNode<BoolT> phi_bb135_33;
  TNode<Int32T> phi_bb135_35;
  TNode<Object> phi_bb135_38;
  TNode<IntPtrT> phi_bb135_39;
  TNode<Int32T> tmp234;
  TNode<Uint32T> tmp235;
  TNode<IntPtrT> tmp236;
  if (block135.is_used()) {
    ca_.Bind(&block135, &phi_bb135_16, &phi_bb135_17, &phi_bb135_18, &phi_bb135_26, &phi_bb135_27, &phi_bb135_28, &phi_bb135_29, &phi_bb135_31, &phi_bb135_32, &phi_bb135_33, &phi_bb135_35, &phi_bb135_38, &phi_bb135_39);
    tmp234 = CodeStubAssembler(state_).SmiToInt32(TNode<Smi>{tmp229});
    tmp235 = CodeStubAssembler(state_).Unsigned(TNode<Int32T>{tmp234});
    tmp236 = Convert_intptr_uint32_0(state_, TNode<Uint32T>{tmp235});
    CodeStubAssembler(state_).StoreReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb135_38, phi_bb135_39}, tmp236);
    ca_.Goto(&block133, phi_bb135_16, phi_bb135_17, phi_bb135_18, phi_bb135_26, phi_bb135_27, phi_bb135_28, phi_bb135_29, phi_bb135_31, phi_bb135_32, phi_bb135_33, phi_bb135_35, phi_bb135_38, phi_bb135_39);
  }

  TNode<Object> phi_bb133_16;
  TNode<IntPtrT> phi_bb133_17;
  TNode<BoolT> phi_bb133_18;
  TNode<IntPtrT> phi_bb133_26;
  TNode<IntPtrT> phi_bb133_27;
  TNode<IntPtrT> phi_bb133_28;
  TNode<IntPtrT> phi_bb133_29;
  TNode<IntPtrT> phi_bb133_31;
  TNode<BoolT> phi_bb133_32;
  TNode<BoolT> phi_bb133_33;
  TNode<Int32T> phi_bb133_35;
  TNode<Object> phi_bb133_38;
  TNode<IntPtrT> phi_bb133_39;
  if (block133.is_used()) {
    ca_.Bind(&block133, &phi_bb133_16, &phi_bb133_17, &phi_bb133_18, &phi_bb133_26, &phi_bb133_27, &phi_bb133_28, &phi_bb133_29, &phi_bb133_31, &phi_bb133_32, &phi_bb133_33, &phi_bb133_35, &phi_bb133_38, &phi_bb133_39);
    ca_.Goto(&block123, phi_bb133_16, phi_bb133_17, phi_bb133_18, tmp205, phi_bb133_26, phi_bb133_27, phi_bb133_28, phi_bb133_29, phi_bb133_31, phi_bb133_32, phi_bb133_33, phi_bb133_35);
  }

  TNode<Object> phi_bb122_16;
  TNode<IntPtrT> phi_bb122_17;
  TNode<BoolT> phi_bb122_18;
  TNode<IntPtrT> phi_bb122_25;
  TNode<IntPtrT> phi_bb122_26;
  TNode<IntPtrT> phi_bb122_27;
  TNode<IntPtrT> phi_bb122_28;
  TNode<IntPtrT> phi_bb122_29;
  TNode<IntPtrT> phi_bb122_31;
  TNode<BoolT> phi_bb122_32;
  TNode<BoolT> phi_bb122_33;
  TNode<Int32T> phi_bb122_35;
  TNode<Int32T> tmp237;
  TNode<BoolT> tmp238;
  if (block122.is_used()) {
    ca_.Bind(&block122, &phi_bb122_16, &phi_bb122_17, &phi_bb122_18, &phi_bb122_25, &phi_bb122_26, &phi_bb122_27, &phi_bb122_28, &phi_bb122_29, &phi_bb122_31, &phi_bb122_32, &phi_bb122_33, &phi_bb122_35);
    tmp237 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF32.raw_bit_field());
    tmp238 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp201}, TNode<Int32T>{tmp237});
    ca_.Branch(tmp238, &block137, std::vector<compiler::Node*>{phi_bb122_16, phi_bb122_17, phi_bb122_18, phi_bb122_25, phi_bb122_26, phi_bb122_27, phi_bb122_28, phi_bb122_29, phi_bb122_31, phi_bb122_32, phi_bb122_33, phi_bb122_35}, &block138, std::vector<compiler::Node*>{phi_bb122_16, phi_bb122_17, phi_bb122_18, phi_bb122_25, phi_bb122_26, phi_bb122_27, phi_bb122_28, phi_bb122_29, phi_bb122_31, phi_bb122_32, phi_bb122_33, phi_bb122_35});
  }

  TNode<Object> phi_bb137_16;
  TNode<IntPtrT> phi_bb137_17;
  TNode<BoolT> phi_bb137_18;
  TNode<IntPtrT> phi_bb137_25;
  TNode<IntPtrT> phi_bb137_26;
  TNode<IntPtrT> phi_bb137_27;
  TNode<IntPtrT> phi_bb137_28;
  TNode<IntPtrT> phi_bb137_29;
  TNode<IntPtrT> phi_bb137_31;
  TNode<BoolT> phi_bb137_32;
  TNode<BoolT> phi_bb137_33;
  TNode<Int32T> phi_bb137_35;
  TNode<IntPtrT> tmp239;
  TNode<IntPtrT> tmp240;
  TNode<IntPtrT> tmp241;
  TNode<BoolT> tmp242;
  if (block137.is_used()) {
    ca_.Bind(&block137, &phi_bb137_16, &phi_bb137_17, &phi_bb137_18, &phi_bb137_25, &phi_bb137_26, &phi_bb137_27, &phi_bb137_28, &phi_bb137_29, &phi_bb137_31, &phi_bb137_32, &phi_bb137_33, &phi_bb137_35);
    tmp239 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp240 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb137_26}, TNode<IntPtrT>{tmp239});
    tmp241 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp242 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb137_26}, TNode<IntPtrT>{tmp241});
    ca_.Branch(tmp242, &block141, std::vector<compiler::Node*>{phi_bb137_16, phi_bb137_17, phi_bb137_18, phi_bb137_25, phi_bb137_27, phi_bb137_28, phi_bb137_29, phi_bb137_31, phi_bb137_32, phi_bb137_33, phi_bb137_35}, &block142, std::vector<compiler::Node*>{phi_bb137_16, phi_bb137_17, phi_bb137_18, phi_bb137_25, phi_bb137_27, phi_bb137_28, phi_bb137_29, phi_bb137_31, phi_bb137_32, phi_bb137_33, phi_bb137_35});
  }

  TNode<Object> phi_bb141_16;
  TNode<IntPtrT> phi_bb141_17;
  TNode<BoolT> phi_bb141_18;
  TNode<IntPtrT> phi_bb141_25;
  TNode<IntPtrT> phi_bb141_27;
  TNode<IntPtrT> phi_bb141_28;
  TNode<IntPtrT> phi_bb141_29;
  TNode<IntPtrT> phi_bb141_31;
  TNode<BoolT> phi_bb141_32;
  TNode<BoolT> phi_bb141_33;
  TNode<Int32T> phi_bb141_35;
  TNode<Object> tmp243;
  TNode<IntPtrT> tmp244;
  TNode<IntPtrT> tmp245;
  TNode<IntPtrT> tmp246;
  if (block141.is_used()) {
    ca_.Bind(&block141, &phi_bb141_16, &phi_bb141_17, &phi_bb141_18, &phi_bb141_25, &phi_bb141_27, &phi_bb141_28, &phi_bb141_29, &phi_bb141_31, &phi_bb141_32, &phi_bb141_33, &phi_bb141_35);
    std::tie(tmp243, tmp244) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb141_28}).Flatten();
    tmp245 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_float64_0(state_)));
    tmp246 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb141_28}, TNode<IntPtrT>{tmp245});
    ca_.Goto(&block140, phi_bb141_16, phi_bb141_17, phi_bb141_18, phi_bb141_25, phi_bb141_27, tmp246, phi_bb141_29, phi_bb141_31, phi_bb141_32, phi_bb141_33, phi_bb141_35, tmp243, tmp244);
  }

  TNode<Object> phi_bb142_16;
  TNode<IntPtrT> phi_bb142_17;
  TNode<BoolT> phi_bb142_18;
  TNode<IntPtrT> phi_bb142_25;
  TNode<IntPtrT> phi_bb142_27;
  TNode<IntPtrT> phi_bb142_28;
  TNode<IntPtrT> phi_bb142_29;
  TNode<IntPtrT> phi_bb142_31;
  TNode<BoolT> phi_bb142_32;
  TNode<BoolT> phi_bb142_33;
  TNode<Int32T> phi_bb142_35;
  if (block142.is_used()) {
    ca_.Bind(&block142, &phi_bb142_16, &phi_bb142_17, &phi_bb142_18, &phi_bb142_25, &phi_bb142_27, &phi_bb142_28, &phi_bb142_29, &phi_bb142_31, &phi_bb142_32, &phi_bb142_33, &phi_bb142_35);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block144, phi_bb142_16, phi_bb142_17, phi_bb142_18, phi_bb142_25, phi_bb142_27, phi_bb142_28, phi_bb142_29, phi_bb142_31, phi_bb142_32, phi_bb142_33, phi_bb142_35);
    } else {
      ca_.Goto(&block145, phi_bb142_16, phi_bb142_17, phi_bb142_18, phi_bb142_25, phi_bb142_27, phi_bb142_28, phi_bb142_29, phi_bb142_31, phi_bb142_32, phi_bb142_33, phi_bb142_35);
    }
  }

  TNode<Object> phi_bb144_16;
  TNode<IntPtrT> phi_bb144_17;
  TNode<BoolT> phi_bb144_18;
  TNode<IntPtrT> phi_bb144_25;
  TNode<IntPtrT> phi_bb144_27;
  TNode<IntPtrT> phi_bb144_28;
  TNode<IntPtrT> phi_bb144_29;
  TNode<IntPtrT> phi_bb144_31;
  TNode<BoolT> phi_bb144_32;
  TNode<BoolT> phi_bb144_33;
  TNode<Int32T> phi_bb144_35;
  TNode<Object> tmp247;
  TNode<IntPtrT> tmp248;
  TNode<IntPtrT> tmp249;
  TNode<IntPtrT> tmp250;
  if (block144.is_used()) {
    ca_.Bind(&block144, &phi_bb144_16, &phi_bb144_17, &phi_bb144_18, &phi_bb144_25, &phi_bb144_27, &phi_bb144_28, &phi_bb144_29, &phi_bb144_31, &phi_bb144_32, &phi_bb144_33, &phi_bb144_35);
    std::tie(tmp247, tmp248) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb144_29}).Flatten();
    tmp249 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp250 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb144_29}, TNode<IntPtrT>{tmp249});
    ca_.Goto(&block143, phi_bb144_16, phi_bb144_17, phi_bb144_18, phi_bb144_25, phi_bb144_27, phi_bb144_28, tmp250, phi_bb144_31, phi_bb144_32, phi_bb144_33, phi_bb144_35, tmp247, tmp248);
  }

  TNode<Object> phi_bb145_16;
  TNode<IntPtrT> phi_bb145_17;
  TNode<BoolT> phi_bb145_18;
  TNode<IntPtrT> phi_bb145_25;
  TNode<IntPtrT> phi_bb145_27;
  TNode<IntPtrT> phi_bb145_28;
  TNode<IntPtrT> phi_bb145_29;
  TNode<IntPtrT> phi_bb145_31;
  TNode<BoolT> phi_bb145_32;
  TNode<BoolT> phi_bb145_33;
  TNode<Int32T> phi_bb145_35;
  TNode<IntPtrT> tmp251;
  TNode<BoolT> tmp252;
  if (block145.is_used()) {
    ca_.Bind(&block145, &phi_bb145_16, &phi_bb145_17, &phi_bb145_18, &phi_bb145_25, &phi_bb145_27, &phi_bb145_28, &phi_bb145_29, &phi_bb145_31, &phi_bb145_32, &phi_bb145_33, &phi_bb145_35);
    tmp251 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp252 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb145_31}, TNode<IntPtrT>{tmp251});
    ca_.Branch(tmp252, &block147, std::vector<compiler::Node*>{phi_bb145_16, phi_bb145_17, phi_bb145_18, phi_bb145_25, phi_bb145_27, phi_bb145_28, phi_bb145_29, phi_bb145_31, phi_bb145_32, phi_bb145_33, phi_bb145_35}, &block148, std::vector<compiler::Node*>{phi_bb145_16, phi_bb145_17, phi_bb145_18, phi_bb145_25, phi_bb145_27, phi_bb145_28, phi_bb145_29, phi_bb145_31, phi_bb145_32, phi_bb145_33, phi_bb145_35});
  }

  TNode<Object> phi_bb147_16;
  TNode<IntPtrT> phi_bb147_17;
  TNode<BoolT> phi_bb147_18;
  TNode<IntPtrT> phi_bb147_25;
  TNode<IntPtrT> phi_bb147_27;
  TNode<IntPtrT> phi_bb147_28;
  TNode<IntPtrT> phi_bb147_29;
  TNode<IntPtrT> phi_bb147_31;
  TNode<BoolT> phi_bb147_32;
  TNode<BoolT> phi_bb147_33;
  TNode<Int32T> phi_bb147_35;
  TNode<Object> tmp253;
  TNode<IntPtrT> tmp254;
  TNode<IntPtrT> tmp255;
  TNode<BoolT> tmp256;
  if (block147.is_used()) {
    ca_.Bind(&block147, &phi_bb147_16, &phi_bb147_17, &phi_bb147_18, &phi_bb147_25, &phi_bb147_27, &phi_bb147_28, &phi_bb147_29, &phi_bb147_31, &phi_bb147_32, &phi_bb147_33, &phi_bb147_35);
    std::tie(tmp253, tmp254) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb147_31}).Flatten();
    tmp255 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp256 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block143, phi_bb147_16, phi_bb147_17, phi_bb147_18, phi_bb147_25, phi_bb147_27, phi_bb147_28, phi_bb147_29, tmp255, tmp256, phi_bb147_33, phi_bb147_35, tmp253, tmp254);
  }

  TNode<Object> phi_bb148_16;
  TNode<IntPtrT> phi_bb148_17;
  TNode<BoolT> phi_bb148_18;
  TNode<IntPtrT> phi_bb148_25;
  TNode<IntPtrT> phi_bb148_27;
  TNode<IntPtrT> phi_bb148_28;
  TNode<IntPtrT> phi_bb148_29;
  TNode<IntPtrT> phi_bb148_31;
  TNode<BoolT> phi_bb148_32;
  TNode<BoolT> phi_bb148_33;
  TNode<Int32T> phi_bb148_35;
  TNode<Object> tmp257;
  TNode<IntPtrT> tmp258;
  TNode<IntPtrT> tmp259;
  TNode<IntPtrT> tmp260;
  TNode<IntPtrT> tmp261;
  TNode<IntPtrT> tmp262;
  TNode<BoolT> tmp263;
  if (block148.is_used()) {
    ca_.Bind(&block148, &phi_bb148_16, &phi_bb148_17, &phi_bb148_18, &phi_bb148_25, &phi_bb148_27, &phi_bb148_28, &phi_bb148_29, &phi_bb148_31, &phi_bb148_32, &phi_bb148_33, &phi_bb148_35);
    std::tie(tmp257, tmp258) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb148_29}).Flatten();
    tmp259 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp260 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb148_29}, TNode<IntPtrT>{tmp259});
    tmp261 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp262 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp260}, TNode<IntPtrT>{tmp261});
    tmp263 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block143, phi_bb148_16, phi_bb148_17, phi_bb148_18, phi_bb148_25, phi_bb148_27, phi_bb148_28, tmp262, tmp260, tmp263, phi_bb148_33, phi_bb148_35, tmp257, tmp258);
  }

  TNode<Object> phi_bb143_16;
  TNode<IntPtrT> phi_bb143_17;
  TNode<BoolT> phi_bb143_18;
  TNode<IntPtrT> phi_bb143_25;
  TNode<IntPtrT> phi_bb143_27;
  TNode<IntPtrT> phi_bb143_28;
  TNode<IntPtrT> phi_bb143_29;
  TNode<IntPtrT> phi_bb143_31;
  TNode<BoolT> phi_bb143_32;
  TNode<BoolT> phi_bb143_33;
  TNode<Int32T> phi_bb143_35;
  TNode<Object> phi_bb143_38;
  TNode<IntPtrT> phi_bb143_39;
  if (block143.is_used()) {
    ca_.Bind(&block143, &phi_bb143_16, &phi_bb143_17, &phi_bb143_18, &phi_bb143_25, &phi_bb143_27, &phi_bb143_28, &phi_bb143_29, &phi_bb143_31, &phi_bb143_32, &phi_bb143_33, &phi_bb143_35, &phi_bb143_38, &phi_bb143_39);
    ca_.Goto(&block140, phi_bb143_16, phi_bb143_17, phi_bb143_18, phi_bb143_25, phi_bb143_27, phi_bb143_28, phi_bb143_29, phi_bb143_31, phi_bb143_32, phi_bb143_33, phi_bb143_35, phi_bb143_38, phi_bb143_39);
  }

  TNode<Object> phi_bb140_16;
  TNode<IntPtrT> phi_bb140_17;
  TNode<BoolT> phi_bb140_18;
  TNode<IntPtrT> phi_bb140_25;
  TNode<IntPtrT> phi_bb140_27;
  TNode<IntPtrT> phi_bb140_28;
  TNode<IntPtrT> phi_bb140_29;
  TNode<IntPtrT> phi_bb140_31;
  TNode<BoolT> phi_bb140_32;
  TNode<BoolT> phi_bb140_33;
  TNode<Int32T> phi_bb140_35;
  TNode<Object> phi_bb140_38;
  TNode<IntPtrT> phi_bb140_39;
  TNode<Float32T> tmp264;
  TNode<Uint32T> tmp265;
  TNode<IntPtrT> tmp266;
  if (block140.is_used()) {
    ca_.Bind(&block140, &phi_bb140_16, &phi_bb140_17, &phi_bb140_18, &phi_bb140_25, &phi_bb140_27, &phi_bb140_28, &phi_bb140_29, &phi_bb140_31, &phi_bb140_32, &phi_bb140_33, &phi_bb140_35, &phi_bb140_38, &phi_bb140_39);
    tmp264 = ca_.CallBuiltin<Float32T>(Builtin::kWasmTaggedToFloat32, p_context, tmp193);
    tmp265 = Bitcast_uint32_float32_0(state_, TNode<Float32T>{tmp264});
    tmp266 = Convert_intptr_uint32_0(state_, TNode<Uint32T>{tmp265});
    CodeStubAssembler(state_).StoreReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb140_38, phi_bb140_39}, tmp266);
    ca_.Goto(&block139, phi_bb140_16, phi_bb140_17, phi_bb140_18, phi_bb140_25, tmp240, phi_bb140_27, phi_bb140_28, phi_bb140_29, phi_bb140_31, phi_bb140_32, phi_bb140_33, phi_bb140_35);
  }

  TNode<Object> phi_bb138_16;
  TNode<IntPtrT> phi_bb138_17;
  TNode<BoolT> phi_bb138_18;
  TNode<IntPtrT> phi_bb138_25;
  TNode<IntPtrT> phi_bb138_26;
  TNode<IntPtrT> phi_bb138_27;
  TNode<IntPtrT> phi_bb138_28;
  TNode<IntPtrT> phi_bb138_29;
  TNode<IntPtrT> phi_bb138_31;
  TNode<BoolT> phi_bb138_32;
  TNode<BoolT> phi_bb138_33;
  TNode<Int32T> phi_bb138_35;
  TNode<Int32T> tmp267;
  TNode<BoolT> tmp268;
  if (block138.is_used()) {
    ca_.Bind(&block138, &phi_bb138_16, &phi_bb138_17, &phi_bb138_18, &phi_bb138_25, &phi_bb138_26, &phi_bb138_27, &phi_bb138_28, &phi_bb138_29, &phi_bb138_31, &phi_bb138_32, &phi_bb138_33, &phi_bb138_35);
    tmp267 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF64.raw_bit_field());
    tmp268 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp201}, TNode<Int32T>{tmp267});
    ca_.Branch(tmp268, &block149, std::vector<compiler::Node*>{phi_bb138_16, phi_bb138_17, phi_bb138_18, phi_bb138_25, phi_bb138_26, phi_bb138_27, phi_bb138_28, phi_bb138_29, phi_bb138_31, phi_bb138_32, phi_bb138_33, phi_bb138_35}, &block150, std::vector<compiler::Node*>{phi_bb138_16, phi_bb138_17, phi_bb138_18, phi_bb138_25, phi_bb138_26, phi_bb138_27, phi_bb138_28, phi_bb138_29, phi_bb138_31, phi_bb138_32, phi_bb138_33, phi_bb138_35});
  }

  TNode<Object> phi_bb149_16;
  TNode<IntPtrT> phi_bb149_17;
  TNode<BoolT> phi_bb149_18;
  TNode<IntPtrT> phi_bb149_25;
  TNode<IntPtrT> phi_bb149_26;
  TNode<IntPtrT> phi_bb149_27;
  TNode<IntPtrT> phi_bb149_28;
  TNode<IntPtrT> phi_bb149_29;
  TNode<IntPtrT> phi_bb149_31;
  TNode<BoolT> phi_bb149_32;
  TNode<BoolT> phi_bb149_33;
  TNode<Int32T> phi_bb149_35;
  TNode<IntPtrT> tmp269;
  TNode<IntPtrT> tmp270;
  TNode<IntPtrT> tmp271;
  TNode<BoolT> tmp272;
  if (block149.is_used()) {
    ca_.Bind(&block149, &phi_bb149_16, &phi_bb149_17, &phi_bb149_18, &phi_bb149_25, &phi_bb149_26, &phi_bb149_27, &phi_bb149_28, &phi_bb149_29, &phi_bb149_31, &phi_bb149_32, &phi_bb149_33, &phi_bb149_35);
    tmp269 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp270 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb149_26}, TNode<IntPtrT>{tmp269});
    tmp271 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp272 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb149_26}, TNode<IntPtrT>{tmp271});
    ca_.Branch(tmp272, &block153, std::vector<compiler::Node*>{phi_bb149_16, phi_bb149_17, phi_bb149_18, phi_bb149_25, phi_bb149_27, phi_bb149_28, phi_bb149_29, phi_bb149_31, phi_bb149_32, phi_bb149_33, phi_bb149_35}, &block154, std::vector<compiler::Node*>{phi_bb149_16, phi_bb149_17, phi_bb149_18, phi_bb149_25, phi_bb149_27, phi_bb149_28, phi_bb149_29, phi_bb149_31, phi_bb149_32, phi_bb149_33, phi_bb149_35});
  }

  TNode<Object> phi_bb153_16;
  TNode<IntPtrT> phi_bb153_17;
  TNode<BoolT> phi_bb153_18;
  TNode<IntPtrT> phi_bb153_25;
  TNode<IntPtrT> phi_bb153_27;
  TNode<IntPtrT> phi_bb153_28;
  TNode<IntPtrT> phi_bb153_29;
  TNode<IntPtrT> phi_bb153_31;
  TNode<BoolT> phi_bb153_32;
  TNode<BoolT> phi_bb153_33;
  TNode<Int32T> phi_bb153_35;
  TNode<Object> tmp273;
  TNode<IntPtrT> tmp274;
  TNode<IntPtrT> tmp275;
  TNode<IntPtrT> tmp276;
  if (block153.is_used()) {
    ca_.Bind(&block153, &phi_bb153_16, &phi_bb153_17, &phi_bb153_18, &phi_bb153_25, &phi_bb153_27, &phi_bb153_28, &phi_bb153_29, &phi_bb153_31, &phi_bb153_32, &phi_bb153_33, &phi_bb153_35);
    std::tie(tmp273, tmp274) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb153_28}).Flatten();
    tmp275 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_float64_0(state_)));
    tmp276 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb153_28}, TNode<IntPtrT>{tmp275});
    ca_.Goto(&block152, phi_bb153_16, phi_bb153_17, phi_bb153_18, phi_bb153_25, phi_bb153_27, tmp276, phi_bb153_29, phi_bb153_31, phi_bb153_32, phi_bb153_33, phi_bb153_35, tmp273, tmp274);
  }

  TNode<Object> phi_bb154_16;
  TNode<IntPtrT> phi_bb154_17;
  TNode<BoolT> phi_bb154_18;
  TNode<IntPtrT> phi_bb154_25;
  TNode<IntPtrT> phi_bb154_27;
  TNode<IntPtrT> phi_bb154_28;
  TNode<IntPtrT> phi_bb154_29;
  TNode<IntPtrT> phi_bb154_31;
  TNode<BoolT> phi_bb154_32;
  TNode<BoolT> phi_bb154_33;
  TNode<Int32T> phi_bb154_35;
  if (block154.is_used()) {
    ca_.Bind(&block154, &phi_bb154_16, &phi_bb154_17, &phi_bb154_18, &phi_bb154_25, &phi_bb154_27, &phi_bb154_28, &phi_bb154_29, &phi_bb154_31, &phi_bb154_32, &phi_bb154_33, &phi_bb154_35);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block155, phi_bb154_16, phi_bb154_17, phi_bb154_18, phi_bb154_25, phi_bb154_27, phi_bb154_28, phi_bb154_29, phi_bb154_31, phi_bb154_32, phi_bb154_33, phi_bb154_35);
    } else {
      ca_.Goto(&block156, phi_bb154_16, phi_bb154_17, phi_bb154_18, phi_bb154_25, phi_bb154_27, phi_bb154_28, phi_bb154_29, phi_bb154_31, phi_bb154_32, phi_bb154_33, phi_bb154_35);
    }
  }

  TNode<Object> phi_bb155_16;
  TNode<IntPtrT> phi_bb155_17;
  TNode<BoolT> phi_bb155_18;
  TNode<IntPtrT> phi_bb155_25;
  TNode<IntPtrT> phi_bb155_27;
  TNode<IntPtrT> phi_bb155_28;
  TNode<IntPtrT> phi_bb155_29;
  TNode<IntPtrT> phi_bb155_31;
  TNode<BoolT> phi_bb155_32;
  TNode<BoolT> phi_bb155_33;
  TNode<Int32T> phi_bb155_35;
  if (block155.is_used()) {
    ca_.Bind(&block155, &phi_bb155_16, &phi_bb155_17, &phi_bb155_18, &phi_bb155_25, &phi_bb155_27, &phi_bb155_28, &phi_bb155_29, &phi_bb155_31, &phi_bb155_32, &phi_bb155_33, &phi_bb155_35);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block159, phi_bb155_16, phi_bb155_17, phi_bb155_18, phi_bb155_25, phi_bb155_27, phi_bb155_28, phi_bb155_29, phi_bb155_31, phi_bb155_32, phi_bb155_33, phi_bb155_35);
    } else {
      ca_.Goto(&block160, phi_bb155_16, phi_bb155_17, phi_bb155_18, phi_bb155_25, phi_bb155_27, phi_bb155_28, phi_bb155_29, phi_bb155_31, phi_bb155_32, phi_bb155_33, phi_bb155_35);
    }
  }

  TNode<Object> phi_bb159_16;
  TNode<IntPtrT> phi_bb159_17;
  TNode<BoolT> phi_bb159_18;
  TNode<IntPtrT> phi_bb159_25;
  TNode<IntPtrT> phi_bb159_27;
  TNode<IntPtrT> phi_bb159_28;
  TNode<IntPtrT> phi_bb159_29;
  TNode<IntPtrT> phi_bb159_31;
  TNode<BoolT> phi_bb159_32;
  TNode<BoolT> phi_bb159_33;
  TNode<Int32T> phi_bb159_35;
  TNode<Object> tmp277;
  TNode<IntPtrT> tmp278;
  TNode<IntPtrT> tmp279;
  TNode<IntPtrT> tmp280;
  if (block159.is_used()) {
    ca_.Bind(&block159, &phi_bb159_16, &phi_bb159_17, &phi_bb159_18, &phi_bb159_25, &phi_bb159_27, &phi_bb159_28, &phi_bb159_29, &phi_bb159_31, &phi_bb159_32, &phi_bb159_33, &phi_bb159_35);
    std::tie(tmp277, tmp278) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb159_29}).Flatten();
    tmp279 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp280 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb159_29}, TNode<IntPtrT>{tmp279});
    ca_.Goto(&block158, phi_bb159_16, phi_bb159_17, phi_bb159_18, phi_bb159_25, phi_bb159_27, phi_bb159_28, tmp280, phi_bb159_31, phi_bb159_32, phi_bb159_33, phi_bb159_35, tmp277, tmp278);
  }

  TNode<Object> phi_bb160_16;
  TNode<IntPtrT> phi_bb160_17;
  TNode<BoolT> phi_bb160_18;
  TNode<IntPtrT> phi_bb160_25;
  TNode<IntPtrT> phi_bb160_27;
  TNode<IntPtrT> phi_bb160_28;
  TNode<IntPtrT> phi_bb160_29;
  TNode<IntPtrT> phi_bb160_31;
  TNode<BoolT> phi_bb160_32;
  TNode<BoolT> phi_bb160_33;
  TNode<Int32T> phi_bb160_35;
  TNode<IntPtrT> tmp281;
  TNode<BoolT> tmp282;
  if (block160.is_used()) {
    ca_.Bind(&block160, &phi_bb160_16, &phi_bb160_17, &phi_bb160_18, &phi_bb160_25, &phi_bb160_27, &phi_bb160_28, &phi_bb160_29, &phi_bb160_31, &phi_bb160_32, &phi_bb160_33, &phi_bb160_35);
    tmp281 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp282 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb160_31}, TNode<IntPtrT>{tmp281});
    ca_.Branch(tmp282, &block162, std::vector<compiler::Node*>{phi_bb160_16, phi_bb160_17, phi_bb160_18, phi_bb160_25, phi_bb160_27, phi_bb160_28, phi_bb160_29, phi_bb160_31, phi_bb160_32, phi_bb160_33, phi_bb160_35}, &block163, std::vector<compiler::Node*>{phi_bb160_16, phi_bb160_17, phi_bb160_18, phi_bb160_25, phi_bb160_27, phi_bb160_28, phi_bb160_29, phi_bb160_31, phi_bb160_32, phi_bb160_33, phi_bb160_35});
  }

  TNode<Object> phi_bb162_16;
  TNode<IntPtrT> phi_bb162_17;
  TNode<BoolT> phi_bb162_18;
  TNode<IntPtrT> phi_bb162_25;
  TNode<IntPtrT> phi_bb162_27;
  TNode<IntPtrT> phi_bb162_28;
  TNode<IntPtrT> phi_bb162_29;
  TNode<IntPtrT> phi_bb162_31;
  TNode<BoolT> phi_bb162_32;
  TNode<BoolT> phi_bb162_33;
  TNode<Int32T> phi_bb162_35;
  TNode<Object> tmp283;
  TNode<IntPtrT> tmp284;
  TNode<IntPtrT> tmp285;
  TNode<BoolT> tmp286;
  if (block162.is_used()) {
    ca_.Bind(&block162, &phi_bb162_16, &phi_bb162_17, &phi_bb162_18, &phi_bb162_25, &phi_bb162_27, &phi_bb162_28, &phi_bb162_29, &phi_bb162_31, &phi_bb162_32, &phi_bb162_33, &phi_bb162_35);
    std::tie(tmp283, tmp284) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb162_31}).Flatten();
    tmp285 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp286 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block158, phi_bb162_16, phi_bb162_17, phi_bb162_18, phi_bb162_25, phi_bb162_27, phi_bb162_28, phi_bb162_29, tmp285, tmp286, phi_bb162_33, phi_bb162_35, tmp283, tmp284);
  }

  TNode<Object> phi_bb163_16;
  TNode<IntPtrT> phi_bb163_17;
  TNode<BoolT> phi_bb163_18;
  TNode<IntPtrT> phi_bb163_25;
  TNode<IntPtrT> phi_bb163_27;
  TNode<IntPtrT> phi_bb163_28;
  TNode<IntPtrT> phi_bb163_29;
  TNode<IntPtrT> phi_bb163_31;
  TNode<BoolT> phi_bb163_32;
  TNode<BoolT> phi_bb163_33;
  TNode<Int32T> phi_bb163_35;
  TNode<Object> tmp287;
  TNode<IntPtrT> tmp288;
  TNode<IntPtrT> tmp289;
  TNode<IntPtrT> tmp290;
  TNode<IntPtrT> tmp291;
  TNode<IntPtrT> tmp292;
  TNode<BoolT> tmp293;
  if (block163.is_used()) {
    ca_.Bind(&block163, &phi_bb163_16, &phi_bb163_17, &phi_bb163_18, &phi_bb163_25, &phi_bb163_27, &phi_bb163_28, &phi_bb163_29, &phi_bb163_31, &phi_bb163_32, &phi_bb163_33, &phi_bb163_35);
    std::tie(tmp287, tmp288) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb163_29}).Flatten();
    tmp289 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp290 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb163_29}, TNode<IntPtrT>{tmp289});
    tmp291 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp292 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp290}, TNode<IntPtrT>{tmp291});
    tmp293 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block158, phi_bb163_16, phi_bb163_17, phi_bb163_18, phi_bb163_25, phi_bb163_27, phi_bb163_28, tmp292, tmp290, tmp293, phi_bb163_33, phi_bb163_35, tmp287, tmp288);
  }

  TNode<Object> phi_bb158_16;
  TNode<IntPtrT> phi_bb158_17;
  TNode<BoolT> phi_bb158_18;
  TNode<IntPtrT> phi_bb158_25;
  TNode<IntPtrT> phi_bb158_27;
  TNode<IntPtrT> phi_bb158_28;
  TNode<IntPtrT> phi_bb158_29;
  TNode<IntPtrT> phi_bb158_31;
  TNode<BoolT> phi_bb158_32;
  TNode<BoolT> phi_bb158_33;
  TNode<Int32T> phi_bb158_35;
  TNode<Object> phi_bb158_38;
  TNode<IntPtrT> phi_bb158_39;
  if (block158.is_used()) {
    ca_.Bind(&block158, &phi_bb158_16, &phi_bb158_17, &phi_bb158_18, &phi_bb158_25, &phi_bb158_27, &phi_bb158_28, &phi_bb158_29, &phi_bb158_31, &phi_bb158_32, &phi_bb158_33, &phi_bb158_35, &phi_bb158_38, &phi_bb158_39);
    ca_.Goto(&block152, phi_bb158_16, phi_bb158_17, phi_bb158_18, phi_bb158_25, phi_bb158_27, phi_bb158_28, phi_bb158_29, phi_bb158_31, phi_bb158_32, phi_bb158_33, phi_bb158_35, phi_bb158_38, phi_bb158_39);
  }

  TNode<Object> phi_bb156_16;
  TNode<IntPtrT> phi_bb156_17;
  TNode<BoolT> phi_bb156_18;
  TNode<IntPtrT> phi_bb156_25;
  TNode<IntPtrT> phi_bb156_27;
  TNode<IntPtrT> phi_bb156_28;
  TNode<IntPtrT> phi_bb156_29;
  TNode<IntPtrT> phi_bb156_31;
  TNode<BoolT> phi_bb156_32;
  TNode<BoolT> phi_bb156_33;
  TNode<Int32T> phi_bb156_35;
  TNode<Object> tmp294;
  TNode<IntPtrT> tmp295;
  TNode<IntPtrT> tmp296;
  TNode<IntPtrT> tmp297;
  TNode<BoolT> tmp298;
  if (block156.is_used()) {
    ca_.Bind(&block156, &phi_bb156_16, &phi_bb156_17, &phi_bb156_18, &phi_bb156_25, &phi_bb156_27, &phi_bb156_28, &phi_bb156_29, &phi_bb156_31, &phi_bb156_32, &phi_bb156_33, &phi_bb156_35);
    std::tie(tmp294, tmp295) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb156_29}).Flatten();
    tmp296 = FromConstexpr_intptr_constexpr_int31_0(state_, (CodeStubAssembler(state_).ConstexprInt31Mul((FromConstexpr_constexpr_int31_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x2ull))), (SizeOf_intptr_0(state_)))));
    tmp297 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb156_29}, TNode<IntPtrT>{tmp296});
    tmp298 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block152, phi_bb156_16, phi_bb156_17, phi_bb156_18, phi_bb156_25, phi_bb156_27, phi_bb156_28, tmp297, phi_bb156_31, tmp298, phi_bb156_33, phi_bb156_35, tmp294, tmp295);
  }

  TNode<Object> phi_bb152_16;
  TNode<IntPtrT> phi_bb152_17;
  TNode<BoolT> phi_bb152_18;
  TNode<IntPtrT> phi_bb152_25;
  TNode<IntPtrT> phi_bb152_27;
  TNode<IntPtrT> phi_bb152_28;
  TNode<IntPtrT> phi_bb152_29;
  TNode<IntPtrT> phi_bb152_31;
  TNode<BoolT> phi_bb152_32;
  TNode<BoolT> phi_bb152_33;
  TNode<Int32T> phi_bb152_35;
  TNode<Object> phi_bb152_38;
  TNode<IntPtrT> phi_bb152_39;
  TNode<Object> tmp299;
  TNode<IntPtrT> tmp300;
  TNode<Float64T> tmp301;
  TNode<Float64T> tmp302;
  if (block152.is_used()) {
    ca_.Bind(&block152, &phi_bb152_16, &phi_bb152_17, &phi_bb152_18, &phi_bb152_25, &phi_bb152_27, &phi_bb152_28, &phi_bb152_29, &phi_bb152_31, &phi_bb152_32, &phi_bb152_33, &phi_bb152_35, &phi_bb152_38, &phi_bb152_39);
    std::tie(tmp299, tmp300) = RefCast_float64_0(state_, TorqueStructReference_intptr_0{TNode<Object>{phi_bb152_38}, TNode<IntPtrT>{phi_bb152_39}, TorqueStructUnsafe_0{}}).Flatten();
    tmp301 = CodeStubAssembler(state_).ChangeTaggedToFloat64(TNode<Context>{p_context}, TNode<Object>{tmp193});
    tmp302 = CodeStubAssembler(state_).Float64SilenceNaN(TNode<Float64T>{tmp301});
    CodeStubAssembler(state_).StoreReference<Float64T>(CodeStubAssembler::Reference{tmp299, tmp300}, tmp302);
    ca_.Goto(&block151, phi_bb152_16, phi_bb152_17, phi_bb152_18, phi_bb152_25, tmp270, phi_bb152_27, phi_bb152_28, phi_bb152_29, phi_bb152_31, phi_bb152_32, phi_bb152_33, phi_bb152_35);
  }

  TNode<Object> phi_bb150_16;
  TNode<IntPtrT> phi_bb150_17;
  TNode<BoolT> phi_bb150_18;
  TNode<IntPtrT> phi_bb150_25;
  TNode<IntPtrT> phi_bb150_26;
  TNode<IntPtrT> phi_bb150_27;
  TNode<IntPtrT> phi_bb150_28;
  TNode<IntPtrT> phi_bb150_29;
  TNode<IntPtrT> phi_bb150_31;
  TNode<BoolT> phi_bb150_32;
  TNode<BoolT> phi_bb150_33;
  TNode<Int32T> phi_bb150_35;
  TNode<Int32T> tmp303;
  TNode<BoolT> tmp304;
  if (block150.is_used()) {
    ca_.Bind(&block150, &phi_bb150_16, &phi_bb150_17, &phi_bb150_18, &phi_bb150_25, &phi_bb150_26, &phi_bb150_27, &phi_bb150_28, &phi_bb150_29, &phi_bb150_31, &phi_bb150_32, &phi_bb150_33, &phi_bb150_35);
    tmp303 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI64.raw_bit_field());
    tmp304 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp201}, TNode<Int32T>{tmp303});
    ca_.Branch(tmp304, &block164, std::vector<compiler::Node*>{phi_bb150_16, phi_bb150_17, phi_bb150_18, phi_bb150_25, phi_bb150_26, phi_bb150_27, phi_bb150_28, phi_bb150_29, phi_bb150_31, phi_bb150_32, phi_bb150_33, phi_bb150_35}, &block165, std::vector<compiler::Node*>{phi_bb150_16, phi_bb150_17, phi_bb150_18, phi_bb150_25, phi_bb150_26, phi_bb150_27, phi_bb150_28, phi_bb150_29, phi_bb150_31, phi_bb150_32, phi_bb150_33, phi_bb150_35});
  }

  TNode<Object> phi_bb164_16;
  TNode<IntPtrT> phi_bb164_17;
  TNode<BoolT> phi_bb164_18;
  TNode<IntPtrT> phi_bb164_25;
  TNode<IntPtrT> phi_bb164_26;
  TNode<IntPtrT> phi_bb164_27;
  TNode<IntPtrT> phi_bb164_28;
  TNode<IntPtrT> phi_bb164_29;
  TNode<IntPtrT> phi_bb164_31;
  TNode<BoolT> phi_bb164_32;
  TNode<BoolT> phi_bb164_33;
  TNode<Int32T> phi_bb164_35;
  if (block164.is_used()) {
    ca_.Bind(&block164, &phi_bb164_16, &phi_bb164_17, &phi_bb164_18, &phi_bb164_25, &phi_bb164_26, &phi_bb164_27, &phi_bb164_28, &phi_bb164_29, &phi_bb164_31, &phi_bb164_32, &phi_bb164_33, &phi_bb164_35);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block167, phi_bb164_16, phi_bb164_17, phi_bb164_18, phi_bb164_25, phi_bb164_26, phi_bb164_27, phi_bb164_28, phi_bb164_29, phi_bb164_31, phi_bb164_32, phi_bb164_33, phi_bb164_35);
    } else {
      ca_.Goto(&block168, phi_bb164_16, phi_bb164_17, phi_bb164_18, phi_bb164_25, phi_bb164_26, phi_bb164_27, phi_bb164_28, phi_bb164_29, phi_bb164_31, phi_bb164_32, phi_bb164_33, phi_bb164_35);
    }
  }

  TNode<Object> phi_bb167_16;
  TNode<IntPtrT> phi_bb167_17;
  TNode<BoolT> phi_bb167_18;
  TNode<IntPtrT> phi_bb167_25;
  TNode<IntPtrT> phi_bb167_26;
  TNode<IntPtrT> phi_bb167_27;
  TNode<IntPtrT> phi_bb167_28;
  TNode<IntPtrT> phi_bb167_29;
  TNode<IntPtrT> phi_bb167_31;
  TNode<BoolT> phi_bb167_32;
  TNode<BoolT> phi_bb167_33;
  TNode<Int32T> phi_bb167_35;
  TNode<IntPtrT> tmp305;
  TNode<IntPtrT> tmp306;
  TNode<IntPtrT> tmp307;
  TNode<BoolT> tmp308;
  if (block167.is_used()) {
    ca_.Bind(&block167, &phi_bb167_16, &phi_bb167_17, &phi_bb167_18, &phi_bb167_25, &phi_bb167_26, &phi_bb167_27, &phi_bb167_28, &phi_bb167_29, &phi_bb167_31, &phi_bb167_32, &phi_bb167_33, &phi_bb167_35);
    tmp305 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp306 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb167_25}, TNode<IntPtrT>{tmp305});
    tmp307 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp308 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb167_25}, TNode<IntPtrT>{tmp307});
    ca_.Branch(tmp308, &block171, std::vector<compiler::Node*>{phi_bb167_16, phi_bb167_17, phi_bb167_18, phi_bb167_26, phi_bb167_27, phi_bb167_28, phi_bb167_29, phi_bb167_31, phi_bb167_32, phi_bb167_33, phi_bb167_35}, &block172, std::vector<compiler::Node*>{phi_bb167_16, phi_bb167_17, phi_bb167_18, phi_bb167_26, phi_bb167_27, phi_bb167_28, phi_bb167_29, phi_bb167_31, phi_bb167_32, phi_bb167_33, phi_bb167_35});
  }

  TNode<Object> phi_bb171_16;
  TNode<IntPtrT> phi_bb171_17;
  TNode<BoolT> phi_bb171_18;
  TNode<IntPtrT> phi_bb171_26;
  TNode<IntPtrT> phi_bb171_27;
  TNode<IntPtrT> phi_bb171_28;
  TNode<IntPtrT> phi_bb171_29;
  TNode<IntPtrT> phi_bb171_31;
  TNode<BoolT> phi_bb171_32;
  TNode<BoolT> phi_bb171_33;
  TNode<Int32T> phi_bb171_35;
  TNode<Object> tmp309;
  TNode<IntPtrT> tmp310;
  TNode<IntPtrT> tmp311;
  TNode<IntPtrT> tmp312;
  if (block171.is_used()) {
    ca_.Bind(&block171, &phi_bb171_16, &phi_bb171_17, &phi_bb171_18, &phi_bb171_26, &phi_bb171_27, &phi_bb171_28, &phi_bb171_29, &phi_bb171_31, &phi_bb171_32, &phi_bb171_33, &phi_bb171_35);
    std::tie(tmp309, tmp310) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb171_27}).Flatten();
    tmp311 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp312 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb171_27}, TNode<IntPtrT>{tmp311});
    ca_.Goto(&block170, phi_bb171_16, phi_bb171_17, phi_bb171_18, phi_bb171_26, tmp312, phi_bb171_28, phi_bb171_29, phi_bb171_31, phi_bb171_32, phi_bb171_33, phi_bb171_35, tmp309, tmp310);
  }

  TNode<Object> phi_bb172_16;
  TNode<IntPtrT> phi_bb172_17;
  TNode<BoolT> phi_bb172_18;
  TNode<IntPtrT> phi_bb172_26;
  TNode<IntPtrT> phi_bb172_27;
  TNode<IntPtrT> phi_bb172_28;
  TNode<IntPtrT> phi_bb172_29;
  TNode<IntPtrT> phi_bb172_31;
  TNode<BoolT> phi_bb172_32;
  TNode<BoolT> phi_bb172_33;
  TNode<Int32T> phi_bb172_35;
  if (block172.is_used()) {
    ca_.Bind(&block172, &phi_bb172_16, &phi_bb172_17, &phi_bb172_18, &phi_bb172_26, &phi_bb172_27, &phi_bb172_28, &phi_bb172_29, &phi_bb172_31, &phi_bb172_32, &phi_bb172_33, &phi_bb172_35);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block174, phi_bb172_16, phi_bb172_17, phi_bb172_18, phi_bb172_26, phi_bb172_27, phi_bb172_28, phi_bb172_29, phi_bb172_31, phi_bb172_32, phi_bb172_33, phi_bb172_35);
    } else {
      ca_.Goto(&block175, phi_bb172_16, phi_bb172_17, phi_bb172_18, phi_bb172_26, phi_bb172_27, phi_bb172_28, phi_bb172_29, phi_bb172_31, phi_bb172_32, phi_bb172_33, phi_bb172_35);
    }
  }

  TNode<Object> phi_bb174_16;
  TNode<IntPtrT> phi_bb174_17;
  TNode<BoolT> phi_bb174_18;
  TNode<IntPtrT> phi_bb174_26;
  TNode<IntPtrT> phi_bb174_27;
  TNode<IntPtrT> phi_bb174_28;
  TNode<IntPtrT> phi_bb174_29;
  TNode<IntPtrT> phi_bb174_31;
  TNode<BoolT> phi_bb174_32;
  TNode<BoolT> phi_bb174_33;
  TNode<Int32T> phi_bb174_35;
  TNode<Object> tmp313;
  TNode<IntPtrT> tmp314;
  TNode<IntPtrT> tmp315;
  TNode<IntPtrT> tmp316;
  if (block174.is_used()) {
    ca_.Bind(&block174, &phi_bb174_16, &phi_bb174_17, &phi_bb174_18, &phi_bb174_26, &phi_bb174_27, &phi_bb174_28, &phi_bb174_29, &phi_bb174_31, &phi_bb174_32, &phi_bb174_33, &phi_bb174_35);
    std::tie(tmp313, tmp314) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb174_29}).Flatten();
    tmp315 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp316 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb174_29}, TNode<IntPtrT>{tmp315});
    ca_.Goto(&block173, phi_bb174_16, phi_bb174_17, phi_bb174_18, phi_bb174_26, phi_bb174_27, phi_bb174_28, tmp316, phi_bb174_31, phi_bb174_32, phi_bb174_33, phi_bb174_35, tmp313, tmp314);
  }

  TNode<Object> phi_bb175_16;
  TNode<IntPtrT> phi_bb175_17;
  TNode<BoolT> phi_bb175_18;
  TNode<IntPtrT> phi_bb175_26;
  TNode<IntPtrT> phi_bb175_27;
  TNode<IntPtrT> phi_bb175_28;
  TNode<IntPtrT> phi_bb175_29;
  TNode<IntPtrT> phi_bb175_31;
  TNode<BoolT> phi_bb175_32;
  TNode<BoolT> phi_bb175_33;
  TNode<Int32T> phi_bb175_35;
  TNode<IntPtrT> tmp317;
  TNode<BoolT> tmp318;
  if (block175.is_used()) {
    ca_.Bind(&block175, &phi_bb175_16, &phi_bb175_17, &phi_bb175_18, &phi_bb175_26, &phi_bb175_27, &phi_bb175_28, &phi_bb175_29, &phi_bb175_31, &phi_bb175_32, &phi_bb175_33, &phi_bb175_35);
    tmp317 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp318 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb175_31}, TNode<IntPtrT>{tmp317});
    ca_.Branch(tmp318, &block177, std::vector<compiler::Node*>{phi_bb175_16, phi_bb175_17, phi_bb175_18, phi_bb175_26, phi_bb175_27, phi_bb175_28, phi_bb175_29, phi_bb175_31, phi_bb175_32, phi_bb175_33, phi_bb175_35}, &block178, std::vector<compiler::Node*>{phi_bb175_16, phi_bb175_17, phi_bb175_18, phi_bb175_26, phi_bb175_27, phi_bb175_28, phi_bb175_29, phi_bb175_31, phi_bb175_32, phi_bb175_33, phi_bb175_35});
  }

  TNode<Object> phi_bb177_16;
  TNode<IntPtrT> phi_bb177_17;
  TNode<BoolT> phi_bb177_18;
  TNode<IntPtrT> phi_bb177_26;
  TNode<IntPtrT> phi_bb177_27;
  TNode<IntPtrT> phi_bb177_28;
  TNode<IntPtrT> phi_bb177_29;
  TNode<IntPtrT> phi_bb177_31;
  TNode<BoolT> phi_bb177_32;
  TNode<BoolT> phi_bb177_33;
  TNode<Int32T> phi_bb177_35;
  TNode<Object> tmp319;
  TNode<IntPtrT> tmp320;
  TNode<IntPtrT> tmp321;
  TNode<BoolT> tmp322;
  if (block177.is_used()) {
    ca_.Bind(&block177, &phi_bb177_16, &phi_bb177_17, &phi_bb177_18, &phi_bb177_26, &phi_bb177_27, &phi_bb177_28, &phi_bb177_29, &phi_bb177_31, &phi_bb177_32, &phi_bb177_33, &phi_bb177_35);
    std::tie(tmp319, tmp320) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb177_31}).Flatten();
    tmp321 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp322 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block173, phi_bb177_16, phi_bb177_17, phi_bb177_18, phi_bb177_26, phi_bb177_27, phi_bb177_28, phi_bb177_29, tmp321, tmp322, phi_bb177_33, phi_bb177_35, tmp319, tmp320);
  }

  TNode<Object> phi_bb178_16;
  TNode<IntPtrT> phi_bb178_17;
  TNode<BoolT> phi_bb178_18;
  TNode<IntPtrT> phi_bb178_26;
  TNode<IntPtrT> phi_bb178_27;
  TNode<IntPtrT> phi_bb178_28;
  TNode<IntPtrT> phi_bb178_29;
  TNode<IntPtrT> phi_bb178_31;
  TNode<BoolT> phi_bb178_32;
  TNode<BoolT> phi_bb178_33;
  TNode<Int32T> phi_bb178_35;
  TNode<Object> tmp323;
  TNode<IntPtrT> tmp324;
  TNode<IntPtrT> tmp325;
  TNode<IntPtrT> tmp326;
  TNode<IntPtrT> tmp327;
  TNode<IntPtrT> tmp328;
  TNode<BoolT> tmp329;
  if (block178.is_used()) {
    ca_.Bind(&block178, &phi_bb178_16, &phi_bb178_17, &phi_bb178_18, &phi_bb178_26, &phi_bb178_27, &phi_bb178_28, &phi_bb178_29, &phi_bb178_31, &phi_bb178_32, &phi_bb178_33, &phi_bb178_35);
    std::tie(tmp323, tmp324) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb178_29}).Flatten();
    tmp325 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp326 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb178_29}, TNode<IntPtrT>{tmp325});
    tmp327 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp328 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp326}, TNode<IntPtrT>{tmp327});
    tmp329 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block173, phi_bb178_16, phi_bb178_17, phi_bb178_18, phi_bb178_26, phi_bb178_27, phi_bb178_28, tmp328, tmp326, tmp329, phi_bb178_33, phi_bb178_35, tmp323, tmp324);
  }

  TNode<Object> phi_bb173_16;
  TNode<IntPtrT> phi_bb173_17;
  TNode<BoolT> phi_bb173_18;
  TNode<IntPtrT> phi_bb173_26;
  TNode<IntPtrT> phi_bb173_27;
  TNode<IntPtrT> phi_bb173_28;
  TNode<IntPtrT> phi_bb173_29;
  TNode<IntPtrT> phi_bb173_31;
  TNode<BoolT> phi_bb173_32;
  TNode<BoolT> phi_bb173_33;
  TNode<Int32T> phi_bb173_35;
  TNode<Object> phi_bb173_38;
  TNode<IntPtrT> phi_bb173_39;
  if (block173.is_used()) {
    ca_.Bind(&block173, &phi_bb173_16, &phi_bb173_17, &phi_bb173_18, &phi_bb173_26, &phi_bb173_27, &phi_bb173_28, &phi_bb173_29, &phi_bb173_31, &phi_bb173_32, &phi_bb173_33, &phi_bb173_35, &phi_bb173_38, &phi_bb173_39);
    ca_.Goto(&block170, phi_bb173_16, phi_bb173_17, phi_bb173_18, phi_bb173_26, phi_bb173_27, phi_bb173_28, phi_bb173_29, phi_bb173_31, phi_bb173_32, phi_bb173_33, phi_bb173_35, phi_bb173_38, phi_bb173_39);
  }

  TNode<Object> phi_bb170_16;
  TNode<IntPtrT> phi_bb170_17;
  TNode<BoolT> phi_bb170_18;
  TNode<IntPtrT> phi_bb170_26;
  TNode<IntPtrT> phi_bb170_27;
  TNode<IntPtrT> phi_bb170_28;
  TNode<IntPtrT> phi_bb170_29;
  TNode<IntPtrT> phi_bb170_31;
  TNode<BoolT> phi_bb170_32;
  TNode<BoolT> phi_bb170_33;
  TNode<Int32T> phi_bb170_35;
  TNode<Object> phi_bb170_38;
  TNode<IntPtrT> phi_bb170_39;
  TNode<IntPtrT> tmp330;
  if (block170.is_used()) {
    ca_.Bind(&block170, &phi_bb170_16, &phi_bb170_17, &phi_bb170_18, &phi_bb170_26, &phi_bb170_27, &phi_bb170_28, &phi_bb170_29, &phi_bb170_31, &phi_bb170_32, &phi_bb170_33, &phi_bb170_35, &phi_bb170_38, &phi_bb170_39);
    tmp330 = TruncateBigIntToI64_0(state_, TNode<Context>{p_context}, TNode<Object>{tmp193});
    CodeStubAssembler(state_).StoreReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb170_38, phi_bb170_39}, tmp330);
    ca_.Goto(&block169, phi_bb170_16, phi_bb170_17, phi_bb170_18, tmp306, phi_bb170_26, phi_bb170_27, phi_bb170_28, phi_bb170_29, phi_bb170_31, phi_bb170_32, phi_bb170_33, phi_bb170_35);
  }

  TNode<Object> phi_bb168_16;
  TNode<IntPtrT> phi_bb168_17;
  TNode<BoolT> phi_bb168_18;
  TNode<IntPtrT> phi_bb168_25;
  TNode<IntPtrT> phi_bb168_26;
  TNode<IntPtrT> phi_bb168_27;
  TNode<IntPtrT> phi_bb168_28;
  TNode<IntPtrT> phi_bb168_29;
  TNode<IntPtrT> phi_bb168_31;
  TNode<BoolT> phi_bb168_32;
  TNode<BoolT> phi_bb168_33;
  TNode<Int32T> phi_bb168_35;
  TNode<IntPtrT> tmp331;
  TNode<IntPtrT> tmp332;
  TNode<IntPtrT> tmp333;
  TNode<BoolT> tmp334;
  if (block168.is_used()) {
    ca_.Bind(&block168, &phi_bb168_16, &phi_bb168_17, &phi_bb168_18, &phi_bb168_25, &phi_bb168_26, &phi_bb168_27, &phi_bb168_28, &phi_bb168_29, &phi_bb168_31, &phi_bb168_32, &phi_bb168_33, &phi_bb168_35);
    tmp331 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp332 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb168_25}, TNode<IntPtrT>{tmp331});
    tmp333 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp334 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb168_25}, TNode<IntPtrT>{tmp333});
    ca_.Branch(tmp334, &block180, std::vector<compiler::Node*>{phi_bb168_16, phi_bb168_17, phi_bb168_18, phi_bb168_26, phi_bb168_27, phi_bb168_28, phi_bb168_29, phi_bb168_31, phi_bb168_32, phi_bb168_33, phi_bb168_35}, &block181, std::vector<compiler::Node*>{phi_bb168_16, phi_bb168_17, phi_bb168_18, phi_bb168_26, phi_bb168_27, phi_bb168_28, phi_bb168_29, phi_bb168_31, phi_bb168_32, phi_bb168_33, phi_bb168_35});
  }

  TNode<Object> phi_bb180_16;
  TNode<IntPtrT> phi_bb180_17;
  TNode<BoolT> phi_bb180_18;
  TNode<IntPtrT> phi_bb180_26;
  TNode<IntPtrT> phi_bb180_27;
  TNode<IntPtrT> phi_bb180_28;
  TNode<IntPtrT> phi_bb180_29;
  TNode<IntPtrT> phi_bb180_31;
  TNode<BoolT> phi_bb180_32;
  TNode<BoolT> phi_bb180_33;
  TNode<Int32T> phi_bb180_35;
  TNode<Object> tmp335;
  TNode<IntPtrT> tmp336;
  TNode<IntPtrT> tmp337;
  TNode<IntPtrT> tmp338;
  if (block180.is_used()) {
    ca_.Bind(&block180, &phi_bb180_16, &phi_bb180_17, &phi_bb180_18, &phi_bb180_26, &phi_bb180_27, &phi_bb180_28, &phi_bb180_29, &phi_bb180_31, &phi_bb180_32, &phi_bb180_33, &phi_bb180_35);
    std::tie(tmp335, tmp336) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb180_27}).Flatten();
    tmp337 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp338 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb180_27}, TNode<IntPtrT>{tmp337});
    ca_.Goto(&block179, phi_bb180_16, phi_bb180_17, phi_bb180_18, phi_bb180_26, tmp338, phi_bb180_28, phi_bb180_29, phi_bb180_31, phi_bb180_32, phi_bb180_33, phi_bb180_35, tmp335, tmp336);
  }

  TNode<Object> phi_bb181_16;
  TNode<IntPtrT> phi_bb181_17;
  TNode<BoolT> phi_bb181_18;
  TNode<IntPtrT> phi_bb181_26;
  TNode<IntPtrT> phi_bb181_27;
  TNode<IntPtrT> phi_bb181_28;
  TNode<IntPtrT> phi_bb181_29;
  TNode<IntPtrT> phi_bb181_31;
  TNode<BoolT> phi_bb181_32;
  TNode<BoolT> phi_bb181_33;
  TNode<Int32T> phi_bb181_35;
  if (block181.is_used()) {
    ca_.Bind(&block181, &phi_bb181_16, &phi_bb181_17, &phi_bb181_18, &phi_bb181_26, &phi_bb181_27, &phi_bb181_28, &phi_bb181_29, &phi_bb181_31, &phi_bb181_32, &phi_bb181_33, &phi_bb181_35);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block183, phi_bb181_16, phi_bb181_17, phi_bb181_18, phi_bb181_26, phi_bb181_27, phi_bb181_28, phi_bb181_29, phi_bb181_31, phi_bb181_32, phi_bb181_33, phi_bb181_35);
    } else {
      ca_.Goto(&block184, phi_bb181_16, phi_bb181_17, phi_bb181_18, phi_bb181_26, phi_bb181_27, phi_bb181_28, phi_bb181_29, phi_bb181_31, phi_bb181_32, phi_bb181_33, phi_bb181_35);
    }
  }

  TNode<Object> phi_bb183_16;
  TNode<IntPtrT> phi_bb183_17;
  TNode<BoolT> phi_bb183_18;
  TNode<IntPtrT> phi_bb183_26;
  TNode<IntPtrT> phi_bb183_27;
  TNode<IntPtrT> phi_bb183_28;
  TNode<IntPtrT> phi_bb183_29;
  TNode<IntPtrT> phi_bb183_31;
  TNode<BoolT> phi_bb183_32;
  TNode<BoolT> phi_bb183_33;
  TNode<Int32T> phi_bb183_35;
  TNode<Object> tmp339;
  TNode<IntPtrT> tmp340;
  TNode<IntPtrT> tmp341;
  TNode<IntPtrT> tmp342;
  if (block183.is_used()) {
    ca_.Bind(&block183, &phi_bb183_16, &phi_bb183_17, &phi_bb183_18, &phi_bb183_26, &phi_bb183_27, &phi_bb183_28, &phi_bb183_29, &phi_bb183_31, &phi_bb183_32, &phi_bb183_33, &phi_bb183_35);
    std::tie(tmp339, tmp340) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb183_29}).Flatten();
    tmp341 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp342 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb183_29}, TNode<IntPtrT>{tmp341});
    ca_.Goto(&block182, phi_bb183_16, phi_bb183_17, phi_bb183_18, phi_bb183_26, phi_bb183_27, phi_bb183_28, tmp342, phi_bb183_31, phi_bb183_32, phi_bb183_33, phi_bb183_35, tmp339, tmp340);
  }

  TNode<Object> phi_bb184_16;
  TNode<IntPtrT> phi_bb184_17;
  TNode<BoolT> phi_bb184_18;
  TNode<IntPtrT> phi_bb184_26;
  TNode<IntPtrT> phi_bb184_27;
  TNode<IntPtrT> phi_bb184_28;
  TNode<IntPtrT> phi_bb184_29;
  TNode<IntPtrT> phi_bb184_31;
  TNode<BoolT> phi_bb184_32;
  TNode<BoolT> phi_bb184_33;
  TNode<Int32T> phi_bb184_35;
  TNode<IntPtrT> tmp343;
  TNode<BoolT> tmp344;
  if (block184.is_used()) {
    ca_.Bind(&block184, &phi_bb184_16, &phi_bb184_17, &phi_bb184_18, &phi_bb184_26, &phi_bb184_27, &phi_bb184_28, &phi_bb184_29, &phi_bb184_31, &phi_bb184_32, &phi_bb184_33, &phi_bb184_35);
    tmp343 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp344 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb184_31}, TNode<IntPtrT>{tmp343});
    ca_.Branch(tmp344, &block186, std::vector<compiler::Node*>{phi_bb184_16, phi_bb184_17, phi_bb184_18, phi_bb184_26, phi_bb184_27, phi_bb184_28, phi_bb184_29, phi_bb184_31, phi_bb184_32, phi_bb184_33, phi_bb184_35}, &block187, std::vector<compiler::Node*>{phi_bb184_16, phi_bb184_17, phi_bb184_18, phi_bb184_26, phi_bb184_27, phi_bb184_28, phi_bb184_29, phi_bb184_31, phi_bb184_32, phi_bb184_33, phi_bb184_35});
  }

  TNode<Object> phi_bb186_16;
  TNode<IntPtrT> phi_bb186_17;
  TNode<BoolT> phi_bb186_18;
  TNode<IntPtrT> phi_bb186_26;
  TNode<IntPtrT> phi_bb186_27;
  TNode<IntPtrT> phi_bb186_28;
  TNode<IntPtrT> phi_bb186_29;
  TNode<IntPtrT> phi_bb186_31;
  TNode<BoolT> phi_bb186_32;
  TNode<BoolT> phi_bb186_33;
  TNode<Int32T> phi_bb186_35;
  TNode<Object> tmp345;
  TNode<IntPtrT> tmp346;
  TNode<IntPtrT> tmp347;
  TNode<BoolT> tmp348;
  if (block186.is_used()) {
    ca_.Bind(&block186, &phi_bb186_16, &phi_bb186_17, &phi_bb186_18, &phi_bb186_26, &phi_bb186_27, &phi_bb186_28, &phi_bb186_29, &phi_bb186_31, &phi_bb186_32, &phi_bb186_33, &phi_bb186_35);
    std::tie(tmp345, tmp346) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb186_31}).Flatten();
    tmp347 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp348 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block182, phi_bb186_16, phi_bb186_17, phi_bb186_18, phi_bb186_26, phi_bb186_27, phi_bb186_28, phi_bb186_29, tmp347, tmp348, phi_bb186_33, phi_bb186_35, tmp345, tmp346);
  }

  TNode<Object> phi_bb187_16;
  TNode<IntPtrT> phi_bb187_17;
  TNode<BoolT> phi_bb187_18;
  TNode<IntPtrT> phi_bb187_26;
  TNode<IntPtrT> phi_bb187_27;
  TNode<IntPtrT> phi_bb187_28;
  TNode<IntPtrT> phi_bb187_29;
  TNode<IntPtrT> phi_bb187_31;
  TNode<BoolT> phi_bb187_32;
  TNode<BoolT> phi_bb187_33;
  TNode<Int32T> phi_bb187_35;
  TNode<Object> tmp349;
  TNode<IntPtrT> tmp350;
  TNode<IntPtrT> tmp351;
  TNode<IntPtrT> tmp352;
  TNode<IntPtrT> tmp353;
  TNode<IntPtrT> tmp354;
  TNode<BoolT> tmp355;
  if (block187.is_used()) {
    ca_.Bind(&block187, &phi_bb187_16, &phi_bb187_17, &phi_bb187_18, &phi_bb187_26, &phi_bb187_27, &phi_bb187_28, &phi_bb187_29, &phi_bb187_31, &phi_bb187_32, &phi_bb187_33, &phi_bb187_35);
    std::tie(tmp349, tmp350) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb187_29}).Flatten();
    tmp351 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp352 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb187_29}, TNode<IntPtrT>{tmp351});
    tmp353 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp354 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp352}, TNode<IntPtrT>{tmp353});
    tmp355 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block182, phi_bb187_16, phi_bb187_17, phi_bb187_18, phi_bb187_26, phi_bb187_27, phi_bb187_28, tmp354, tmp352, tmp355, phi_bb187_33, phi_bb187_35, tmp349, tmp350);
  }

  TNode<Object> phi_bb182_16;
  TNode<IntPtrT> phi_bb182_17;
  TNode<BoolT> phi_bb182_18;
  TNode<IntPtrT> phi_bb182_26;
  TNode<IntPtrT> phi_bb182_27;
  TNode<IntPtrT> phi_bb182_28;
  TNode<IntPtrT> phi_bb182_29;
  TNode<IntPtrT> phi_bb182_31;
  TNode<BoolT> phi_bb182_32;
  TNode<BoolT> phi_bb182_33;
  TNode<Int32T> phi_bb182_35;
  TNode<Object> phi_bb182_38;
  TNode<IntPtrT> phi_bb182_39;
  if (block182.is_used()) {
    ca_.Bind(&block182, &phi_bb182_16, &phi_bb182_17, &phi_bb182_18, &phi_bb182_26, &phi_bb182_27, &phi_bb182_28, &phi_bb182_29, &phi_bb182_31, &phi_bb182_32, &phi_bb182_33, &phi_bb182_35, &phi_bb182_38, &phi_bb182_39);
    ca_.Goto(&block179, phi_bb182_16, phi_bb182_17, phi_bb182_18, phi_bb182_26, phi_bb182_27, phi_bb182_28, phi_bb182_29, phi_bb182_31, phi_bb182_32, phi_bb182_33, phi_bb182_35, phi_bb182_38, phi_bb182_39);
  }

  TNode<Object> phi_bb179_16;
  TNode<IntPtrT> phi_bb179_17;
  TNode<BoolT> phi_bb179_18;
  TNode<IntPtrT> phi_bb179_26;
  TNode<IntPtrT> phi_bb179_27;
  TNode<IntPtrT> phi_bb179_28;
  TNode<IntPtrT> phi_bb179_29;
  TNode<IntPtrT> phi_bb179_31;
  TNode<BoolT> phi_bb179_32;
  TNode<BoolT> phi_bb179_33;
  TNode<Int32T> phi_bb179_35;
  TNode<Object> phi_bb179_38;
  TNode<IntPtrT> phi_bb179_39;
  TNode<IntPtrT> tmp356;
  TNode<IntPtrT> tmp357;
  TNode<IntPtrT> tmp358;
  TNode<BoolT> tmp359;
  if (block179.is_used()) {
    ca_.Bind(&block179, &phi_bb179_16, &phi_bb179_17, &phi_bb179_18, &phi_bb179_26, &phi_bb179_27, &phi_bb179_28, &phi_bb179_29, &phi_bb179_31, &phi_bb179_32, &phi_bb179_33, &phi_bb179_35, &phi_bb179_38, &phi_bb179_39);
    tmp356 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp357 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{tmp332}, TNode<IntPtrT>{tmp356});
    tmp358 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp359 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{tmp332}, TNode<IntPtrT>{tmp358});
    ca_.Branch(tmp359, &block189, std::vector<compiler::Node*>{phi_bb179_16, phi_bb179_17, phi_bb179_18, phi_bb179_26, phi_bb179_27, phi_bb179_28, phi_bb179_29, phi_bb179_31, phi_bb179_32, phi_bb179_33, phi_bb179_35, phi_bb179_38, phi_bb179_39}, &block190, std::vector<compiler::Node*>{phi_bb179_16, phi_bb179_17, phi_bb179_18, phi_bb179_26, phi_bb179_27, phi_bb179_28, phi_bb179_29, phi_bb179_31, phi_bb179_32, phi_bb179_33, phi_bb179_35, phi_bb179_38, phi_bb179_39});
  }

  TNode<Object> phi_bb189_16;
  TNode<IntPtrT> phi_bb189_17;
  TNode<BoolT> phi_bb189_18;
  TNode<IntPtrT> phi_bb189_26;
  TNode<IntPtrT> phi_bb189_27;
  TNode<IntPtrT> phi_bb189_28;
  TNode<IntPtrT> phi_bb189_29;
  TNode<IntPtrT> phi_bb189_31;
  TNode<BoolT> phi_bb189_32;
  TNode<BoolT> phi_bb189_33;
  TNode<Int32T> phi_bb189_35;
  TNode<Object> phi_bb189_38;
  TNode<IntPtrT> phi_bb189_39;
  TNode<Object> tmp360;
  TNode<IntPtrT> tmp361;
  TNode<IntPtrT> tmp362;
  TNode<IntPtrT> tmp363;
  if (block189.is_used()) {
    ca_.Bind(&block189, &phi_bb189_16, &phi_bb189_17, &phi_bb189_18, &phi_bb189_26, &phi_bb189_27, &phi_bb189_28, &phi_bb189_29, &phi_bb189_31, &phi_bb189_32, &phi_bb189_33, &phi_bb189_35, &phi_bb189_38, &phi_bb189_39);
    std::tie(tmp360, tmp361) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb189_27}).Flatten();
    tmp362 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp363 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb189_27}, TNode<IntPtrT>{tmp362});
    ca_.Goto(&block188, phi_bb189_16, phi_bb189_17, phi_bb189_18, phi_bb189_26, tmp363, phi_bb189_28, phi_bb189_29, phi_bb189_31, phi_bb189_32, phi_bb189_33, phi_bb189_35, phi_bb189_38, phi_bb189_39, tmp360, tmp361);
  }

  TNode<Object> phi_bb190_16;
  TNode<IntPtrT> phi_bb190_17;
  TNode<BoolT> phi_bb190_18;
  TNode<IntPtrT> phi_bb190_26;
  TNode<IntPtrT> phi_bb190_27;
  TNode<IntPtrT> phi_bb190_28;
  TNode<IntPtrT> phi_bb190_29;
  TNode<IntPtrT> phi_bb190_31;
  TNode<BoolT> phi_bb190_32;
  TNode<BoolT> phi_bb190_33;
  TNode<Int32T> phi_bb190_35;
  TNode<Object> phi_bb190_38;
  TNode<IntPtrT> phi_bb190_39;
  if (block190.is_used()) {
    ca_.Bind(&block190, &phi_bb190_16, &phi_bb190_17, &phi_bb190_18, &phi_bb190_26, &phi_bb190_27, &phi_bb190_28, &phi_bb190_29, &phi_bb190_31, &phi_bb190_32, &phi_bb190_33, &phi_bb190_35, &phi_bb190_38, &phi_bb190_39);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block192, phi_bb190_16, phi_bb190_17, phi_bb190_18, phi_bb190_26, phi_bb190_27, phi_bb190_28, phi_bb190_29, phi_bb190_31, phi_bb190_32, phi_bb190_33, phi_bb190_35, phi_bb190_38, phi_bb190_39);
    } else {
      ca_.Goto(&block193, phi_bb190_16, phi_bb190_17, phi_bb190_18, phi_bb190_26, phi_bb190_27, phi_bb190_28, phi_bb190_29, phi_bb190_31, phi_bb190_32, phi_bb190_33, phi_bb190_35, phi_bb190_38, phi_bb190_39);
    }
  }

  TNode<Object> phi_bb192_16;
  TNode<IntPtrT> phi_bb192_17;
  TNode<BoolT> phi_bb192_18;
  TNode<IntPtrT> phi_bb192_26;
  TNode<IntPtrT> phi_bb192_27;
  TNode<IntPtrT> phi_bb192_28;
  TNode<IntPtrT> phi_bb192_29;
  TNode<IntPtrT> phi_bb192_31;
  TNode<BoolT> phi_bb192_32;
  TNode<BoolT> phi_bb192_33;
  TNode<Int32T> phi_bb192_35;
  TNode<Object> phi_bb192_38;
  TNode<IntPtrT> phi_bb192_39;
  TNode<Object> tmp364;
  TNode<IntPtrT> tmp365;
  TNode<IntPtrT> tmp366;
  TNode<IntPtrT> tmp367;
  if (block192.is_used()) {
    ca_.Bind(&block192, &phi_bb192_16, &phi_bb192_17, &phi_bb192_18, &phi_bb192_26, &phi_bb192_27, &phi_bb192_28, &phi_bb192_29, &phi_bb192_31, &phi_bb192_32, &phi_bb192_33, &phi_bb192_35, &phi_bb192_38, &phi_bb192_39);
    std::tie(tmp364, tmp365) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb192_29}).Flatten();
    tmp366 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp367 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb192_29}, TNode<IntPtrT>{tmp366});
    ca_.Goto(&block191, phi_bb192_16, phi_bb192_17, phi_bb192_18, phi_bb192_26, phi_bb192_27, phi_bb192_28, tmp367, phi_bb192_31, phi_bb192_32, phi_bb192_33, phi_bb192_35, phi_bb192_38, phi_bb192_39, tmp364, tmp365);
  }

  TNode<Object> phi_bb193_16;
  TNode<IntPtrT> phi_bb193_17;
  TNode<BoolT> phi_bb193_18;
  TNode<IntPtrT> phi_bb193_26;
  TNode<IntPtrT> phi_bb193_27;
  TNode<IntPtrT> phi_bb193_28;
  TNode<IntPtrT> phi_bb193_29;
  TNode<IntPtrT> phi_bb193_31;
  TNode<BoolT> phi_bb193_32;
  TNode<BoolT> phi_bb193_33;
  TNode<Int32T> phi_bb193_35;
  TNode<Object> phi_bb193_38;
  TNode<IntPtrT> phi_bb193_39;
  TNode<IntPtrT> tmp368;
  TNode<BoolT> tmp369;
  if (block193.is_used()) {
    ca_.Bind(&block193, &phi_bb193_16, &phi_bb193_17, &phi_bb193_18, &phi_bb193_26, &phi_bb193_27, &phi_bb193_28, &phi_bb193_29, &phi_bb193_31, &phi_bb193_32, &phi_bb193_33, &phi_bb193_35, &phi_bb193_38, &phi_bb193_39);
    tmp368 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp369 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb193_31}, TNode<IntPtrT>{tmp368});
    ca_.Branch(tmp369, &block195, std::vector<compiler::Node*>{phi_bb193_16, phi_bb193_17, phi_bb193_18, phi_bb193_26, phi_bb193_27, phi_bb193_28, phi_bb193_29, phi_bb193_31, phi_bb193_32, phi_bb193_33, phi_bb193_35, phi_bb193_38, phi_bb193_39}, &block196, std::vector<compiler::Node*>{phi_bb193_16, phi_bb193_17, phi_bb193_18, phi_bb193_26, phi_bb193_27, phi_bb193_28, phi_bb193_29, phi_bb193_31, phi_bb193_32, phi_bb193_33, phi_bb193_35, phi_bb193_38, phi_bb193_39});
  }

  TNode<Object> phi_bb195_16;
  TNode<IntPtrT> phi_bb195_17;
  TNode<BoolT> phi_bb195_18;
  TNode<IntPtrT> phi_bb195_26;
  TNode<IntPtrT> phi_bb195_27;
  TNode<IntPtrT> phi_bb195_28;
  TNode<IntPtrT> phi_bb195_29;
  TNode<IntPtrT> phi_bb195_31;
  TNode<BoolT> phi_bb195_32;
  TNode<BoolT> phi_bb195_33;
  TNode<Int32T> phi_bb195_35;
  TNode<Object> phi_bb195_38;
  TNode<IntPtrT> phi_bb195_39;
  TNode<Object> tmp370;
  TNode<IntPtrT> tmp371;
  TNode<IntPtrT> tmp372;
  TNode<BoolT> tmp373;
  if (block195.is_used()) {
    ca_.Bind(&block195, &phi_bb195_16, &phi_bb195_17, &phi_bb195_18, &phi_bb195_26, &phi_bb195_27, &phi_bb195_28, &phi_bb195_29, &phi_bb195_31, &phi_bb195_32, &phi_bb195_33, &phi_bb195_35, &phi_bb195_38, &phi_bb195_39);
    std::tie(tmp370, tmp371) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb195_31}).Flatten();
    tmp372 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp373 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block191, phi_bb195_16, phi_bb195_17, phi_bb195_18, phi_bb195_26, phi_bb195_27, phi_bb195_28, phi_bb195_29, tmp372, tmp373, phi_bb195_33, phi_bb195_35, phi_bb195_38, phi_bb195_39, tmp370, tmp371);
  }

  TNode<Object> phi_bb196_16;
  TNode<IntPtrT> phi_bb196_17;
  TNode<BoolT> phi_bb196_18;
  TNode<IntPtrT> phi_bb196_26;
  TNode<IntPtrT> phi_bb196_27;
  TNode<IntPtrT> phi_bb196_28;
  TNode<IntPtrT> phi_bb196_29;
  TNode<IntPtrT> phi_bb196_31;
  TNode<BoolT> phi_bb196_32;
  TNode<BoolT> phi_bb196_33;
  TNode<Int32T> phi_bb196_35;
  TNode<Object> phi_bb196_38;
  TNode<IntPtrT> phi_bb196_39;
  TNode<Object> tmp374;
  TNode<IntPtrT> tmp375;
  TNode<IntPtrT> tmp376;
  TNode<IntPtrT> tmp377;
  TNode<IntPtrT> tmp378;
  TNode<IntPtrT> tmp379;
  TNode<BoolT> tmp380;
  if (block196.is_used()) {
    ca_.Bind(&block196, &phi_bb196_16, &phi_bb196_17, &phi_bb196_18, &phi_bb196_26, &phi_bb196_27, &phi_bb196_28, &phi_bb196_29, &phi_bb196_31, &phi_bb196_32, &phi_bb196_33, &phi_bb196_35, &phi_bb196_38, &phi_bb196_39);
    std::tie(tmp374, tmp375) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb196_29}).Flatten();
    tmp376 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp377 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb196_29}, TNode<IntPtrT>{tmp376});
    tmp378 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp379 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp377}, TNode<IntPtrT>{tmp378});
    tmp380 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block191, phi_bb196_16, phi_bb196_17, phi_bb196_18, phi_bb196_26, phi_bb196_27, phi_bb196_28, tmp379, tmp377, tmp380, phi_bb196_33, phi_bb196_35, phi_bb196_38, phi_bb196_39, tmp374, tmp375);
  }

  TNode<Object> phi_bb191_16;
  TNode<IntPtrT> phi_bb191_17;
  TNode<BoolT> phi_bb191_18;
  TNode<IntPtrT> phi_bb191_26;
  TNode<IntPtrT> phi_bb191_27;
  TNode<IntPtrT> phi_bb191_28;
  TNode<IntPtrT> phi_bb191_29;
  TNode<IntPtrT> phi_bb191_31;
  TNode<BoolT> phi_bb191_32;
  TNode<BoolT> phi_bb191_33;
  TNode<Int32T> phi_bb191_35;
  TNode<Object> phi_bb191_38;
  TNode<IntPtrT> phi_bb191_39;
  TNode<Object> phi_bb191_40;
  TNode<IntPtrT> phi_bb191_41;
  if (block191.is_used()) {
    ca_.Bind(&block191, &phi_bb191_16, &phi_bb191_17, &phi_bb191_18, &phi_bb191_26, &phi_bb191_27, &phi_bb191_28, &phi_bb191_29, &phi_bb191_31, &phi_bb191_32, &phi_bb191_33, &phi_bb191_35, &phi_bb191_38, &phi_bb191_39, &phi_bb191_40, &phi_bb191_41);
    ca_.Goto(&block188, phi_bb191_16, phi_bb191_17, phi_bb191_18, phi_bb191_26, phi_bb191_27, phi_bb191_28, phi_bb191_29, phi_bb191_31, phi_bb191_32, phi_bb191_33, phi_bb191_35, phi_bb191_38, phi_bb191_39, phi_bb191_40, phi_bb191_41);
  }

  TNode<Object> phi_bb188_16;
  TNode<IntPtrT> phi_bb188_17;
  TNode<BoolT> phi_bb188_18;
  TNode<IntPtrT> phi_bb188_26;
  TNode<IntPtrT> phi_bb188_27;
  TNode<IntPtrT> phi_bb188_28;
  TNode<IntPtrT> phi_bb188_29;
  TNode<IntPtrT> phi_bb188_31;
  TNode<BoolT> phi_bb188_32;
  TNode<BoolT> phi_bb188_33;
  TNode<Int32T> phi_bb188_35;
  TNode<Object> phi_bb188_38;
  TNode<IntPtrT> phi_bb188_39;
  TNode<Object> phi_bb188_40;
  TNode<IntPtrT> phi_bb188_41;
  TNode<BigInt> tmp381;
  TNode<UintPtrT> tmp382;
  TNode<UintPtrT> tmp383;
  TNode<IntPtrT> tmp384;
  TNode<IntPtrT> tmp385;
  if (block188.is_used()) {
    ca_.Bind(&block188, &phi_bb188_16, &phi_bb188_17, &phi_bb188_18, &phi_bb188_26, &phi_bb188_27, &phi_bb188_28, &phi_bb188_29, &phi_bb188_31, &phi_bb188_32, &phi_bb188_33, &phi_bb188_35, &phi_bb188_38, &phi_bb188_39, &phi_bb188_40, &phi_bb188_41);
    tmp381 = CodeStubAssembler(state_).ToBigInt(TNode<Context>{p_context}, TNode<Object>{tmp193});
    std::tie(tmp382, tmp383) = CodeStubAssembler(state_).BigIntToRawBytes(TNode<BigInt>{tmp381}).Flatten();
    tmp384 = CodeStubAssembler(state_).Signed(TNode<UintPtrT>{tmp382});
    CodeStubAssembler(state_).StoreReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb188_38, phi_bb188_39}, tmp384);
    tmp385 = CodeStubAssembler(state_).Signed(TNode<UintPtrT>{tmp383});
    CodeStubAssembler(state_).StoreReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb188_40, phi_bb188_41}, tmp385);
    ca_.Goto(&block169, phi_bb188_16, phi_bb188_17, phi_bb188_18, tmp357, phi_bb188_26, phi_bb188_27, phi_bb188_28, phi_bb188_29, phi_bb188_31, phi_bb188_32, phi_bb188_33, phi_bb188_35);
  }

  TNode<Object> phi_bb169_16;
  TNode<IntPtrT> phi_bb169_17;
  TNode<BoolT> phi_bb169_18;
  TNode<IntPtrT> phi_bb169_25;
  TNode<IntPtrT> phi_bb169_26;
  TNode<IntPtrT> phi_bb169_27;
  TNode<IntPtrT> phi_bb169_28;
  TNode<IntPtrT> phi_bb169_29;
  TNode<IntPtrT> phi_bb169_31;
  TNode<BoolT> phi_bb169_32;
  TNode<BoolT> phi_bb169_33;
  TNode<Int32T> phi_bb169_35;
  if (block169.is_used()) {
    ca_.Bind(&block169, &phi_bb169_16, &phi_bb169_17, &phi_bb169_18, &phi_bb169_25, &phi_bb169_26, &phi_bb169_27, &phi_bb169_28, &phi_bb169_29, &phi_bb169_31, &phi_bb169_32, &phi_bb169_33, &phi_bb169_35);
    ca_.Goto(&block166, phi_bb169_16, phi_bb169_17, phi_bb169_18, phi_bb169_25, phi_bb169_26, phi_bb169_27, phi_bb169_28, phi_bb169_29, phi_bb169_31, phi_bb169_32, phi_bb169_33, phi_bb169_35);
  }

  TNode<Object> phi_bb165_16;
  TNode<IntPtrT> phi_bb165_17;
  TNode<BoolT> phi_bb165_18;
  TNode<IntPtrT> phi_bb165_25;
  TNode<IntPtrT> phi_bb165_26;
  TNode<IntPtrT> phi_bb165_27;
  TNode<IntPtrT> phi_bb165_28;
  TNode<IntPtrT> phi_bb165_29;
  TNode<IntPtrT> phi_bb165_31;
  TNode<BoolT> phi_bb165_32;
  TNode<BoolT> phi_bb165_33;
  TNode<Int32T> phi_bb165_35;
  TNode<Int32T> tmp386;
  TNode<Int32T> tmp387;
  TNode<BoolT> tmp388;
  TNode<IntPtrT> tmp389;
  TNode<Object> tmp390;
  if (block165.is_used()) {
    ca_.Bind(&block165, &phi_bb165_16, &phi_bb165_17, &phi_bb165_18, &phi_bb165_25, &phi_bb165_26, &phi_bb165_27, &phi_bb165_28, &phi_bb165_29, &phi_bb165_31, &phi_bb165_32, &phi_bb165_33, &phi_bb165_35);
    tmp386 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmValueKindBitsMask);
    tmp387 = CodeStubAssembler(state_).Word32And(TNode<Int32T>{tmp201}, TNode<Int32T>{tmp386});
    tmp388 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    tmp389 = Convert_intptr_int32_0(state_, TNode<Int32T>{phi_bb165_35});
    tmp390 = JSToWasmObject_0(state_, TNode<NativeContext>{p_context}, TNode<HeapObject>{tmp19}, TNode<Int32T>{tmp201}, TNode<Object>{tmp193});
    CodeStubAssembler(state_).SetArgumentValue(TorqueStructArguments{TNode<RawPtrT>{p_arguments.frame}, TNode<RawPtrT>{p_arguments.base}, TNode<IntPtrT>{p_arguments.length}, TNode<IntPtrT>{p_arguments.actual_count}}, TNode<IntPtrT>{tmp389}, TNode<Object>{tmp390});
    ca_.Goto(&block166, phi_bb165_16, phi_bb165_17, phi_bb165_18, phi_bb165_25, phi_bb165_26, phi_bb165_27, phi_bb165_28, phi_bb165_29, phi_bb165_31, phi_bb165_32, tmp388, phi_bb165_35);
  }

  TNode<Object> phi_bb166_16;
  TNode<IntPtrT> phi_bb166_17;
  TNode<BoolT> phi_bb166_18;
  TNode<IntPtrT> phi_bb166_25;
  TNode<IntPtrT> phi_bb166_26;
  TNode<IntPtrT> phi_bb166_27;
  TNode<IntPtrT> phi_bb166_28;
  TNode<IntPtrT> phi_bb166_29;
  TNode<IntPtrT> phi_bb166_31;
  TNode<BoolT> phi_bb166_32;
  TNode<BoolT> phi_bb166_33;
  TNode<Int32T> phi_bb166_35;
  if (block166.is_used()) {
    ca_.Bind(&block166, &phi_bb166_16, &phi_bb166_17, &phi_bb166_18, &phi_bb166_25, &phi_bb166_26, &phi_bb166_27, &phi_bb166_28, &phi_bb166_29, &phi_bb166_31, &phi_bb166_32, &phi_bb166_33, &phi_bb166_35);
    ca_.Goto(&block151, phi_bb166_16, phi_bb166_17, phi_bb166_18, phi_bb166_25, phi_bb166_26, phi_bb166_27, phi_bb166_28, phi_bb166_29, phi_bb166_31, phi_bb166_32, phi_bb166_33, phi_bb166_35);
  }

  TNode<Object> phi_bb151_16;
  TNode<IntPtrT> phi_bb151_17;
  TNode<BoolT> phi_bb151_18;
  TNode<IntPtrT> phi_bb151_25;
  TNode<IntPtrT> phi_bb151_26;
  TNode<IntPtrT> phi_bb151_27;
  TNode<IntPtrT> phi_bb151_28;
  TNode<IntPtrT> phi_bb151_29;
  TNode<IntPtrT> phi_bb151_31;
  TNode<BoolT> phi_bb151_32;
  TNode<BoolT> phi_bb151_33;
  TNode<Int32T> phi_bb151_35;
  if (block151.is_used()) {
    ca_.Bind(&block151, &phi_bb151_16, &phi_bb151_17, &phi_bb151_18, &phi_bb151_25, &phi_bb151_26, &phi_bb151_27, &phi_bb151_28, &phi_bb151_29, &phi_bb151_31, &phi_bb151_32, &phi_bb151_33, &phi_bb151_35);
    ca_.Goto(&block139, phi_bb151_16, phi_bb151_17, phi_bb151_18, phi_bb151_25, phi_bb151_26, phi_bb151_27, phi_bb151_28, phi_bb151_29, phi_bb151_31, phi_bb151_32, phi_bb151_33, phi_bb151_35);
  }

  TNode<Object> phi_bb139_16;
  TNode<IntPtrT> phi_bb139_17;
  TNode<BoolT> phi_bb139_18;
  TNode<IntPtrT> phi_bb139_25;
  TNode<IntPtrT> phi_bb139_26;
  TNode<IntPtrT> phi_bb139_27;
  TNode<IntPtrT> phi_bb139_28;
  TNode<IntPtrT> phi_bb139_29;
  TNode<IntPtrT> phi_bb139_31;
  TNode<BoolT> phi_bb139_32;
  TNode<BoolT> phi_bb139_33;
  TNode<Int32T> phi_bb139_35;
  if (block139.is_used()) {
    ca_.Bind(&block139, &phi_bb139_16, &phi_bb139_17, &phi_bb139_18, &phi_bb139_25, &phi_bb139_26, &phi_bb139_27, &phi_bb139_28, &phi_bb139_29, &phi_bb139_31, &phi_bb139_32, &phi_bb139_33, &phi_bb139_35);
    ca_.Goto(&block123, phi_bb139_16, phi_bb139_17, phi_bb139_18, phi_bb139_25, phi_bb139_26, phi_bb139_27, phi_bb139_28, phi_bb139_29, phi_bb139_31, phi_bb139_32, phi_bb139_33, phi_bb139_35);
  }

  TNode<Object> phi_bb123_16;
  TNode<IntPtrT> phi_bb123_17;
  TNode<BoolT> phi_bb123_18;
  TNode<IntPtrT> phi_bb123_25;
  TNode<IntPtrT> phi_bb123_26;
  TNode<IntPtrT> phi_bb123_27;
  TNode<IntPtrT> phi_bb123_28;
  TNode<IntPtrT> phi_bb123_29;
  TNode<IntPtrT> phi_bb123_31;
  TNode<BoolT> phi_bb123_32;
  TNode<BoolT> phi_bb123_33;
  TNode<Int32T> phi_bb123_35;
  TNode<Int32T> tmp391;
  TNode<Int32T> tmp392;
  if (block123.is_used()) {
    ca_.Bind(&block123, &phi_bb123_16, &phi_bb123_17, &phi_bb123_18, &phi_bb123_25, &phi_bb123_26, &phi_bb123_27, &phi_bb123_28, &phi_bb123_29, &phi_bb123_31, &phi_bb123_32, &phi_bb123_33, &phi_bb123_35);
    tmp391 = FromConstexpr_int32_constexpr_int31_0(state_, 1);
    tmp392 = CodeStubAssembler(state_).Int32Add(TNode<Int32T>{phi_bb123_35}, TNode<Int32T>{tmp391});
    ca_.Goto(&block118, phi_bb123_16, phi_bb123_17, phi_bb123_18, phi_bb123_25, phi_bb123_26, phi_bb123_27, phi_bb123_28, phi_bb123_29, phi_bb123_31, phi_bb123_32, phi_bb123_33, tmp195, tmp392);
  }

  TNode<Object> phi_bb117_16;
  TNode<IntPtrT> phi_bb117_17;
  TNode<BoolT> phi_bb117_18;
  TNode<IntPtrT> phi_bb117_25;
  TNode<IntPtrT> phi_bb117_26;
  TNode<IntPtrT> phi_bb117_27;
  TNode<IntPtrT> phi_bb117_28;
  TNode<IntPtrT> phi_bb117_29;
  TNode<IntPtrT> phi_bb117_31;
  TNode<BoolT> phi_bb117_32;
  TNode<BoolT> phi_bb117_33;
  TNode<Int32T> phi_bb117_34;
  TNode<Int32T> phi_bb117_35;
  if (block117.is_used()) {
    ca_.Bind(&block117, &phi_bb117_16, &phi_bb117_17, &phi_bb117_18, &phi_bb117_25, &phi_bb117_26, &phi_bb117_27, &phi_bb117_28, &phi_bb117_29, &phi_bb117_31, &phi_bb117_32, &phi_bb117_33, &phi_bb117_34, &phi_bb117_35);
    ca_.Branch(phi_bb117_33, &block204, std::vector<compiler::Node*>{phi_bb117_16, phi_bb117_17, phi_bb117_18, phi_bb117_25, phi_bb117_26, phi_bb117_27, phi_bb117_28, phi_bb117_29, phi_bb117_31, phi_bb117_32, phi_bb117_33, phi_bb117_34}, &block205, std::vector<compiler::Node*>{phi_bb117_16, phi_bb117_17, phi_bb117_18, phi_bb117_25, phi_bb117_26, phi_bb117_27, phi_bb117_28, phi_bb117_29, phi_bb117_31, phi_bb117_32, phi_bb117_33, phi_bb117_34});
  }

  TNode<Object> phi_bb204_16;
  TNode<IntPtrT> phi_bb204_17;
  TNode<BoolT> phi_bb204_18;
  TNode<IntPtrT> phi_bb204_25;
  TNode<IntPtrT> phi_bb204_26;
  TNode<IntPtrT> phi_bb204_27;
  TNode<IntPtrT> phi_bb204_28;
  TNode<IntPtrT> phi_bb204_29;
  TNode<IntPtrT> phi_bb204_31;
  TNode<BoolT> phi_bb204_32;
  TNode<BoolT> phi_bb204_33;
  TNode<Int32T> phi_bb204_34;
  TNode<Int32T> tmp393;
  TNode<Int32T> tmp394;
  TNode<BoolT> tmp395;
  if (block204.is_used()) {
    ca_.Bind(&block204, &phi_bb204_16, &phi_bb204_17, &phi_bb204_18, &phi_bb204_25, &phi_bb204_26, &phi_bb204_27, &phi_bb204_28, &phi_bb204_29, &phi_bb204_31, &phi_bb204_32, &phi_bb204_33, &phi_bb204_34);
    tmp393 = FromConstexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp394 = FromConstexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp395 = CodeStubAssembler(state_).Word32BinaryNot(TNode<BoolT>{phi_bb204_32});
    ca_.Branch(tmp395, &block207, std::vector<compiler::Node*>{phi_bb204_16, phi_bb204_17, phi_bb204_18, phi_bb204_25, phi_bb204_26, phi_bb204_27, phi_bb204_28, phi_bb204_29, phi_bb204_31, phi_bb204_32, phi_bb204_33, phi_bb204_34}, &block208, std::vector<compiler::Node*>{phi_bb204_16, phi_bb204_17, phi_bb204_18, phi_bb204_25, phi_bb204_26, phi_bb204_27, phi_bb204_28, phi_bb204_29, phi_bb204_31, phi_bb204_32, phi_bb204_33, phi_bb204_34});
  }

  TNode<Object> phi_bb207_16;
  TNode<IntPtrT> phi_bb207_17;
  TNode<BoolT> phi_bb207_18;
  TNode<IntPtrT> phi_bb207_25;
  TNode<IntPtrT> phi_bb207_26;
  TNode<IntPtrT> phi_bb207_27;
  TNode<IntPtrT> phi_bb207_28;
  TNode<IntPtrT> phi_bb207_29;
  TNode<IntPtrT> phi_bb207_31;
  TNode<BoolT> phi_bb207_32;
  TNode<BoolT> phi_bb207_33;
  TNode<Int32T> phi_bb207_34;
  TNode<IntPtrT> tmp396;
  if (block207.is_used()) {
    ca_.Bind(&block207, &phi_bb207_16, &phi_bb207_17, &phi_bb207_18, &phi_bb207_25, &phi_bb207_26, &phi_bb207_27, &phi_bb207_28, &phi_bb207_29, &phi_bb207_31, &phi_bb207_32, &phi_bb207_33, &phi_bb207_34);
    tmp396 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    ca_.Goto(&block208, phi_bb207_16, phi_bb207_17, phi_bb207_18, phi_bb207_25, phi_bb207_26, phi_bb207_27, phi_bb207_28, phi_bb207_29, tmp396, phi_bb207_32, phi_bb207_33, phi_bb207_34);
  }

  TNode<Object> phi_bb208_16;
  TNode<IntPtrT> phi_bb208_17;
  TNode<BoolT> phi_bb208_18;
  TNode<IntPtrT> phi_bb208_25;
  TNode<IntPtrT> phi_bb208_26;
  TNode<IntPtrT> phi_bb208_27;
  TNode<IntPtrT> phi_bb208_28;
  TNode<IntPtrT> phi_bb208_29;
  TNode<IntPtrT> phi_bb208_31;
  TNode<BoolT> phi_bb208_32;
  TNode<BoolT> phi_bb208_33;
  TNode<Int32T> phi_bb208_34;
  if (block208.is_used()) {
    ca_.Bind(&block208, &phi_bb208_16, &phi_bb208_17, &phi_bb208_18, &phi_bb208_25, &phi_bb208_26, &phi_bb208_27, &phi_bb208_28, &phi_bb208_29, &phi_bb208_31, &phi_bb208_32, &phi_bb208_33, &phi_bb208_34);
    if ((p_switchStack)) {
      ca_.Goto(&block209, phi_bb208_16, phi_bb208_17, phi_bb208_18, phi_bb208_25, phi_bb208_26, phi_bb208_27, phi_bb208_28, phi_bb208_29, phi_bb208_32, phi_bb208_33, phi_bb208_34);
    } else {
      ca_.Goto(&block210, phi_bb208_16, phi_bb208_17, phi_bb208_18, phi_bb208_25, phi_bb208_26, phi_bb208_27, phi_bb208_28, phi_bb208_29, phi_bb208_32, phi_bb208_33, phi_bb208_34);
    }
  }

  TNode<Object> phi_bb209_16;
  TNode<IntPtrT> phi_bb209_17;
  TNode<BoolT> phi_bb209_18;
  TNode<IntPtrT> phi_bb209_25;
  TNode<IntPtrT> phi_bb209_26;
  TNode<IntPtrT> phi_bb209_27;
  TNode<IntPtrT> phi_bb209_28;
  TNode<IntPtrT> phi_bb209_29;
  TNode<BoolT> phi_bb209_32;
  TNode<BoolT> phi_bb209_33;
  TNode<Int32T> phi_bb209_34;
  TNode<Object> tmp397;
  TNode<IntPtrT> tmp398;
  TNode<IntPtrT> tmp399;
  TNode<IntPtrT> tmp400;
  TNode<BoolT> tmp401;
  if (block209.is_used()) {
    ca_.Bind(&block209, &phi_bb209_16, &phi_bb209_17, &phi_bb209_18, &phi_bb209_25, &phi_bb209_26, &phi_bb209_27, &phi_bb209_28, &phi_bb209_29, &phi_bb209_32, &phi_bb209_33, &phi_bb209_34);
    tmp397 = CodeStubAssembler(state_).CallRuntime(Runtime::kWasmAllocateSuspender, p_context); 
    tmp398 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp399 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb209_25}, TNode<IntPtrT>{tmp398});
    tmp400 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp401 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb209_25}, TNode<IntPtrT>{tmp400});
    ca_.Branch(tmp401, &block213, std::vector<compiler::Node*>{phi_bb209_16, phi_bb209_17, phi_bb209_18, phi_bb209_26, phi_bb209_27, phi_bb209_28, phi_bb209_29, phi_bb209_32, phi_bb209_33, phi_bb209_34}, &block214, std::vector<compiler::Node*>{phi_bb209_16, phi_bb209_17, phi_bb209_18, phi_bb209_26, phi_bb209_27, phi_bb209_28, phi_bb209_29, phi_bb209_32, phi_bb209_33, phi_bb209_34});
  }

  TNode<Object> phi_bb213_16;
  TNode<IntPtrT> phi_bb213_17;
  TNode<BoolT> phi_bb213_18;
  TNode<IntPtrT> phi_bb213_26;
  TNode<IntPtrT> phi_bb213_27;
  TNode<IntPtrT> phi_bb213_28;
  TNode<IntPtrT> phi_bb213_29;
  TNode<BoolT> phi_bb213_32;
  TNode<BoolT> phi_bb213_33;
  TNode<Int32T> phi_bb213_34;
  TNode<Object> tmp402;
  TNode<IntPtrT> tmp403;
  TNode<IntPtrT> tmp404;
  TNode<IntPtrT> tmp405;
  if (block213.is_used()) {
    ca_.Bind(&block213, &phi_bb213_16, &phi_bb213_17, &phi_bb213_18, &phi_bb213_26, &phi_bb213_27, &phi_bb213_28, &phi_bb213_29, &phi_bb213_32, &phi_bb213_33, &phi_bb213_34);
    std::tie(tmp402, tmp403) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb213_27}).Flatten();
    tmp404 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp405 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb213_27}, TNode<IntPtrT>{tmp404});
    ca_.Goto(&block212, phi_bb213_16, phi_bb213_17, phi_bb213_18, phi_bb213_26, tmp405, phi_bb213_28, phi_bb213_29, phi_bb208_31, phi_bb213_32, phi_bb213_33, phi_bb213_34, tmp402, tmp403);
  }

  TNode<Object> phi_bb214_16;
  TNode<IntPtrT> phi_bb214_17;
  TNode<BoolT> phi_bb214_18;
  TNode<IntPtrT> phi_bb214_26;
  TNode<IntPtrT> phi_bb214_27;
  TNode<IntPtrT> phi_bb214_28;
  TNode<IntPtrT> phi_bb214_29;
  TNode<BoolT> phi_bb214_32;
  TNode<BoolT> phi_bb214_33;
  TNode<Int32T> phi_bb214_34;
  if (block214.is_used()) {
    ca_.Bind(&block214, &phi_bb214_16, &phi_bb214_17, &phi_bb214_18, &phi_bb214_26, &phi_bb214_27, &phi_bb214_28, &phi_bb214_29, &phi_bb214_32, &phi_bb214_33, &phi_bb214_34);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block216, phi_bb214_16, phi_bb214_17, phi_bb214_18, phi_bb214_26, phi_bb214_27, phi_bb214_28, phi_bb214_29, phi_bb214_32, phi_bb214_33, phi_bb214_34);
    } else {
      ca_.Goto(&block217, phi_bb214_16, phi_bb214_17, phi_bb214_18, phi_bb214_26, phi_bb214_27, phi_bb214_28, phi_bb214_29, phi_bb214_32, phi_bb214_33, phi_bb214_34);
    }
  }

  TNode<Object> phi_bb216_16;
  TNode<IntPtrT> phi_bb216_17;
  TNode<BoolT> phi_bb216_18;
  TNode<IntPtrT> phi_bb216_26;
  TNode<IntPtrT> phi_bb216_27;
  TNode<IntPtrT> phi_bb216_28;
  TNode<IntPtrT> phi_bb216_29;
  TNode<BoolT> phi_bb216_32;
  TNode<BoolT> phi_bb216_33;
  TNode<Int32T> phi_bb216_34;
  TNode<Object> tmp406;
  TNode<IntPtrT> tmp407;
  TNode<IntPtrT> tmp408;
  TNode<IntPtrT> tmp409;
  if (block216.is_used()) {
    ca_.Bind(&block216, &phi_bb216_16, &phi_bb216_17, &phi_bb216_18, &phi_bb216_26, &phi_bb216_27, &phi_bb216_28, &phi_bb216_29, &phi_bb216_32, &phi_bb216_33, &phi_bb216_34);
    std::tie(tmp406, tmp407) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb216_29}).Flatten();
    tmp408 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp409 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb216_29}, TNode<IntPtrT>{tmp408});
    ca_.Goto(&block215, phi_bb216_16, phi_bb216_17, phi_bb216_18, phi_bb216_26, phi_bb216_27, phi_bb216_28, tmp409, phi_bb208_31, phi_bb216_32, phi_bb216_33, phi_bb216_34, tmp406, tmp407);
  }

  TNode<Object> phi_bb217_16;
  TNode<IntPtrT> phi_bb217_17;
  TNode<BoolT> phi_bb217_18;
  TNode<IntPtrT> phi_bb217_26;
  TNode<IntPtrT> phi_bb217_27;
  TNode<IntPtrT> phi_bb217_28;
  TNode<IntPtrT> phi_bb217_29;
  TNode<BoolT> phi_bb217_32;
  TNode<BoolT> phi_bb217_33;
  TNode<Int32T> phi_bb217_34;
  TNode<IntPtrT> tmp410;
  TNode<BoolT> tmp411;
  if (block217.is_used()) {
    ca_.Bind(&block217, &phi_bb217_16, &phi_bb217_17, &phi_bb217_18, &phi_bb217_26, &phi_bb217_27, &phi_bb217_28, &phi_bb217_29, &phi_bb217_32, &phi_bb217_33, &phi_bb217_34);
    tmp410 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp411 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb208_31}, TNode<IntPtrT>{tmp410});
    ca_.Branch(tmp411, &block219, std::vector<compiler::Node*>{phi_bb217_16, phi_bb217_17, phi_bb217_18, phi_bb217_26, phi_bb217_27, phi_bb217_28, phi_bb217_29, phi_bb217_32, phi_bb217_33, phi_bb217_34}, &block220, std::vector<compiler::Node*>{phi_bb217_16, phi_bb217_17, phi_bb217_18, phi_bb217_26, phi_bb217_27, phi_bb217_28, phi_bb217_29, phi_bb217_32, phi_bb217_33, phi_bb217_34});
  }

  TNode<Object> phi_bb219_16;
  TNode<IntPtrT> phi_bb219_17;
  TNode<BoolT> phi_bb219_18;
  TNode<IntPtrT> phi_bb219_26;
  TNode<IntPtrT> phi_bb219_27;
  TNode<IntPtrT> phi_bb219_28;
  TNode<IntPtrT> phi_bb219_29;
  TNode<BoolT> phi_bb219_32;
  TNode<BoolT> phi_bb219_33;
  TNode<Int32T> phi_bb219_34;
  TNode<Object> tmp412;
  TNode<IntPtrT> tmp413;
  TNode<IntPtrT> tmp414;
  TNode<BoolT> tmp415;
  if (block219.is_used()) {
    ca_.Bind(&block219, &phi_bb219_16, &phi_bb219_17, &phi_bb219_18, &phi_bb219_26, &phi_bb219_27, &phi_bb219_28, &phi_bb219_29, &phi_bb219_32, &phi_bb219_33, &phi_bb219_34);
    std::tie(tmp412, tmp413) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb208_31}).Flatten();
    tmp414 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp415 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block215, phi_bb219_16, phi_bb219_17, phi_bb219_18, phi_bb219_26, phi_bb219_27, phi_bb219_28, phi_bb219_29, tmp414, tmp415, phi_bb219_33, phi_bb219_34, tmp412, tmp413);
  }

  TNode<Object> phi_bb220_16;
  TNode<IntPtrT> phi_bb220_17;
  TNode<BoolT> phi_bb220_18;
  TNode<IntPtrT> phi_bb220_26;
  TNode<IntPtrT> phi_bb220_27;
  TNode<IntPtrT> phi_bb220_28;
  TNode<IntPtrT> phi_bb220_29;
  TNode<BoolT> phi_bb220_32;
  TNode<BoolT> phi_bb220_33;
  TNode<Int32T> phi_bb220_34;
  TNode<Object> tmp416;
  TNode<IntPtrT> tmp417;
  TNode<IntPtrT> tmp418;
  TNode<IntPtrT> tmp419;
  TNode<IntPtrT> tmp420;
  TNode<IntPtrT> tmp421;
  TNode<BoolT> tmp422;
  if (block220.is_used()) {
    ca_.Bind(&block220, &phi_bb220_16, &phi_bb220_17, &phi_bb220_18, &phi_bb220_26, &phi_bb220_27, &phi_bb220_28, &phi_bb220_29, &phi_bb220_32, &phi_bb220_33, &phi_bb220_34);
    std::tie(tmp416, tmp417) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb220_29}).Flatten();
    tmp418 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp419 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb220_29}, TNode<IntPtrT>{tmp418});
    tmp420 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp421 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp419}, TNode<IntPtrT>{tmp420});
    tmp422 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block215, phi_bb220_16, phi_bb220_17, phi_bb220_18, phi_bb220_26, phi_bb220_27, phi_bb220_28, tmp421, tmp419, tmp422, phi_bb220_33, phi_bb220_34, tmp416, tmp417);
  }

  TNode<Object> phi_bb215_16;
  TNode<IntPtrT> phi_bb215_17;
  TNode<BoolT> phi_bb215_18;
  TNode<IntPtrT> phi_bb215_26;
  TNode<IntPtrT> phi_bb215_27;
  TNode<IntPtrT> phi_bb215_28;
  TNode<IntPtrT> phi_bb215_29;
  TNode<IntPtrT> phi_bb215_31;
  TNode<BoolT> phi_bb215_32;
  TNode<BoolT> phi_bb215_33;
  TNode<Int32T> phi_bb215_34;
  TNode<Object> phi_bb215_38;
  TNode<IntPtrT> phi_bb215_39;
  if (block215.is_used()) {
    ca_.Bind(&block215, &phi_bb215_16, &phi_bb215_17, &phi_bb215_18, &phi_bb215_26, &phi_bb215_27, &phi_bb215_28, &phi_bb215_29, &phi_bb215_31, &phi_bb215_32, &phi_bb215_33, &phi_bb215_34, &phi_bb215_38, &phi_bb215_39);
    ca_.Goto(&block212, phi_bb215_16, phi_bb215_17, phi_bb215_18, phi_bb215_26, phi_bb215_27, phi_bb215_28, phi_bb215_29, phi_bb215_31, phi_bb215_32, phi_bb215_33, phi_bb215_34, phi_bb215_38, phi_bb215_39);
  }

  TNode<Object> phi_bb212_16;
  TNode<IntPtrT> phi_bb212_17;
  TNode<BoolT> phi_bb212_18;
  TNode<IntPtrT> phi_bb212_26;
  TNode<IntPtrT> phi_bb212_27;
  TNode<IntPtrT> phi_bb212_28;
  TNode<IntPtrT> phi_bb212_29;
  TNode<IntPtrT> phi_bb212_31;
  TNode<BoolT> phi_bb212_32;
  TNode<BoolT> phi_bb212_33;
  TNode<Int32T> phi_bb212_34;
  TNode<Object> phi_bb212_38;
  TNode<IntPtrT> phi_bb212_39;
  TNode<IntPtrT> tmp423;
  TNode<Int32T> tmp424;
  TNode<Int32T> tmp425;
  if (block212.is_used()) {
    ca_.Bind(&block212, &phi_bb212_16, &phi_bb212_17, &phi_bb212_18, &phi_bb212_26, &phi_bb212_27, &phi_bb212_28, &phi_bb212_29, &phi_bb212_31, &phi_bb212_32, &phi_bb212_33, &phi_bb212_34, &phi_bb212_38, &phi_bb212_39);
    tmp423 = CodeStubAssembler(state_).BitcastTaggedToWord(TNode<Object>{tmp397});
    CodeStubAssembler(state_).StoreReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb212_38, phi_bb212_39}, tmp423);
    tmp424 = FromConstexpr_int32_constexpr_int31_0(state_, 1);
    tmp425 = CodeStubAssembler(state_).Int32Add(TNode<Int32T>{tmp393}, TNode<Int32T>{tmp424});
    ca_.Goto(&block211, phi_bb212_16, phi_bb212_17, phi_bb212_18, tmp399, phi_bb212_26, phi_bb212_27, phi_bb212_28, phi_bb212_29, phi_bb212_31, phi_bb212_32, phi_bb212_33, phi_bb212_34, tmp425);
  }

  TNode<Object> phi_bb210_16;
  TNode<IntPtrT> phi_bb210_17;
  TNode<BoolT> phi_bb210_18;
  TNode<IntPtrT> phi_bb210_25;
  TNode<IntPtrT> phi_bb210_26;
  TNode<IntPtrT> phi_bb210_27;
  TNode<IntPtrT> phi_bb210_28;
  TNode<IntPtrT> phi_bb210_29;
  TNode<BoolT> phi_bb210_32;
  TNode<BoolT> phi_bb210_33;
  TNode<Int32T> phi_bb210_34;
  if (block210.is_used()) {
    ca_.Bind(&block210, &phi_bb210_16, &phi_bb210_17, &phi_bb210_18, &phi_bb210_25, &phi_bb210_26, &phi_bb210_27, &phi_bb210_28, &phi_bb210_29, &phi_bb210_32, &phi_bb210_33, &phi_bb210_34);
    ca_.Goto(&block211, phi_bb210_16, phi_bb210_17, phi_bb210_18, phi_bb210_25, phi_bb210_26, phi_bb210_27, phi_bb210_28, phi_bb210_29, phi_bb208_31, phi_bb210_32, phi_bb210_33, phi_bb210_34, tmp393);
  }

  TNode<Object> phi_bb211_16;
  TNode<IntPtrT> phi_bb211_17;
  TNode<BoolT> phi_bb211_18;
  TNode<IntPtrT> phi_bb211_25;
  TNode<IntPtrT> phi_bb211_26;
  TNode<IntPtrT> phi_bb211_27;
  TNode<IntPtrT> phi_bb211_28;
  TNode<IntPtrT> phi_bb211_29;
  TNode<IntPtrT> phi_bb211_31;
  TNode<BoolT> phi_bb211_32;
  TNode<BoolT> phi_bb211_33;
  TNode<Int32T> phi_bb211_34;
  TNode<Int32T> phi_bb211_35;
  if (block211.is_used()) {
    ca_.Bind(&block211, &phi_bb211_16, &phi_bb211_17, &phi_bb211_18, &phi_bb211_25, &phi_bb211_26, &phi_bb211_27, &phi_bb211_28, &phi_bb211_29, &phi_bb211_31, &phi_bb211_32, &phi_bb211_33, &phi_bb211_34, &phi_bb211_35);
    ca_.Goto(&block223, phi_bb211_16, phi_bb211_17, phi_bb211_18, phi_bb211_25, phi_bb211_26, phi_bb211_27, phi_bb211_28, phi_bb211_29, phi_bb211_31, phi_bb211_32, phi_bb211_33, phi_bb211_34, phi_bb211_35, tmp394);
  }

  TNode<Object> phi_bb223_16;
  TNode<IntPtrT> phi_bb223_17;
  TNode<BoolT> phi_bb223_18;
  TNode<IntPtrT> phi_bb223_25;
  TNode<IntPtrT> phi_bb223_26;
  TNode<IntPtrT> phi_bb223_27;
  TNode<IntPtrT> phi_bb223_28;
  TNode<IntPtrT> phi_bb223_29;
  TNode<IntPtrT> phi_bb223_31;
  TNode<BoolT> phi_bb223_32;
  TNode<BoolT> phi_bb223_33;
  TNode<Int32T> phi_bb223_34;
  TNode<Int32T> phi_bb223_35;
  TNode<Int32T> phi_bb223_36;
  TNode<BoolT> tmp426;
  if (block223.is_used()) {
    ca_.Bind(&block223, &phi_bb223_16, &phi_bb223_17, &phi_bb223_18, &phi_bb223_25, &phi_bb223_26, &phi_bb223_27, &phi_bb223_28, &phi_bb223_29, &phi_bb223_31, &phi_bb223_32, &phi_bb223_33, &phi_bb223_34, &phi_bb223_35, &phi_bb223_36);
    tmp426 = CodeStubAssembler(state_).Int32LessThan(TNode<Int32T>{phi_bb223_35}, TNode<Int32T>{tmp23});
    ca_.Branch(tmp426, &block221, std::vector<compiler::Node*>{phi_bb223_16, phi_bb223_17, phi_bb223_18, phi_bb223_25, phi_bb223_26, phi_bb223_27, phi_bb223_28, phi_bb223_29, phi_bb223_31, phi_bb223_32, phi_bb223_33, phi_bb223_34, phi_bb223_35, phi_bb223_36}, &block222, std::vector<compiler::Node*>{phi_bb223_16, phi_bb223_17, phi_bb223_18, phi_bb223_25, phi_bb223_26, phi_bb223_27, phi_bb223_28, phi_bb223_29, phi_bb223_31, phi_bb223_32, phi_bb223_33, phi_bb223_34, phi_bb223_35, phi_bb223_36});
  }

  TNode<Object> phi_bb221_16;
  TNode<IntPtrT> phi_bb221_17;
  TNode<BoolT> phi_bb221_18;
  TNode<IntPtrT> phi_bb221_25;
  TNode<IntPtrT> phi_bb221_26;
  TNode<IntPtrT> phi_bb221_27;
  TNode<IntPtrT> phi_bb221_28;
  TNode<IntPtrT> phi_bb221_29;
  TNode<IntPtrT> phi_bb221_31;
  TNode<BoolT> phi_bb221_32;
  TNode<BoolT> phi_bb221_33;
  TNode<Int32T> phi_bb221_34;
  TNode<Int32T> phi_bb221_35;
  TNode<Int32T> phi_bb221_36;
  TNode<IntPtrT> tmp427;
  TNode<IntPtrT> tmp428;
  TNode<IntPtrT> tmp429;
  TNode<Object> tmp430;
  TNode<IntPtrT> tmp431;
  TNode<Int32T> tmp432;
  TNode<Int32T> tmp433;
  TNode<Int32T> tmp434;
  TNode<Int32T> tmp435;
  TNode<BoolT> tmp436;
  if (block221.is_used()) {
    ca_.Bind(&block221, &phi_bb221_16, &phi_bb221_17, &phi_bb221_18, &phi_bb221_25, &phi_bb221_26, &phi_bb221_27, &phi_bb221_28, &phi_bb221_29, &phi_bb221_31, &phi_bb221_32, &phi_bb221_33, &phi_bb221_34, &phi_bb221_35, &phi_bb221_36);
    tmp427 = Convert_intptr_int32_0(state_, TNode<Int32T>{phi_bb221_35});
    tmp428 = TimesSizeOf_int32_0(state_, TNode<IntPtrT>{tmp427});
    tmp429 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp150}, TNode<IntPtrT>{tmp428});
    std::tie(tmp430, tmp431) = NewReference_int32_0(state_, TNode<Object>{tmp149}, TNode<IntPtrT>{tmp429}).Flatten();
    tmp432 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp430, tmp431});
    tmp433 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmValueKindBitsMask);
    tmp434 = CodeStubAssembler(state_).Word32And(TNode<Int32T>{tmp432}, TNode<Int32T>{tmp433});
    tmp435 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::ValueKind::kRef);
    tmp436 = CodeStubAssembler(state_).Word32NotEqual(TNode<Int32T>{tmp434}, TNode<Int32T>{tmp435});
    ca_.Branch(tmp436, &block227, std::vector<compiler::Node*>{phi_bb221_16, phi_bb221_17, phi_bb221_18, phi_bb221_25, phi_bb221_26, phi_bb221_27, phi_bb221_28, phi_bb221_29, phi_bb221_31, phi_bb221_32, phi_bb221_33, phi_bb221_34, phi_bb221_35, phi_bb221_36}, &block228, std::vector<compiler::Node*>{phi_bb221_16, phi_bb221_17, phi_bb221_18, phi_bb221_25, phi_bb221_26, phi_bb221_27, phi_bb221_28, phi_bb221_29, phi_bb221_31, phi_bb221_32, phi_bb221_33, phi_bb221_34, phi_bb221_35, phi_bb221_36});
  }

  TNode<Object> phi_bb227_16;
  TNode<IntPtrT> phi_bb227_17;
  TNode<BoolT> phi_bb227_18;
  TNode<IntPtrT> phi_bb227_25;
  TNode<IntPtrT> phi_bb227_26;
  TNode<IntPtrT> phi_bb227_27;
  TNode<IntPtrT> phi_bb227_28;
  TNode<IntPtrT> phi_bb227_29;
  TNode<IntPtrT> phi_bb227_31;
  TNode<BoolT> phi_bb227_32;
  TNode<BoolT> phi_bb227_33;
  TNode<Int32T> phi_bb227_34;
  TNode<Int32T> phi_bb227_35;
  TNode<Int32T> phi_bb227_36;
  TNode<Int32T> tmp437;
  TNode<BoolT> tmp438;
  if (block227.is_used()) {
    ca_.Bind(&block227, &phi_bb227_16, &phi_bb227_17, &phi_bb227_18, &phi_bb227_25, &phi_bb227_26, &phi_bb227_27, &phi_bb227_28, &phi_bb227_29, &phi_bb227_31, &phi_bb227_32, &phi_bb227_33, &phi_bb227_34, &phi_bb227_35, &phi_bb227_36);
    tmp437 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::ValueKind::kRefNull);
    tmp438 = CodeStubAssembler(state_).Word32NotEqual(TNode<Int32T>{tmp434}, TNode<Int32T>{tmp437});
    ca_.Goto(&block229, phi_bb227_16, phi_bb227_17, phi_bb227_18, phi_bb227_25, phi_bb227_26, phi_bb227_27, phi_bb227_28, phi_bb227_29, phi_bb227_31, phi_bb227_32, phi_bb227_33, phi_bb227_34, phi_bb227_35, phi_bb227_36, tmp438);
  }

  TNode<Object> phi_bb228_16;
  TNode<IntPtrT> phi_bb228_17;
  TNode<BoolT> phi_bb228_18;
  TNode<IntPtrT> phi_bb228_25;
  TNode<IntPtrT> phi_bb228_26;
  TNode<IntPtrT> phi_bb228_27;
  TNode<IntPtrT> phi_bb228_28;
  TNode<IntPtrT> phi_bb228_29;
  TNode<IntPtrT> phi_bb228_31;
  TNode<BoolT> phi_bb228_32;
  TNode<BoolT> phi_bb228_33;
  TNode<Int32T> phi_bb228_34;
  TNode<Int32T> phi_bb228_35;
  TNode<Int32T> phi_bb228_36;
  TNode<BoolT> tmp439;
  if (block228.is_used()) {
    ca_.Bind(&block228, &phi_bb228_16, &phi_bb228_17, &phi_bb228_18, &phi_bb228_25, &phi_bb228_26, &phi_bb228_27, &phi_bb228_28, &phi_bb228_29, &phi_bb228_31, &phi_bb228_32, &phi_bb228_33, &phi_bb228_34, &phi_bb228_35, &phi_bb228_36);
    tmp439 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block229, phi_bb228_16, phi_bb228_17, phi_bb228_18, phi_bb228_25, phi_bb228_26, phi_bb228_27, phi_bb228_28, phi_bb228_29, phi_bb228_31, phi_bb228_32, phi_bb228_33, phi_bb228_34, phi_bb228_35, phi_bb228_36, tmp439);
  }

  TNode<Object> phi_bb229_16;
  TNode<IntPtrT> phi_bb229_17;
  TNode<BoolT> phi_bb229_18;
  TNode<IntPtrT> phi_bb229_25;
  TNode<IntPtrT> phi_bb229_26;
  TNode<IntPtrT> phi_bb229_27;
  TNode<IntPtrT> phi_bb229_28;
  TNode<IntPtrT> phi_bb229_29;
  TNode<IntPtrT> phi_bb229_31;
  TNode<BoolT> phi_bb229_32;
  TNode<BoolT> phi_bb229_33;
  TNode<Int32T> phi_bb229_34;
  TNode<Int32T> phi_bb229_35;
  TNode<Int32T> phi_bb229_36;
  TNode<BoolT> phi_bb229_40;
  if (block229.is_used()) {
    ca_.Bind(&block229, &phi_bb229_16, &phi_bb229_17, &phi_bb229_18, &phi_bb229_25, &phi_bb229_26, &phi_bb229_27, &phi_bb229_28, &phi_bb229_29, &phi_bb229_31, &phi_bb229_32, &phi_bb229_33, &phi_bb229_34, &phi_bb229_35, &phi_bb229_36, &phi_bb229_40);
    ca_.Branch(phi_bb229_40, &block225, std::vector<compiler::Node*>{phi_bb229_16, phi_bb229_17, phi_bb229_18, phi_bb229_25, phi_bb229_26, phi_bb229_27, phi_bb229_28, phi_bb229_29, phi_bb229_31, phi_bb229_32, phi_bb229_33, phi_bb229_34, phi_bb229_35, phi_bb229_36}, &block226, std::vector<compiler::Node*>{phi_bb229_16, phi_bb229_17, phi_bb229_18, phi_bb229_25, phi_bb229_26, phi_bb229_27, phi_bb229_28, phi_bb229_29, phi_bb229_31, phi_bb229_32, phi_bb229_33, phi_bb229_34, phi_bb229_35, phi_bb229_36});
  }

  TNode<Object> phi_bb225_16;
  TNode<IntPtrT> phi_bb225_17;
  TNode<BoolT> phi_bb225_18;
  TNode<IntPtrT> phi_bb225_25;
  TNode<IntPtrT> phi_bb225_26;
  TNode<IntPtrT> phi_bb225_27;
  TNode<IntPtrT> phi_bb225_28;
  TNode<IntPtrT> phi_bb225_29;
  TNode<IntPtrT> phi_bb225_31;
  TNode<BoolT> phi_bb225_32;
  TNode<BoolT> phi_bb225_33;
  TNode<Int32T> phi_bb225_34;
  TNode<Int32T> phi_bb225_35;
  TNode<Int32T> phi_bb225_36;
  TNode<Int32T> tmp440;
  TNode<Int32T> tmp441;
  TNode<Int32T> tmp442;
  TNode<Int32T> tmp443;
  if (block225.is_used()) {
    ca_.Bind(&block225, &phi_bb225_16, &phi_bb225_17, &phi_bb225_18, &phi_bb225_25, &phi_bb225_26, &phi_bb225_27, &phi_bb225_28, &phi_bb225_29, &phi_bb225_31, &phi_bb225_32, &phi_bb225_33, &phi_bb225_34, &phi_bb225_35, &phi_bb225_36);
    tmp440 = FromConstexpr_int32_constexpr_int31_0(state_, 1);
    tmp441 = CodeStubAssembler(state_).Int32Add(TNode<Int32T>{phi_bb225_35}, TNode<Int32T>{tmp440});
    tmp442 = FromConstexpr_int32_constexpr_int31_0(state_, 1);
    tmp443 = CodeStubAssembler(state_).Int32Add(TNode<Int32T>{phi_bb225_36}, TNode<Int32T>{tmp442});
    ca_.Goto(&block223, phi_bb225_16, phi_bb225_17, phi_bb225_18, phi_bb225_25, phi_bb225_26, phi_bb225_27, phi_bb225_28, phi_bb225_29, phi_bb225_31, phi_bb225_32, phi_bb225_33, phi_bb225_34, tmp441, tmp443);
  }

  TNode<Object> phi_bb226_16;
  TNode<IntPtrT> phi_bb226_17;
  TNode<BoolT> phi_bb226_18;
  TNode<IntPtrT> phi_bb226_25;
  TNode<IntPtrT> phi_bb226_26;
  TNode<IntPtrT> phi_bb226_27;
  TNode<IntPtrT> phi_bb226_28;
  TNode<IntPtrT> phi_bb226_29;
  TNode<IntPtrT> phi_bb226_31;
  TNode<BoolT> phi_bb226_32;
  TNode<BoolT> phi_bb226_33;
  TNode<Int32T> phi_bb226_34;
  TNode<Int32T> phi_bb226_35;
  TNode<Int32T> phi_bb226_36;
  TNode<Int32T> tmp444;
  TNode<Int32T> tmp445;
  TNode<IntPtrT> tmp446;
  TNode<Object> tmp447;
  TNode<IntPtrT> tmp448;
  TNode<IntPtrT> tmp449;
  TNode<IntPtrT> tmp450;
  TNode<BoolT> tmp451;
  if (block226.is_used()) {
    ca_.Bind(&block226, &phi_bb226_16, &phi_bb226_17, &phi_bb226_18, &phi_bb226_25, &phi_bb226_26, &phi_bb226_27, &phi_bb226_28, &phi_bb226_29, &phi_bb226_31, &phi_bb226_32, &phi_bb226_33, &phi_bb226_34, &phi_bb226_35, &phi_bb226_36);
    tmp444 = FromConstexpr_int32_constexpr_int31_0(state_, 1);
    tmp445 = CodeStubAssembler(state_).Int32Add(TNode<Int32T>{phi_bb226_36}, TNode<Int32T>{tmp444});
    tmp446 = Convert_intptr_int32_0(state_, TNode<Int32T>{phi_bb226_36});
    tmp447 = CodeStubAssembler(state_).GetArgumentValue(TorqueStructArguments{TNode<RawPtrT>{p_arguments.frame}, TNode<RawPtrT>{p_arguments.base}, TNode<IntPtrT>{p_arguments.length}, TNode<IntPtrT>{p_arguments.actual_count}}, TNode<IntPtrT>{tmp446});
    tmp448 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp449 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb226_25}, TNode<IntPtrT>{tmp448});
    tmp450 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp451 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb226_25}, TNode<IntPtrT>{tmp450});
    ca_.Branch(tmp451, &block231, std::vector<compiler::Node*>{phi_bb226_16, phi_bb226_17, phi_bb226_18, phi_bb226_26, phi_bb226_27, phi_bb226_28, phi_bb226_29, phi_bb226_31, phi_bb226_32, phi_bb226_33, phi_bb226_34, phi_bb226_35}, &block232, std::vector<compiler::Node*>{phi_bb226_16, phi_bb226_17, phi_bb226_18, phi_bb226_26, phi_bb226_27, phi_bb226_28, phi_bb226_29, phi_bb226_31, phi_bb226_32, phi_bb226_33, phi_bb226_34, phi_bb226_35});
  }

  TNode<Object> phi_bb231_16;
  TNode<IntPtrT> phi_bb231_17;
  TNode<BoolT> phi_bb231_18;
  TNode<IntPtrT> phi_bb231_26;
  TNode<IntPtrT> phi_bb231_27;
  TNode<IntPtrT> phi_bb231_28;
  TNode<IntPtrT> phi_bb231_29;
  TNode<IntPtrT> phi_bb231_31;
  TNode<BoolT> phi_bb231_32;
  TNode<BoolT> phi_bb231_33;
  TNode<Int32T> phi_bb231_34;
  TNode<Int32T> phi_bb231_35;
  TNode<Object> tmp452;
  TNode<IntPtrT> tmp453;
  TNode<IntPtrT> tmp454;
  TNode<IntPtrT> tmp455;
  if (block231.is_used()) {
    ca_.Bind(&block231, &phi_bb231_16, &phi_bb231_17, &phi_bb231_18, &phi_bb231_26, &phi_bb231_27, &phi_bb231_28, &phi_bb231_29, &phi_bb231_31, &phi_bb231_32, &phi_bb231_33, &phi_bb231_34, &phi_bb231_35);
    std::tie(tmp452, tmp453) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb231_27}).Flatten();
    tmp454 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp455 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb231_27}, TNode<IntPtrT>{tmp454});
    ca_.Goto(&block230, phi_bb231_16, phi_bb231_17, phi_bb231_18, phi_bb231_26, tmp455, phi_bb231_28, phi_bb231_29, phi_bb231_31, phi_bb231_32, phi_bb231_33, phi_bb231_34, phi_bb231_35, tmp452, tmp453);
  }

  TNode<Object> phi_bb232_16;
  TNode<IntPtrT> phi_bb232_17;
  TNode<BoolT> phi_bb232_18;
  TNode<IntPtrT> phi_bb232_26;
  TNode<IntPtrT> phi_bb232_27;
  TNode<IntPtrT> phi_bb232_28;
  TNode<IntPtrT> phi_bb232_29;
  TNode<IntPtrT> phi_bb232_31;
  TNode<BoolT> phi_bb232_32;
  TNode<BoolT> phi_bb232_33;
  TNode<Int32T> phi_bb232_34;
  TNode<Int32T> phi_bb232_35;
  if (block232.is_used()) {
    ca_.Bind(&block232, &phi_bb232_16, &phi_bb232_17, &phi_bb232_18, &phi_bb232_26, &phi_bb232_27, &phi_bb232_28, &phi_bb232_29, &phi_bb232_31, &phi_bb232_32, &phi_bb232_33, &phi_bb232_34, &phi_bb232_35);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block234, phi_bb232_16, phi_bb232_17, phi_bb232_18, phi_bb232_26, phi_bb232_27, phi_bb232_28, phi_bb232_29, phi_bb232_31, phi_bb232_32, phi_bb232_33, phi_bb232_34, phi_bb232_35);
    } else {
      ca_.Goto(&block235, phi_bb232_16, phi_bb232_17, phi_bb232_18, phi_bb232_26, phi_bb232_27, phi_bb232_28, phi_bb232_29, phi_bb232_31, phi_bb232_32, phi_bb232_33, phi_bb232_34, phi_bb232_35);
    }
  }

  TNode<Object> phi_bb234_16;
  TNode<IntPtrT> phi_bb234_17;
  TNode<BoolT> phi_bb234_18;
  TNode<IntPtrT> phi_bb234_26;
  TNode<IntPtrT> phi_bb234_27;
  TNode<IntPtrT> phi_bb234_28;
  TNode<IntPtrT> phi_bb234_29;
  TNode<IntPtrT> phi_bb234_31;
  TNode<BoolT> phi_bb234_32;
  TNode<BoolT> phi_bb234_33;
  TNode<Int32T> phi_bb234_34;
  TNode<Int32T> phi_bb234_35;
  TNode<Object> tmp456;
  TNode<IntPtrT> tmp457;
  TNode<IntPtrT> tmp458;
  TNode<IntPtrT> tmp459;
  if (block234.is_used()) {
    ca_.Bind(&block234, &phi_bb234_16, &phi_bb234_17, &phi_bb234_18, &phi_bb234_26, &phi_bb234_27, &phi_bb234_28, &phi_bb234_29, &phi_bb234_31, &phi_bb234_32, &phi_bb234_33, &phi_bb234_34, &phi_bb234_35);
    std::tie(tmp456, tmp457) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb234_29}).Flatten();
    tmp458 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp459 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb234_29}, TNode<IntPtrT>{tmp458});
    ca_.Goto(&block233, phi_bb234_16, phi_bb234_17, phi_bb234_18, phi_bb234_26, phi_bb234_27, phi_bb234_28, tmp459, phi_bb234_31, phi_bb234_32, phi_bb234_33, phi_bb234_34, phi_bb234_35, tmp456, tmp457);
  }

  TNode<Object> phi_bb235_16;
  TNode<IntPtrT> phi_bb235_17;
  TNode<BoolT> phi_bb235_18;
  TNode<IntPtrT> phi_bb235_26;
  TNode<IntPtrT> phi_bb235_27;
  TNode<IntPtrT> phi_bb235_28;
  TNode<IntPtrT> phi_bb235_29;
  TNode<IntPtrT> phi_bb235_31;
  TNode<BoolT> phi_bb235_32;
  TNode<BoolT> phi_bb235_33;
  TNode<Int32T> phi_bb235_34;
  TNode<Int32T> phi_bb235_35;
  TNode<IntPtrT> tmp460;
  TNode<BoolT> tmp461;
  if (block235.is_used()) {
    ca_.Bind(&block235, &phi_bb235_16, &phi_bb235_17, &phi_bb235_18, &phi_bb235_26, &phi_bb235_27, &phi_bb235_28, &phi_bb235_29, &phi_bb235_31, &phi_bb235_32, &phi_bb235_33, &phi_bb235_34, &phi_bb235_35);
    tmp460 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp461 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb235_31}, TNode<IntPtrT>{tmp460});
    ca_.Branch(tmp461, &block237, std::vector<compiler::Node*>{phi_bb235_16, phi_bb235_17, phi_bb235_18, phi_bb235_26, phi_bb235_27, phi_bb235_28, phi_bb235_29, phi_bb235_31, phi_bb235_32, phi_bb235_33, phi_bb235_34, phi_bb235_35}, &block238, std::vector<compiler::Node*>{phi_bb235_16, phi_bb235_17, phi_bb235_18, phi_bb235_26, phi_bb235_27, phi_bb235_28, phi_bb235_29, phi_bb235_31, phi_bb235_32, phi_bb235_33, phi_bb235_34, phi_bb235_35});
  }

  TNode<Object> phi_bb237_16;
  TNode<IntPtrT> phi_bb237_17;
  TNode<BoolT> phi_bb237_18;
  TNode<IntPtrT> phi_bb237_26;
  TNode<IntPtrT> phi_bb237_27;
  TNode<IntPtrT> phi_bb237_28;
  TNode<IntPtrT> phi_bb237_29;
  TNode<IntPtrT> phi_bb237_31;
  TNode<BoolT> phi_bb237_32;
  TNode<BoolT> phi_bb237_33;
  TNode<Int32T> phi_bb237_34;
  TNode<Int32T> phi_bb237_35;
  TNode<Object> tmp462;
  TNode<IntPtrT> tmp463;
  TNode<IntPtrT> tmp464;
  TNode<BoolT> tmp465;
  if (block237.is_used()) {
    ca_.Bind(&block237, &phi_bb237_16, &phi_bb237_17, &phi_bb237_18, &phi_bb237_26, &phi_bb237_27, &phi_bb237_28, &phi_bb237_29, &phi_bb237_31, &phi_bb237_32, &phi_bb237_33, &phi_bb237_34, &phi_bb237_35);
    std::tie(tmp462, tmp463) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb237_31}).Flatten();
    tmp464 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp465 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block233, phi_bb237_16, phi_bb237_17, phi_bb237_18, phi_bb237_26, phi_bb237_27, phi_bb237_28, phi_bb237_29, tmp464, tmp465, phi_bb237_33, phi_bb237_34, phi_bb237_35, tmp462, tmp463);
  }

  TNode<Object> phi_bb238_16;
  TNode<IntPtrT> phi_bb238_17;
  TNode<BoolT> phi_bb238_18;
  TNode<IntPtrT> phi_bb238_26;
  TNode<IntPtrT> phi_bb238_27;
  TNode<IntPtrT> phi_bb238_28;
  TNode<IntPtrT> phi_bb238_29;
  TNode<IntPtrT> phi_bb238_31;
  TNode<BoolT> phi_bb238_32;
  TNode<BoolT> phi_bb238_33;
  TNode<Int32T> phi_bb238_34;
  TNode<Int32T> phi_bb238_35;
  TNode<Object> tmp466;
  TNode<IntPtrT> tmp467;
  TNode<IntPtrT> tmp468;
  TNode<IntPtrT> tmp469;
  TNode<IntPtrT> tmp470;
  TNode<IntPtrT> tmp471;
  TNode<BoolT> tmp472;
  if (block238.is_used()) {
    ca_.Bind(&block238, &phi_bb238_16, &phi_bb238_17, &phi_bb238_18, &phi_bb238_26, &phi_bb238_27, &phi_bb238_28, &phi_bb238_29, &phi_bb238_31, &phi_bb238_32, &phi_bb238_33, &phi_bb238_34, &phi_bb238_35);
    std::tie(tmp466, tmp467) = NewReference_intptr_0(state_, TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb238_29}).Flatten();
    tmp468 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp469 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb238_29}, TNode<IntPtrT>{tmp468});
    tmp470 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp471 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp469}, TNode<IntPtrT>{tmp470});
    tmp472 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block233, phi_bb238_16, phi_bb238_17, phi_bb238_18, phi_bb238_26, phi_bb238_27, phi_bb238_28, tmp471, tmp469, tmp472, phi_bb238_33, phi_bb238_34, phi_bb238_35, tmp466, tmp467);
  }

  TNode<Object> phi_bb233_16;
  TNode<IntPtrT> phi_bb233_17;
  TNode<BoolT> phi_bb233_18;
  TNode<IntPtrT> phi_bb233_26;
  TNode<IntPtrT> phi_bb233_27;
  TNode<IntPtrT> phi_bb233_28;
  TNode<IntPtrT> phi_bb233_29;
  TNode<IntPtrT> phi_bb233_31;
  TNode<BoolT> phi_bb233_32;
  TNode<BoolT> phi_bb233_33;
  TNode<Int32T> phi_bb233_34;
  TNode<Int32T> phi_bb233_35;
  TNode<Object> phi_bb233_40;
  TNode<IntPtrT> phi_bb233_41;
  if (block233.is_used()) {
    ca_.Bind(&block233, &phi_bb233_16, &phi_bb233_17, &phi_bb233_18, &phi_bb233_26, &phi_bb233_27, &phi_bb233_28, &phi_bb233_29, &phi_bb233_31, &phi_bb233_32, &phi_bb233_33, &phi_bb233_34, &phi_bb233_35, &phi_bb233_40, &phi_bb233_41);
    ca_.Goto(&block230, phi_bb233_16, phi_bb233_17, phi_bb233_18, phi_bb233_26, phi_bb233_27, phi_bb233_28, phi_bb233_29, phi_bb233_31, phi_bb233_32, phi_bb233_33, phi_bb233_34, phi_bb233_35, phi_bb233_40, phi_bb233_41);
  }

  TNode<Object> phi_bb230_16;
  TNode<IntPtrT> phi_bb230_17;
  TNode<BoolT> phi_bb230_18;
  TNode<IntPtrT> phi_bb230_26;
  TNode<IntPtrT> phi_bb230_27;
  TNode<IntPtrT> phi_bb230_28;
  TNode<IntPtrT> phi_bb230_29;
  TNode<IntPtrT> phi_bb230_31;
  TNode<BoolT> phi_bb230_32;
  TNode<BoolT> phi_bb230_33;
  TNode<Int32T> phi_bb230_34;
  TNode<Int32T> phi_bb230_35;
  TNode<Object> phi_bb230_40;
  TNode<IntPtrT> phi_bb230_41;
  TNode<IntPtrT> tmp473;
  TNode<Int32T> tmp474;
  TNode<Int32T> tmp475;
  if (block230.is_used()) {
    ca_.Bind(&block230, &phi_bb230_16, &phi_bb230_17, &phi_bb230_18, &phi_bb230_26, &phi_bb230_27, &phi_bb230_28, &phi_bb230_29, &phi_bb230_31, &phi_bb230_32, &phi_bb230_33, &phi_bb230_34, &phi_bb230_35, &phi_bb230_40, &phi_bb230_41);
    tmp473 = CodeStubAssembler(state_).BitcastTaggedToWord(TNode<Object>{tmp447});
    CodeStubAssembler(state_).StoreReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb230_40, phi_bb230_41}, tmp473);
    tmp474 = FromConstexpr_int32_constexpr_int31_0(state_, 1);
    tmp475 = CodeStubAssembler(state_).Int32Add(TNode<Int32T>{phi_bb230_35}, TNode<Int32T>{tmp474});
    ca_.Goto(&block223, phi_bb230_16, phi_bb230_17, phi_bb230_18, tmp449, phi_bb230_26, phi_bb230_27, phi_bb230_28, phi_bb230_29, phi_bb230_31, phi_bb230_32, phi_bb230_33, phi_bb230_34, tmp475, tmp445);
  }

  TNode<Object> phi_bb222_16;
  TNode<IntPtrT> phi_bb222_17;
  TNode<BoolT> phi_bb222_18;
  TNode<IntPtrT> phi_bb222_25;
  TNode<IntPtrT> phi_bb222_26;
  TNode<IntPtrT> phi_bb222_27;
  TNode<IntPtrT> phi_bb222_28;
  TNode<IntPtrT> phi_bb222_29;
  TNode<IntPtrT> phi_bb222_31;
  TNode<BoolT> phi_bb222_32;
  TNode<BoolT> phi_bb222_33;
  TNode<Int32T> phi_bb222_34;
  TNode<Int32T> phi_bb222_35;
  TNode<Int32T> phi_bb222_36;
  if (block222.is_used()) {
    ca_.Bind(&block222, &phi_bb222_16, &phi_bb222_17, &phi_bb222_18, &phi_bb222_25, &phi_bb222_26, &phi_bb222_27, &phi_bb222_28, &phi_bb222_29, &phi_bb222_31, &phi_bb222_32, &phi_bb222_33, &phi_bb222_34, &phi_bb222_35, &phi_bb222_36);
    ca_.Goto(&block205, phi_bb222_16, phi_bb222_17, phi_bb222_18, phi_bb222_25, phi_bb222_26, phi_bb222_27, phi_bb222_28, phi_bb222_29, phi_bb222_31, phi_bb222_32, phi_bb222_33, phi_bb222_34);
  }

  TNode<Object> phi_bb205_16;
  TNode<IntPtrT> phi_bb205_17;
  TNode<BoolT> phi_bb205_18;
  TNode<IntPtrT> phi_bb205_25;
  TNode<IntPtrT> phi_bb205_26;
  TNode<IntPtrT> phi_bb205_27;
  TNode<IntPtrT> phi_bb205_28;
  TNode<IntPtrT> phi_bb205_29;
  TNode<IntPtrT> phi_bb205_31;
  TNode<BoolT> phi_bb205_32;
  TNode<BoolT> phi_bb205_33;
  TNode<Int32T> phi_bb205_34;
  TNode<RawPtrT> tmp476;
  TNode<RawPtrT> tmp477;
  if (block205.is_used()) {
    ca_.Bind(&block205, &phi_bb205_16, &phi_bb205_17, &phi_bb205_18, &phi_bb205_25, &phi_bb205_26, &phi_bb205_27, &phi_bb205_28, &phi_bb205_29, &phi_bb205_31, &phi_bb205_32, &phi_bb205_33, &phi_bb205_34);
    tmp476 = CodeStubAssembler(state_).GCUnsafeReferenceToRawPtr(TNode<Object>{phi_bb112_22}, TNode<IntPtrT>{phi_bb112_23});
    tmp477 = (TNode<RawPtrT>{tmp476});
    ca_.Branch(phi_bb205_32, &block241, std::vector<compiler::Node*>{phi_bb205_16, phi_bb205_17, phi_bb205_18, phi_bb205_25, phi_bb205_26, phi_bb205_27, phi_bb205_28, phi_bb205_29, phi_bb205_31, phi_bb205_32, phi_bb205_33, phi_bb205_34, phi_bb205_29}, &block242, std::vector<compiler::Node*>{phi_bb205_16, phi_bb205_17, phi_bb205_18, phi_bb205_25, phi_bb205_26, phi_bb205_27, phi_bb205_28, phi_bb205_29, phi_bb205_31, phi_bb205_32, phi_bb205_33, phi_bb205_34, phi_bb205_29});
  }

  TNode<Object> phi_bb241_16;
  TNode<IntPtrT> phi_bb241_17;
  TNode<BoolT> phi_bb241_18;
  TNode<IntPtrT> phi_bb241_25;
  TNode<IntPtrT> phi_bb241_26;
  TNode<IntPtrT> phi_bb241_27;
  TNode<IntPtrT> phi_bb241_28;
  TNode<IntPtrT> phi_bb241_29;
  TNode<IntPtrT> phi_bb241_31;
  TNode<BoolT> phi_bb241_32;
  TNode<BoolT> phi_bb241_33;
  TNode<Int32T> phi_bb241_34;
  TNode<IntPtrT> phi_bb241_36;
  TNode<IntPtrT> tmp478;
  TNode<IntPtrT> tmp479;
  if (block241.is_used()) {
    ca_.Bind(&block241, &phi_bb241_16, &phi_bb241_17, &phi_bb241_18, &phi_bb241_25, &phi_bb241_26, &phi_bb241_27, &phi_bb241_28, &phi_bb241_29, &phi_bb241_31, &phi_bb241_32, &phi_bb241_33, &phi_bb241_34, &phi_bb241_36);
    tmp478 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp479 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb241_36}, TNode<IntPtrT>{tmp478});
    ca_.Goto(&block242, phi_bb241_16, phi_bb241_17, phi_bb241_18, phi_bb241_25, phi_bb241_26, phi_bb241_27, phi_bb241_28, phi_bb241_29, phi_bb241_31, phi_bb241_32, phi_bb241_33, phi_bb241_34, tmp479);
  }

  TNode<Object> phi_bb242_16;
  TNode<IntPtrT> phi_bb242_17;
  TNode<BoolT> phi_bb242_18;
  TNode<IntPtrT> phi_bb242_25;
  TNode<IntPtrT> phi_bb242_26;
  TNode<IntPtrT> phi_bb242_27;
  TNode<IntPtrT> phi_bb242_28;
  TNode<IntPtrT> phi_bb242_29;
  TNode<IntPtrT> phi_bb242_31;
  TNode<BoolT> phi_bb242_32;
  TNode<BoolT> phi_bb242_33;
  TNode<Int32T> phi_bb242_34;
  TNode<IntPtrT> phi_bb242_36;
  TNode<RawPtrT> tmp480;
  TNode<IntPtrT> tmp481;
  TNode<WasmInternalFunction> tmp482;
  TNode<RawPtrT> tmp483;
  TNode<RawPtrT> tmp484;
  TNode<RawPtrT> tmp485;
  TNode<IntPtrT> tmp486;
  TNode<Object> tmp487;
  TNode<IntPtrT> tmp488;
  TNode<IntPtrT> tmp489;
  TNode<Object> tmp490;
  TNode<IntPtrT> tmp491;
  TNode<IntPtrT> tmp492;
  TNode<Object> tmp493;
  TNode<IntPtrT> tmp494;
  TNode<IntPtrT> tmp495;
  TNode<Object> tmp496;
  TNode<IntPtrT> tmp497;
  TNode<IntPtrT> tmp498;
  TNode<Object> tmp499;
  TNode<IntPtrT> tmp500;
  TNode<IntPtrT> tmp501;
  TNode<Object> tmp502;
  TNode<IntPtrT> tmp503;
  TNode<IntPtrT> tmp504;
  TNode<Object> tmp505;
  TNode<IntPtrT> tmp506;
  if (block242.is_used()) {
    ca_.Bind(&block242, &phi_bb242_16, &phi_bb242_17, &phi_bb242_18, &phi_bb242_25, &phi_bb242_26, &phi_bb242_27, &phi_bb242_28, &phi_bb242_29, &phi_bb242_31, &phi_bb242_32, &phi_bb242_33, &phi_bb242_34, &phi_bb242_36);
    tmp480 = CodeStubAssembler(state_).GCUnsafeReferenceToRawPtr(TNode<Object>{tmp176}, TNode<IntPtrT>{phi_bb242_36});
    tmp481 = FromConstexpr_intptr_constexpr_int31_0(state_, 16);
    tmp482 = CodeStubAssembler(state_).LoadReference<WasmInternalFunction>(CodeStubAssembler::Reference{tmp4, tmp481});
    tmp483 = CodeStubAssembler(state_).LoadWasmInternalFunctionCallTargetPtr(TNode<WasmInternalFunction>{tmp482});
    tmp484 = CodeStubAssembler(state_).StackSlotPtr(JSToWasmWrapperFrameConstants::kWrapperBufferSize, (SizeOf_intptr_0(state_)));
    tmp485 = (TNode<RawPtrT>{tmp484});
    tmp486 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferReturnCount);
    std::tie(tmp487, tmp488) = GetRefAt_int32_RawPtr_intptr_0(state_, TNode<RawPtrT>{tmp485}, TNode<IntPtrT>{tmp486}).Flatten();
    CodeStubAssembler(state_).StoreReference<Int32T>(CodeStubAssembler::Reference{tmp487, tmp488}, tmp27);
    tmp489 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferRefReturnCount);
    std::tie(tmp490, tmp491) = GetRefAt_bool_RawPtr_intptr_0(state_, TNode<RawPtrT>{tmp485}, TNode<IntPtrT>{tmp489}).Flatten();
    CodeStubAssembler(state_).StoreReference<BoolT>(CodeStubAssembler::Reference{tmp490, tmp491}, phi_bb242_18);
    tmp492 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferSigRepresentationArray);
    std::tie(tmp493, tmp494) = GetRefAt_RawPtr_RawPtr_intptr_0(state_, TNode<RawPtrT>{tmp485}, TNode<IntPtrT>{tmp492}).Flatten();
    CodeStubAssembler(state_).StoreReference<RawPtrT>(CodeStubAssembler::Reference{tmp493, tmp494}, tmp31);
    tmp495 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferStackReturnBufferSize);
    std::tie(tmp496, tmp497) = GetRefAt_intptr_RawPtr_intptr_0(state_, TNode<RawPtrT>{tmp485}, TNode<IntPtrT>{tmp495}).Flatten();
    CodeStubAssembler(state_).StoreReference<IntPtrT>(CodeStubAssembler::Reference{tmp496, tmp497}, phi_bb242_17);
    tmp498 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferCallTarget);
    std::tie(tmp499, tmp500) = GetRefAt_RawPtr_RawPtr_intptr_0(state_, TNode<RawPtrT>{tmp485}, TNode<IntPtrT>{tmp498}).Flatten();
    CodeStubAssembler(state_).StoreReference<RawPtrT>(CodeStubAssembler::Reference{tmp499, tmp500}, tmp483);
    tmp501 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferParamStart);
    std::tie(tmp502, tmp503) = GetRefAt_RawPtr_intptr_RawPtr_intptr_0(state_, TNode<RawPtrT>{tmp485}, TNode<IntPtrT>{tmp501}).Flatten();
    CodeStubAssembler(state_).StoreReference<RawPtrT>(CodeStubAssembler::Reference{tmp502, tmp503}, tmp477);
    tmp504 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferParamEnd);
    std::tie(tmp505, tmp506) = GetRefAt_RawPtr_RawPtr_intptr_0(state_, TNode<RawPtrT>{tmp485}, TNode<IntPtrT>{tmp504}).Flatten();
    CodeStubAssembler(state_).StoreReference<RawPtrT>(CodeStubAssembler::Reference{tmp505, tmp506}, tmp480);
    if ((p_switchStack)) {
      ca_.Goto(&block243, phi_bb242_16, phi_bb242_17, phi_bb242_18, phi_bb242_25, phi_bb242_26, phi_bb242_27, phi_bb242_28, phi_bb242_29, phi_bb242_31, phi_bb242_32, phi_bb242_33, phi_bb242_34);
    } else {
      ca_.Goto(&block244, phi_bb242_16, phi_bb242_17, phi_bb242_18, phi_bb242_25, phi_bb242_26, phi_bb242_27, phi_bb242_28, phi_bb242_29, phi_bb242_31, phi_bb242_32, phi_bb242_33, phi_bb242_34);
    }
  }

  TNode<Object> phi_bb243_16;
  TNode<IntPtrT> phi_bb243_17;
  TNode<BoolT> phi_bb243_18;
  TNode<IntPtrT> phi_bb243_25;
  TNode<IntPtrT> phi_bb243_26;
  TNode<IntPtrT> phi_bb243_27;
  TNode<IntPtrT> phi_bb243_28;
  TNode<IntPtrT> phi_bb243_29;
  TNode<IntPtrT> phi_bb243_31;
  TNode<BoolT> phi_bb243_32;
  TNode<BoolT> phi_bb243_33;
  TNode<Int32T> phi_bb243_34;
  TNode<Object> tmp507;
  if (block243.is_used()) {
    ca_.Bind(&block243, &phi_bb243_16, &phi_bb243_17, &phi_bb243_18, &phi_bb243_25, &phi_bb243_26, &phi_bb243_27, &phi_bb243_28, &phi_bb243_29, &phi_bb243_31, &phi_bb243_32, &phi_bb243_33, &phi_bb243_34);
    tmp507 = ca_.CallBuiltin<Object>(Builtin::kWasmReturnPromiseOnSuspendAsm, TNode<Object>(), tmp485, tmp19, phi_bb243_16);
    ca_.Goto(&block245, phi_bb243_16, phi_bb243_17, phi_bb243_18, phi_bb243_25, phi_bb243_26, phi_bb243_27, phi_bb243_28, phi_bb243_29, phi_bb243_31, phi_bb243_32, phi_bb243_33, phi_bb243_34, tmp507);
  }

  TNode<Object> phi_bb244_16;
  TNode<IntPtrT> phi_bb244_17;
  TNode<BoolT> phi_bb244_18;
  TNode<IntPtrT> phi_bb244_25;
  TNode<IntPtrT> phi_bb244_26;
  TNode<IntPtrT> phi_bb244_27;
  TNode<IntPtrT> phi_bb244_28;
  TNode<IntPtrT> phi_bb244_29;
  TNode<IntPtrT> phi_bb244_31;
  TNode<BoolT> phi_bb244_32;
  TNode<BoolT> phi_bb244_33;
  TNode<Int32T> phi_bb244_34;
  TNode<Object> tmp508;
  if (block244.is_used()) {
    ca_.Bind(&block244, &phi_bb244_16, &phi_bb244_17, &phi_bb244_18, &phi_bb244_25, &phi_bb244_26, &phi_bb244_27, &phi_bb244_28, &phi_bb244_29, &phi_bb244_31, &phi_bb244_32, &phi_bb244_33, &phi_bb244_34);
    tmp508 = ca_.CallBuiltin<Object>(Builtin::kJSToWasmWrapperAsm, TNode<Object>(), tmp485, tmp19, phi_bb244_16);
    ca_.Goto(&block245, phi_bb244_16, phi_bb244_17, phi_bb244_18, phi_bb244_25, phi_bb244_26, phi_bb244_27, phi_bb244_28, phi_bb244_29, phi_bb244_31, phi_bb244_32, phi_bb244_33, phi_bb244_34, tmp508);
  }

  TNode<Object> phi_bb245_16;
  TNode<IntPtrT> phi_bb245_17;
  TNode<BoolT> phi_bb245_18;
  TNode<IntPtrT> phi_bb245_25;
  TNode<IntPtrT> phi_bb245_26;
  TNode<IntPtrT> phi_bb245_27;
  TNode<IntPtrT> phi_bb245_28;
  TNode<IntPtrT> phi_bb245_29;
  TNode<IntPtrT> phi_bb245_31;
  TNode<BoolT> phi_bb245_32;
  TNode<BoolT> phi_bb245_33;
  TNode<Int32T> phi_bb245_34;
  TNode<Object> phi_bb245_40;
  TNode<IntPtrT> tmp509;
  TNode<SharedFunctionInfo> tmp510;
  TNode<IntPtrT> tmp511;
  TNode<Int16T> tmp512;
  TNode<Int32T> tmp513;
  TNode<IntPtrT> tmp514;
  TNode<BoolT> tmp515;
  if (block245.is_used()) {
    ca_.Bind(&block245, &phi_bb245_16, &phi_bb245_17, &phi_bb245_18, &phi_bb245_25, &phi_bb245_26, &phi_bb245_27, &phi_bb245_28, &phi_bb245_29, &phi_bb245_31, &phi_bb245_32, &phi_bb245_33, &phi_bb245_34, &phi_bb245_40);
    tmp509 = FromConstexpr_intptr_constexpr_int31_0(state_, 32);
    tmp510 = CodeStubAssembler(state_).LoadReference<SharedFunctionInfo>(CodeStubAssembler::Reference{p_target, tmp509});
    tmp511 = FromConstexpr_intptr_constexpr_int31_0(state_, 40);
    tmp512 = CodeStubAssembler(state_).LoadReference<Int16T>(CodeStubAssembler::Reference{tmp510, tmp511});
    tmp513 = Convert_int32_int16_0(state_, TNode<Int16T>{tmp512});
    tmp514 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp513});
    tmp515 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{tmp514}, TNode<IntPtrT>{p_arguments.length});
    ca_.Branch(tmp515, &block246, std::vector<compiler::Node*>{phi_bb245_16, phi_bb245_17, phi_bb245_18, phi_bb245_25, phi_bb245_26, phi_bb245_27, phi_bb245_28, phi_bb245_29, phi_bb245_31, phi_bb245_32, phi_bb245_33, phi_bb245_34}, &block247, std::vector<compiler::Node*>{phi_bb245_16, phi_bb245_17, phi_bb245_18, phi_bb245_25, phi_bb245_26, phi_bb245_27, phi_bb245_28, phi_bb245_29, phi_bb245_31, phi_bb245_32, phi_bb245_33, phi_bb245_34, p_arguments.length});
  }

  TNode<Object> phi_bb246_16;
  TNode<IntPtrT> phi_bb246_17;
  TNode<BoolT> phi_bb246_18;
  TNode<IntPtrT> phi_bb246_25;
  TNode<IntPtrT> phi_bb246_26;
  TNode<IntPtrT> phi_bb246_27;
  TNode<IntPtrT> phi_bb246_28;
  TNode<IntPtrT> phi_bb246_29;
  TNode<IntPtrT> phi_bb246_31;
  TNode<BoolT> phi_bb246_32;
  TNode<BoolT> phi_bb246_33;
  TNode<Int32T> phi_bb246_34;
  if (block246.is_used()) {
    ca_.Bind(&block246, &phi_bb246_16, &phi_bb246_17, &phi_bb246_18, &phi_bb246_25, &phi_bb246_26, &phi_bb246_27, &phi_bb246_28, &phi_bb246_29, &phi_bb246_31, &phi_bb246_32, &phi_bb246_33, &phi_bb246_34);
    ca_.Goto(&block247, phi_bb246_16, phi_bb246_17, phi_bb246_18, phi_bb246_25, phi_bb246_26, phi_bb246_27, phi_bb246_28, phi_bb246_29, phi_bb246_31, phi_bb246_32, phi_bb246_33, phi_bb246_34, tmp514);
  }

  TNode<Object> phi_bb247_16;
  TNode<IntPtrT> phi_bb247_17;
  TNode<BoolT> phi_bb247_18;
  TNode<IntPtrT> phi_bb247_25;
  TNode<IntPtrT> phi_bb247_26;
  TNode<IntPtrT> phi_bb247_27;
  TNode<IntPtrT> phi_bb247_28;
  TNode<IntPtrT> phi_bb247_29;
  TNode<IntPtrT> phi_bb247_31;
  TNode<BoolT> phi_bb247_32;
  TNode<BoolT> phi_bb247_33;
  TNode<Int32T> phi_bb247_34;
  TNode<IntPtrT> phi_bb247_41;
  TNode<IntPtrT> tmp516;
  TNode<IntPtrT> tmp517;
  if (block247.is_used()) {
    ca_.Bind(&block247, &phi_bb247_16, &phi_bb247_17, &phi_bb247_18, &phi_bb247_25, &phi_bb247_26, &phi_bb247_27, &phi_bb247_28, &phi_bb247_29, &phi_bb247_31, &phi_bb247_32, &phi_bb247_33, &phi_bb247_34, &phi_bb247_41);
    tmp516 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp517 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb247_41}, TNode<IntPtrT>{tmp516});
    CodeStubAssembler(state_).PopAndReturn(TNode<IntPtrT>{tmp517}, TNode<Object>{phi_bb245_40});
  }
}

TF_BUILTIN(JSToWasmWrapper, CodeStubAssembler) {
  compiler::CodeAssemblerState* state_ = state();  compiler::CodeAssembler ca_(state());
  TNode<Word32T> argc = UncheckedParameter<Word32T>(Descriptor::kJSActualArgumentsCount);
  TNode<IntPtrT> arguments_length(ChangeInt32ToIntPtr(UncheckedCast<Int32T>(argc)));
  TNode<RawPtrT> arguments_frame = UncheckedCast<RawPtrT>(LoadFramePointer());
  TorqueStructArguments torque_arguments(GetFrameArguments(arguments_frame, arguments_length, FrameArgumentsArgcType::kCountIncludesReceiver));
  CodeStubArguments arguments(this, torque_arguments);
  TNode<NativeContext> parameter0 = UncheckedParameter<NativeContext>(Descriptor::kContext);
  USE(parameter0);
  TNode<Object> parameter1 = arguments.GetReceiver();
  USE(parameter1);
  TNode<JSFunction> parameter2 = UncheckedParameter<JSFunction>(Descriptor::kJSTarget);
USE(parameter2);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  if (block0.is_used()) {
    ca_.Bind(&block0);
    JSToWasmWrapperHelper_0(state_, TNode<NativeContext>{parameter0}, TNode<Object>{parameter1}, TNode<JSFunction>{parameter2}, TorqueStructArguments{TNode<RawPtrT>{torque_arguments.frame}, TNode<RawPtrT>{torque_arguments.base}, TNode<IntPtrT>{torque_arguments.length}, TNode<IntPtrT>{torque_arguments.actual_count}}, false);
  }
}

TF_BUILTIN(WasmReturnPromiseOnSuspend, CodeStubAssembler) {
  compiler::CodeAssemblerState* state_ = state();  compiler::CodeAssembler ca_(state());
  TNode<Word32T> argc = UncheckedParameter<Word32T>(Descriptor::kJSActualArgumentsCount);
  TNode<IntPtrT> arguments_length(ChangeInt32ToIntPtr(UncheckedCast<Int32T>(argc)));
  TNode<RawPtrT> arguments_frame = UncheckedCast<RawPtrT>(LoadFramePointer());
  TorqueStructArguments torque_arguments(GetFrameArguments(arguments_frame, arguments_length, FrameArgumentsArgcType::kCountIncludesReceiver));
  CodeStubArguments arguments(this, torque_arguments);
  TNode<NativeContext> parameter0 = UncheckedParameter<NativeContext>(Descriptor::kContext);
  USE(parameter0);
  TNode<Object> parameter1 = arguments.GetReceiver();
  USE(parameter1);
  TNode<JSFunction> parameter2 = UncheckedParameter<JSFunction>(Descriptor::kJSTarget);
USE(parameter2);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  if (block0.is_used()) {
    ca_.Bind(&block0);
    JSToWasmWrapperHelper_0(state_, TNode<NativeContext>{parameter0}, TNode<Object>{parameter1}, TNode<JSFunction>{parameter2}, TorqueStructArguments{TNode<RawPtrT>{torque_arguments.frame}, TNode<RawPtrT>{torque_arguments.base}, TNode<IntPtrT>{torque_arguments.length}, TNode<IntPtrT>{torque_arguments.actual_count}}, true);
  }
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=718&c=1
TNode<Object> WasmToJSObject_0(compiler::CodeAssemblerState* state_, TNode<NativeContext> p_context, TNode<Object> p_value, TNode<Int32T> p_retType) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block7(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block8(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block9(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block10(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block11(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block12(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block13(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block14(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block15(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block16(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block17(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block18(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block19(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block20(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block21(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block22(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block23(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block24(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block25(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block26(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block27(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block28(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block29(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block30(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block31(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block32(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block33(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block34(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block35(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block36(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block37(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block38(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block39(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block5(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block6(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block3(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block46(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block47(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block48(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block49(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block50(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block51(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block52(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block53(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block54(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block44(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block45(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block55(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block56(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block59(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block60(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block61(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block62(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block63(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block64(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block65(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block66(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block67(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block68(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block69(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block70(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block71(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block72(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<BoolT> block73(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block57(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block58(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object> block1(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<Object> block74(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Int32T> tmp0;
  TNode<Int32T> tmp1;
  TNode<Int32T> tmp2;
  TNode<Int32T> tmp3;
  TNode<Int32T> tmp4;
  TNode<Int32T> tmp5;
  TNode<Int32T> tmp6;
  TNode<BoolT> tmp7;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmValueKindBitsMask);
    tmp1 = CodeStubAssembler(state_).Word32And(TNode<Int32T>{p_retType}, TNode<Int32T>{tmp0});
    tmp2 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::ValueType::kKindBits);
    tmp3 = CodeStubAssembler(state_).Word32Sar(TNode<Int32T>{p_retType}, TNode<Int32T>{tmp2});
    tmp4 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmHeapTypeBitsMask);
    tmp5 = CodeStubAssembler(state_).Word32And(TNode<Int32T>{tmp3}, TNode<Int32T>{tmp4});
    tmp6 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::ValueKind::kRef);
    tmp7 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp1}, TNode<Int32T>{tmp6});
    ca_.Branch(tmp7, &block2, std::vector<compiler::Node*>{}, &block3, std::vector<compiler::Node*>{});
  }

  TNode<Int32T> tmp8;
  TNode<BoolT> tmp9;
  if (block2.is_used()) {
    ca_.Bind(&block2);
    tmp8 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kEq);
    tmp9 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp8});
    ca_.Branch(tmp9, &block7, std::vector<compiler::Node*>{}, &block8, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp10;
  if (block7.is_used()) {
    ca_.Bind(&block7);
    tmp10 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block9, tmp10);
  }

  TNode<Int32T> tmp11;
  TNode<BoolT> tmp12;
  if (block8.is_used()) {
    ca_.Bind(&block8);
    tmp11 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kI31);
    tmp12 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp11});
    ca_.Goto(&block9, tmp12);
  }

  TNode<BoolT> phi_bb9_6;
  if (block9.is_used()) {
    ca_.Bind(&block9, &phi_bb9_6);
    ca_.Branch(phi_bb9_6, &block10, std::vector<compiler::Node*>{}, &block11, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp13;
  if (block10.is_used()) {
    ca_.Bind(&block10);
    tmp13 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block12, tmp13);
  }

  TNode<Int32T> tmp14;
  TNode<BoolT> tmp15;
  if (block11.is_used()) {
    ca_.Bind(&block11);
    tmp14 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kStruct);
    tmp15 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp14});
    ca_.Goto(&block12, tmp15);
  }

  TNode<BoolT> phi_bb12_6;
  if (block12.is_used()) {
    ca_.Bind(&block12, &phi_bb12_6);
    ca_.Branch(phi_bb12_6, &block13, std::vector<compiler::Node*>{}, &block14, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp16;
  if (block13.is_used()) {
    ca_.Bind(&block13);
    tmp16 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block15, tmp16);
  }

  TNode<Int32T> tmp17;
  TNode<BoolT> tmp18;
  if (block14.is_used()) {
    ca_.Bind(&block14);
    tmp17 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kArray);
    tmp18 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp17});
    ca_.Goto(&block15, tmp18);
  }

  TNode<BoolT> phi_bb15_6;
  if (block15.is_used()) {
    ca_.Bind(&block15, &phi_bb15_6);
    ca_.Branch(phi_bb15_6, &block16, std::vector<compiler::Node*>{}, &block17, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp19;
  if (block16.is_used()) {
    ca_.Bind(&block16);
    tmp19 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block18, tmp19);
  }

  TNode<Int32T> tmp20;
  TNode<BoolT> tmp21;
  if (block17.is_used()) {
    ca_.Bind(&block17);
    tmp20 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kAny);
    tmp21 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp20});
    ca_.Goto(&block18, tmp21);
  }

  TNode<BoolT> phi_bb18_6;
  if (block18.is_used()) {
    ca_.Bind(&block18, &phi_bb18_6);
    ca_.Branch(phi_bb18_6, &block19, std::vector<compiler::Node*>{}, &block20, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp22;
  if (block19.is_used()) {
    ca_.Bind(&block19);
    tmp22 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block21, tmp22);
  }

  TNode<Int32T> tmp23;
  TNode<BoolT> tmp24;
  if (block20.is_used()) {
    ca_.Bind(&block20);
    tmp23 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kExtern);
    tmp24 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp23});
    ca_.Goto(&block21, tmp24);
  }

  TNode<BoolT> phi_bb21_6;
  if (block21.is_used()) {
    ca_.Bind(&block21, &phi_bb21_6);
    ca_.Branch(phi_bb21_6, &block22, std::vector<compiler::Node*>{}, &block23, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp25;
  if (block22.is_used()) {
    ca_.Bind(&block22);
    tmp25 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block24, tmp25);
  }

  TNode<Int32T> tmp26;
  TNode<BoolT> tmp27;
  if (block23.is_used()) {
    ca_.Bind(&block23);
    tmp26 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kString);
    tmp27 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp26});
    ca_.Goto(&block24, tmp27);
  }

  TNode<BoolT> phi_bb24_6;
  if (block24.is_used()) {
    ca_.Bind(&block24, &phi_bb24_6);
    ca_.Branch(phi_bb24_6, &block25, std::vector<compiler::Node*>{}, &block26, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp28;
  if (block25.is_used()) {
    ca_.Bind(&block25);
    tmp28 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block27, tmp28);
  }

  TNode<Int32T> tmp29;
  TNode<BoolT> tmp30;
  if (block26.is_used()) {
    ca_.Bind(&block26);
    tmp29 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kNone);
    tmp30 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp29});
    ca_.Goto(&block27, tmp30);
  }

  TNode<BoolT> phi_bb27_6;
  if (block27.is_used()) {
    ca_.Bind(&block27, &phi_bb27_6);
    ca_.Branch(phi_bb27_6, &block28, std::vector<compiler::Node*>{}, &block29, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp31;
  if (block28.is_used()) {
    ca_.Bind(&block28);
    tmp31 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block30, tmp31);
  }

  TNode<Int32T> tmp32;
  TNode<BoolT> tmp33;
  if (block29.is_used()) {
    ca_.Bind(&block29);
    tmp32 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kNoFunc);
    tmp33 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp32});
    ca_.Goto(&block30, tmp33);
  }

  TNode<BoolT> phi_bb30_6;
  if (block30.is_used()) {
    ca_.Bind(&block30, &phi_bb30_6);
    ca_.Branch(phi_bb30_6, &block31, std::vector<compiler::Node*>{}, &block32, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp34;
  if (block31.is_used()) {
    ca_.Bind(&block31);
    tmp34 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block33, tmp34);
  }

  TNode<Int32T> tmp35;
  TNode<BoolT> tmp36;
  if (block32.is_used()) {
    ca_.Bind(&block32);
    tmp35 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kNoExtern);
    tmp36 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp35});
    ca_.Goto(&block33, tmp36);
  }

  TNode<BoolT> phi_bb33_6;
  if (block33.is_used()) {
    ca_.Bind(&block33, &phi_bb33_6);
    ca_.Branch(phi_bb33_6, &block34, std::vector<compiler::Node*>{}, &block35, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp37;
  if (block34.is_used()) {
    ca_.Bind(&block34);
    tmp37 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block36, tmp37);
  }

  TNode<Int32T> tmp38;
  TNode<BoolT> tmp39;
  if (block35.is_used()) {
    ca_.Bind(&block35);
    tmp38 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kExn);
    tmp39 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp38});
    ca_.Goto(&block36, tmp39);
  }

  TNode<BoolT> phi_bb36_6;
  if (block36.is_used()) {
    ca_.Bind(&block36, &phi_bb36_6);
    ca_.Branch(phi_bb36_6, &block37, std::vector<compiler::Node*>{}, &block38, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp40;
  if (block37.is_used()) {
    ca_.Bind(&block37);
    tmp40 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block39, tmp40);
  }

  TNode<Int32T> tmp41;
  TNode<BoolT> tmp42;
  if (block38.is_used()) {
    ca_.Bind(&block38);
    tmp41 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kNoExn);
    tmp42 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp41});
    ca_.Goto(&block39, tmp42);
  }

  TNode<BoolT> phi_bb39_6;
  if (block39.is_used()) {
    ca_.Bind(&block39, &phi_bb39_6);
    ca_.Branch(phi_bb39_6, &block5, std::vector<compiler::Node*>{}, &block6, std::vector<compiler::Node*>{});
  }

  TNode<Object> tmp43;
  if (block5.is_used()) {
    ca_.Bind(&block5);
    tmp43 = UnsafeCast_JSAny_0(state_, TNode<Context>{p_context}, TNode<Object>{p_value});
    ca_.Goto(&block1, tmp43);
  }

  TNode<Object> tmp44;
  if (block6.is_used()) {
    ca_.Bind(&block6);
    tmp44 = CodeStubAssembler(state_).CallRuntime(Runtime::kWasmGenericWasmToJSObject, p_context, p_value); 
    ca_.Goto(&block1, tmp44);
  }

  TNode<Int32T> tmp45;
  TNode<BoolT> tmp46;
  if (block3.is_used()) {
    ca_.Bind(&block3);
    tmp45 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kExtern);
    tmp46 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp45});
    ca_.Branch(tmp46, &block46, std::vector<compiler::Node*>{}, &block47, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp47;
  if (block46.is_used()) {
    ca_.Bind(&block46);
    tmp47 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block48, tmp47);
  }

  TNode<Int32T> tmp48;
  TNode<BoolT> tmp49;
  if (block47.is_used()) {
    ca_.Bind(&block47);
    tmp48 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kNoExtern);
    tmp49 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp48});
    ca_.Goto(&block48, tmp49);
  }

  TNode<BoolT> phi_bb48_6;
  if (block48.is_used()) {
    ca_.Bind(&block48, &phi_bb48_6);
    ca_.Branch(phi_bb48_6, &block49, std::vector<compiler::Node*>{}, &block50, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp50;
  if (block49.is_used()) {
    ca_.Bind(&block49);
    tmp50 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block51, tmp50);
  }

  TNode<Int32T> tmp51;
  TNode<BoolT> tmp52;
  if (block50.is_used()) {
    ca_.Bind(&block50);
    tmp51 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kExn);
    tmp52 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp51});
    ca_.Goto(&block51, tmp52);
  }

  TNode<BoolT> phi_bb51_6;
  if (block51.is_used()) {
    ca_.Bind(&block51, &phi_bb51_6);
    ca_.Branch(phi_bb51_6, &block52, std::vector<compiler::Node*>{}, &block53, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp53;
  if (block52.is_used()) {
    ca_.Bind(&block52);
    tmp53 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block54, tmp53);
  }

  TNode<Int32T> tmp54;
  TNode<BoolT> tmp55;
  if (block53.is_used()) {
    ca_.Bind(&block53);
    tmp54 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kNoExn);
    tmp55 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp54});
    ca_.Goto(&block54, tmp55);
  }

  TNode<BoolT> phi_bb54_6;
  if (block54.is_used()) {
    ca_.Bind(&block54, &phi_bb54_6);
    ca_.Branch(phi_bb54_6, &block44, std::vector<compiler::Node*>{}, &block45, std::vector<compiler::Node*>{});
  }

  TNode<Object> tmp56;
  if (block44.is_used()) {
    ca_.Bind(&block44);
    tmp56 = UnsafeCast_JSAny_0(state_, TNode<Context>{p_context}, TNode<Object>{p_value});
    ca_.Goto(&block1, tmp56);
  }

  TNode<WasmNull> tmp57;
  TNode<BoolT> tmp58;
  if (block45.is_used()) {
    ca_.Bind(&block45);
    tmp57 = kWasmNull_0(state_);
    tmp58 = CodeStubAssembler(state_).TaggedEqual(TNode<Object>{p_value}, TNode<HeapObject>{tmp57});
    ca_.Branch(tmp58, &block55, std::vector<compiler::Node*>{}, &block56, std::vector<compiler::Node*>{});
  }

  TNode<Null> tmp59;
  if (block55.is_used()) {
    ca_.Bind(&block55);
    tmp59 = Null_0(state_);
    ca_.Goto(&block1, tmp59);
  }

  TNode<Int32T> tmp60;
  TNode<BoolT> tmp61;
  if (block56.is_used()) {
    ca_.Bind(&block56);
    tmp60 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kEq);
    tmp61 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp60});
    ca_.Branch(tmp61, &block59, std::vector<compiler::Node*>{}, &block60, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp62;
  if (block59.is_used()) {
    ca_.Bind(&block59);
    tmp62 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block61, tmp62);
  }

  TNode<Int32T> tmp63;
  TNode<BoolT> tmp64;
  if (block60.is_used()) {
    ca_.Bind(&block60);
    tmp63 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kStruct);
    tmp64 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp63});
    ca_.Goto(&block61, tmp64);
  }

  TNode<BoolT> phi_bb61_6;
  if (block61.is_used()) {
    ca_.Bind(&block61, &phi_bb61_6);
    ca_.Branch(phi_bb61_6, &block62, std::vector<compiler::Node*>{}, &block63, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp65;
  if (block62.is_used()) {
    ca_.Bind(&block62);
    tmp65 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block64, tmp65);
  }

  TNode<Int32T> tmp66;
  TNode<BoolT> tmp67;
  if (block63.is_used()) {
    ca_.Bind(&block63);
    tmp66 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kArray);
    tmp67 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp66});
    ca_.Goto(&block64, tmp67);
  }

  TNode<BoolT> phi_bb64_6;
  if (block64.is_used()) {
    ca_.Bind(&block64, &phi_bb64_6);
    ca_.Branch(phi_bb64_6, &block65, std::vector<compiler::Node*>{}, &block66, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp68;
  if (block65.is_used()) {
    ca_.Bind(&block65);
    tmp68 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block67, tmp68);
  }

  TNode<Int32T> tmp69;
  TNode<BoolT> tmp70;
  if (block66.is_used()) {
    ca_.Bind(&block66);
    tmp69 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kString);
    tmp70 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp69});
    ca_.Goto(&block67, tmp70);
  }

  TNode<BoolT> phi_bb67_6;
  if (block67.is_used()) {
    ca_.Bind(&block67, &phi_bb67_6);
    ca_.Branch(phi_bb67_6, &block68, std::vector<compiler::Node*>{}, &block69, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp71;
  if (block68.is_used()) {
    ca_.Bind(&block68);
    tmp71 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block70, tmp71);
  }

  TNode<Int32T> tmp72;
  TNode<BoolT> tmp73;
  if (block69.is_used()) {
    ca_.Bind(&block69);
    tmp72 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kI31);
    tmp73 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp72});
    ca_.Goto(&block70, tmp73);
  }

  TNode<BoolT> phi_bb70_6;
  if (block70.is_used()) {
    ca_.Bind(&block70, &phi_bb70_6);
    ca_.Branch(phi_bb70_6, &block71, std::vector<compiler::Node*>{}, &block72, std::vector<compiler::Node*>{});
  }

  TNode<BoolT> tmp74;
  if (block71.is_used()) {
    ca_.Bind(&block71);
    tmp74 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block73, tmp74);
  }

  TNode<Int32T> tmp75;
  TNode<BoolT> tmp76;
  if (block72.is_used()) {
    ca_.Bind(&block72);
    tmp75 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::HeapType::Representation::kAny);
    tmp76 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp5}, TNode<Int32T>{tmp75});
    ca_.Goto(&block73, tmp76);
  }

  TNode<BoolT> phi_bb73_6;
  if (block73.is_used()) {
    ca_.Bind(&block73, &phi_bb73_6);
    ca_.Branch(phi_bb73_6, &block57, std::vector<compiler::Node*>{}, &block58, std::vector<compiler::Node*>{});
  }

  TNode<Object> tmp77;
  if (block57.is_used()) {
    ca_.Bind(&block57);
    tmp77 = UnsafeCast_JSAny_0(state_, TNode<Context>{p_context}, TNode<Object>{p_value});
    ca_.Goto(&block1, tmp77);
  }

  TNode<Object> tmp78;
  if (block58.is_used()) {
    ca_.Bind(&block58);
    tmp78 = CodeStubAssembler(state_).CallRuntime(Runtime::kWasmGenericWasmToJSObject, p_context, p_value); 
    ca_.Goto(&block1, tmp78);
  }

  TNode<Object> phi_bb1_3;
  if (block1.is_used()) {
    ca_.Bind(&block1, &phi_bb1_3);
    ca_.Goto(&block74, phi_bb1_3);
  }

  TNode<Object> phi_bb74_3;
    ca_.Bind(&block74, &phi_bb74_3);
  return TNode<Object>{phi_bb74_3};
}

TF_BUILTIN(JSToWasmHandleReturns, CodeStubAssembler) {
  compiler::CodeAssemblerState* state_ = state();  compiler::CodeAssembler ca_(state());
  TNode<WasmTrustedInstanceData> parameter0 = UncheckedParameter<WasmTrustedInstanceData>(Descriptor::kTrustedData);
  USE(parameter0);
  TNode<JSArray> parameter1 = UncheckedParameter<JSArray>(Descriptor::kResultArray);
  USE(parameter1);
  TNode<RawPtrT> parameter2 = UncheckedParameter<RawPtrT>(Descriptor::kWrapperBuffer);
  USE(parameter2);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block1(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block3(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block5(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block6(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block8(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block9(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block11(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block12(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block14(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block17(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block18(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block15(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block4(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block33(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block37(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block35(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block40(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block44(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block45(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block47(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block48(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block50(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block51(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block46(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block43(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block41(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block52(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block56(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block57(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block59(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block60(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block62(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block63(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block58(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block55(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block53(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block64(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block68(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block69(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block71(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block72(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block74(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block75(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block70(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block67(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block76(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block80(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block81(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block83(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block84(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block86(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block87(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block82(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block79(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block77(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block78(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block65(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block88(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block92(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block93(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block94(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block98(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block99(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block101(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block102(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block97(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block95(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block91(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block89(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block104(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block105(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block107(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block108(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block110(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block111(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block106(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block103(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block116(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block117(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block90(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block66(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block54(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block42(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block36(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT> block34(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block122(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block120(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block125(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block129(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block130(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block132(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block133(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block135(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block136(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block131(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block128(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block141(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block142(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block126(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block145(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block149(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block150(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block152(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block153(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block155(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block156(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block151(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block148(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block161(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block162(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block146(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block165(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block168(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block172(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block173(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block175(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block176(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block178(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block179(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block174(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block171(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block184(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block185(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block169(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block189(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block190(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block192(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block193(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block195(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block196(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block191(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block188(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block198(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block199(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block201(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block202(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block204(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block205(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, Object, IntPtrT> block200(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, Object, IntPtrT> block197(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block210(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block211(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block170(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block166(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block214(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block218(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block219(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block220(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block224(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block225(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block227(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block228(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block223(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block221(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block217(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block233(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block234(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block215(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block238(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block239(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block241(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block242(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block244(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block245(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block240(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, Object, IntPtrT> block237(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block250(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block251(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block258(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT> block259(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block216(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block167(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block147(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block127(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, IntPtrT, BoolT, IntPtrT> block121(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<IntPtrT> tmp0;
  TNode<Object> tmp1;
  TNode<IntPtrT> tmp2;
  TNode<Int32T> tmp3;
  TNode<Int32T> tmp4;
  TNode<BoolT> tmp5;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferReturnCount);
    std::tie(tmp1, tmp2) = GetRefAt_int32_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp0}).Flatten();
    tmp3 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp1, tmp2});
    tmp4 = FromConstexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp5 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp3}, TNode<Int32T>{tmp4});
    ca_.Branch(tmp5, &block1, std::vector<compiler::Node*>{}, &block2, std::vector<compiler::Node*>{});
  }

  TNode<Undefined> tmp6;
  if (block1.is_used()) {
    ca_.Bind(&block1);
    tmp6 = Undefined_0(state_);
    CodeStubAssembler(state_).Return(tmp6);
  }

  TNode<Int32T> tmp7;
  TNode<BoolT> tmp8;
  if (block2.is_used()) {
    ca_.Bind(&block2);
    tmp7 = FromConstexpr_int32_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x1ull));
    tmp8 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp3}, TNode<Int32T>{tmp7});
    ca_.Branch(tmp8, &block3, std::vector<compiler::Node*>{}, &block4, std::vector<compiler::Node*>{});
  }

  TNode<IntPtrT> tmp9;
  TNode<Object> tmp10;
  TNode<IntPtrT> tmp11;
  TNode<RawPtrT> tmp12;
  TNode<IntPtrT> tmp13;
  TNode<Object> tmp14;
  TNode<IntPtrT> tmp15;
  TNode<Int32T> tmp16;
  TNode<Int32T> tmp17;
  TNode<BoolT> tmp18;
  if (block3.is_used()) {
    ca_.Bind(&block3);
    tmp9 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferSigRepresentationArray);
    std::tie(tmp10, tmp11) = GetRefAt_RawPtr_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp9}).Flatten();
    tmp12 = CodeStubAssembler(state_).LoadReference<RawPtrT>(CodeStubAssembler::Reference{tmp10, tmp11});
    tmp13 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    std::tie(tmp14, tmp15) = GetRefAt_int32_RawPtr_0(state_, TNode<RawPtrT>{tmp12}, TNode<IntPtrT>{tmp13}).Flatten();
    tmp16 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp14, tmp15});
    tmp17 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI32.raw_bit_field());
    tmp18 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp16}, TNode<Int32T>{tmp17});
    ca_.Branch(tmp18, &block5, std::vector<compiler::Node*>{}, &block6, std::vector<compiler::Node*>{});
  }

  TNode<IntPtrT> tmp19;
  TNode<Object> tmp20;
  TNode<IntPtrT> tmp21;
  TNode<Int32T> tmp22;
  TNode<Number> tmp23;
  if (block5.is_used()) {
    ca_.Bind(&block5);
    tmp19 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferGPReturnRegister1);
    std::tie(tmp20, tmp21) = GetRefAt_int32_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp19}).Flatten();
    tmp22 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp20, tmp21});
    tmp23 = Convert_Number_int32_0(state_, TNode<Int32T>{tmp22});
    CodeStubAssembler(state_).Return(tmp23);
  }

  TNode<Int32T> tmp24;
  TNode<BoolT> tmp25;
  if (block6.is_used()) {
    ca_.Bind(&block6);
    tmp24 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF32.raw_bit_field());
    tmp25 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp16}, TNode<Int32T>{tmp24});
    ca_.Branch(tmp25, &block8, std::vector<compiler::Node*>{}, &block9, std::vector<compiler::Node*>{});
  }

  TNode<IntPtrT> tmp26;
  TNode<Object> tmp27;
  TNode<IntPtrT> tmp28;
  TNode<Float32T> tmp29;
  TNode<Number> tmp30;
  if (block8.is_used()) {
    ca_.Bind(&block8);
    tmp26 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferFPReturnRegister1);
    std::tie(tmp27, tmp28) = GetRefAt_float32_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp26}).Flatten();
    tmp29 = CodeStubAssembler(state_).LoadReference<Float32T>(CodeStubAssembler::Reference{tmp27, tmp28});
    tmp30 = Convert_Number_float32_0(state_, TNode<Float32T>{tmp29});
    CodeStubAssembler(state_).Return(tmp30);
  }

  TNode<Int32T> tmp31;
  TNode<BoolT> tmp32;
  if (block9.is_used()) {
    ca_.Bind(&block9);
    tmp31 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF64.raw_bit_field());
    tmp32 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp16}, TNode<Int32T>{tmp31});
    ca_.Branch(tmp32, &block11, std::vector<compiler::Node*>{}, &block12, std::vector<compiler::Node*>{});
  }

  TNode<IntPtrT> tmp33;
  TNode<Object> tmp34;
  TNode<IntPtrT> tmp35;
  TNode<Float64T> tmp36;
  TNode<Number> tmp37;
  if (block11.is_used()) {
    ca_.Bind(&block11);
    tmp33 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferFPReturnRegister1);
    std::tie(tmp34, tmp35) = GetRefAt_float64_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp33}).Flatten();
    tmp36 = CodeStubAssembler(state_).LoadReference<Float64T>(CodeStubAssembler::Reference{tmp34, tmp35});
    tmp37 = Convert_Number_float64_0(state_, TNode<Float64T>{tmp36});
    CodeStubAssembler(state_).Return(tmp37);
  }

  TNode<Int32T> tmp38;
  TNode<BoolT> tmp39;
  if (block12.is_used()) {
    ca_.Bind(&block12);
    tmp38 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI64.raw_bit_field());
    tmp39 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp16}, TNode<Int32T>{tmp38});
    ca_.Branch(tmp39, &block14, std::vector<compiler::Node*>{}, &block15, std::vector<compiler::Node*>{});
  }

  if (block14.is_used()) {
    ca_.Bind(&block14);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block17);
    } else {
      ca_.Goto(&block18);
    }
  }

  TNode<IntPtrT> tmp40;
  TNode<Object> tmp41;
  TNode<IntPtrT> tmp42;
  TNode<IntPtrT> tmp43;
  TNode<BigInt> tmp44;
  if (block17.is_used()) {
    ca_.Bind(&block17);
    tmp40 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferGPReturnRegister1);
    std::tie(tmp41, tmp42) = GetRefAt_intptr_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp40}).Flatten();
    tmp43 = CodeStubAssembler(state_).LoadReference<IntPtrT>(CodeStubAssembler::Reference{tmp41, tmp42});
    tmp44 = ca_.CallBuiltin<BigInt>(Builtin::kI64ToBigInt, TNode<Object>(), tmp43);
    CodeStubAssembler(state_).Return(tmp44);
  }

  TNode<IntPtrT> tmp45;
  TNode<Object> tmp46;
  TNode<IntPtrT> tmp47;
  TNode<IntPtrT> tmp48;
  TNode<IntPtrT> tmp49;
  TNode<Object> tmp50;
  TNode<IntPtrT> tmp51;
  TNode<IntPtrT> tmp52;
  TNode<BigInt> tmp53;
  if (block18.is_used()) {
    ca_.Bind(&block18);
    tmp45 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferGPReturnRegister1);
    std::tie(tmp46, tmp47) = GetRefAt_intptr_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp45}).Flatten();
    tmp48 = CodeStubAssembler(state_).LoadReference<IntPtrT>(CodeStubAssembler::Reference{tmp46, tmp47});
    tmp49 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferGPReturnRegister2);
    std::tie(tmp50, tmp51) = GetRefAt_intptr_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp49}).Flatten();
    tmp52 = CodeStubAssembler(state_).LoadReference<IntPtrT>(CodeStubAssembler::Reference{tmp50, tmp51});
    tmp53 = ca_.CallBuiltin<BigInt>(Builtin::kI32PairToBigInt, TNode<Object>(), tmp48, tmp52);
    CodeStubAssembler(state_).Return(tmp53);
  }

  TNode<IntPtrT> tmp54;
  TNode<RawPtrT> tmp55;
  TNode<RawPtrT> tmp56;
  TNode<IntPtrT> tmp57;
  TNode<Object> tmp58;
  TNode<IntPtrT> tmp59;
  TNode<UintPtrT> tmp60;
  TNode<Object> tmp61;
  TNode<NativeContext> tmp62;
  TNode<Object> tmp63;
  if (block15.is_used()) {
    ca_.Bind(&block15);
    tmp54 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferGPReturnRegister1);
    tmp55 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp54});
    tmp56 = (TNode<RawPtrT>{tmp55});
    tmp57 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    std::tie(tmp58, tmp59) = GetRefAt_uintptr_RawPtr_uintptr_0(state_, TNode<RawPtrT>{tmp56}, TNode<IntPtrT>{tmp57}).Flatten();
    tmp60 = CodeStubAssembler(state_).LoadReference<UintPtrT>(CodeStubAssembler::Reference{tmp58, tmp59});
    tmp61 = CodeStubAssembler(state_).BitcastWordToTagged(TNode<UintPtrT>{tmp60});
    tmp62 = WasmBuiltinsAssembler(state_).LoadContextFromInstanceData(TNode<WasmTrustedInstanceData>{parameter0});
    tmp63 = WasmToJSObject_0(state_, TNode<NativeContext>{tmp62}, TNode<Object>{tmp61}, TNode<Int32T>{tmp16});
    CodeStubAssembler(state_).Return(tmp63);
  }

  TNode<IntPtrT> tmp64;
  TNode<FixedArrayBase> tmp65;
  TNode<FixedArray> tmp66;
  TNode<IntPtrT> tmp67;
  TNode<Object> tmp68;
  TNode<IntPtrT> tmp69;
  TNode<RawPtrT> tmp70;
  TNode<IntPtrT> tmp71;
  TNode<RawPtrT> tmp72;
  TNode<IntPtrT> tmp73;
  TNode<RawPtrT> tmp74;
  TNode<Object> tmp75;
  TNode<IntPtrT> tmp76;
  TNode<IntPtrT> tmp77;
  TNode<IntPtrT> tmp78;
  TNode<IntPtrT> tmp79;
  TNode<IntPtrT> tmp80;
  TNode<IntPtrT> tmp81;
  TNode<IntPtrT> tmp82;
  TNode<BoolT> tmp83;
  TNode<IntPtrT> tmp84;
  TNode<Object> tmp85;
  TNode<IntPtrT> tmp86;
  TNode<RawPtrT> tmp87;
  TNode<RawPtrT> tmp88;
  TNode<IntPtrT> tmp89;
  TNode<Object> tmp90;
  TNode<IntPtrT> tmp91;
  TNode<IntPtrT> tmp92;
  TNode<IntPtrT> tmp93;
  TNode<Object> tmp94;
  TNode<IntPtrT> tmp95;
  TNode<BoolT> tmp96;
  if (block4.is_used()) {
    ca_.Bind(&block4);
    tmp64 = FromConstexpr_intptr_constexpr_int31_0(state_, 16);
    tmp65 = CodeStubAssembler(state_).LoadReference<FixedArrayBase>(CodeStubAssembler::Reference{parameter1, tmp64});
    tmp66 = TORQUE_CAST(TNode<Object>{tmp65});
    tmp67 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferStackReturnBufferStart);
    std::tie(tmp68, tmp69) = GetRefAt_RawPtr_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp67}).Flatten();
    tmp70 = CodeStubAssembler(state_).LoadReference<RawPtrT>(CodeStubAssembler::Reference{tmp68, tmp69});
    tmp71 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferGPReturnRegister1);
    tmp72 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp71});
    tmp73 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferFPReturnRegister1);
    tmp74 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp73});
    std::tie(tmp75, tmp76, tmp77, tmp78, tmp79, tmp80, tmp81, tmp82, tmp83) = LocationAllocatorForReturns_0(state_, TNode<RawPtrT>{tmp72}, TNode<RawPtrT>{tmp74}, TNode<RawPtrT>{tmp70}).Flatten();
    tmp84 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferSigRepresentationArray);
    std::tie(tmp85, tmp86) = GetRefAt_RawPtr_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp84}).Flatten();
    tmp87 = CodeStubAssembler(state_).LoadReference<RawPtrT>(CodeStubAssembler::Reference{tmp85, tmp86});
    tmp88 = (TNode<RawPtrT>{tmp87});
    tmp89 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp3});
    std::tie(tmp90, tmp91, tmp92) = NewOffHeapConstSlice_int32_0(state_, TNode<RawPtrT>{tmp88}, TNode<IntPtrT>{tmp89}).Flatten();
    tmp93 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferRefReturnCount);
    std::tie(tmp94, tmp95) = GetRefAt_bool_RawPtr_intptr_0(state_, TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp93}).Flatten();
    tmp96 = CodeStubAssembler(state_).LoadReference<BoolT>(CodeStubAssembler::Reference{tmp94, tmp95});
    ca_.Branch(tmp96, &block33, std::vector<compiler::Node*>{}, &block34, std::vector<compiler::Node*>{tmp76, tmp77, tmp78, tmp79, tmp80, tmp82, tmp83});
  }

  TNode<IntPtrT> tmp97;
  if (block33.is_used()) {
    ca_.Bind(&block33);
    tmp97 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    ca_.Goto(&block37, tmp76, tmp77, tmp78, tmp79, tmp80, tmp82, tmp83, tmp97);
  }

  TNode<IntPtrT> phi_bb37_7;
  TNode<IntPtrT> phi_bb37_8;
  TNode<IntPtrT> phi_bb37_9;
  TNode<IntPtrT> phi_bb37_10;
  TNode<IntPtrT> phi_bb37_11;
  TNode<IntPtrT> phi_bb37_13;
  TNode<BoolT> phi_bb37_14;
  TNode<IntPtrT> phi_bb37_20;
  TNode<IntPtrT> tmp98;
  TNode<BoolT> tmp99;
  if (block37.is_used()) {
    ca_.Bind(&block37, &phi_bb37_7, &phi_bb37_8, &phi_bb37_9, &phi_bb37_10, &phi_bb37_11, &phi_bb37_13, &phi_bb37_14, &phi_bb37_20);
    tmp98 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp3});
    tmp99 = CodeStubAssembler(state_).IntPtrLessThan(TNode<IntPtrT>{phi_bb37_20}, TNode<IntPtrT>{tmp98});
    ca_.Branch(tmp99, &block35, std::vector<compiler::Node*>{phi_bb37_7, phi_bb37_8, phi_bb37_9, phi_bb37_10, phi_bb37_11, phi_bb37_13, phi_bb37_14, phi_bb37_20}, &block36, std::vector<compiler::Node*>{phi_bb37_7, phi_bb37_8, phi_bb37_9, phi_bb37_10, phi_bb37_11, phi_bb37_13, phi_bb37_14, phi_bb37_20});
  }

  TNode<IntPtrT> phi_bb35_7;
  TNode<IntPtrT> phi_bb35_8;
  TNode<IntPtrT> phi_bb35_9;
  TNode<IntPtrT> phi_bb35_10;
  TNode<IntPtrT> phi_bb35_11;
  TNode<IntPtrT> phi_bb35_13;
  TNode<BoolT> phi_bb35_14;
  TNode<IntPtrT> phi_bb35_20;
  TNode<IntPtrT> tmp100;
  TNode<IntPtrT> tmp101;
  TNode<IntPtrT> tmp102;
  TNode<Object> tmp103;
  TNode<IntPtrT> tmp104;
  TNode<Int32T> tmp105;
  TNode<Int32T> tmp106;
  TNode<BoolT> tmp107;
  if (block35.is_used()) {
    ca_.Bind(&block35, &phi_bb35_7, &phi_bb35_8, &phi_bb35_9, &phi_bb35_10, &phi_bb35_11, &phi_bb35_13, &phi_bb35_14, &phi_bb35_20);
    tmp100 = Convert_intptr_intptr_0(state_, TNode<IntPtrT>{phi_bb35_20});
    tmp101 = TimesSizeOf_int32_0(state_, TNode<IntPtrT>{tmp100});
    tmp102 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp91}, TNode<IntPtrT>{tmp101});
    std::tie(tmp103, tmp104) = NewReference_int32_0(state_, TNode<Object>{tmp90}, TNode<IntPtrT>{tmp102}).Flatten();
    tmp105 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp103, tmp104});
    tmp106 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI32.raw_bit_field());
    tmp107 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp105}, TNode<Int32T>{tmp106});
    ca_.Branch(tmp107, &block40, std::vector<compiler::Node*>{phi_bb35_7, phi_bb35_8, phi_bb35_9, phi_bb35_10, phi_bb35_11, phi_bb35_13, phi_bb35_14, phi_bb35_20}, &block41, std::vector<compiler::Node*>{phi_bb35_7, phi_bb35_8, phi_bb35_9, phi_bb35_10, phi_bb35_11, phi_bb35_13, phi_bb35_14, phi_bb35_20});
  }

  TNode<IntPtrT> phi_bb40_7;
  TNode<IntPtrT> phi_bb40_8;
  TNode<IntPtrT> phi_bb40_9;
  TNode<IntPtrT> phi_bb40_10;
  TNode<IntPtrT> phi_bb40_11;
  TNode<IntPtrT> phi_bb40_13;
  TNode<BoolT> phi_bb40_14;
  TNode<IntPtrT> phi_bb40_20;
  TNode<IntPtrT> tmp108;
  TNode<IntPtrT> tmp109;
  TNode<IntPtrT> tmp110;
  TNode<BoolT> tmp111;
  if (block40.is_used()) {
    ca_.Bind(&block40, &phi_bb40_7, &phi_bb40_8, &phi_bb40_9, &phi_bb40_10, &phi_bb40_11, &phi_bb40_13, &phi_bb40_14, &phi_bb40_20);
    tmp108 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp109 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb40_7}, TNode<IntPtrT>{tmp108});
    tmp110 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp111 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb40_7}, TNode<IntPtrT>{tmp110});
    ca_.Branch(tmp111, &block44, std::vector<compiler::Node*>{phi_bb40_8, phi_bb40_9, phi_bb40_10, phi_bb40_11, phi_bb40_13, phi_bb40_14, phi_bb40_20}, &block45, std::vector<compiler::Node*>{phi_bb40_8, phi_bb40_9, phi_bb40_10, phi_bb40_11, phi_bb40_13, phi_bb40_14, phi_bb40_20});
  }

  TNode<IntPtrT> phi_bb44_8;
  TNode<IntPtrT> phi_bb44_9;
  TNode<IntPtrT> phi_bb44_10;
  TNode<IntPtrT> phi_bb44_11;
  TNode<IntPtrT> phi_bb44_13;
  TNode<BoolT> phi_bb44_14;
  TNode<IntPtrT> phi_bb44_20;
  TNode<Object> tmp112;
  TNode<IntPtrT> tmp113;
  TNode<IntPtrT> tmp114;
  TNode<IntPtrT> tmp115;
  if (block44.is_used()) {
    ca_.Bind(&block44, &phi_bb44_8, &phi_bb44_9, &phi_bb44_10, &phi_bb44_11, &phi_bb44_13, &phi_bb44_14, &phi_bb44_20);
    std::tie(tmp112, tmp113) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb44_9}).Flatten();
    tmp114 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp115 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb44_9}, TNode<IntPtrT>{tmp114});
    ca_.Goto(&block43, phi_bb44_8, tmp115, phi_bb44_10, phi_bb44_11, phi_bb44_13, phi_bb44_14, phi_bb44_20, tmp112, tmp113);
  }

  TNode<IntPtrT> phi_bb45_8;
  TNode<IntPtrT> phi_bb45_9;
  TNode<IntPtrT> phi_bb45_10;
  TNode<IntPtrT> phi_bb45_11;
  TNode<IntPtrT> phi_bb45_13;
  TNode<BoolT> phi_bb45_14;
  TNode<IntPtrT> phi_bb45_20;
  if (block45.is_used()) {
    ca_.Bind(&block45, &phi_bb45_8, &phi_bb45_9, &phi_bb45_10, &phi_bb45_11, &phi_bb45_13, &phi_bb45_14, &phi_bb45_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block47, phi_bb45_8, phi_bb45_9, phi_bb45_10, phi_bb45_11, phi_bb45_13, phi_bb45_14, phi_bb45_20);
    } else {
      ca_.Goto(&block48, phi_bb45_8, phi_bb45_9, phi_bb45_10, phi_bb45_11, phi_bb45_13, phi_bb45_14, phi_bb45_20);
    }
  }

  TNode<IntPtrT> phi_bb47_8;
  TNode<IntPtrT> phi_bb47_9;
  TNode<IntPtrT> phi_bb47_10;
  TNode<IntPtrT> phi_bb47_11;
  TNode<IntPtrT> phi_bb47_13;
  TNode<BoolT> phi_bb47_14;
  TNode<IntPtrT> phi_bb47_20;
  TNode<Object> tmp116;
  TNode<IntPtrT> tmp117;
  TNode<IntPtrT> tmp118;
  TNode<IntPtrT> tmp119;
  if (block47.is_used()) {
    ca_.Bind(&block47, &phi_bb47_8, &phi_bb47_9, &phi_bb47_10, &phi_bb47_11, &phi_bb47_13, &phi_bb47_14, &phi_bb47_20);
    std::tie(tmp116, tmp117) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb47_11}).Flatten();
    tmp118 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp119 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb47_11}, TNode<IntPtrT>{tmp118});
    ca_.Goto(&block46, phi_bb47_8, phi_bb47_9, phi_bb47_10, tmp119, phi_bb47_13, phi_bb47_14, phi_bb47_20, tmp116, tmp117);
  }

  TNode<IntPtrT> phi_bb48_8;
  TNode<IntPtrT> phi_bb48_9;
  TNode<IntPtrT> phi_bb48_10;
  TNode<IntPtrT> phi_bb48_11;
  TNode<IntPtrT> phi_bb48_13;
  TNode<BoolT> phi_bb48_14;
  TNode<IntPtrT> phi_bb48_20;
  TNode<IntPtrT> tmp120;
  TNode<BoolT> tmp121;
  if (block48.is_used()) {
    ca_.Bind(&block48, &phi_bb48_8, &phi_bb48_9, &phi_bb48_10, &phi_bb48_11, &phi_bb48_13, &phi_bb48_14, &phi_bb48_20);
    tmp120 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp121 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb48_13}, TNode<IntPtrT>{tmp120});
    ca_.Branch(tmp121, &block50, std::vector<compiler::Node*>{phi_bb48_8, phi_bb48_9, phi_bb48_10, phi_bb48_11, phi_bb48_13, phi_bb48_14, phi_bb48_20}, &block51, std::vector<compiler::Node*>{phi_bb48_8, phi_bb48_9, phi_bb48_10, phi_bb48_11, phi_bb48_13, phi_bb48_14, phi_bb48_20});
  }

  TNode<IntPtrT> phi_bb50_8;
  TNode<IntPtrT> phi_bb50_9;
  TNode<IntPtrT> phi_bb50_10;
  TNode<IntPtrT> phi_bb50_11;
  TNode<IntPtrT> phi_bb50_13;
  TNode<BoolT> phi_bb50_14;
  TNode<IntPtrT> phi_bb50_20;
  TNode<Object> tmp122;
  TNode<IntPtrT> tmp123;
  TNode<IntPtrT> tmp124;
  TNode<BoolT> tmp125;
  if (block50.is_used()) {
    ca_.Bind(&block50, &phi_bb50_8, &phi_bb50_9, &phi_bb50_10, &phi_bb50_11, &phi_bb50_13, &phi_bb50_14, &phi_bb50_20);
    std::tie(tmp122, tmp123) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb50_13}).Flatten();
    tmp124 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp125 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block46, phi_bb50_8, phi_bb50_9, phi_bb50_10, phi_bb50_11, tmp124, tmp125, phi_bb50_20, tmp122, tmp123);
  }

  TNode<IntPtrT> phi_bb51_8;
  TNode<IntPtrT> phi_bb51_9;
  TNode<IntPtrT> phi_bb51_10;
  TNode<IntPtrT> phi_bb51_11;
  TNode<IntPtrT> phi_bb51_13;
  TNode<BoolT> phi_bb51_14;
  TNode<IntPtrT> phi_bb51_20;
  TNode<Object> tmp126;
  TNode<IntPtrT> tmp127;
  TNode<IntPtrT> tmp128;
  TNode<IntPtrT> tmp129;
  TNode<IntPtrT> tmp130;
  TNode<IntPtrT> tmp131;
  TNode<BoolT> tmp132;
  if (block51.is_used()) {
    ca_.Bind(&block51, &phi_bb51_8, &phi_bb51_9, &phi_bb51_10, &phi_bb51_11, &phi_bb51_13, &phi_bb51_14, &phi_bb51_20);
    std::tie(tmp126, tmp127) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb51_11}).Flatten();
    tmp128 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp129 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb51_11}, TNode<IntPtrT>{tmp128});
    tmp130 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp131 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp129}, TNode<IntPtrT>{tmp130});
    tmp132 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block46, phi_bb51_8, phi_bb51_9, phi_bb51_10, tmp131, tmp129, tmp132, phi_bb51_20, tmp126, tmp127);
  }

  TNode<IntPtrT> phi_bb46_8;
  TNode<IntPtrT> phi_bb46_9;
  TNode<IntPtrT> phi_bb46_10;
  TNode<IntPtrT> phi_bb46_11;
  TNode<IntPtrT> phi_bb46_13;
  TNode<BoolT> phi_bb46_14;
  TNode<IntPtrT> phi_bb46_20;
  TNode<Object> phi_bb46_22;
  TNode<IntPtrT> phi_bb46_23;
  if (block46.is_used()) {
    ca_.Bind(&block46, &phi_bb46_8, &phi_bb46_9, &phi_bb46_10, &phi_bb46_11, &phi_bb46_13, &phi_bb46_14, &phi_bb46_20, &phi_bb46_22, &phi_bb46_23);
    ca_.Goto(&block43, phi_bb46_8, phi_bb46_9, phi_bb46_10, phi_bb46_11, phi_bb46_13, phi_bb46_14, phi_bb46_20, phi_bb46_22, phi_bb46_23);
  }

  TNode<IntPtrT> phi_bb43_8;
  TNode<IntPtrT> phi_bb43_9;
  TNode<IntPtrT> phi_bb43_10;
  TNode<IntPtrT> phi_bb43_11;
  TNode<IntPtrT> phi_bb43_13;
  TNode<BoolT> phi_bb43_14;
  TNode<IntPtrT> phi_bb43_20;
  TNode<Object> phi_bb43_22;
  TNode<IntPtrT> phi_bb43_23;
  if (block43.is_used()) {
    ca_.Bind(&block43, &phi_bb43_8, &phi_bb43_9, &phi_bb43_10, &phi_bb43_11, &phi_bb43_13, &phi_bb43_14, &phi_bb43_20, &phi_bb43_22, &phi_bb43_23);
    ca_.Goto(&block42, tmp109, phi_bb43_8, phi_bb43_9, phi_bb43_10, phi_bb43_11, phi_bb43_13, phi_bb43_14, phi_bb43_20);
  }

  TNode<IntPtrT> phi_bb41_7;
  TNode<IntPtrT> phi_bb41_8;
  TNode<IntPtrT> phi_bb41_9;
  TNode<IntPtrT> phi_bb41_10;
  TNode<IntPtrT> phi_bb41_11;
  TNode<IntPtrT> phi_bb41_13;
  TNode<BoolT> phi_bb41_14;
  TNode<IntPtrT> phi_bb41_20;
  TNode<Int32T> tmp133;
  TNode<BoolT> tmp134;
  if (block41.is_used()) {
    ca_.Bind(&block41, &phi_bb41_7, &phi_bb41_8, &phi_bb41_9, &phi_bb41_10, &phi_bb41_11, &phi_bb41_13, &phi_bb41_14, &phi_bb41_20);
    tmp133 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF32.raw_bit_field());
    tmp134 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp105}, TNode<Int32T>{tmp133});
    ca_.Branch(tmp134, &block52, std::vector<compiler::Node*>{phi_bb41_7, phi_bb41_8, phi_bb41_9, phi_bb41_10, phi_bb41_11, phi_bb41_13, phi_bb41_14, phi_bb41_20}, &block53, std::vector<compiler::Node*>{phi_bb41_7, phi_bb41_8, phi_bb41_9, phi_bb41_10, phi_bb41_11, phi_bb41_13, phi_bb41_14, phi_bb41_20});
  }

  TNode<IntPtrT> phi_bb52_7;
  TNode<IntPtrT> phi_bb52_8;
  TNode<IntPtrT> phi_bb52_9;
  TNode<IntPtrT> phi_bb52_10;
  TNode<IntPtrT> phi_bb52_11;
  TNode<IntPtrT> phi_bb52_13;
  TNode<BoolT> phi_bb52_14;
  TNode<IntPtrT> phi_bb52_20;
  TNode<IntPtrT> tmp135;
  TNode<IntPtrT> tmp136;
  TNode<IntPtrT> tmp137;
  TNode<BoolT> tmp138;
  if (block52.is_used()) {
    ca_.Bind(&block52, &phi_bb52_7, &phi_bb52_8, &phi_bb52_9, &phi_bb52_10, &phi_bb52_11, &phi_bb52_13, &phi_bb52_14, &phi_bb52_20);
    tmp135 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp136 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb52_8}, TNode<IntPtrT>{tmp135});
    tmp137 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp138 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb52_8}, TNode<IntPtrT>{tmp137});
    ca_.Branch(tmp138, &block56, std::vector<compiler::Node*>{phi_bb52_7, phi_bb52_9, phi_bb52_10, phi_bb52_11, phi_bb52_13, phi_bb52_14, phi_bb52_20}, &block57, std::vector<compiler::Node*>{phi_bb52_7, phi_bb52_9, phi_bb52_10, phi_bb52_11, phi_bb52_13, phi_bb52_14, phi_bb52_20});
  }

  TNode<IntPtrT> phi_bb56_7;
  TNode<IntPtrT> phi_bb56_9;
  TNode<IntPtrT> phi_bb56_10;
  TNode<IntPtrT> phi_bb56_11;
  TNode<IntPtrT> phi_bb56_13;
  TNode<BoolT> phi_bb56_14;
  TNode<IntPtrT> phi_bb56_20;
  TNode<Object> tmp139;
  TNode<IntPtrT> tmp140;
  TNode<IntPtrT> tmp141;
  TNode<IntPtrT> tmp142;
  if (block56.is_used()) {
    ca_.Bind(&block56, &phi_bb56_7, &phi_bb56_9, &phi_bb56_10, &phi_bb56_11, &phi_bb56_13, &phi_bb56_14, &phi_bb56_20);
    std::tie(tmp139, tmp140) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb56_10}).Flatten();
    tmp141 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_float64_0(state_)));
    tmp142 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb56_10}, TNode<IntPtrT>{tmp141});
    ca_.Goto(&block55, phi_bb56_7, phi_bb56_9, tmp142, phi_bb56_11, phi_bb56_13, phi_bb56_14, phi_bb56_20, tmp139, tmp140);
  }

  TNode<IntPtrT> phi_bb57_7;
  TNode<IntPtrT> phi_bb57_9;
  TNode<IntPtrT> phi_bb57_10;
  TNode<IntPtrT> phi_bb57_11;
  TNode<IntPtrT> phi_bb57_13;
  TNode<BoolT> phi_bb57_14;
  TNode<IntPtrT> phi_bb57_20;
  if (block57.is_used()) {
    ca_.Bind(&block57, &phi_bb57_7, &phi_bb57_9, &phi_bb57_10, &phi_bb57_11, &phi_bb57_13, &phi_bb57_14, &phi_bb57_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block59, phi_bb57_7, phi_bb57_9, phi_bb57_10, phi_bb57_11, phi_bb57_13, phi_bb57_14, phi_bb57_20);
    } else {
      ca_.Goto(&block60, phi_bb57_7, phi_bb57_9, phi_bb57_10, phi_bb57_11, phi_bb57_13, phi_bb57_14, phi_bb57_20);
    }
  }

  TNode<IntPtrT> phi_bb59_7;
  TNode<IntPtrT> phi_bb59_9;
  TNode<IntPtrT> phi_bb59_10;
  TNode<IntPtrT> phi_bb59_11;
  TNode<IntPtrT> phi_bb59_13;
  TNode<BoolT> phi_bb59_14;
  TNode<IntPtrT> phi_bb59_20;
  TNode<Object> tmp143;
  TNode<IntPtrT> tmp144;
  TNode<IntPtrT> tmp145;
  TNode<IntPtrT> tmp146;
  if (block59.is_used()) {
    ca_.Bind(&block59, &phi_bb59_7, &phi_bb59_9, &phi_bb59_10, &phi_bb59_11, &phi_bb59_13, &phi_bb59_14, &phi_bb59_20);
    std::tie(tmp143, tmp144) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb59_11}).Flatten();
    tmp145 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp146 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb59_11}, TNode<IntPtrT>{tmp145});
    ca_.Goto(&block58, phi_bb59_7, phi_bb59_9, phi_bb59_10, tmp146, phi_bb59_13, phi_bb59_14, phi_bb59_20, tmp143, tmp144);
  }

  TNode<IntPtrT> phi_bb60_7;
  TNode<IntPtrT> phi_bb60_9;
  TNode<IntPtrT> phi_bb60_10;
  TNode<IntPtrT> phi_bb60_11;
  TNode<IntPtrT> phi_bb60_13;
  TNode<BoolT> phi_bb60_14;
  TNode<IntPtrT> phi_bb60_20;
  TNode<IntPtrT> tmp147;
  TNode<BoolT> tmp148;
  if (block60.is_used()) {
    ca_.Bind(&block60, &phi_bb60_7, &phi_bb60_9, &phi_bb60_10, &phi_bb60_11, &phi_bb60_13, &phi_bb60_14, &phi_bb60_20);
    tmp147 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp148 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb60_13}, TNode<IntPtrT>{tmp147});
    ca_.Branch(tmp148, &block62, std::vector<compiler::Node*>{phi_bb60_7, phi_bb60_9, phi_bb60_10, phi_bb60_11, phi_bb60_13, phi_bb60_14, phi_bb60_20}, &block63, std::vector<compiler::Node*>{phi_bb60_7, phi_bb60_9, phi_bb60_10, phi_bb60_11, phi_bb60_13, phi_bb60_14, phi_bb60_20});
  }

  TNode<IntPtrT> phi_bb62_7;
  TNode<IntPtrT> phi_bb62_9;
  TNode<IntPtrT> phi_bb62_10;
  TNode<IntPtrT> phi_bb62_11;
  TNode<IntPtrT> phi_bb62_13;
  TNode<BoolT> phi_bb62_14;
  TNode<IntPtrT> phi_bb62_20;
  TNode<Object> tmp149;
  TNode<IntPtrT> tmp150;
  TNode<IntPtrT> tmp151;
  TNode<BoolT> tmp152;
  if (block62.is_used()) {
    ca_.Bind(&block62, &phi_bb62_7, &phi_bb62_9, &phi_bb62_10, &phi_bb62_11, &phi_bb62_13, &phi_bb62_14, &phi_bb62_20);
    std::tie(tmp149, tmp150) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb62_13}).Flatten();
    tmp151 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp152 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block58, phi_bb62_7, phi_bb62_9, phi_bb62_10, phi_bb62_11, tmp151, tmp152, phi_bb62_20, tmp149, tmp150);
  }

  TNode<IntPtrT> phi_bb63_7;
  TNode<IntPtrT> phi_bb63_9;
  TNode<IntPtrT> phi_bb63_10;
  TNode<IntPtrT> phi_bb63_11;
  TNode<IntPtrT> phi_bb63_13;
  TNode<BoolT> phi_bb63_14;
  TNode<IntPtrT> phi_bb63_20;
  TNode<Object> tmp153;
  TNode<IntPtrT> tmp154;
  TNode<IntPtrT> tmp155;
  TNode<IntPtrT> tmp156;
  TNode<IntPtrT> tmp157;
  TNode<IntPtrT> tmp158;
  TNode<BoolT> tmp159;
  if (block63.is_used()) {
    ca_.Bind(&block63, &phi_bb63_7, &phi_bb63_9, &phi_bb63_10, &phi_bb63_11, &phi_bb63_13, &phi_bb63_14, &phi_bb63_20);
    std::tie(tmp153, tmp154) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb63_11}).Flatten();
    tmp155 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp156 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb63_11}, TNode<IntPtrT>{tmp155});
    tmp157 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp158 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp156}, TNode<IntPtrT>{tmp157});
    tmp159 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block58, phi_bb63_7, phi_bb63_9, phi_bb63_10, tmp158, tmp156, tmp159, phi_bb63_20, tmp153, tmp154);
  }

  TNode<IntPtrT> phi_bb58_7;
  TNode<IntPtrT> phi_bb58_9;
  TNode<IntPtrT> phi_bb58_10;
  TNode<IntPtrT> phi_bb58_11;
  TNode<IntPtrT> phi_bb58_13;
  TNode<BoolT> phi_bb58_14;
  TNode<IntPtrT> phi_bb58_20;
  TNode<Object> phi_bb58_22;
  TNode<IntPtrT> phi_bb58_23;
  if (block58.is_used()) {
    ca_.Bind(&block58, &phi_bb58_7, &phi_bb58_9, &phi_bb58_10, &phi_bb58_11, &phi_bb58_13, &phi_bb58_14, &phi_bb58_20, &phi_bb58_22, &phi_bb58_23);
    ca_.Goto(&block55, phi_bb58_7, phi_bb58_9, phi_bb58_10, phi_bb58_11, phi_bb58_13, phi_bb58_14, phi_bb58_20, phi_bb58_22, phi_bb58_23);
  }

  TNode<IntPtrT> phi_bb55_7;
  TNode<IntPtrT> phi_bb55_9;
  TNode<IntPtrT> phi_bb55_10;
  TNode<IntPtrT> phi_bb55_11;
  TNode<IntPtrT> phi_bb55_13;
  TNode<BoolT> phi_bb55_14;
  TNode<IntPtrT> phi_bb55_20;
  TNode<Object> phi_bb55_22;
  TNode<IntPtrT> phi_bb55_23;
  if (block55.is_used()) {
    ca_.Bind(&block55, &phi_bb55_7, &phi_bb55_9, &phi_bb55_10, &phi_bb55_11, &phi_bb55_13, &phi_bb55_14, &phi_bb55_20, &phi_bb55_22, &phi_bb55_23);
    ca_.Goto(&block54, phi_bb55_7, tmp136, phi_bb55_9, phi_bb55_10, phi_bb55_11, phi_bb55_13, phi_bb55_14, phi_bb55_20);
  }

  TNode<IntPtrT> phi_bb53_7;
  TNode<IntPtrT> phi_bb53_8;
  TNode<IntPtrT> phi_bb53_9;
  TNode<IntPtrT> phi_bb53_10;
  TNode<IntPtrT> phi_bb53_11;
  TNode<IntPtrT> phi_bb53_13;
  TNode<BoolT> phi_bb53_14;
  TNode<IntPtrT> phi_bb53_20;
  TNode<Int32T> tmp160;
  TNode<BoolT> tmp161;
  if (block53.is_used()) {
    ca_.Bind(&block53, &phi_bb53_7, &phi_bb53_8, &phi_bb53_9, &phi_bb53_10, &phi_bb53_11, &phi_bb53_13, &phi_bb53_14, &phi_bb53_20);
    tmp160 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI64.raw_bit_field());
    tmp161 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp105}, TNode<Int32T>{tmp160});
    ca_.Branch(tmp161, &block64, std::vector<compiler::Node*>{phi_bb53_7, phi_bb53_8, phi_bb53_9, phi_bb53_10, phi_bb53_11, phi_bb53_13, phi_bb53_14, phi_bb53_20}, &block65, std::vector<compiler::Node*>{phi_bb53_7, phi_bb53_8, phi_bb53_9, phi_bb53_10, phi_bb53_11, phi_bb53_13, phi_bb53_14, phi_bb53_20});
  }

  TNode<IntPtrT> phi_bb64_7;
  TNode<IntPtrT> phi_bb64_8;
  TNode<IntPtrT> phi_bb64_9;
  TNode<IntPtrT> phi_bb64_10;
  TNode<IntPtrT> phi_bb64_11;
  TNode<IntPtrT> phi_bb64_13;
  TNode<BoolT> phi_bb64_14;
  TNode<IntPtrT> phi_bb64_20;
  TNode<IntPtrT> tmp162;
  TNode<IntPtrT> tmp163;
  TNode<IntPtrT> tmp164;
  TNode<BoolT> tmp165;
  if (block64.is_used()) {
    ca_.Bind(&block64, &phi_bb64_7, &phi_bb64_8, &phi_bb64_9, &phi_bb64_10, &phi_bb64_11, &phi_bb64_13, &phi_bb64_14, &phi_bb64_20);
    tmp162 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp163 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb64_7}, TNode<IntPtrT>{tmp162});
    tmp164 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp165 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb64_7}, TNode<IntPtrT>{tmp164});
    ca_.Branch(tmp165, &block68, std::vector<compiler::Node*>{phi_bb64_8, phi_bb64_9, phi_bb64_10, phi_bb64_11, phi_bb64_13, phi_bb64_14, phi_bb64_20}, &block69, std::vector<compiler::Node*>{phi_bb64_8, phi_bb64_9, phi_bb64_10, phi_bb64_11, phi_bb64_13, phi_bb64_14, phi_bb64_20});
  }

  TNode<IntPtrT> phi_bb68_8;
  TNode<IntPtrT> phi_bb68_9;
  TNode<IntPtrT> phi_bb68_10;
  TNode<IntPtrT> phi_bb68_11;
  TNode<IntPtrT> phi_bb68_13;
  TNode<BoolT> phi_bb68_14;
  TNode<IntPtrT> phi_bb68_20;
  TNode<Object> tmp166;
  TNode<IntPtrT> tmp167;
  TNode<IntPtrT> tmp168;
  TNode<IntPtrT> tmp169;
  if (block68.is_used()) {
    ca_.Bind(&block68, &phi_bb68_8, &phi_bb68_9, &phi_bb68_10, &phi_bb68_11, &phi_bb68_13, &phi_bb68_14, &phi_bb68_20);
    std::tie(tmp166, tmp167) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb68_9}).Flatten();
    tmp168 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp169 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb68_9}, TNode<IntPtrT>{tmp168});
    ca_.Goto(&block67, phi_bb68_8, tmp169, phi_bb68_10, phi_bb68_11, phi_bb68_13, phi_bb68_14, phi_bb68_20, tmp166, tmp167);
  }

  TNode<IntPtrT> phi_bb69_8;
  TNode<IntPtrT> phi_bb69_9;
  TNode<IntPtrT> phi_bb69_10;
  TNode<IntPtrT> phi_bb69_11;
  TNode<IntPtrT> phi_bb69_13;
  TNode<BoolT> phi_bb69_14;
  TNode<IntPtrT> phi_bb69_20;
  if (block69.is_used()) {
    ca_.Bind(&block69, &phi_bb69_8, &phi_bb69_9, &phi_bb69_10, &phi_bb69_11, &phi_bb69_13, &phi_bb69_14, &phi_bb69_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block71, phi_bb69_8, phi_bb69_9, phi_bb69_10, phi_bb69_11, phi_bb69_13, phi_bb69_14, phi_bb69_20);
    } else {
      ca_.Goto(&block72, phi_bb69_8, phi_bb69_9, phi_bb69_10, phi_bb69_11, phi_bb69_13, phi_bb69_14, phi_bb69_20);
    }
  }

  TNode<IntPtrT> phi_bb71_8;
  TNode<IntPtrT> phi_bb71_9;
  TNode<IntPtrT> phi_bb71_10;
  TNode<IntPtrT> phi_bb71_11;
  TNode<IntPtrT> phi_bb71_13;
  TNode<BoolT> phi_bb71_14;
  TNode<IntPtrT> phi_bb71_20;
  TNode<Object> tmp170;
  TNode<IntPtrT> tmp171;
  TNode<IntPtrT> tmp172;
  TNode<IntPtrT> tmp173;
  if (block71.is_used()) {
    ca_.Bind(&block71, &phi_bb71_8, &phi_bb71_9, &phi_bb71_10, &phi_bb71_11, &phi_bb71_13, &phi_bb71_14, &phi_bb71_20);
    std::tie(tmp170, tmp171) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb71_11}).Flatten();
    tmp172 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp173 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb71_11}, TNode<IntPtrT>{tmp172});
    ca_.Goto(&block70, phi_bb71_8, phi_bb71_9, phi_bb71_10, tmp173, phi_bb71_13, phi_bb71_14, phi_bb71_20, tmp170, tmp171);
  }

  TNode<IntPtrT> phi_bb72_8;
  TNode<IntPtrT> phi_bb72_9;
  TNode<IntPtrT> phi_bb72_10;
  TNode<IntPtrT> phi_bb72_11;
  TNode<IntPtrT> phi_bb72_13;
  TNode<BoolT> phi_bb72_14;
  TNode<IntPtrT> phi_bb72_20;
  TNode<IntPtrT> tmp174;
  TNode<BoolT> tmp175;
  if (block72.is_used()) {
    ca_.Bind(&block72, &phi_bb72_8, &phi_bb72_9, &phi_bb72_10, &phi_bb72_11, &phi_bb72_13, &phi_bb72_14, &phi_bb72_20);
    tmp174 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp175 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb72_13}, TNode<IntPtrT>{tmp174});
    ca_.Branch(tmp175, &block74, std::vector<compiler::Node*>{phi_bb72_8, phi_bb72_9, phi_bb72_10, phi_bb72_11, phi_bb72_13, phi_bb72_14, phi_bb72_20}, &block75, std::vector<compiler::Node*>{phi_bb72_8, phi_bb72_9, phi_bb72_10, phi_bb72_11, phi_bb72_13, phi_bb72_14, phi_bb72_20});
  }

  TNode<IntPtrT> phi_bb74_8;
  TNode<IntPtrT> phi_bb74_9;
  TNode<IntPtrT> phi_bb74_10;
  TNode<IntPtrT> phi_bb74_11;
  TNode<IntPtrT> phi_bb74_13;
  TNode<BoolT> phi_bb74_14;
  TNode<IntPtrT> phi_bb74_20;
  TNode<Object> tmp176;
  TNode<IntPtrT> tmp177;
  TNode<IntPtrT> tmp178;
  TNode<BoolT> tmp179;
  if (block74.is_used()) {
    ca_.Bind(&block74, &phi_bb74_8, &phi_bb74_9, &phi_bb74_10, &phi_bb74_11, &phi_bb74_13, &phi_bb74_14, &phi_bb74_20);
    std::tie(tmp176, tmp177) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb74_13}).Flatten();
    tmp178 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp179 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block70, phi_bb74_8, phi_bb74_9, phi_bb74_10, phi_bb74_11, tmp178, tmp179, phi_bb74_20, tmp176, tmp177);
  }

  TNode<IntPtrT> phi_bb75_8;
  TNode<IntPtrT> phi_bb75_9;
  TNode<IntPtrT> phi_bb75_10;
  TNode<IntPtrT> phi_bb75_11;
  TNode<IntPtrT> phi_bb75_13;
  TNode<BoolT> phi_bb75_14;
  TNode<IntPtrT> phi_bb75_20;
  TNode<Object> tmp180;
  TNode<IntPtrT> tmp181;
  TNode<IntPtrT> tmp182;
  TNode<IntPtrT> tmp183;
  TNode<IntPtrT> tmp184;
  TNode<IntPtrT> tmp185;
  TNode<BoolT> tmp186;
  if (block75.is_used()) {
    ca_.Bind(&block75, &phi_bb75_8, &phi_bb75_9, &phi_bb75_10, &phi_bb75_11, &phi_bb75_13, &phi_bb75_14, &phi_bb75_20);
    std::tie(tmp180, tmp181) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb75_11}).Flatten();
    tmp182 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp183 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb75_11}, TNode<IntPtrT>{tmp182});
    tmp184 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp185 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp183}, TNode<IntPtrT>{tmp184});
    tmp186 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block70, phi_bb75_8, phi_bb75_9, phi_bb75_10, tmp185, tmp183, tmp186, phi_bb75_20, tmp180, tmp181);
  }

  TNode<IntPtrT> phi_bb70_8;
  TNode<IntPtrT> phi_bb70_9;
  TNode<IntPtrT> phi_bb70_10;
  TNode<IntPtrT> phi_bb70_11;
  TNode<IntPtrT> phi_bb70_13;
  TNode<BoolT> phi_bb70_14;
  TNode<IntPtrT> phi_bb70_20;
  TNode<Object> phi_bb70_22;
  TNode<IntPtrT> phi_bb70_23;
  if (block70.is_used()) {
    ca_.Bind(&block70, &phi_bb70_8, &phi_bb70_9, &phi_bb70_10, &phi_bb70_11, &phi_bb70_13, &phi_bb70_14, &phi_bb70_20, &phi_bb70_22, &phi_bb70_23);
    ca_.Goto(&block67, phi_bb70_8, phi_bb70_9, phi_bb70_10, phi_bb70_11, phi_bb70_13, phi_bb70_14, phi_bb70_20, phi_bb70_22, phi_bb70_23);
  }

  TNode<IntPtrT> phi_bb67_8;
  TNode<IntPtrT> phi_bb67_9;
  TNode<IntPtrT> phi_bb67_10;
  TNode<IntPtrT> phi_bb67_11;
  TNode<IntPtrT> phi_bb67_13;
  TNode<BoolT> phi_bb67_14;
  TNode<IntPtrT> phi_bb67_20;
  TNode<Object> phi_bb67_22;
  TNode<IntPtrT> phi_bb67_23;
  if (block67.is_used()) {
    ca_.Bind(&block67, &phi_bb67_8, &phi_bb67_9, &phi_bb67_10, &phi_bb67_11, &phi_bb67_13, &phi_bb67_14, &phi_bb67_20, &phi_bb67_22, &phi_bb67_23);
    if (((CodeStubAssembler(state_).ConstexprBoolNot((CodeStubAssembler(state_).Is64()))))) {
      ca_.Goto(&block76, phi_bb67_8, phi_bb67_9, phi_bb67_10, phi_bb67_11, phi_bb67_13, phi_bb67_14, phi_bb67_20);
    } else {
      ca_.Goto(&block77, phi_bb67_8, phi_bb67_9, phi_bb67_10, phi_bb67_11, phi_bb67_13, phi_bb67_14, phi_bb67_20);
    }
  }

  TNode<IntPtrT> phi_bb76_8;
  TNode<IntPtrT> phi_bb76_9;
  TNode<IntPtrT> phi_bb76_10;
  TNode<IntPtrT> phi_bb76_11;
  TNode<IntPtrT> phi_bb76_13;
  TNode<BoolT> phi_bb76_14;
  TNode<IntPtrT> phi_bb76_20;
  TNode<IntPtrT> tmp187;
  TNode<IntPtrT> tmp188;
  TNode<IntPtrT> tmp189;
  TNode<BoolT> tmp190;
  if (block76.is_used()) {
    ca_.Bind(&block76, &phi_bb76_8, &phi_bb76_9, &phi_bb76_10, &phi_bb76_11, &phi_bb76_13, &phi_bb76_14, &phi_bb76_20);
    tmp187 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp188 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{tmp163}, TNode<IntPtrT>{tmp187});
    tmp189 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp190 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{tmp163}, TNode<IntPtrT>{tmp189});
    ca_.Branch(tmp190, &block80, std::vector<compiler::Node*>{phi_bb76_8, phi_bb76_9, phi_bb76_10, phi_bb76_11, phi_bb76_13, phi_bb76_14, phi_bb76_20}, &block81, std::vector<compiler::Node*>{phi_bb76_8, phi_bb76_9, phi_bb76_10, phi_bb76_11, phi_bb76_13, phi_bb76_14, phi_bb76_20});
  }

  TNode<IntPtrT> phi_bb80_8;
  TNode<IntPtrT> phi_bb80_9;
  TNode<IntPtrT> phi_bb80_10;
  TNode<IntPtrT> phi_bb80_11;
  TNode<IntPtrT> phi_bb80_13;
  TNode<BoolT> phi_bb80_14;
  TNode<IntPtrT> phi_bb80_20;
  TNode<Object> tmp191;
  TNode<IntPtrT> tmp192;
  TNode<IntPtrT> tmp193;
  TNode<IntPtrT> tmp194;
  if (block80.is_used()) {
    ca_.Bind(&block80, &phi_bb80_8, &phi_bb80_9, &phi_bb80_10, &phi_bb80_11, &phi_bb80_13, &phi_bb80_14, &phi_bb80_20);
    std::tie(tmp191, tmp192) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb80_9}).Flatten();
    tmp193 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp194 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb80_9}, TNode<IntPtrT>{tmp193});
    ca_.Goto(&block79, phi_bb80_8, tmp194, phi_bb80_10, phi_bb80_11, phi_bb80_13, phi_bb80_14, phi_bb80_20, tmp191, tmp192);
  }

  TNode<IntPtrT> phi_bb81_8;
  TNode<IntPtrT> phi_bb81_9;
  TNode<IntPtrT> phi_bb81_10;
  TNode<IntPtrT> phi_bb81_11;
  TNode<IntPtrT> phi_bb81_13;
  TNode<BoolT> phi_bb81_14;
  TNode<IntPtrT> phi_bb81_20;
  if (block81.is_used()) {
    ca_.Bind(&block81, &phi_bb81_8, &phi_bb81_9, &phi_bb81_10, &phi_bb81_11, &phi_bb81_13, &phi_bb81_14, &phi_bb81_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block83, phi_bb81_8, phi_bb81_9, phi_bb81_10, phi_bb81_11, phi_bb81_13, phi_bb81_14, phi_bb81_20);
    } else {
      ca_.Goto(&block84, phi_bb81_8, phi_bb81_9, phi_bb81_10, phi_bb81_11, phi_bb81_13, phi_bb81_14, phi_bb81_20);
    }
  }

  TNode<IntPtrT> phi_bb83_8;
  TNode<IntPtrT> phi_bb83_9;
  TNode<IntPtrT> phi_bb83_10;
  TNode<IntPtrT> phi_bb83_11;
  TNode<IntPtrT> phi_bb83_13;
  TNode<BoolT> phi_bb83_14;
  TNode<IntPtrT> phi_bb83_20;
  TNode<Object> tmp195;
  TNode<IntPtrT> tmp196;
  TNode<IntPtrT> tmp197;
  TNode<IntPtrT> tmp198;
  if (block83.is_used()) {
    ca_.Bind(&block83, &phi_bb83_8, &phi_bb83_9, &phi_bb83_10, &phi_bb83_11, &phi_bb83_13, &phi_bb83_14, &phi_bb83_20);
    std::tie(tmp195, tmp196) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb83_11}).Flatten();
    tmp197 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp198 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb83_11}, TNode<IntPtrT>{tmp197});
    ca_.Goto(&block82, phi_bb83_8, phi_bb83_9, phi_bb83_10, tmp198, phi_bb83_13, phi_bb83_14, phi_bb83_20, tmp195, tmp196);
  }

  TNode<IntPtrT> phi_bb84_8;
  TNode<IntPtrT> phi_bb84_9;
  TNode<IntPtrT> phi_bb84_10;
  TNode<IntPtrT> phi_bb84_11;
  TNode<IntPtrT> phi_bb84_13;
  TNode<BoolT> phi_bb84_14;
  TNode<IntPtrT> phi_bb84_20;
  TNode<IntPtrT> tmp199;
  TNode<BoolT> tmp200;
  if (block84.is_used()) {
    ca_.Bind(&block84, &phi_bb84_8, &phi_bb84_9, &phi_bb84_10, &phi_bb84_11, &phi_bb84_13, &phi_bb84_14, &phi_bb84_20);
    tmp199 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp200 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb84_13}, TNode<IntPtrT>{tmp199});
    ca_.Branch(tmp200, &block86, std::vector<compiler::Node*>{phi_bb84_8, phi_bb84_9, phi_bb84_10, phi_bb84_11, phi_bb84_13, phi_bb84_14, phi_bb84_20}, &block87, std::vector<compiler::Node*>{phi_bb84_8, phi_bb84_9, phi_bb84_10, phi_bb84_11, phi_bb84_13, phi_bb84_14, phi_bb84_20});
  }

  TNode<IntPtrT> phi_bb86_8;
  TNode<IntPtrT> phi_bb86_9;
  TNode<IntPtrT> phi_bb86_10;
  TNode<IntPtrT> phi_bb86_11;
  TNode<IntPtrT> phi_bb86_13;
  TNode<BoolT> phi_bb86_14;
  TNode<IntPtrT> phi_bb86_20;
  TNode<Object> tmp201;
  TNode<IntPtrT> tmp202;
  TNode<IntPtrT> tmp203;
  TNode<BoolT> tmp204;
  if (block86.is_used()) {
    ca_.Bind(&block86, &phi_bb86_8, &phi_bb86_9, &phi_bb86_10, &phi_bb86_11, &phi_bb86_13, &phi_bb86_14, &phi_bb86_20);
    std::tie(tmp201, tmp202) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb86_13}).Flatten();
    tmp203 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp204 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block82, phi_bb86_8, phi_bb86_9, phi_bb86_10, phi_bb86_11, tmp203, tmp204, phi_bb86_20, tmp201, tmp202);
  }

  TNode<IntPtrT> phi_bb87_8;
  TNode<IntPtrT> phi_bb87_9;
  TNode<IntPtrT> phi_bb87_10;
  TNode<IntPtrT> phi_bb87_11;
  TNode<IntPtrT> phi_bb87_13;
  TNode<BoolT> phi_bb87_14;
  TNode<IntPtrT> phi_bb87_20;
  TNode<Object> tmp205;
  TNode<IntPtrT> tmp206;
  TNode<IntPtrT> tmp207;
  TNode<IntPtrT> tmp208;
  TNode<IntPtrT> tmp209;
  TNode<IntPtrT> tmp210;
  TNode<BoolT> tmp211;
  if (block87.is_used()) {
    ca_.Bind(&block87, &phi_bb87_8, &phi_bb87_9, &phi_bb87_10, &phi_bb87_11, &phi_bb87_13, &phi_bb87_14, &phi_bb87_20);
    std::tie(tmp205, tmp206) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb87_11}).Flatten();
    tmp207 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp208 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb87_11}, TNode<IntPtrT>{tmp207});
    tmp209 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp210 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp208}, TNode<IntPtrT>{tmp209});
    tmp211 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block82, phi_bb87_8, phi_bb87_9, phi_bb87_10, tmp210, tmp208, tmp211, phi_bb87_20, tmp205, tmp206);
  }

  TNode<IntPtrT> phi_bb82_8;
  TNode<IntPtrT> phi_bb82_9;
  TNode<IntPtrT> phi_bb82_10;
  TNode<IntPtrT> phi_bb82_11;
  TNode<IntPtrT> phi_bb82_13;
  TNode<BoolT> phi_bb82_14;
  TNode<IntPtrT> phi_bb82_20;
  TNode<Object> phi_bb82_22;
  TNode<IntPtrT> phi_bb82_23;
  if (block82.is_used()) {
    ca_.Bind(&block82, &phi_bb82_8, &phi_bb82_9, &phi_bb82_10, &phi_bb82_11, &phi_bb82_13, &phi_bb82_14, &phi_bb82_20, &phi_bb82_22, &phi_bb82_23);
    ca_.Goto(&block79, phi_bb82_8, phi_bb82_9, phi_bb82_10, phi_bb82_11, phi_bb82_13, phi_bb82_14, phi_bb82_20, phi_bb82_22, phi_bb82_23);
  }

  TNode<IntPtrT> phi_bb79_8;
  TNode<IntPtrT> phi_bb79_9;
  TNode<IntPtrT> phi_bb79_10;
  TNode<IntPtrT> phi_bb79_11;
  TNode<IntPtrT> phi_bb79_13;
  TNode<BoolT> phi_bb79_14;
  TNode<IntPtrT> phi_bb79_20;
  TNode<Object> phi_bb79_22;
  TNode<IntPtrT> phi_bb79_23;
  if (block79.is_used()) {
    ca_.Bind(&block79, &phi_bb79_8, &phi_bb79_9, &phi_bb79_10, &phi_bb79_11, &phi_bb79_13, &phi_bb79_14, &phi_bb79_20, &phi_bb79_22, &phi_bb79_23);
    ca_.Goto(&block78, tmp188, phi_bb79_8, phi_bb79_9, phi_bb79_10, phi_bb79_11, phi_bb79_13, phi_bb79_14, phi_bb79_20);
  }

  TNode<IntPtrT> phi_bb77_8;
  TNode<IntPtrT> phi_bb77_9;
  TNode<IntPtrT> phi_bb77_10;
  TNode<IntPtrT> phi_bb77_11;
  TNode<IntPtrT> phi_bb77_13;
  TNode<BoolT> phi_bb77_14;
  TNode<IntPtrT> phi_bb77_20;
  if (block77.is_used()) {
    ca_.Bind(&block77, &phi_bb77_8, &phi_bb77_9, &phi_bb77_10, &phi_bb77_11, &phi_bb77_13, &phi_bb77_14, &phi_bb77_20);
    ca_.Goto(&block78, tmp163, phi_bb77_8, phi_bb77_9, phi_bb77_10, phi_bb77_11, phi_bb77_13, phi_bb77_14, phi_bb77_20);
  }

  TNode<IntPtrT> phi_bb78_7;
  TNode<IntPtrT> phi_bb78_8;
  TNode<IntPtrT> phi_bb78_9;
  TNode<IntPtrT> phi_bb78_10;
  TNode<IntPtrT> phi_bb78_11;
  TNode<IntPtrT> phi_bb78_13;
  TNode<BoolT> phi_bb78_14;
  TNode<IntPtrT> phi_bb78_20;
  if (block78.is_used()) {
    ca_.Bind(&block78, &phi_bb78_7, &phi_bb78_8, &phi_bb78_9, &phi_bb78_10, &phi_bb78_11, &phi_bb78_13, &phi_bb78_14, &phi_bb78_20);
    ca_.Goto(&block66, phi_bb78_7, phi_bb78_8, phi_bb78_9, phi_bb78_10, phi_bb78_11, phi_bb78_13, phi_bb78_14, phi_bb78_20);
  }

  TNode<IntPtrT> phi_bb65_7;
  TNode<IntPtrT> phi_bb65_8;
  TNode<IntPtrT> phi_bb65_9;
  TNode<IntPtrT> phi_bb65_10;
  TNode<IntPtrT> phi_bb65_11;
  TNode<IntPtrT> phi_bb65_13;
  TNode<BoolT> phi_bb65_14;
  TNode<IntPtrT> phi_bb65_20;
  TNode<Int32T> tmp212;
  TNode<BoolT> tmp213;
  if (block65.is_used()) {
    ca_.Bind(&block65, &phi_bb65_7, &phi_bb65_8, &phi_bb65_9, &phi_bb65_10, &phi_bb65_11, &phi_bb65_13, &phi_bb65_14, &phi_bb65_20);
    tmp212 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF64.raw_bit_field());
    tmp213 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp105}, TNode<Int32T>{tmp212});
    ca_.Branch(tmp213, &block88, std::vector<compiler::Node*>{phi_bb65_7, phi_bb65_8, phi_bb65_9, phi_bb65_10, phi_bb65_11, phi_bb65_13, phi_bb65_14, phi_bb65_20}, &block89, std::vector<compiler::Node*>{phi_bb65_7, phi_bb65_8, phi_bb65_9, phi_bb65_10, phi_bb65_11, phi_bb65_13, phi_bb65_14, phi_bb65_20});
  }

  TNode<IntPtrT> phi_bb88_7;
  TNode<IntPtrT> phi_bb88_8;
  TNode<IntPtrT> phi_bb88_9;
  TNode<IntPtrT> phi_bb88_10;
  TNode<IntPtrT> phi_bb88_11;
  TNode<IntPtrT> phi_bb88_13;
  TNode<BoolT> phi_bb88_14;
  TNode<IntPtrT> phi_bb88_20;
  TNode<IntPtrT> tmp214;
  TNode<IntPtrT> tmp215;
  TNode<IntPtrT> tmp216;
  TNode<BoolT> tmp217;
  if (block88.is_used()) {
    ca_.Bind(&block88, &phi_bb88_7, &phi_bb88_8, &phi_bb88_9, &phi_bb88_10, &phi_bb88_11, &phi_bb88_13, &phi_bb88_14, &phi_bb88_20);
    tmp214 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp215 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb88_8}, TNode<IntPtrT>{tmp214});
    tmp216 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp217 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb88_8}, TNode<IntPtrT>{tmp216});
    ca_.Branch(tmp217, &block92, std::vector<compiler::Node*>{phi_bb88_7, phi_bb88_9, phi_bb88_10, phi_bb88_11, phi_bb88_13, phi_bb88_14, phi_bb88_20}, &block93, std::vector<compiler::Node*>{phi_bb88_7, phi_bb88_9, phi_bb88_10, phi_bb88_11, phi_bb88_13, phi_bb88_14, phi_bb88_20});
  }

  TNode<IntPtrT> phi_bb92_7;
  TNode<IntPtrT> phi_bb92_9;
  TNode<IntPtrT> phi_bb92_10;
  TNode<IntPtrT> phi_bb92_11;
  TNode<IntPtrT> phi_bb92_13;
  TNode<BoolT> phi_bb92_14;
  TNode<IntPtrT> phi_bb92_20;
  TNode<Object> tmp218;
  TNode<IntPtrT> tmp219;
  TNode<IntPtrT> tmp220;
  TNode<IntPtrT> tmp221;
  if (block92.is_used()) {
    ca_.Bind(&block92, &phi_bb92_7, &phi_bb92_9, &phi_bb92_10, &phi_bb92_11, &phi_bb92_13, &phi_bb92_14, &phi_bb92_20);
    std::tie(tmp218, tmp219) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb92_10}).Flatten();
    tmp220 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_float64_0(state_)));
    tmp221 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb92_10}, TNode<IntPtrT>{tmp220});
    ca_.Goto(&block91, phi_bb92_7, phi_bb92_9, tmp221, phi_bb92_11, phi_bb92_13, phi_bb92_14, phi_bb92_20, tmp218, tmp219);
  }

  TNode<IntPtrT> phi_bb93_7;
  TNode<IntPtrT> phi_bb93_9;
  TNode<IntPtrT> phi_bb93_10;
  TNode<IntPtrT> phi_bb93_11;
  TNode<IntPtrT> phi_bb93_13;
  TNode<BoolT> phi_bb93_14;
  TNode<IntPtrT> phi_bb93_20;
  if (block93.is_used()) {
    ca_.Bind(&block93, &phi_bb93_7, &phi_bb93_9, &phi_bb93_10, &phi_bb93_11, &phi_bb93_13, &phi_bb93_14, &phi_bb93_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block94, phi_bb93_7, phi_bb93_9, phi_bb93_10, phi_bb93_11, phi_bb93_13, phi_bb93_14, phi_bb93_20);
    } else {
      ca_.Goto(&block95, phi_bb93_7, phi_bb93_9, phi_bb93_10, phi_bb93_11, phi_bb93_13, phi_bb93_14, phi_bb93_20);
    }
  }

  TNode<IntPtrT> phi_bb94_7;
  TNode<IntPtrT> phi_bb94_9;
  TNode<IntPtrT> phi_bb94_10;
  TNode<IntPtrT> phi_bb94_11;
  TNode<IntPtrT> phi_bb94_13;
  TNode<BoolT> phi_bb94_14;
  TNode<IntPtrT> phi_bb94_20;
  if (block94.is_used()) {
    ca_.Bind(&block94, &phi_bb94_7, &phi_bb94_9, &phi_bb94_10, &phi_bb94_11, &phi_bb94_13, &phi_bb94_14, &phi_bb94_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block98, phi_bb94_7, phi_bb94_9, phi_bb94_10, phi_bb94_11, phi_bb94_13, phi_bb94_14, phi_bb94_20);
    } else {
      ca_.Goto(&block99, phi_bb94_7, phi_bb94_9, phi_bb94_10, phi_bb94_11, phi_bb94_13, phi_bb94_14, phi_bb94_20);
    }
  }

  TNode<IntPtrT> phi_bb98_7;
  TNode<IntPtrT> phi_bb98_9;
  TNode<IntPtrT> phi_bb98_10;
  TNode<IntPtrT> phi_bb98_11;
  TNode<IntPtrT> phi_bb98_13;
  TNode<BoolT> phi_bb98_14;
  TNode<IntPtrT> phi_bb98_20;
  TNode<Object> tmp222;
  TNode<IntPtrT> tmp223;
  TNode<IntPtrT> tmp224;
  TNode<IntPtrT> tmp225;
  if (block98.is_used()) {
    ca_.Bind(&block98, &phi_bb98_7, &phi_bb98_9, &phi_bb98_10, &phi_bb98_11, &phi_bb98_13, &phi_bb98_14, &phi_bb98_20);
    std::tie(tmp222, tmp223) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb98_11}).Flatten();
    tmp224 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp225 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb98_11}, TNode<IntPtrT>{tmp224});
    ca_.Goto(&block97, phi_bb98_7, phi_bb98_9, phi_bb98_10, tmp225, phi_bb98_13, phi_bb98_14, phi_bb98_20, tmp222, tmp223);
  }

  TNode<IntPtrT> phi_bb99_7;
  TNode<IntPtrT> phi_bb99_9;
  TNode<IntPtrT> phi_bb99_10;
  TNode<IntPtrT> phi_bb99_11;
  TNode<IntPtrT> phi_bb99_13;
  TNode<BoolT> phi_bb99_14;
  TNode<IntPtrT> phi_bb99_20;
  TNode<IntPtrT> tmp226;
  TNode<BoolT> tmp227;
  if (block99.is_used()) {
    ca_.Bind(&block99, &phi_bb99_7, &phi_bb99_9, &phi_bb99_10, &phi_bb99_11, &phi_bb99_13, &phi_bb99_14, &phi_bb99_20);
    tmp226 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp227 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb99_13}, TNode<IntPtrT>{tmp226});
    ca_.Branch(tmp227, &block101, std::vector<compiler::Node*>{phi_bb99_7, phi_bb99_9, phi_bb99_10, phi_bb99_11, phi_bb99_13, phi_bb99_14, phi_bb99_20}, &block102, std::vector<compiler::Node*>{phi_bb99_7, phi_bb99_9, phi_bb99_10, phi_bb99_11, phi_bb99_13, phi_bb99_14, phi_bb99_20});
  }

  TNode<IntPtrT> phi_bb101_7;
  TNode<IntPtrT> phi_bb101_9;
  TNode<IntPtrT> phi_bb101_10;
  TNode<IntPtrT> phi_bb101_11;
  TNode<IntPtrT> phi_bb101_13;
  TNode<BoolT> phi_bb101_14;
  TNode<IntPtrT> phi_bb101_20;
  TNode<Object> tmp228;
  TNode<IntPtrT> tmp229;
  TNode<IntPtrT> tmp230;
  TNode<BoolT> tmp231;
  if (block101.is_used()) {
    ca_.Bind(&block101, &phi_bb101_7, &phi_bb101_9, &phi_bb101_10, &phi_bb101_11, &phi_bb101_13, &phi_bb101_14, &phi_bb101_20);
    std::tie(tmp228, tmp229) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb101_13}).Flatten();
    tmp230 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp231 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block97, phi_bb101_7, phi_bb101_9, phi_bb101_10, phi_bb101_11, tmp230, tmp231, phi_bb101_20, tmp228, tmp229);
  }

  TNode<IntPtrT> phi_bb102_7;
  TNode<IntPtrT> phi_bb102_9;
  TNode<IntPtrT> phi_bb102_10;
  TNode<IntPtrT> phi_bb102_11;
  TNode<IntPtrT> phi_bb102_13;
  TNode<BoolT> phi_bb102_14;
  TNode<IntPtrT> phi_bb102_20;
  TNode<Object> tmp232;
  TNode<IntPtrT> tmp233;
  TNode<IntPtrT> tmp234;
  TNode<IntPtrT> tmp235;
  TNode<IntPtrT> tmp236;
  TNode<IntPtrT> tmp237;
  TNode<BoolT> tmp238;
  if (block102.is_used()) {
    ca_.Bind(&block102, &phi_bb102_7, &phi_bb102_9, &phi_bb102_10, &phi_bb102_11, &phi_bb102_13, &phi_bb102_14, &phi_bb102_20);
    std::tie(tmp232, tmp233) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb102_11}).Flatten();
    tmp234 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp235 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb102_11}, TNode<IntPtrT>{tmp234});
    tmp236 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp237 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp235}, TNode<IntPtrT>{tmp236});
    tmp238 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block97, phi_bb102_7, phi_bb102_9, phi_bb102_10, tmp237, tmp235, tmp238, phi_bb102_20, tmp232, tmp233);
  }

  TNode<IntPtrT> phi_bb97_7;
  TNode<IntPtrT> phi_bb97_9;
  TNode<IntPtrT> phi_bb97_10;
  TNode<IntPtrT> phi_bb97_11;
  TNode<IntPtrT> phi_bb97_13;
  TNode<BoolT> phi_bb97_14;
  TNode<IntPtrT> phi_bb97_20;
  TNode<Object> phi_bb97_22;
  TNode<IntPtrT> phi_bb97_23;
  if (block97.is_used()) {
    ca_.Bind(&block97, &phi_bb97_7, &phi_bb97_9, &phi_bb97_10, &phi_bb97_11, &phi_bb97_13, &phi_bb97_14, &phi_bb97_20, &phi_bb97_22, &phi_bb97_23);
    ca_.Goto(&block91, phi_bb97_7, phi_bb97_9, phi_bb97_10, phi_bb97_11, phi_bb97_13, phi_bb97_14, phi_bb97_20, phi_bb97_22, phi_bb97_23);
  }

  TNode<IntPtrT> phi_bb95_7;
  TNode<IntPtrT> phi_bb95_9;
  TNode<IntPtrT> phi_bb95_10;
  TNode<IntPtrT> phi_bb95_11;
  TNode<IntPtrT> phi_bb95_13;
  TNode<BoolT> phi_bb95_14;
  TNode<IntPtrT> phi_bb95_20;
  TNode<Object> tmp239;
  TNode<IntPtrT> tmp240;
  TNode<IntPtrT> tmp241;
  TNode<IntPtrT> tmp242;
  TNode<BoolT> tmp243;
  if (block95.is_used()) {
    ca_.Bind(&block95, &phi_bb95_7, &phi_bb95_9, &phi_bb95_10, &phi_bb95_11, &phi_bb95_13, &phi_bb95_14, &phi_bb95_20);
    std::tie(tmp239, tmp240) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb95_11}).Flatten();
    tmp241 = FromConstexpr_intptr_constexpr_int31_0(state_, (CodeStubAssembler(state_).ConstexprInt31Mul((FromConstexpr_constexpr_int31_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x2ull))), (SizeOf_intptr_0(state_)))));
    tmp242 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb95_11}, TNode<IntPtrT>{tmp241});
    tmp243 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block91, phi_bb95_7, phi_bb95_9, phi_bb95_10, tmp242, phi_bb95_13, tmp243, phi_bb95_20, tmp239, tmp240);
  }

  TNode<IntPtrT> phi_bb91_7;
  TNode<IntPtrT> phi_bb91_9;
  TNode<IntPtrT> phi_bb91_10;
  TNode<IntPtrT> phi_bb91_11;
  TNode<IntPtrT> phi_bb91_13;
  TNode<BoolT> phi_bb91_14;
  TNode<IntPtrT> phi_bb91_20;
  TNode<Object> phi_bb91_22;
  TNode<IntPtrT> phi_bb91_23;
  if (block91.is_used()) {
    ca_.Bind(&block91, &phi_bb91_7, &phi_bb91_9, &phi_bb91_10, &phi_bb91_11, &phi_bb91_13, &phi_bb91_14, &phi_bb91_20, &phi_bb91_22, &phi_bb91_23);
    ca_.Goto(&block90, phi_bb91_7, tmp215, phi_bb91_9, phi_bb91_10, phi_bb91_11, phi_bb91_13, phi_bb91_14, phi_bb91_20);
  }

  TNode<IntPtrT> phi_bb89_7;
  TNode<IntPtrT> phi_bb89_8;
  TNode<IntPtrT> phi_bb89_9;
  TNode<IntPtrT> phi_bb89_10;
  TNode<IntPtrT> phi_bb89_11;
  TNode<IntPtrT> phi_bb89_13;
  TNode<BoolT> phi_bb89_14;
  TNode<IntPtrT> phi_bb89_20;
  TNode<IntPtrT> tmp244;
  TNode<IntPtrT> tmp245;
  TNode<IntPtrT> tmp246;
  TNode<BoolT> tmp247;
  if (block89.is_used()) {
    ca_.Bind(&block89, &phi_bb89_7, &phi_bb89_8, &phi_bb89_9, &phi_bb89_10, &phi_bb89_11, &phi_bb89_13, &phi_bb89_14, &phi_bb89_20);
    tmp244 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp245 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb89_7}, TNode<IntPtrT>{tmp244});
    tmp246 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp247 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb89_7}, TNode<IntPtrT>{tmp246});
    ca_.Branch(tmp247, &block104, std::vector<compiler::Node*>{phi_bb89_8, phi_bb89_9, phi_bb89_10, phi_bb89_11, phi_bb89_13, phi_bb89_14, phi_bb89_20}, &block105, std::vector<compiler::Node*>{phi_bb89_8, phi_bb89_9, phi_bb89_10, phi_bb89_11, phi_bb89_13, phi_bb89_14, phi_bb89_20});
  }

  TNode<IntPtrT> phi_bb104_8;
  TNode<IntPtrT> phi_bb104_9;
  TNode<IntPtrT> phi_bb104_10;
  TNode<IntPtrT> phi_bb104_11;
  TNode<IntPtrT> phi_bb104_13;
  TNode<BoolT> phi_bb104_14;
  TNode<IntPtrT> phi_bb104_20;
  TNode<Object> tmp248;
  TNode<IntPtrT> tmp249;
  TNode<IntPtrT> tmp250;
  TNode<IntPtrT> tmp251;
  if (block104.is_used()) {
    ca_.Bind(&block104, &phi_bb104_8, &phi_bb104_9, &phi_bb104_10, &phi_bb104_11, &phi_bb104_13, &phi_bb104_14, &phi_bb104_20);
    std::tie(tmp248, tmp249) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb104_9}).Flatten();
    tmp250 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp251 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb104_9}, TNode<IntPtrT>{tmp250});
    ca_.Goto(&block103, phi_bb104_8, tmp251, phi_bb104_10, phi_bb104_11, phi_bb104_13, phi_bb104_14, phi_bb104_20, tmp248, tmp249);
  }

  TNode<IntPtrT> phi_bb105_8;
  TNode<IntPtrT> phi_bb105_9;
  TNode<IntPtrT> phi_bb105_10;
  TNode<IntPtrT> phi_bb105_11;
  TNode<IntPtrT> phi_bb105_13;
  TNode<BoolT> phi_bb105_14;
  TNode<IntPtrT> phi_bb105_20;
  if (block105.is_used()) {
    ca_.Bind(&block105, &phi_bb105_8, &phi_bb105_9, &phi_bb105_10, &phi_bb105_11, &phi_bb105_13, &phi_bb105_14, &phi_bb105_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block107, phi_bb105_8, phi_bb105_9, phi_bb105_10, phi_bb105_11, phi_bb105_13, phi_bb105_14, phi_bb105_20);
    } else {
      ca_.Goto(&block108, phi_bb105_8, phi_bb105_9, phi_bb105_10, phi_bb105_11, phi_bb105_13, phi_bb105_14, phi_bb105_20);
    }
  }

  TNode<IntPtrT> phi_bb107_8;
  TNode<IntPtrT> phi_bb107_9;
  TNode<IntPtrT> phi_bb107_10;
  TNode<IntPtrT> phi_bb107_11;
  TNode<IntPtrT> phi_bb107_13;
  TNode<BoolT> phi_bb107_14;
  TNode<IntPtrT> phi_bb107_20;
  TNode<Object> tmp252;
  TNode<IntPtrT> tmp253;
  TNode<IntPtrT> tmp254;
  TNode<IntPtrT> tmp255;
  if (block107.is_used()) {
    ca_.Bind(&block107, &phi_bb107_8, &phi_bb107_9, &phi_bb107_10, &phi_bb107_11, &phi_bb107_13, &phi_bb107_14, &phi_bb107_20);
    std::tie(tmp252, tmp253) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb107_11}).Flatten();
    tmp254 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp255 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb107_11}, TNode<IntPtrT>{tmp254});
    ca_.Goto(&block106, phi_bb107_8, phi_bb107_9, phi_bb107_10, tmp255, phi_bb107_13, phi_bb107_14, phi_bb107_20, tmp252, tmp253);
  }

  TNode<IntPtrT> phi_bb108_8;
  TNode<IntPtrT> phi_bb108_9;
  TNode<IntPtrT> phi_bb108_10;
  TNode<IntPtrT> phi_bb108_11;
  TNode<IntPtrT> phi_bb108_13;
  TNode<BoolT> phi_bb108_14;
  TNode<IntPtrT> phi_bb108_20;
  TNode<IntPtrT> tmp256;
  TNode<BoolT> tmp257;
  if (block108.is_used()) {
    ca_.Bind(&block108, &phi_bb108_8, &phi_bb108_9, &phi_bb108_10, &phi_bb108_11, &phi_bb108_13, &phi_bb108_14, &phi_bb108_20);
    tmp256 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp257 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb108_13}, TNode<IntPtrT>{tmp256});
    ca_.Branch(tmp257, &block110, std::vector<compiler::Node*>{phi_bb108_8, phi_bb108_9, phi_bb108_10, phi_bb108_11, phi_bb108_13, phi_bb108_14, phi_bb108_20}, &block111, std::vector<compiler::Node*>{phi_bb108_8, phi_bb108_9, phi_bb108_10, phi_bb108_11, phi_bb108_13, phi_bb108_14, phi_bb108_20});
  }

  TNode<IntPtrT> phi_bb110_8;
  TNode<IntPtrT> phi_bb110_9;
  TNode<IntPtrT> phi_bb110_10;
  TNode<IntPtrT> phi_bb110_11;
  TNode<IntPtrT> phi_bb110_13;
  TNode<BoolT> phi_bb110_14;
  TNode<IntPtrT> phi_bb110_20;
  TNode<Object> tmp258;
  TNode<IntPtrT> tmp259;
  TNode<IntPtrT> tmp260;
  TNode<BoolT> tmp261;
  if (block110.is_used()) {
    ca_.Bind(&block110, &phi_bb110_8, &phi_bb110_9, &phi_bb110_10, &phi_bb110_11, &phi_bb110_13, &phi_bb110_14, &phi_bb110_20);
    std::tie(tmp258, tmp259) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb110_13}).Flatten();
    tmp260 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp261 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block106, phi_bb110_8, phi_bb110_9, phi_bb110_10, phi_bb110_11, tmp260, tmp261, phi_bb110_20, tmp258, tmp259);
  }

  TNode<IntPtrT> phi_bb111_8;
  TNode<IntPtrT> phi_bb111_9;
  TNode<IntPtrT> phi_bb111_10;
  TNode<IntPtrT> phi_bb111_11;
  TNode<IntPtrT> phi_bb111_13;
  TNode<BoolT> phi_bb111_14;
  TNode<IntPtrT> phi_bb111_20;
  TNode<Object> tmp262;
  TNode<IntPtrT> tmp263;
  TNode<IntPtrT> tmp264;
  TNode<IntPtrT> tmp265;
  TNode<IntPtrT> tmp266;
  TNode<IntPtrT> tmp267;
  TNode<BoolT> tmp268;
  if (block111.is_used()) {
    ca_.Bind(&block111, &phi_bb111_8, &phi_bb111_9, &phi_bb111_10, &phi_bb111_11, &phi_bb111_13, &phi_bb111_14, &phi_bb111_20);
    std::tie(tmp262, tmp263) = NewReference_intptr_0(state_, TNode<Object>{tmp75}, TNode<IntPtrT>{phi_bb111_11}).Flatten();
    tmp264 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp265 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb111_11}, TNode<IntPtrT>{tmp264});
    tmp266 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp267 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp265}, TNode<IntPtrT>{tmp266});
    tmp268 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block106, phi_bb111_8, phi_bb111_9, phi_bb111_10, tmp267, tmp265, tmp268, phi_bb111_20, tmp262, tmp263);
  }

  TNode<IntPtrT> phi_bb106_8;
  TNode<IntPtrT> phi_bb106_9;
  TNode<IntPtrT> phi_bb106_10;
  TNode<IntPtrT> phi_bb106_11;
  TNode<IntPtrT> phi_bb106_13;
  TNode<BoolT> phi_bb106_14;
  TNode<IntPtrT> phi_bb106_20;
  TNode<Object> phi_bb106_23;
  TNode<IntPtrT> phi_bb106_24;
  if (block106.is_used()) {
    ca_.Bind(&block106, &phi_bb106_8, &phi_bb106_9, &phi_bb106_10, &phi_bb106_11, &phi_bb106_13, &phi_bb106_14, &phi_bb106_20, &phi_bb106_23, &phi_bb106_24);
    ca_.Goto(&block103, phi_bb106_8, phi_bb106_9, phi_bb106_10, phi_bb106_11, phi_bb106_13, phi_bb106_14, phi_bb106_20, phi_bb106_23, phi_bb106_24);
  }

  TNode<IntPtrT> phi_bb103_8;
  TNode<IntPtrT> phi_bb103_9;
  TNode<IntPtrT> phi_bb103_10;
  TNode<IntPtrT> phi_bb103_11;
  TNode<IntPtrT> phi_bb103_13;
  TNode<BoolT> phi_bb103_14;
  TNode<IntPtrT> phi_bb103_20;
  TNode<Object> phi_bb103_23;
  TNode<IntPtrT> phi_bb103_24;
  TNode<IntPtrT> tmp269;
  TNode<Object> tmp270;
  TNode<Object> tmp271;
  TNode<IntPtrT> tmp272;
  TNode<IntPtrT> tmp273;
  TNode<UintPtrT> tmp274;
  TNode<UintPtrT> tmp275;
  TNode<BoolT> tmp276;
  if (block103.is_used()) {
    ca_.Bind(&block103, &phi_bb103_8, &phi_bb103_9, &phi_bb103_10, &phi_bb103_11, &phi_bb103_13, &phi_bb103_14, &phi_bb103_20, &phi_bb103_23, &phi_bb103_24);
    tmp269 = CodeStubAssembler(state_).LoadReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb103_23, phi_bb103_24});
    tmp270 = CodeStubAssembler(state_).BitcastWordToTagged(TNode<IntPtrT>{tmp269});
    std::tie(tmp271, tmp272, tmp273) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp66}).Flatten();
    tmp274 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb103_20});
    tmp275 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp273});
    tmp276 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp274}, TNode<UintPtrT>{tmp275});
    ca_.Branch(tmp276, &block116, std::vector<compiler::Node*>{phi_bb103_8, phi_bb103_9, phi_bb103_10, phi_bb103_11, phi_bb103_13, phi_bb103_14, phi_bb103_20, phi_bb103_23, phi_bb103_24, phi_bb103_20, phi_bb103_20, phi_bb103_20, phi_bb103_20}, &block117, std::vector<compiler::Node*>{phi_bb103_8, phi_bb103_9, phi_bb103_10, phi_bb103_11, phi_bb103_13, phi_bb103_14, phi_bb103_20, phi_bb103_23, phi_bb103_24, phi_bb103_20, phi_bb103_20, phi_bb103_20, phi_bb103_20});
  }

  TNode<IntPtrT> phi_bb116_8;
  TNode<IntPtrT> phi_bb116_9;
  TNode<IntPtrT> phi_bb116_10;
  TNode<IntPtrT> phi_bb116_11;
  TNode<IntPtrT> phi_bb116_13;
  TNode<BoolT> phi_bb116_14;
  TNode<IntPtrT> phi_bb116_20;
  TNode<Object> phi_bb116_23;
  TNode<IntPtrT> phi_bb116_24;
  TNode<IntPtrT> phi_bb116_30;
  TNode<IntPtrT> phi_bb116_31;
  TNode<IntPtrT> phi_bb116_35;
  TNode<IntPtrT> phi_bb116_36;
  TNode<IntPtrT> tmp277;
  TNode<IntPtrT> tmp278;
  TNode<Object> tmp279;
  TNode<IntPtrT> tmp280;
  if (block116.is_used()) {
    ca_.Bind(&block116, &phi_bb116_8, &phi_bb116_9, &phi_bb116_10, &phi_bb116_11, &phi_bb116_13, &phi_bb116_14, &phi_bb116_20, &phi_bb116_23, &phi_bb116_24, &phi_bb116_30, &phi_bb116_31, &phi_bb116_35, &phi_bb116_36);
    tmp277 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb116_36});
    tmp278 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp272}, TNode<IntPtrT>{tmp277});
    std::tie(tmp279, tmp280) = NewReference_Object_0(state_, TNode<Object>{tmp271}, TNode<IntPtrT>{tmp278}).Flatten();
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp279, tmp280}, tmp270);
    ca_.Goto(&block90, tmp245, phi_bb116_8, phi_bb116_9, phi_bb116_10, phi_bb116_11, phi_bb116_13, phi_bb116_14, phi_bb116_20);
  }

  TNode<IntPtrT> phi_bb117_8;
  TNode<IntPtrT> phi_bb117_9;
  TNode<IntPtrT> phi_bb117_10;
  TNode<IntPtrT> phi_bb117_11;
  TNode<IntPtrT> phi_bb117_13;
  TNode<BoolT> phi_bb117_14;
  TNode<IntPtrT> phi_bb117_20;
  TNode<Object> phi_bb117_23;
  TNode<IntPtrT> phi_bb117_24;
  TNode<IntPtrT> phi_bb117_30;
  TNode<IntPtrT> phi_bb117_31;
  TNode<IntPtrT> phi_bb117_35;
  TNode<IntPtrT> phi_bb117_36;
  if (block117.is_used()) {
    ca_.Bind(&block117, &phi_bb117_8, &phi_bb117_9, &phi_bb117_10, &phi_bb117_11, &phi_bb117_13, &phi_bb117_14, &phi_bb117_20, &phi_bb117_23, &phi_bb117_24, &phi_bb117_30, &phi_bb117_31, &phi_bb117_35, &phi_bb117_36);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb90_7;
  TNode<IntPtrT> phi_bb90_8;
  TNode<IntPtrT> phi_bb90_9;
  TNode<IntPtrT> phi_bb90_10;
  TNode<IntPtrT> phi_bb90_11;
  TNode<IntPtrT> phi_bb90_13;
  TNode<BoolT> phi_bb90_14;
  TNode<IntPtrT> phi_bb90_20;
  if (block90.is_used()) {
    ca_.Bind(&block90, &phi_bb90_7, &phi_bb90_8, &phi_bb90_9, &phi_bb90_10, &phi_bb90_11, &phi_bb90_13, &phi_bb90_14, &phi_bb90_20);
    ca_.Goto(&block66, phi_bb90_7, phi_bb90_8, phi_bb90_9, phi_bb90_10, phi_bb90_11, phi_bb90_13, phi_bb90_14, phi_bb90_20);
  }

  TNode<IntPtrT> phi_bb66_7;
  TNode<IntPtrT> phi_bb66_8;
  TNode<IntPtrT> phi_bb66_9;
  TNode<IntPtrT> phi_bb66_10;
  TNode<IntPtrT> phi_bb66_11;
  TNode<IntPtrT> phi_bb66_13;
  TNode<BoolT> phi_bb66_14;
  TNode<IntPtrT> phi_bb66_20;
  if (block66.is_used()) {
    ca_.Bind(&block66, &phi_bb66_7, &phi_bb66_8, &phi_bb66_9, &phi_bb66_10, &phi_bb66_11, &phi_bb66_13, &phi_bb66_14, &phi_bb66_20);
    ca_.Goto(&block54, phi_bb66_7, phi_bb66_8, phi_bb66_9, phi_bb66_10, phi_bb66_11, phi_bb66_13, phi_bb66_14, phi_bb66_20);
  }

  TNode<IntPtrT> phi_bb54_7;
  TNode<IntPtrT> phi_bb54_8;
  TNode<IntPtrT> phi_bb54_9;
  TNode<IntPtrT> phi_bb54_10;
  TNode<IntPtrT> phi_bb54_11;
  TNode<IntPtrT> phi_bb54_13;
  TNode<BoolT> phi_bb54_14;
  TNode<IntPtrT> phi_bb54_20;
  if (block54.is_used()) {
    ca_.Bind(&block54, &phi_bb54_7, &phi_bb54_8, &phi_bb54_9, &phi_bb54_10, &phi_bb54_11, &phi_bb54_13, &phi_bb54_14, &phi_bb54_20);
    ca_.Goto(&block42, phi_bb54_7, phi_bb54_8, phi_bb54_9, phi_bb54_10, phi_bb54_11, phi_bb54_13, phi_bb54_14, phi_bb54_20);
  }

  TNode<IntPtrT> phi_bb42_7;
  TNode<IntPtrT> phi_bb42_8;
  TNode<IntPtrT> phi_bb42_9;
  TNode<IntPtrT> phi_bb42_10;
  TNode<IntPtrT> phi_bb42_11;
  TNode<IntPtrT> phi_bb42_13;
  TNode<BoolT> phi_bb42_14;
  TNode<IntPtrT> phi_bb42_20;
  TNode<IntPtrT> tmp281;
  TNode<IntPtrT> tmp282;
  if (block42.is_used()) {
    ca_.Bind(&block42, &phi_bb42_7, &phi_bb42_8, &phi_bb42_9, &phi_bb42_10, &phi_bb42_11, &phi_bb42_13, &phi_bb42_14, &phi_bb42_20);
    tmp281 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp282 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb42_20}, TNode<IntPtrT>{tmp281});
    ca_.Goto(&block37, phi_bb42_7, phi_bb42_8, phi_bb42_9, phi_bb42_10, phi_bb42_11, phi_bb42_13, phi_bb42_14, tmp282);
  }

  TNode<IntPtrT> phi_bb36_7;
  TNode<IntPtrT> phi_bb36_8;
  TNode<IntPtrT> phi_bb36_9;
  TNode<IntPtrT> phi_bb36_10;
  TNode<IntPtrT> phi_bb36_11;
  TNode<IntPtrT> phi_bb36_13;
  TNode<BoolT> phi_bb36_14;
  TNode<IntPtrT> phi_bb36_20;
  if (block36.is_used()) {
    ca_.Bind(&block36, &phi_bb36_7, &phi_bb36_8, &phi_bb36_9, &phi_bb36_10, &phi_bb36_11, &phi_bb36_13, &phi_bb36_14, &phi_bb36_20);
    ca_.Goto(&block34, phi_bb36_7, phi_bb36_8, phi_bb36_9, phi_bb36_10, phi_bb36_11, phi_bb36_13, phi_bb36_14);
  }

  TNode<IntPtrT> phi_bb34_7;
  TNode<IntPtrT> phi_bb34_8;
  TNode<IntPtrT> phi_bb34_9;
  TNode<IntPtrT> phi_bb34_10;
  TNode<IntPtrT> phi_bb34_11;
  TNode<IntPtrT> phi_bb34_13;
  TNode<BoolT> phi_bb34_14;
  TNode<IntPtrT> tmp283;
  TNode<RawPtrT> tmp284;
  TNode<IntPtrT> tmp285;
  TNode<RawPtrT> tmp286;
  TNode<Object> tmp287;
  TNode<IntPtrT> tmp288;
  TNode<IntPtrT> tmp289;
  TNode<IntPtrT> tmp290;
  TNode<IntPtrT> tmp291;
  TNode<IntPtrT> tmp292;
  TNode<IntPtrT> tmp293;
  TNode<IntPtrT> tmp294;
  TNode<BoolT> tmp295;
  TNode<IntPtrT> tmp296;
  if (block34.is_used()) {
    ca_.Bind(&block34, &phi_bb34_7, &phi_bb34_8, &phi_bb34_9, &phi_bb34_10, &phi_bb34_11, &phi_bb34_13, &phi_bb34_14);
    tmp283 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferGPReturnRegister1);
    tmp284 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp283});
    tmp285 = FromConstexpr_intptr_constexpr_intptr_0(state_, JSToWasmWrapperFrameConstants::kWrapperBufferFPReturnRegister1);
    tmp286 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{parameter2}, TNode<IntPtrT>{tmp285});
    std::tie(tmp287, tmp288, tmp289, tmp290, tmp291, tmp292, tmp293, tmp294, tmp295) = LocationAllocatorForReturns_0(state_, TNode<RawPtrT>{tmp284}, TNode<RawPtrT>{tmp286}, TNode<RawPtrT>{tmp70}).Flatten();
    tmp296 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    ca_.Goto(&block122, tmp288, tmp289, tmp290, tmp291, tmp292, tmp294, tmp295, tmp296);
  }

  TNode<IntPtrT> phi_bb122_7;
  TNode<IntPtrT> phi_bb122_8;
  TNode<IntPtrT> phi_bb122_9;
  TNode<IntPtrT> phi_bb122_10;
  TNode<IntPtrT> phi_bb122_11;
  TNode<IntPtrT> phi_bb122_13;
  TNode<BoolT> phi_bb122_14;
  TNode<IntPtrT> phi_bb122_20;
  TNode<IntPtrT> tmp297;
  TNode<BoolT> tmp298;
  if (block122.is_used()) {
    ca_.Bind(&block122, &phi_bb122_7, &phi_bb122_8, &phi_bb122_9, &phi_bb122_10, &phi_bb122_11, &phi_bb122_13, &phi_bb122_14, &phi_bb122_20);
    tmp297 = Convert_intptr_int32_0(state_, TNode<Int32T>{tmp3});
    tmp298 = CodeStubAssembler(state_).IntPtrLessThan(TNode<IntPtrT>{phi_bb122_20}, TNode<IntPtrT>{tmp297});
    ca_.Branch(tmp298, &block120, std::vector<compiler::Node*>{phi_bb122_7, phi_bb122_8, phi_bb122_9, phi_bb122_10, phi_bb122_11, phi_bb122_13, phi_bb122_14, phi_bb122_20}, &block121, std::vector<compiler::Node*>{phi_bb122_7, phi_bb122_8, phi_bb122_9, phi_bb122_10, phi_bb122_11, phi_bb122_13, phi_bb122_14, phi_bb122_20});
  }

  TNode<IntPtrT> phi_bb120_7;
  TNode<IntPtrT> phi_bb120_8;
  TNode<IntPtrT> phi_bb120_9;
  TNode<IntPtrT> phi_bb120_10;
  TNode<IntPtrT> phi_bb120_11;
  TNode<IntPtrT> phi_bb120_13;
  TNode<BoolT> phi_bb120_14;
  TNode<IntPtrT> phi_bb120_20;
  TNode<IntPtrT> tmp299;
  TNode<IntPtrT> tmp300;
  TNode<IntPtrT> tmp301;
  TNode<Object> tmp302;
  TNode<IntPtrT> tmp303;
  TNode<Int32T> tmp304;
  TNode<Int32T> tmp305;
  TNode<BoolT> tmp306;
  if (block120.is_used()) {
    ca_.Bind(&block120, &phi_bb120_7, &phi_bb120_8, &phi_bb120_9, &phi_bb120_10, &phi_bb120_11, &phi_bb120_13, &phi_bb120_14, &phi_bb120_20);
    tmp299 = Convert_intptr_intptr_0(state_, TNode<IntPtrT>{phi_bb120_20});
    tmp300 = TimesSizeOf_int32_0(state_, TNode<IntPtrT>{tmp299});
    tmp301 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp91}, TNode<IntPtrT>{tmp300});
    std::tie(tmp302, tmp303) = NewReference_int32_0(state_, TNode<Object>{tmp90}, TNode<IntPtrT>{tmp301}).Flatten();
    tmp304 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp302, tmp303});
    tmp305 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI32.raw_bit_field());
    tmp306 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp304}, TNode<Int32T>{tmp305});
    ca_.Branch(tmp306, &block125, std::vector<compiler::Node*>{phi_bb120_7, phi_bb120_8, phi_bb120_9, phi_bb120_10, phi_bb120_11, phi_bb120_13, phi_bb120_14, phi_bb120_20}, &block126, std::vector<compiler::Node*>{phi_bb120_7, phi_bb120_8, phi_bb120_9, phi_bb120_10, phi_bb120_11, phi_bb120_13, phi_bb120_14, phi_bb120_20});
  }

  TNode<IntPtrT> phi_bb125_7;
  TNode<IntPtrT> phi_bb125_8;
  TNode<IntPtrT> phi_bb125_9;
  TNode<IntPtrT> phi_bb125_10;
  TNode<IntPtrT> phi_bb125_11;
  TNode<IntPtrT> phi_bb125_13;
  TNode<BoolT> phi_bb125_14;
  TNode<IntPtrT> phi_bb125_20;
  TNode<IntPtrT> tmp307;
  TNode<IntPtrT> tmp308;
  TNode<IntPtrT> tmp309;
  TNode<BoolT> tmp310;
  if (block125.is_used()) {
    ca_.Bind(&block125, &phi_bb125_7, &phi_bb125_8, &phi_bb125_9, &phi_bb125_10, &phi_bb125_11, &phi_bb125_13, &phi_bb125_14, &phi_bb125_20);
    tmp307 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp308 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb125_7}, TNode<IntPtrT>{tmp307});
    tmp309 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp310 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb125_7}, TNode<IntPtrT>{tmp309});
    ca_.Branch(tmp310, &block129, std::vector<compiler::Node*>{phi_bb125_8, phi_bb125_9, phi_bb125_10, phi_bb125_11, phi_bb125_13, phi_bb125_14, phi_bb125_20}, &block130, std::vector<compiler::Node*>{phi_bb125_8, phi_bb125_9, phi_bb125_10, phi_bb125_11, phi_bb125_13, phi_bb125_14, phi_bb125_20});
  }

  TNode<IntPtrT> phi_bb129_8;
  TNode<IntPtrT> phi_bb129_9;
  TNode<IntPtrT> phi_bb129_10;
  TNode<IntPtrT> phi_bb129_11;
  TNode<IntPtrT> phi_bb129_13;
  TNode<BoolT> phi_bb129_14;
  TNode<IntPtrT> phi_bb129_20;
  TNode<Object> tmp311;
  TNode<IntPtrT> tmp312;
  TNode<IntPtrT> tmp313;
  TNode<IntPtrT> tmp314;
  if (block129.is_used()) {
    ca_.Bind(&block129, &phi_bb129_8, &phi_bb129_9, &phi_bb129_10, &phi_bb129_11, &phi_bb129_13, &phi_bb129_14, &phi_bb129_20);
    std::tie(tmp311, tmp312) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb129_9}).Flatten();
    tmp313 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp314 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb129_9}, TNode<IntPtrT>{tmp313});
    ca_.Goto(&block128, phi_bb129_8, tmp314, phi_bb129_10, phi_bb129_11, phi_bb129_13, phi_bb129_14, phi_bb129_20, tmp311, tmp312);
  }

  TNode<IntPtrT> phi_bb130_8;
  TNode<IntPtrT> phi_bb130_9;
  TNode<IntPtrT> phi_bb130_10;
  TNode<IntPtrT> phi_bb130_11;
  TNode<IntPtrT> phi_bb130_13;
  TNode<BoolT> phi_bb130_14;
  TNode<IntPtrT> phi_bb130_20;
  if (block130.is_used()) {
    ca_.Bind(&block130, &phi_bb130_8, &phi_bb130_9, &phi_bb130_10, &phi_bb130_11, &phi_bb130_13, &phi_bb130_14, &phi_bb130_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block132, phi_bb130_8, phi_bb130_9, phi_bb130_10, phi_bb130_11, phi_bb130_13, phi_bb130_14, phi_bb130_20);
    } else {
      ca_.Goto(&block133, phi_bb130_8, phi_bb130_9, phi_bb130_10, phi_bb130_11, phi_bb130_13, phi_bb130_14, phi_bb130_20);
    }
  }

  TNode<IntPtrT> phi_bb132_8;
  TNode<IntPtrT> phi_bb132_9;
  TNode<IntPtrT> phi_bb132_10;
  TNode<IntPtrT> phi_bb132_11;
  TNode<IntPtrT> phi_bb132_13;
  TNode<BoolT> phi_bb132_14;
  TNode<IntPtrT> phi_bb132_20;
  TNode<Object> tmp315;
  TNode<IntPtrT> tmp316;
  TNode<IntPtrT> tmp317;
  TNode<IntPtrT> tmp318;
  if (block132.is_used()) {
    ca_.Bind(&block132, &phi_bb132_8, &phi_bb132_9, &phi_bb132_10, &phi_bb132_11, &phi_bb132_13, &phi_bb132_14, &phi_bb132_20);
    std::tie(tmp315, tmp316) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb132_11}).Flatten();
    tmp317 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp318 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb132_11}, TNode<IntPtrT>{tmp317});
    ca_.Goto(&block131, phi_bb132_8, phi_bb132_9, phi_bb132_10, tmp318, phi_bb132_13, phi_bb132_14, phi_bb132_20, tmp315, tmp316);
  }

  TNode<IntPtrT> phi_bb133_8;
  TNode<IntPtrT> phi_bb133_9;
  TNode<IntPtrT> phi_bb133_10;
  TNode<IntPtrT> phi_bb133_11;
  TNode<IntPtrT> phi_bb133_13;
  TNode<BoolT> phi_bb133_14;
  TNode<IntPtrT> phi_bb133_20;
  TNode<IntPtrT> tmp319;
  TNode<BoolT> tmp320;
  if (block133.is_used()) {
    ca_.Bind(&block133, &phi_bb133_8, &phi_bb133_9, &phi_bb133_10, &phi_bb133_11, &phi_bb133_13, &phi_bb133_14, &phi_bb133_20);
    tmp319 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp320 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb133_13}, TNode<IntPtrT>{tmp319});
    ca_.Branch(tmp320, &block135, std::vector<compiler::Node*>{phi_bb133_8, phi_bb133_9, phi_bb133_10, phi_bb133_11, phi_bb133_13, phi_bb133_14, phi_bb133_20}, &block136, std::vector<compiler::Node*>{phi_bb133_8, phi_bb133_9, phi_bb133_10, phi_bb133_11, phi_bb133_13, phi_bb133_14, phi_bb133_20});
  }

  TNode<IntPtrT> phi_bb135_8;
  TNode<IntPtrT> phi_bb135_9;
  TNode<IntPtrT> phi_bb135_10;
  TNode<IntPtrT> phi_bb135_11;
  TNode<IntPtrT> phi_bb135_13;
  TNode<BoolT> phi_bb135_14;
  TNode<IntPtrT> phi_bb135_20;
  TNode<Object> tmp321;
  TNode<IntPtrT> tmp322;
  TNode<IntPtrT> tmp323;
  TNode<BoolT> tmp324;
  if (block135.is_used()) {
    ca_.Bind(&block135, &phi_bb135_8, &phi_bb135_9, &phi_bb135_10, &phi_bb135_11, &phi_bb135_13, &phi_bb135_14, &phi_bb135_20);
    std::tie(tmp321, tmp322) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb135_13}).Flatten();
    tmp323 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp324 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block131, phi_bb135_8, phi_bb135_9, phi_bb135_10, phi_bb135_11, tmp323, tmp324, phi_bb135_20, tmp321, tmp322);
  }

  TNode<IntPtrT> phi_bb136_8;
  TNode<IntPtrT> phi_bb136_9;
  TNode<IntPtrT> phi_bb136_10;
  TNode<IntPtrT> phi_bb136_11;
  TNode<IntPtrT> phi_bb136_13;
  TNode<BoolT> phi_bb136_14;
  TNode<IntPtrT> phi_bb136_20;
  TNode<Object> tmp325;
  TNode<IntPtrT> tmp326;
  TNode<IntPtrT> tmp327;
  TNode<IntPtrT> tmp328;
  TNode<IntPtrT> tmp329;
  TNode<IntPtrT> tmp330;
  TNode<BoolT> tmp331;
  if (block136.is_used()) {
    ca_.Bind(&block136, &phi_bb136_8, &phi_bb136_9, &phi_bb136_10, &phi_bb136_11, &phi_bb136_13, &phi_bb136_14, &phi_bb136_20);
    std::tie(tmp325, tmp326) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb136_11}).Flatten();
    tmp327 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp328 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb136_11}, TNode<IntPtrT>{tmp327});
    tmp329 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp330 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp328}, TNode<IntPtrT>{tmp329});
    tmp331 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block131, phi_bb136_8, phi_bb136_9, phi_bb136_10, tmp330, tmp328, tmp331, phi_bb136_20, tmp325, tmp326);
  }

  TNode<IntPtrT> phi_bb131_8;
  TNode<IntPtrT> phi_bb131_9;
  TNode<IntPtrT> phi_bb131_10;
  TNode<IntPtrT> phi_bb131_11;
  TNode<IntPtrT> phi_bb131_13;
  TNode<BoolT> phi_bb131_14;
  TNode<IntPtrT> phi_bb131_20;
  TNode<Object> phi_bb131_22;
  TNode<IntPtrT> phi_bb131_23;
  if (block131.is_used()) {
    ca_.Bind(&block131, &phi_bb131_8, &phi_bb131_9, &phi_bb131_10, &phi_bb131_11, &phi_bb131_13, &phi_bb131_14, &phi_bb131_20, &phi_bb131_22, &phi_bb131_23);
    ca_.Goto(&block128, phi_bb131_8, phi_bb131_9, phi_bb131_10, phi_bb131_11, phi_bb131_13, phi_bb131_14, phi_bb131_20, phi_bb131_22, phi_bb131_23);
  }

  TNode<IntPtrT> phi_bb128_8;
  TNode<IntPtrT> phi_bb128_9;
  TNode<IntPtrT> phi_bb128_10;
  TNode<IntPtrT> phi_bb128_11;
  TNode<IntPtrT> phi_bb128_13;
  TNode<BoolT> phi_bb128_14;
  TNode<IntPtrT> phi_bb128_20;
  TNode<Object> phi_bb128_22;
  TNode<IntPtrT> phi_bb128_23;
  TNode<Object> tmp332;
  TNode<IntPtrT> tmp333;
  TNode<Int32T> tmp334;
  TNode<Object> tmp335;
  TNode<IntPtrT> tmp336;
  TNode<IntPtrT> tmp337;
  TNode<UintPtrT> tmp338;
  TNode<UintPtrT> tmp339;
  TNode<BoolT> tmp340;
  if (block128.is_used()) {
    ca_.Bind(&block128, &phi_bb128_8, &phi_bb128_9, &phi_bb128_10, &phi_bb128_11, &phi_bb128_13, &phi_bb128_14, &phi_bb128_20, &phi_bb128_22, &phi_bb128_23);
    std::tie(tmp332, tmp333) = RefCast_int32_0(state_, TorqueStructReference_intptr_0{TNode<Object>{phi_bb128_22}, TNode<IntPtrT>{phi_bb128_23}, TorqueStructUnsafe_0{}}).Flatten();
    tmp334 = CodeStubAssembler(state_).LoadReference<Int32T>(CodeStubAssembler::Reference{tmp332, tmp333});
    std::tie(tmp335, tmp336, tmp337) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp66}).Flatten();
    tmp338 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb128_20});
    tmp339 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp337});
    tmp340 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp338}, TNode<UintPtrT>{tmp339});
    ca_.Branch(tmp340, &block141, std::vector<compiler::Node*>{phi_bb128_8, phi_bb128_9, phi_bb128_10, phi_bb128_11, phi_bb128_13, phi_bb128_14, phi_bb128_20, phi_bb128_22, phi_bb128_23, phi_bb128_20, phi_bb128_20, phi_bb128_20, phi_bb128_20}, &block142, std::vector<compiler::Node*>{phi_bb128_8, phi_bb128_9, phi_bb128_10, phi_bb128_11, phi_bb128_13, phi_bb128_14, phi_bb128_20, phi_bb128_22, phi_bb128_23, phi_bb128_20, phi_bb128_20, phi_bb128_20, phi_bb128_20});
  }

  TNode<IntPtrT> phi_bb141_8;
  TNode<IntPtrT> phi_bb141_9;
  TNode<IntPtrT> phi_bb141_10;
  TNode<IntPtrT> phi_bb141_11;
  TNode<IntPtrT> phi_bb141_13;
  TNode<BoolT> phi_bb141_14;
  TNode<IntPtrT> phi_bb141_20;
  TNode<Object> phi_bb141_22;
  TNode<IntPtrT> phi_bb141_23;
  TNode<IntPtrT> phi_bb141_29;
  TNode<IntPtrT> phi_bb141_30;
  TNode<IntPtrT> phi_bb141_34;
  TNode<IntPtrT> phi_bb141_35;
  TNode<IntPtrT> tmp341;
  TNode<IntPtrT> tmp342;
  TNode<Object> tmp343;
  TNode<IntPtrT> tmp344;
  TNode<Number> tmp345;
  if (block141.is_used()) {
    ca_.Bind(&block141, &phi_bb141_8, &phi_bb141_9, &phi_bb141_10, &phi_bb141_11, &phi_bb141_13, &phi_bb141_14, &phi_bb141_20, &phi_bb141_22, &phi_bb141_23, &phi_bb141_29, &phi_bb141_30, &phi_bb141_34, &phi_bb141_35);
    tmp341 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb141_35});
    tmp342 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp336}, TNode<IntPtrT>{tmp341});
    std::tie(tmp343, tmp344) = NewReference_Object_0(state_, TNode<Object>{tmp335}, TNode<IntPtrT>{tmp342}).Flatten();
    tmp345 = Convert_Number_int32_0(state_, TNode<Int32T>{tmp334});
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp343, tmp344}, tmp345);
    ca_.Goto(&block127, tmp308, phi_bb141_8, phi_bb141_9, phi_bb141_10, phi_bb141_11, phi_bb141_13, phi_bb141_14, phi_bb141_20);
  }

  TNode<IntPtrT> phi_bb142_8;
  TNode<IntPtrT> phi_bb142_9;
  TNode<IntPtrT> phi_bb142_10;
  TNode<IntPtrT> phi_bb142_11;
  TNode<IntPtrT> phi_bb142_13;
  TNode<BoolT> phi_bb142_14;
  TNode<IntPtrT> phi_bb142_20;
  TNode<Object> phi_bb142_22;
  TNode<IntPtrT> phi_bb142_23;
  TNode<IntPtrT> phi_bb142_29;
  TNode<IntPtrT> phi_bb142_30;
  TNode<IntPtrT> phi_bb142_34;
  TNode<IntPtrT> phi_bb142_35;
  if (block142.is_used()) {
    ca_.Bind(&block142, &phi_bb142_8, &phi_bb142_9, &phi_bb142_10, &phi_bb142_11, &phi_bb142_13, &phi_bb142_14, &phi_bb142_20, &phi_bb142_22, &phi_bb142_23, &phi_bb142_29, &phi_bb142_30, &phi_bb142_34, &phi_bb142_35);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb126_7;
  TNode<IntPtrT> phi_bb126_8;
  TNode<IntPtrT> phi_bb126_9;
  TNode<IntPtrT> phi_bb126_10;
  TNode<IntPtrT> phi_bb126_11;
  TNode<IntPtrT> phi_bb126_13;
  TNode<BoolT> phi_bb126_14;
  TNode<IntPtrT> phi_bb126_20;
  TNode<Int32T> tmp346;
  TNode<BoolT> tmp347;
  if (block126.is_used()) {
    ca_.Bind(&block126, &phi_bb126_7, &phi_bb126_8, &phi_bb126_9, &phi_bb126_10, &phi_bb126_11, &phi_bb126_13, &phi_bb126_14, &phi_bb126_20);
    tmp346 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF32.raw_bit_field());
    tmp347 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp304}, TNode<Int32T>{tmp346});
    ca_.Branch(tmp347, &block145, std::vector<compiler::Node*>{phi_bb126_7, phi_bb126_8, phi_bb126_9, phi_bb126_10, phi_bb126_11, phi_bb126_13, phi_bb126_14, phi_bb126_20}, &block146, std::vector<compiler::Node*>{phi_bb126_7, phi_bb126_8, phi_bb126_9, phi_bb126_10, phi_bb126_11, phi_bb126_13, phi_bb126_14, phi_bb126_20});
  }

  TNode<IntPtrT> phi_bb145_7;
  TNode<IntPtrT> phi_bb145_8;
  TNode<IntPtrT> phi_bb145_9;
  TNode<IntPtrT> phi_bb145_10;
  TNode<IntPtrT> phi_bb145_11;
  TNode<IntPtrT> phi_bb145_13;
  TNode<BoolT> phi_bb145_14;
  TNode<IntPtrT> phi_bb145_20;
  TNode<IntPtrT> tmp348;
  TNode<IntPtrT> tmp349;
  TNode<IntPtrT> tmp350;
  TNode<BoolT> tmp351;
  if (block145.is_used()) {
    ca_.Bind(&block145, &phi_bb145_7, &phi_bb145_8, &phi_bb145_9, &phi_bb145_10, &phi_bb145_11, &phi_bb145_13, &phi_bb145_14, &phi_bb145_20);
    tmp348 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp349 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb145_8}, TNode<IntPtrT>{tmp348});
    tmp350 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp351 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb145_8}, TNode<IntPtrT>{tmp350});
    ca_.Branch(tmp351, &block149, std::vector<compiler::Node*>{phi_bb145_7, phi_bb145_9, phi_bb145_10, phi_bb145_11, phi_bb145_13, phi_bb145_14, phi_bb145_20}, &block150, std::vector<compiler::Node*>{phi_bb145_7, phi_bb145_9, phi_bb145_10, phi_bb145_11, phi_bb145_13, phi_bb145_14, phi_bb145_20});
  }

  TNode<IntPtrT> phi_bb149_7;
  TNode<IntPtrT> phi_bb149_9;
  TNode<IntPtrT> phi_bb149_10;
  TNode<IntPtrT> phi_bb149_11;
  TNode<IntPtrT> phi_bb149_13;
  TNode<BoolT> phi_bb149_14;
  TNode<IntPtrT> phi_bb149_20;
  TNode<Object> tmp352;
  TNode<IntPtrT> tmp353;
  TNode<IntPtrT> tmp354;
  TNode<IntPtrT> tmp355;
  if (block149.is_used()) {
    ca_.Bind(&block149, &phi_bb149_7, &phi_bb149_9, &phi_bb149_10, &phi_bb149_11, &phi_bb149_13, &phi_bb149_14, &phi_bb149_20);
    std::tie(tmp352, tmp353) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb149_10}).Flatten();
    tmp354 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_float64_0(state_)));
    tmp355 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb149_10}, TNode<IntPtrT>{tmp354});
    ca_.Goto(&block148, phi_bb149_7, phi_bb149_9, tmp355, phi_bb149_11, phi_bb149_13, phi_bb149_14, phi_bb149_20, tmp352, tmp353);
  }

  TNode<IntPtrT> phi_bb150_7;
  TNode<IntPtrT> phi_bb150_9;
  TNode<IntPtrT> phi_bb150_10;
  TNode<IntPtrT> phi_bb150_11;
  TNode<IntPtrT> phi_bb150_13;
  TNode<BoolT> phi_bb150_14;
  TNode<IntPtrT> phi_bb150_20;
  if (block150.is_used()) {
    ca_.Bind(&block150, &phi_bb150_7, &phi_bb150_9, &phi_bb150_10, &phi_bb150_11, &phi_bb150_13, &phi_bb150_14, &phi_bb150_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block152, phi_bb150_7, phi_bb150_9, phi_bb150_10, phi_bb150_11, phi_bb150_13, phi_bb150_14, phi_bb150_20);
    } else {
      ca_.Goto(&block153, phi_bb150_7, phi_bb150_9, phi_bb150_10, phi_bb150_11, phi_bb150_13, phi_bb150_14, phi_bb150_20);
    }
  }

  TNode<IntPtrT> phi_bb152_7;
  TNode<IntPtrT> phi_bb152_9;
  TNode<IntPtrT> phi_bb152_10;
  TNode<IntPtrT> phi_bb152_11;
  TNode<IntPtrT> phi_bb152_13;
  TNode<BoolT> phi_bb152_14;
  TNode<IntPtrT> phi_bb152_20;
  TNode<Object> tmp356;
  TNode<IntPtrT> tmp357;
  TNode<IntPtrT> tmp358;
  TNode<IntPtrT> tmp359;
  if (block152.is_used()) {
    ca_.Bind(&block152, &phi_bb152_7, &phi_bb152_9, &phi_bb152_10, &phi_bb152_11, &phi_bb152_13, &phi_bb152_14, &phi_bb152_20);
    std::tie(tmp356, tmp357) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb152_11}).Flatten();
    tmp358 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp359 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb152_11}, TNode<IntPtrT>{tmp358});
    ca_.Goto(&block151, phi_bb152_7, phi_bb152_9, phi_bb152_10, tmp359, phi_bb152_13, phi_bb152_14, phi_bb152_20, tmp356, tmp357);
  }

  TNode<IntPtrT> phi_bb153_7;
  TNode<IntPtrT> phi_bb153_9;
  TNode<IntPtrT> phi_bb153_10;
  TNode<IntPtrT> phi_bb153_11;
  TNode<IntPtrT> phi_bb153_13;
  TNode<BoolT> phi_bb153_14;
  TNode<IntPtrT> phi_bb153_20;
  TNode<IntPtrT> tmp360;
  TNode<BoolT> tmp361;
  if (block153.is_used()) {
    ca_.Bind(&block153, &phi_bb153_7, &phi_bb153_9, &phi_bb153_10, &phi_bb153_11, &phi_bb153_13, &phi_bb153_14, &phi_bb153_20);
    tmp360 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp361 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb153_13}, TNode<IntPtrT>{tmp360});
    ca_.Branch(tmp361, &block155, std::vector<compiler::Node*>{phi_bb153_7, phi_bb153_9, phi_bb153_10, phi_bb153_11, phi_bb153_13, phi_bb153_14, phi_bb153_20}, &block156, std::vector<compiler::Node*>{phi_bb153_7, phi_bb153_9, phi_bb153_10, phi_bb153_11, phi_bb153_13, phi_bb153_14, phi_bb153_20});
  }

  TNode<IntPtrT> phi_bb155_7;
  TNode<IntPtrT> phi_bb155_9;
  TNode<IntPtrT> phi_bb155_10;
  TNode<IntPtrT> phi_bb155_11;
  TNode<IntPtrT> phi_bb155_13;
  TNode<BoolT> phi_bb155_14;
  TNode<IntPtrT> phi_bb155_20;
  TNode<Object> tmp362;
  TNode<IntPtrT> tmp363;
  TNode<IntPtrT> tmp364;
  TNode<BoolT> tmp365;
  if (block155.is_used()) {
    ca_.Bind(&block155, &phi_bb155_7, &phi_bb155_9, &phi_bb155_10, &phi_bb155_11, &phi_bb155_13, &phi_bb155_14, &phi_bb155_20);
    std::tie(tmp362, tmp363) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb155_13}).Flatten();
    tmp364 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp365 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block151, phi_bb155_7, phi_bb155_9, phi_bb155_10, phi_bb155_11, tmp364, tmp365, phi_bb155_20, tmp362, tmp363);
  }

  TNode<IntPtrT> phi_bb156_7;
  TNode<IntPtrT> phi_bb156_9;
  TNode<IntPtrT> phi_bb156_10;
  TNode<IntPtrT> phi_bb156_11;
  TNode<IntPtrT> phi_bb156_13;
  TNode<BoolT> phi_bb156_14;
  TNode<IntPtrT> phi_bb156_20;
  TNode<Object> tmp366;
  TNode<IntPtrT> tmp367;
  TNode<IntPtrT> tmp368;
  TNode<IntPtrT> tmp369;
  TNode<IntPtrT> tmp370;
  TNode<IntPtrT> tmp371;
  TNode<BoolT> tmp372;
  if (block156.is_used()) {
    ca_.Bind(&block156, &phi_bb156_7, &phi_bb156_9, &phi_bb156_10, &phi_bb156_11, &phi_bb156_13, &phi_bb156_14, &phi_bb156_20);
    std::tie(tmp366, tmp367) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb156_11}).Flatten();
    tmp368 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp369 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb156_11}, TNode<IntPtrT>{tmp368});
    tmp370 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp371 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp369}, TNode<IntPtrT>{tmp370});
    tmp372 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block151, phi_bb156_7, phi_bb156_9, phi_bb156_10, tmp371, tmp369, tmp372, phi_bb156_20, tmp366, tmp367);
  }

  TNode<IntPtrT> phi_bb151_7;
  TNode<IntPtrT> phi_bb151_9;
  TNode<IntPtrT> phi_bb151_10;
  TNode<IntPtrT> phi_bb151_11;
  TNode<IntPtrT> phi_bb151_13;
  TNode<BoolT> phi_bb151_14;
  TNode<IntPtrT> phi_bb151_20;
  TNode<Object> phi_bb151_22;
  TNode<IntPtrT> phi_bb151_23;
  if (block151.is_used()) {
    ca_.Bind(&block151, &phi_bb151_7, &phi_bb151_9, &phi_bb151_10, &phi_bb151_11, &phi_bb151_13, &phi_bb151_14, &phi_bb151_20, &phi_bb151_22, &phi_bb151_23);
    ca_.Goto(&block148, phi_bb151_7, phi_bb151_9, phi_bb151_10, phi_bb151_11, phi_bb151_13, phi_bb151_14, phi_bb151_20, phi_bb151_22, phi_bb151_23);
  }

  TNode<IntPtrT> phi_bb148_7;
  TNode<IntPtrT> phi_bb148_9;
  TNode<IntPtrT> phi_bb148_10;
  TNode<IntPtrT> phi_bb148_11;
  TNode<IntPtrT> phi_bb148_13;
  TNode<BoolT> phi_bb148_14;
  TNode<IntPtrT> phi_bb148_20;
  TNode<Object> phi_bb148_22;
  TNode<IntPtrT> phi_bb148_23;
  TNode<Object> tmp373;
  TNode<IntPtrT> tmp374;
  TNode<Float32T> tmp375;
  TNode<Object> tmp376;
  TNode<IntPtrT> tmp377;
  TNode<IntPtrT> tmp378;
  TNode<UintPtrT> tmp379;
  TNode<UintPtrT> tmp380;
  TNode<BoolT> tmp381;
  if (block148.is_used()) {
    ca_.Bind(&block148, &phi_bb148_7, &phi_bb148_9, &phi_bb148_10, &phi_bb148_11, &phi_bb148_13, &phi_bb148_14, &phi_bb148_20, &phi_bb148_22, &phi_bb148_23);
    std::tie(tmp373, tmp374) = RefCast_float32_0(state_, TorqueStructReference_intptr_0{TNode<Object>{phi_bb148_22}, TNode<IntPtrT>{phi_bb148_23}, TorqueStructUnsafe_0{}}).Flatten();
    tmp375 = CodeStubAssembler(state_).LoadReference<Float32T>(CodeStubAssembler::Reference{tmp373, tmp374});
    std::tie(tmp376, tmp377, tmp378) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp66}).Flatten();
    tmp379 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb148_20});
    tmp380 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp378});
    tmp381 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp379}, TNode<UintPtrT>{tmp380});
    ca_.Branch(tmp381, &block161, std::vector<compiler::Node*>{phi_bb148_7, phi_bb148_9, phi_bb148_10, phi_bb148_11, phi_bb148_13, phi_bb148_14, phi_bb148_20, phi_bb148_22, phi_bb148_23, phi_bb148_20, phi_bb148_20, phi_bb148_20, phi_bb148_20}, &block162, std::vector<compiler::Node*>{phi_bb148_7, phi_bb148_9, phi_bb148_10, phi_bb148_11, phi_bb148_13, phi_bb148_14, phi_bb148_20, phi_bb148_22, phi_bb148_23, phi_bb148_20, phi_bb148_20, phi_bb148_20, phi_bb148_20});
  }

  TNode<IntPtrT> phi_bb161_7;
  TNode<IntPtrT> phi_bb161_9;
  TNode<IntPtrT> phi_bb161_10;
  TNode<IntPtrT> phi_bb161_11;
  TNode<IntPtrT> phi_bb161_13;
  TNode<BoolT> phi_bb161_14;
  TNode<IntPtrT> phi_bb161_20;
  TNode<Object> phi_bb161_22;
  TNode<IntPtrT> phi_bb161_23;
  TNode<IntPtrT> phi_bb161_29;
  TNode<IntPtrT> phi_bb161_30;
  TNode<IntPtrT> phi_bb161_34;
  TNode<IntPtrT> phi_bb161_35;
  TNode<IntPtrT> tmp382;
  TNode<IntPtrT> tmp383;
  TNode<Object> tmp384;
  TNode<IntPtrT> tmp385;
  TNode<Number> tmp386;
  if (block161.is_used()) {
    ca_.Bind(&block161, &phi_bb161_7, &phi_bb161_9, &phi_bb161_10, &phi_bb161_11, &phi_bb161_13, &phi_bb161_14, &phi_bb161_20, &phi_bb161_22, &phi_bb161_23, &phi_bb161_29, &phi_bb161_30, &phi_bb161_34, &phi_bb161_35);
    tmp382 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb161_35});
    tmp383 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp377}, TNode<IntPtrT>{tmp382});
    std::tie(tmp384, tmp385) = NewReference_Object_0(state_, TNode<Object>{tmp376}, TNode<IntPtrT>{tmp383}).Flatten();
    tmp386 = Convert_Number_float32_0(state_, TNode<Float32T>{tmp375});
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp384, tmp385}, tmp386);
    ca_.Goto(&block147, phi_bb161_7, tmp349, phi_bb161_9, phi_bb161_10, phi_bb161_11, phi_bb161_13, phi_bb161_14, phi_bb161_20);
  }

  TNode<IntPtrT> phi_bb162_7;
  TNode<IntPtrT> phi_bb162_9;
  TNode<IntPtrT> phi_bb162_10;
  TNode<IntPtrT> phi_bb162_11;
  TNode<IntPtrT> phi_bb162_13;
  TNode<BoolT> phi_bb162_14;
  TNode<IntPtrT> phi_bb162_20;
  TNode<Object> phi_bb162_22;
  TNode<IntPtrT> phi_bb162_23;
  TNode<IntPtrT> phi_bb162_29;
  TNode<IntPtrT> phi_bb162_30;
  TNode<IntPtrT> phi_bb162_34;
  TNode<IntPtrT> phi_bb162_35;
  if (block162.is_used()) {
    ca_.Bind(&block162, &phi_bb162_7, &phi_bb162_9, &phi_bb162_10, &phi_bb162_11, &phi_bb162_13, &phi_bb162_14, &phi_bb162_20, &phi_bb162_22, &phi_bb162_23, &phi_bb162_29, &phi_bb162_30, &phi_bb162_34, &phi_bb162_35);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb146_7;
  TNode<IntPtrT> phi_bb146_8;
  TNode<IntPtrT> phi_bb146_9;
  TNode<IntPtrT> phi_bb146_10;
  TNode<IntPtrT> phi_bb146_11;
  TNode<IntPtrT> phi_bb146_13;
  TNode<BoolT> phi_bb146_14;
  TNode<IntPtrT> phi_bb146_20;
  TNode<Int32T> tmp387;
  TNode<BoolT> tmp388;
  if (block146.is_used()) {
    ca_.Bind(&block146, &phi_bb146_7, &phi_bb146_8, &phi_bb146_9, &phi_bb146_10, &phi_bb146_11, &phi_bb146_13, &phi_bb146_14, &phi_bb146_20);
    tmp387 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmI64.raw_bit_field());
    tmp388 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp304}, TNode<Int32T>{tmp387});
    ca_.Branch(tmp388, &block165, std::vector<compiler::Node*>{phi_bb146_7, phi_bb146_8, phi_bb146_9, phi_bb146_10, phi_bb146_11, phi_bb146_13, phi_bb146_14, phi_bb146_20}, &block166, std::vector<compiler::Node*>{phi_bb146_7, phi_bb146_8, phi_bb146_9, phi_bb146_10, phi_bb146_11, phi_bb146_13, phi_bb146_14, phi_bb146_20});
  }

  TNode<IntPtrT> phi_bb165_7;
  TNode<IntPtrT> phi_bb165_8;
  TNode<IntPtrT> phi_bb165_9;
  TNode<IntPtrT> phi_bb165_10;
  TNode<IntPtrT> phi_bb165_11;
  TNode<IntPtrT> phi_bb165_13;
  TNode<BoolT> phi_bb165_14;
  TNode<IntPtrT> phi_bb165_20;
  if (block165.is_used()) {
    ca_.Bind(&block165, &phi_bb165_7, &phi_bb165_8, &phi_bb165_9, &phi_bb165_10, &phi_bb165_11, &phi_bb165_13, &phi_bb165_14, &phi_bb165_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block168, phi_bb165_7, phi_bb165_8, phi_bb165_9, phi_bb165_10, phi_bb165_11, phi_bb165_13, phi_bb165_14, phi_bb165_20);
    } else {
      ca_.Goto(&block169, phi_bb165_7, phi_bb165_8, phi_bb165_9, phi_bb165_10, phi_bb165_11, phi_bb165_13, phi_bb165_14, phi_bb165_20);
    }
  }

  TNode<IntPtrT> phi_bb168_7;
  TNode<IntPtrT> phi_bb168_8;
  TNode<IntPtrT> phi_bb168_9;
  TNode<IntPtrT> phi_bb168_10;
  TNode<IntPtrT> phi_bb168_11;
  TNode<IntPtrT> phi_bb168_13;
  TNode<BoolT> phi_bb168_14;
  TNode<IntPtrT> phi_bb168_20;
  TNode<IntPtrT> tmp389;
  TNode<IntPtrT> tmp390;
  TNode<IntPtrT> tmp391;
  TNode<BoolT> tmp392;
  if (block168.is_used()) {
    ca_.Bind(&block168, &phi_bb168_7, &phi_bb168_8, &phi_bb168_9, &phi_bb168_10, &phi_bb168_11, &phi_bb168_13, &phi_bb168_14, &phi_bb168_20);
    tmp389 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp390 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb168_7}, TNode<IntPtrT>{tmp389});
    tmp391 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp392 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb168_7}, TNode<IntPtrT>{tmp391});
    ca_.Branch(tmp392, &block172, std::vector<compiler::Node*>{phi_bb168_8, phi_bb168_9, phi_bb168_10, phi_bb168_11, phi_bb168_13, phi_bb168_14, phi_bb168_20}, &block173, std::vector<compiler::Node*>{phi_bb168_8, phi_bb168_9, phi_bb168_10, phi_bb168_11, phi_bb168_13, phi_bb168_14, phi_bb168_20});
  }

  TNode<IntPtrT> phi_bb172_8;
  TNode<IntPtrT> phi_bb172_9;
  TNode<IntPtrT> phi_bb172_10;
  TNode<IntPtrT> phi_bb172_11;
  TNode<IntPtrT> phi_bb172_13;
  TNode<BoolT> phi_bb172_14;
  TNode<IntPtrT> phi_bb172_20;
  TNode<Object> tmp393;
  TNode<IntPtrT> tmp394;
  TNode<IntPtrT> tmp395;
  TNode<IntPtrT> tmp396;
  if (block172.is_used()) {
    ca_.Bind(&block172, &phi_bb172_8, &phi_bb172_9, &phi_bb172_10, &phi_bb172_11, &phi_bb172_13, &phi_bb172_14, &phi_bb172_20);
    std::tie(tmp393, tmp394) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb172_9}).Flatten();
    tmp395 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp396 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb172_9}, TNode<IntPtrT>{tmp395});
    ca_.Goto(&block171, phi_bb172_8, tmp396, phi_bb172_10, phi_bb172_11, phi_bb172_13, phi_bb172_14, phi_bb172_20, tmp393, tmp394);
  }

  TNode<IntPtrT> phi_bb173_8;
  TNode<IntPtrT> phi_bb173_9;
  TNode<IntPtrT> phi_bb173_10;
  TNode<IntPtrT> phi_bb173_11;
  TNode<IntPtrT> phi_bb173_13;
  TNode<BoolT> phi_bb173_14;
  TNode<IntPtrT> phi_bb173_20;
  if (block173.is_used()) {
    ca_.Bind(&block173, &phi_bb173_8, &phi_bb173_9, &phi_bb173_10, &phi_bb173_11, &phi_bb173_13, &phi_bb173_14, &phi_bb173_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block175, phi_bb173_8, phi_bb173_9, phi_bb173_10, phi_bb173_11, phi_bb173_13, phi_bb173_14, phi_bb173_20);
    } else {
      ca_.Goto(&block176, phi_bb173_8, phi_bb173_9, phi_bb173_10, phi_bb173_11, phi_bb173_13, phi_bb173_14, phi_bb173_20);
    }
  }

  TNode<IntPtrT> phi_bb175_8;
  TNode<IntPtrT> phi_bb175_9;
  TNode<IntPtrT> phi_bb175_10;
  TNode<IntPtrT> phi_bb175_11;
  TNode<IntPtrT> phi_bb175_13;
  TNode<BoolT> phi_bb175_14;
  TNode<IntPtrT> phi_bb175_20;
  TNode<Object> tmp397;
  TNode<IntPtrT> tmp398;
  TNode<IntPtrT> tmp399;
  TNode<IntPtrT> tmp400;
  if (block175.is_used()) {
    ca_.Bind(&block175, &phi_bb175_8, &phi_bb175_9, &phi_bb175_10, &phi_bb175_11, &phi_bb175_13, &phi_bb175_14, &phi_bb175_20);
    std::tie(tmp397, tmp398) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb175_11}).Flatten();
    tmp399 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp400 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb175_11}, TNode<IntPtrT>{tmp399});
    ca_.Goto(&block174, phi_bb175_8, phi_bb175_9, phi_bb175_10, tmp400, phi_bb175_13, phi_bb175_14, phi_bb175_20, tmp397, tmp398);
  }

  TNode<IntPtrT> phi_bb176_8;
  TNode<IntPtrT> phi_bb176_9;
  TNode<IntPtrT> phi_bb176_10;
  TNode<IntPtrT> phi_bb176_11;
  TNode<IntPtrT> phi_bb176_13;
  TNode<BoolT> phi_bb176_14;
  TNode<IntPtrT> phi_bb176_20;
  TNode<IntPtrT> tmp401;
  TNode<BoolT> tmp402;
  if (block176.is_used()) {
    ca_.Bind(&block176, &phi_bb176_8, &phi_bb176_9, &phi_bb176_10, &phi_bb176_11, &phi_bb176_13, &phi_bb176_14, &phi_bb176_20);
    tmp401 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp402 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb176_13}, TNode<IntPtrT>{tmp401});
    ca_.Branch(tmp402, &block178, std::vector<compiler::Node*>{phi_bb176_8, phi_bb176_9, phi_bb176_10, phi_bb176_11, phi_bb176_13, phi_bb176_14, phi_bb176_20}, &block179, std::vector<compiler::Node*>{phi_bb176_8, phi_bb176_9, phi_bb176_10, phi_bb176_11, phi_bb176_13, phi_bb176_14, phi_bb176_20});
  }

  TNode<IntPtrT> phi_bb178_8;
  TNode<IntPtrT> phi_bb178_9;
  TNode<IntPtrT> phi_bb178_10;
  TNode<IntPtrT> phi_bb178_11;
  TNode<IntPtrT> phi_bb178_13;
  TNode<BoolT> phi_bb178_14;
  TNode<IntPtrT> phi_bb178_20;
  TNode<Object> tmp403;
  TNode<IntPtrT> tmp404;
  TNode<IntPtrT> tmp405;
  TNode<BoolT> tmp406;
  if (block178.is_used()) {
    ca_.Bind(&block178, &phi_bb178_8, &phi_bb178_9, &phi_bb178_10, &phi_bb178_11, &phi_bb178_13, &phi_bb178_14, &phi_bb178_20);
    std::tie(tmp403, tmp404) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb178_13}).Flatten();
    tmp405 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp406 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block174, phi_bb178_8, phi_bb178_9, phi_bb178_10, phi_bb178_11, tmp405, tmp406, phi_bb178_20, tmp403, tmp404);
  }

  TNode<IntPtrT> phi_bb179_8;
  TNode<IntPtrT> phi_bb179_9;
  TNode<IntPtrT> phi_bb179_10;
  TNode<IntPtrT> phi_bb179_11;
  TNode<IntPtrT> phi_bb179_13;
  TNode<BoolT> phi_bb179_14;
  TNode<IntPtrT> phi_bb179_20;
  TNode<Object> tmp407;
  TNode<IntPtrT> tmp408;
  TNode<IntPtrT> tmp409;
  TNode<IntPtrT> tmp410;
  TNode<IntPtrT> tmp411;
  TNode<IntPtrT> tmp412;
  TNode<BoolT> tmp413;
  if (block179.is_used()) {
    ca_.Bind(&block179, &phi_bb179_8, &phi_bb179_9, &phi_bb179_10, &phi_bb179_11, &phi_bb179_13, &phi_bb179_14, &phi_bb179_20);
    std::tie(tmp407, tmp408) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb179_11}).Flatten();
    tmp409 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp410 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb179_11}, TNode<IntPtrT>{tmp409});
    tmp411 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp412 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp410}, TNode<IntPtrT>{tmp411});
    tmp413 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block174, phi_bb179_8, phi_bb179_9, phi_bb179_10, tmp412, tmp410, tmp413, phi_bb179_20, tmp407, tmp408);
  }

  TNode<IntPtrT> phi_bb174_8;
  TNode<IntPtrT> phi_bb174_9;
  TNode<IntPtrT> phi_bb174_10;
  TNode<IntPtrT> phi_bb174_11;
  TNode<IntPtrT> phi_bb174_13;
  TNode<BoolT> phi_bb174_14;
  TNode<IntPtrT> phi_bb174_20;
  TNode<Object> phi_bb174_22;
  TNode<IntPtrT> phi_bb174_23;
  if (block174.is_used()) {
    ca_.Bind(&block174, &phi_bb174_8, &phi_bb174_9, &phi_bb174_10, &phi_bb174_11, &phi_bb174_13, &phi_bb174_14, &phi_bb174_20, &phi_bb174_22, &phi_bb174_23);
    ca_.Goto(&block171, phi_bb174_8, phi_bb174_9, phi_bb174_10, phi_bb174_11, phi_bb174_13, phi_bb174_14, phi_bb174_20, phi_bb174_22, phi_bb174_23);
  }

  TNode<IntPtrT> phi_bb171_8;
  TNode<IntPtrT> phi_bb171_9;
  TNode<IntPtrT> phi_bb171_10;
  TNode<IntPtrT> phi_bb171_11;
  TNode<IntPtrT> phi_bb171_13;
  TNode<BoolT> phi_bb171_14;
  TNode<IntPtrT> phi_bb171_20;
  TNode<Object> phi_bb171_22;
  TNode<IntPtrT> phi_bb171_23;
  TNode<IntPtrT> tmp414;
  TNode<Object> tmp415;
  TNode<IntPtrT> tmp416;
  TNode<IntPtrT> tmp417;
  TNode<UintPtrT> tmp418;
  TNode<UintPtrT> tmp419;
  TNode<BoolT> tmp420;
  if (block171.is_used()) {
    ca_.Bind(&block171, &phi_bb171_8, &phi_bb171_9, &phi_bb171_10, &phi_bb171_11, &phi_bb171_13, &phi_bb171_14, &phi_bb171_20, &phi_bb171_22, &phi_bb171_23);
    tmp414 = CodeStubAssembler(state_).LoadReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb171_22, phi_bb171_23});
    std::tie(tmp415, tmp416, tmp417) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp66}).Flatten();
    tmp418 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb171_20});
    tmp419 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp417});
    tmp420 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp418}, TNode<UintPtrT>{tmp419});
    ca_.Branch(tmp420, &block184, std::vector<compiler::Node*>{phi_bb171_8, phi_bb171_9, phi_bb171_10, phi_bb171_11, phi_bb171_13, phi_bb171_14, phi_bb171_20, phi_bb171_22, phi_bb171_23, phi_bb171_20, phi_bb171_20, phi_bb171_20, phi_bb171_20}, &block185, std::vector<compiler::Node*>{phi_bb171_8, phi_bb171_9, phi_bb171_10, phi_bb171_11, phi_bb171_13, phi_bb171_14, phi_bb171_20, phi_bb171_22, phi_bb171_23, phi_bb171_20, phi_bb171_20, phi_bb171_20, phi_bb171_20});
  }

  TNode<IntPtrT> phi_bb184_8;
  TNode<IntPtrT> phi_bb184_9;
  TNode<IntPtrT> phi_bb184_10;
  TNode<IntPtrT> phi_bb184_11;
  TNode<IntPtrT> phi_bb184_13;
  TNode<BoolT> phi_bb184_14;
  TNode<IntPtrT> phi_bb184_20;
  TNode<Object> phi_bb184_22;
  TNode<IntPtrT> phi_bb184_23;
  TNode<IntPtrT> phi_bb184_29;
  TNode<IntPtrT> phi_bb184_30;
  TNode<IntPtrT> phi_bb184_34;
  TNode<IntPtrT> phi_bb184_35;
  TNode<IntPtrT> tmp421;
  TNode<IntPtrT> tmp422;
  TNode<Object> tmp423;
  TNode<IntPtrT> tmp424;
  TNode<BigInt> tmp425;
  if (block184.is_used()) {
    ca_.Bind(&block184, &phi_bb184_8, &phi_bb184_9, &phi_bb184_10, &phi_bb184_11, &phi_bb184_13, &phi_bb184_14, &phi_bb184_20, &phi_bb184_22, &phi_bb184_23, &phi_bb184_29, &phi_bb184_30, &phi_bb184_34, &phi_bb184_35);
    tmp421 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb184_35});
    tmp422 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp416}, TNode<IntPtrT>{tmp421});
    std::tie(tmp423, tmp424) = NewReference_Object_0(state_, TNode<Object>{tmp415}, TNode<IntPtrT>{tmp422}).Flatten();
    tmp425 = ca_.CallBuiltin<BigInt>(Builtin::kI64ToBigInt, TNode<Object>(), tmp414);
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp423, tmp424}, tmp425);
    ca_.Goto(&block170, tmp390, phi_bb184_8, phi_bb184_9, phi_bb184_10, phi_bb184_11, phi_bb184_13, phi_bb184_14, phi_bb184_20);
  }

  TNode<IntPtrT> phi_bb185_8;
  TNode<IntPtrT> phi_bb185_9;
  TNode<IntPtrT> phi_bb185_10;
  TNode<IntPtrT> phi_bb185_11;
  TNode<IntPtrT> phi_bb185_13;
  TNode<BoolT> phi_bb185_14;
  TNode<IntPtrT> phi_bb185_20;
  TNode<Object> phi_bb185_22;
  TNode<IntPtrT> phi_bb185_23;
  TNode<IntPtrT> phi_bb185_29;
  TNode<IntPtrT> phi_bb185_30;
  TNode<IntPtrT> phi_bb185_34;
  TNode<IntPtrT> phi_bb185_35;
  if (block185.is_used()) {
    ca_.Bind(&block185, &phi_bb185_8, &phi_bb185_9, &phi_bb185_10, &phi_bb185_11, &phi_bb185_13, &phi_bb185_14, &phi_bb185_20, &phi_bb185_22, &phi_bb185_23, &phi_bb185_29, &phi_bb185_30, &phi_bb185_34, &phi_bb185_35);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb169_7;
  TNode<IntPtrT> phi_bb169_8;
  TNode<IntPtrT> phi_bb169_9;
  TNode<IntPtrT> phi_bb169_10;
  TNode<IntPtrT> phi_bb169_11;
  TNode<IntPtrT> phi_bb169_13;
  TNode<BoolT> phi_bb169_14;
  TNode<IntPtrT> phi_bb169_20;
  TNode<IntPtrT> tmp426;
  TNode<IntPtrT> tmp427;
  TNode<IntPtrT> tmp428;
  TNode<BoolT> tmp429;
  if (block169.is_used()) {
    ca_.Bind(&block169, &phi_bb169_7, &phi_bb169_8, &phi_bb169_9, &phi_bb169_10, &phi_bb169_11, &phi_bb169_13, &phi_bb169_14, &phi_bb169_20);
    tmp426 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp427 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb169_7}, TNode<IntPtrT>{tmp426});
    tmp428 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp429 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb169_7}, TNode<IntPtrT>{tmp428});
    ca_.Branch(tmp429, &block189, std::vector<compiler::Node*>{phi_bb169_8, phi_bb169_9, phi_bb169_10, phi_bb169_11, phi_bb169_13, phi_bb169_14, phi_bb169_20}, &block190, std::vector<compiler::Node*>{phi_bb169_8, phi_bb169_9, phi_bb169_10, phi_bb169_11, phi_bb169_13, phi_bb169_14, phi_bb169_20});
  }

  TNode<IntPtrT> phi_bb189_8;
  TNode<IntPtrT> phi_bb189_9;
  TNode<IntPtrT> phi_bb189_10;
  TNode<IntPtrT> phi_bb189_11;
  TNode<IntPtrT> phi_bb189_13;
  TNode<BoolT> phi_bb189_14;
  TNode<IntPtrT> phi_bb189_20;
  TNode<Object> tmp430;
  TNode<IntPtrT> tmp431;
  TNode<IntPtrT> tmp432;
  TNode<IntPtrT> tmp433;
  if (block189.is_used()) {
    ca_.Bind(&block189, &phi_bb189_8, &phi_bb189_9, &phi_bb189_10, &phi_bb189_11, &phi_bb189_13, &phi_bb189_14, &phi_bb189_20);
    std::tie(tmp430, tmp431) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb189_9}).Flatten();
    tmp432 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp433 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb189_9}, TNode<IntPtrT>{tmp432});
    ca_.Goto(&block188, phi_bb189_8, tmp433, phi_bb189_10, phi_bb189_11, phi_bb189_13, phi_bb189_14, phi_bb189_20, tmp430, tmp431);
  }

  TNode<IntPtrT> phi_bb190_8;
  TNode<IntPtrT> phi_bb190_9;
  TNode<IntPtrT> phi_bb190_10;
  TNode<IntPtrT> phi_bb190_11;
  TNode<IntPtrT> phi_bb190_13;
  TNode<BoolT> phi_bb190_14;
  TNode<IntPtrT> phi_bb190_20;
  if (block190.is_used()) {
    ca_.Bind(&block190, &phi_bb190_8, &phi_bb190_9, &phi_bb190_10, &phi_bb190_11, &phi_bb190_13, &phi_bb190_14, &phi_bb190_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block192, phi_bb190_8, phi_bb190_9, phi_bb190_10, phi_bb190_11, phi_bb190_13, phi_bb190_14, phi_bb190_20);
    } else {
      ca_.Goto(&block193, phi_bb190_8, phi_bb190_9, phi_bb190_10, phi_bb190_11, phi_bb190_13, phi_bb190_14, phi_bb190_20);
    }
  }

  TNode<IntPtrT> phi_bb192_8;
  TNode<IntPtrT> phi_bb192_9;
  TNode<IntPtrT> phi_bb192_10;
  TNode<IntPtrT> phi_bb192_11;
  TNode<IntPtrT> phi_bb192_13;
  TNode<BoolT> phi_bb192_14;
  TNode<IntPtrT> phi_bb192_20;
  TNode<Object> tmp434;
  TNode<IntPtrT> tmp435;
  TNode<IntPtrT> tmp436;
  TNode<IntPtrT> tmp437;
  if (block192.is_used()) {
    ca_.Bind(&block192, &phi_bb192_8, &phi_bb192_9, &phi_bb192_10, &phi_bb192_11, &phi_bb192_13, &phi_bb192_14, &phi_bb192_20);
    std::tie(tmp434, tmp435) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb192_11}).Flatten();
    tmp436 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp437 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb192_11}, TNode<IntPtrT>{tmp436});
    ca_.Goto(&block191, phi_bb192_8, phi_bb192_9, phi_bb192_10, tmp437, phi_bb192_13, phi_bb192_14, phi_bb192_20, tmp434, tmp435);
  }

  TNode<IntPtrT> phi_bb193_8;
  TNode<IntPtrT> phi_bb193_9;
  TNode<IntPtrT> phi_bb193_10;
  TNode<IntPtrT> phi_bb193_11;
  TNode<IntPtrT> phi_bb193_13;
  TNode<BoolT> phi_bb193_14;
  TNode<IntPtrT> phi_bb193_20;
  TNode<IntPtrT> tmp438;
  TNode<BoolT> tmp439;
  if (block193.is_used()) {
    ca_.Bind(&block193, &phi_bb193_8, &phi_bb193_9, &phi_bb193_10, &phi_bb193_11, &phi_bb193_13, &phi_bb193_14, &phi_bb193_20);
    tmp438 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp439 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb193_13}, TNode<IntPtrT>{tmp438});
    ca_.Branch(tmp439, &block195, std::vector<compiler::Node*>{phi_bb193_8, phi_bb193_9, phi_bb193_10, phi_bb193_11, phi_bb193_13, phi_bb193_14, phi_bb193_20}, &block196, std::vector<compiler::Node*>{phi_bb193_8, phi_bb193_9, phi_bb193_10, phi_bb193_11, phi_bb193_13, phi_bb193_14, phi_bb193_20});
  }

  TNode<IntPtrT> phi_bb195_8;
  TNode<IntPtrT> phi_bb195_9;
  TNode<IntPtrT> phi_bb195_10;
  TNode<IntPtrT> phi_bb195_11;
  TNode<IntPtrT> phi_bb195_13;
  TNode<BoolT> phi_bb195_14;
  TNode<IntPtrT> phi_bb195_20;
  TNode<Object> tmp440;
  TNode<IntPtrT> tmp441;
  TNode<IntPtrT> tmp442;
  TNode<BoolT> tmp443;
  if (block195.is_used()) {
    ca_.Bind(&block195, &phi_bb195_8, &phi_bb195_9, &phi_bb195_10, &phi_bb195_11, &phi_bb195_13, &phi_bb195_14, &phi_bb195_20);
    std::tie(tmp440, tmp441) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb195_13}).Flatten();
    tmp442 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp443 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block191, phi_bb195_8, phi_bb195_9, phi_bb195_10, phi_bb195_11, tmp442, tmp443, phi_bb195_20, tmp440, tmp441);
  }

  TNode<IntPtrT> phi_bb196_8;
  TNode<IntPtrT> phi_bb196_9;
  TNode<IntPtrT> phi_bb196_10;
  TNode<IntPtrT> phi_bb196_11;
  TNode<IntPtrT> phi_bb196_13;
  TNode<BoolT> phi_bb196_14;
  TNode<IntPtrT> phi_bb196_20;
  TNode<Object> tmp444;
  TNode<IntPtrT> tmp445;
  TNode<IntPtrT> tmp446;
  TNode<IntPtrT> tmp447;
  TNode<IntPtrT> tmp448;
  TNode<IntPtrT> tmp449;
  TNode<BoolT> tmp450;
  if (block196.is_used()) {
    ca_.Bind(&block196, &phi_bb196_8, &phi_bb196_9, &phi_bb196_10, &phi_bb196_11, &phi_bb196_13, &phi_bb196_14, &phi_bb196_20);
    std::tie(tmp444, tmp445) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb196_11}).Flatten();
    tmp446 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp447 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb196_11}, TNode<IntPtrT>{tmp446});
    tmp448 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp449 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp447}, TNode<IntPtrT>{tmp448});
    tmp450 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block191, phi_bb196_8, phi_bb196_9, phi_bb196_10, tmp449, tmp447, tmp450, phi_bb196_20, tmp444, tmp445);
  }

  TNode<IntPtrT> phi_bb191_8;
  TNode<IntPtrT> phi_bb191_9;
  TNode<IntPtrT> phi_bb191_10;
  TNode<IntPtrT> phi_bb191_11;
  TNode<IntPtrT> phi_bb191_13;
  TNode<BoolT> phi_bb191_14;
  TNode<IntPtrT> phi_bb191_20;
  TNode<Object> phi_bb191_22;
  TNode<IntPtrT> phi_bb191_23;
  if (block191.is_used()) {
    ca_.Bind(&block191, &phi_bb191_8, &phi_bb191_9, &phi_bb191_10, &phi_bb191_11, &phi_bb191_13, &phi_bb191_14, &phi_bb191_20, &phi_bb191_22, &phi_bb191_23);
    ca_.Goto(&block188, phi_bb191_8, phi_bb191_9, phi_bb191_10, phi_bb191_11, phi_bb191_13, phi_bb191_14, phi_bb191_20, phi_bb191_22, phi_bb191_23);
  }

  TNode<IntPtrT> phi_bb188_8;
  TNode<IntPtrT> phi_bb188_9;
  TNode<IntPtrT> phi_bb188_10;
  TNode<IntPtrT> phi_bb188_11;
  TNode<IntPtrT> phi_bb188_13;
  TNode<BoolT> phi_bb188_14;
  TNode<IntPtrT> phi_bb188_20;
  TNode<Object> phi_bb188_22;
  TNode<IntPtrT> phi_bb188_23;
  TNode<IntPtrT> tmp451;
  TNode<IntPtrT> tmp452;
  TNode<IntPtrT> tmp453;
  TNode<BoolT> tmp454;
  if (block188.is_used()) {
    ca_.Bind(&block188, &phi_bb188_8, &phi_bb188_9, &phi_bb188_10, &phi_bb188_11, &phi_bb188_13, &phi_bb188_14, &phi_bb188_20, &phi_bb188_22, &phi_bb188_23);
    tmp451 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp452 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{tmp427}, TNode<IntPtrT>{tmp451});
    tmp453 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp454 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{tmp427}, TNode<IntPtrT>{tmp453});
    ca_.Branch(tmp454, &block198, std::vector<compiler::Node*>{phi_bb188_8, phi_bb188_9, phi_bb188_10, phi_bb188_11, phi_bb188_13, phi_bb188_14, phi_bb188_20, phi_bb188_22, phi_bb188_23}, &block199, std::vector<compiler::Node*>{phi_bb188_8, phi_bb188_9, phi_bb188_10, phi_bb188_11, phi_bb188_13, phi_bb188_14, phi_bb188_20, phi_bb188_22, phi_bb188_23});
  }

  TNode<IntPtrT> phi_bb198_8;
  TNode<IntPtrT> phi_bb198_9;
  TNode<IntPtrT> phi_bb198_10;
  TNode<IntPtrT> phi_bb198_11;
  TNode<IntPtrT> phi_bb198_13;
  TNode<BoolT> phi_bb198_14;
  TNode<IntPtrT> phi_bb198_20;
  TNode<Object> phi_bb198_22;
  TNode<IntPtrT> phi_bb198_23;
  TNode<Object> tmp455;
  TNode<IntPtrT> tmp456;
  TNode<IntPtrT> tmp457;
  TNode<IntPtrT> tmp458;
  if (block198.is_used()) {
    ca_.Bind(&block198, &phi_bb198_8, &phi_bb198_9, &phi_bb198_10, &phi_bb198_11, &phi_bb198_13, &phi_bb198_14, &phi_bb198_20, &phi_bb198_22, &phi_bb198_23);
    std::tie(tmp455, tmp456) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb198_9}).Flatten();
    tmp457 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp458 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb198_9}, TNode<IntPtrT>{tmp457});
    ca_.Goto(&block197, phi_bb198_8, tmp458, phi_bb198_10, phi_bb198_11, phi_bb198_13, phi_bb198_14, phi_bb198_20, phi_bb198_22, phi_bb198_23, tmp455, tmp456);
  }

  TNode<IntPtrT> phi_bb199_8;
  TNode<IntPtrT> phi_bb199_9;
  TNode<IntPtrT> phi_bb199_10;
  TNode<IntPtrT> phi_bb199_11;
  TNode<IntPtrT> phi_bb199_13;
  TNode<BoolT> phi_bb199_14;
  TNode<IntPtrT> phi_bb199_20;
  TNode<Object> phi_bb199_22;
  TNode<IntPtrT> phi_bb199_23;
  if (block199.is_used()) {
    ca_.Bind(&block199, &phi_bb199_8, &phi_bb199_9, &phi_bb199_10, &phi_bb199_11, &phi_bb199_13, &phi_bb199_14, &phi_bb199_20, &phi_bb199_22, &phi_bb199_23);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block201, phi_bb199_8, phi_bb199_9, phi_bb199_10, phi_bb199_11, phi_bb199_13, phi_bb199_14, phi_bb199_20, phi_bb199_22, phi_bb199_23);
    } else {
      ca_.Goto(&block202, phi_bb199_8, phi_bb199_9, phi_bb199_10, phi_bb199_11, phi_bb199_13, phi_bb199_14, phi_bb199_20, phi_bb199_22, phi_bb199_23);
    }
  }

  TNode<IntPtrT> phi_bb201_8;
  TNode<IntPtrT> phi_bb201_9;
  TNode<IntPtrT> phi_bb201_10;
  TNode<IntPtrT> phi_bb201_11;
  TNode<IntPtrT> phi_bb201_13;
  TNode<BoolT> phi_bb201_14;
  TNode<IntPtrT> phi_bb201_20;
  TNode<Object> phi_bb201_22;
  TNode<IntPtrT> phi_bb201_23;
  TNode<Object> tmp459;
  TNode<IntPtrT> tmp460;
  TNode<IntPtrT> tmp461;
  TNode<IntPtrT> tmp462;
  if (block201.is_used()) {
    ca_.Bind(&block201, &phi_bb201_8, &phi_bb201_9, &phi_bb201_10, &phi_bb201_11, &phi_bb201_13, &phi_bb201_14, &phi_bb201_20, &phi_bb201_22, &phi_bb201_23);
    std::tie(tmp459, tmp460) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb201_11}).Flatten();
    tmp461 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp462 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb201_11}, TNode<IntPtrT>{tmp461});
    ca_.Goto(&block200, phi_bb201_8, phi_bb201_9, phi_bb201_10, tmp462, phi_bb201_13, phi_bb201_14, phi_bb201_20, phi_bb201_22, phi_bb201_23, tmp459, tmp460);
  }

  TNode<IntPtrT> phi_bb202_8;
  TNode<IntPtrT> phi_bb202_9;
  TNode<IntPtrT> phi_bb202_10;
  TNode<IntPtrT> phi_bb202_11;
  TNode<IntPtrT> phi_bb202_13;
  TNode<BoolT> phi_bb202_14;
  TNode<IntPtrT> phi_bb202_20;
  TNode<Object> phi_bb202_22;
  TNode<IntPtrT> phi_bb202_23;
  TNode<IntPtrT> tmp463;
  TNode<BoolT> tmp464;
  if (block202.is_used()) {
    ca_.Bind(&block202, &phi_bb202_8, &phi_bb202_9, &phi_bb202_10, &phi_bb202_11, &phi_bb202_13, &phi_bb202_14, &phi_bb202_20, &phi_bb202_22, &phi_bb202_23);
    tmp463 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp464 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb202_13}, TNode<IntPtrT>{tmp463});
    ca_.Branch(tmp464, &block204, std::vector<compiler::Node*>{phi_bb202_8, phi_bb202_9, phi_bb202_10, phi_bb202_11, phi_bb202_13, phi_bb202_14, phi_bb202_20, phi_bb202_22, phi_bb202_23}, &block205, std::vector<compiler::Node*>{phi_bb202_8, phi_bb202_9, phi_bb202_10, phi_bb202_11, phi_bb202_13, phi_bb202_14, phi_bb202_20, phi_bb202_22, phi_bb202_23});
  }

  TNode<IntPtrT> phi_bb204_8;
  TNode<IntPtrT> phi_bb204_9;
  TNode<IntPtrT> phi_bb204_10;
  TNode<IntPtrT> phi_bb204_11;
  TNode<IntPtrT> phi_bb204_13;
  TNode<BoolT> phi_bb204_14;
  TNode<IntPtrT> phi_bb204_20;
  TNode<Object> phi_bb204_22;
  TNode<IntPtrT> phi_bb204_23;
  TNode<Object> tmp465;
  TNode<IntPtrT> tmp466;
  TNode<IntPtrT> tmp467;
  TNode<BoolT> tmp468;
  if (block204.is_used()) {
    ca_.Bind(&block204, &phi_bb204_8, &phi_bb204_9, &phi_bb204_10, &phi_bb204_11, &phi_bb204_13, &phi_bb204_14, &phi_bb204_20, &phi_bb204_22, &phi_bb204_23);
    std::tie(tmp465, tmp466) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb204_13}).Flatten();
    tmp467 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp468 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block200, phi_bb204_8, phi_bb204_9, phi_bb204_10, phi_bb204_11, tmp467, tmp468, phi_bb204_20, phi_bb204_22, phi_bb204_23, tmp465, tmp466);
  }

  TNode<IntPtrT> phi_bb205_8;
  TNode<IntPtrT> phi_bb205_9;
  TNode<IntPtrT> phi_bb205_10;
  TNode<IntPtrT> phi_bb205_11;
  TNode<IntPtrT> phi_bb205_13;
  TNode<BoolT> phi_bb205_14;
  TNode<IntPtrT> phi_bb205_20;
  TNode<Object> phi_bb205_22;
  TNode<IntPtrT> phi_bb205_23;
  TNode<Object> tmp469;
  TNode<IntPtrT> tmp470;
  TNode<IntPtrT> tmp471;
  TNode<IntPtrT> tmp472;
  TNode<IntPtrT> tmp473;
  TNode<IntPtrT> tmp474;
  TNode<BoolT> tmp475;
  if (block205.is_used()) {
    ca_.Bind(&block205, &phi_bb205_8, &phi_bb205_9, &phi_bb205_10, &phi_bb205_11, &phi_bb205_13, &phi_bb205_14, &phi_bb205_20, &phi_bb205_22, &phi_bb205_23);
    std::tie(tmp469, tmp470) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb205_11}).Flatten();
    tmp471 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp472 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb205_11}, TNode<IntPtrT>{tmp471});
    tmp473 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp474 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp472}, TNode<IntPtrT>{tmp473});
    tmp475 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block200, phi_bb205_8, phi_bb205_9, phi_bb205_10, tmp474, tmp472, tmp475, phi_bb205_20, phi_bb205_22, phi_bb205_23, tmp469, tmp470);
  }

  TNode<IntPtrT> phi_bb200_8;
  TNode<IntPtrT> phi_bb200_9;
  TNode<IntPtrT> phi_bb200_10;
  TNode<IntPtrT> phi_bb200_11;
  TNode<IntPtrT> phi_bb200_13;
  TNode<BoolT> phi_bb200_14;
  TNode<IntPtrT> phi_bb200_20;
  TNode<Object> phi_bb200_22;
  TNode<IntPtrT> phi_bb200_23;
  TNode<Object> phi_bb200_24;
  TNode<IntPtrT> phi_bb200_25;
  if (block200.is_used()) {
    ca_.Bind(&block200, &phi_bb200_8, &phi_bb200_9, &phi_bb200_10, &phi_bb200_11, &phi_bb200_13, &phi_bb200_14, &phi_bb200_20, &phi_bb200_22, &phi_bb200_23, &phi_bb200_24, &phi_bb200_25);
    ca_.Goto(&block197, phi_bb200_8, phi_bb200_9, phi_bb200_10, phi_bb200_11, phi_bb200_13, phi_bb200_14, phi_bb200_20, phi_bb200_22, phi_bb200_23, phi_bb200_24, phi_bb200_25);
  }

  TNode<IntPtrT> phi_bb197_8;
  TNode<IntPtrT> phi_bb197_9;
  TNode<IntPtrT> phi_bb197_10;
  TNode<IntPtrT> phi_bb197_11;
  TNode<IntPtrT> phi_bb197_13;
  TNode<BoolT> phi_bb197_14;
  TNode<IntPtrT> phi_bb197_20;
  TNode<Object> phi_bb197_22;
  TNode<IntPtrT> phi_bb197_23;
  TNode<Object> phi_bb197_24;
  TNode<IntPtrT> phi_bb197_25;
  TNode<IntPtrT> tmp476;
  TNode<IntPtrT> tmp477;
  TNode<Object> tmp478;
  TNode<IntPtrT> tmp479;
  TNode<IntPtrT> tmp480;
  TNode<UintPtrT> tmp481;
  TNode<UintPtrT> tmp482;
  TNode<BoolT> tmp483;
  if (block197.is_used()) {
    ca_.Bind(&block197, &phi_bb197_8, &phi_bb197_9, &phi_bb197_10, &phi_bb197_11, &phi_bb197_13, &phi_bb197_14, &phi_bb197_20, &phi_bb197_22, &phi_bb197_23, &phi_bb197_24, &phi_bb197_25);
    tmp476 = CodeStubAssembler(state_).LoadReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb197_22, phi_bb197_23});
    tmp477 = CodeStubAssembler(state_).LoadReference<IntPtrT>(CodeStubAssembler::Reference{phi_bb197_24, phi_bb197_25});
    std::tie(tmp478, tmp479, tmp480) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp66}).Flatten();
    tmp481 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb197_20});
    tmp482 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp480});
    tmp483 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp481}, TNode<UintPtrT>{tmp482});
    ca_.Branch(tmp483, &block210, std::vector<compiler::Node*>{phi_bb197_8, phi_bb197_9, phi_bb197_10, phi_bb197_11, phi_bb197_13, phi_bb197_14, phi_bb197_20, phi_bb197_22, phi_bb197_23, phi_bb197_24, phi_bb197_25, phi_bb197_20, phi_bb197_20, phi_bb197_20, phi_bb197_20}, &block211, std::vector<compiler::Node*>{phi_bb197_8, phi_bb197_9, phi_bb197_10, phi_bb197_11, phi_bb197_13, phi_bb197_14, phi_bb197_20, phi_bb197_22, phi_bb197_23, phi_bb197_24, phi_bb197_25, phi_bb197_20, phi_bb197_20, phi_bb197_20, phi_bb197_20});
  }

  TNode<IntPtrT> phi_bb210_8;
  TNode<IntPtrT> phi_bb210_9;
  TNode<IntPtrT> phi_bb210_10;
  TNode<IntPtrT> phi_bb210_11;
  TNode<IntPtrT> phi_bb210_13;
  TNode<BoolT> phi_bb210_14;
  TNode<IntPtrT> phi_bb210_20;
  TNode<Object> phi_bb210_22;
  TNode<IntPtrT> phi_bb210_23;
  TNode<Object> phi_bb210_24;
  TNode<IntPtrT> phi_bb210_25;
  TNode<IntPtrT> phi_bb210_32;
  TNode<IntPtrT> phi_bb210_33;
  TNode<IntPtrT> phi_bb210_37;
  TNode<IntPtrT> phi_bb210_38;
  TNode<IntPtrT> tmp484;
  TNode<IntPtrT> tmp485;
  TNode<Object> tmp486;
  TNode<IntPtrT> tmp487;
  TNode<BigInt> tmp488;
  if (block210.is_used()) {
    ca_.Bind(&block210, &phi_bb210_8, &phi_bb210_9, &phi_bb210_10, &phi_bb210_11, &phi_bb210_13, &phi_bb210_14, &phi_bb210_20, &phi_bb210_22, &phi_bb210_23, &phi_bb210_24, &phi_bb210_25, &phi_bb210_32, &phi_bb210_33, &phi_bb210_37, &phi_bb210_38);
    tmp484 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb210_38});
    tmp485 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp479}, TNode<IntPtrT>{tmp484});
    std::tie(tmp486, tmp487) = NewReference_Object_0(state_, TNode<Object>{tmp478}, TNode<IntPtrT>{tmp485}).Flatten();
    tmp488 = ca_.CallBuiltin<BigInt>(Builtin::kI32PairToBigInt, TNode<Object>(), tmp476, tmp477);
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp486, tmp487}, tmp488);
    ca_.Goto(&block170, tmp452, phi_bb210_8, phi_bb210_9, phi_bb210_10, phi_bb210_11, phi_bb210_13, phi_bb210_14, phi_bb210_20);
  }

  TNode<IntPtrT> phi_bb211_8;
  TNode<IntPtrT> phi_bb211_9;
  TNode<IntPtrT> phi_bb211_10;
  TNode<IntPtrT> phi_bb211_11;
  TNode<IntPtrT> phi_bb211_13;
  TNode<BoolT> phi_bb211_14;
  TNode<IntPtrT> phi_bb211_20;
  TNode<Object> phi_bb211_22;
  TNode<IntPtrT> phi_bb211_23;
  TNode<Object> phi_bb211_24;
  TNode<IntPtrT> phi_bb211_25;
  TNode<IntPtrT> phi_bb211_32;
  TNode<IntPtrT> phi_bb211_33;
  TNode<IntPtrT> phi_bb211_37;
  TNode<IntPtrT> phi_bb211_38;
  if (block211.is_used()) {
    ca_.Bind(&block211, &phi_bb211_8, &phi_bb211_9, &phi_bb211_10, &phi_bb211_11, &phi_bb211_13, &phi_bb211_14, &phi_bb211_20, &phi_bb211_22, &phi_bb211_23, &phi_bb211_24, &phi_bb211_25, &phi_bb211_32, &phi_bb211_33, &phi_bb211_37, &phi_bb211_38);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb170_7;
  TNode<IntPtrT> phi_bb170_8;
  TNode<IntPtrT> phi_bb170_9;
  TNode<IntPtrT> phi_bb170_10;
  TNode<IntPtrT> phi_bb170_11;
  TNode<IntPtrT> phi_bb170_13;
  TNode<BoolT> phi_bb170_14;
  TNode<IntPtrT> phi_bb170_20;
  if (block170.is_used()) {
    ca_.Bind(&block170, &phi_bb170_7, &phi_bb170_8, &phi_bb170_9, &phi_bb170_10, &phi_bb170_11, &phi_bb170_13, &phi_bb170_14, &phi_bb170_20);
    ca_.Goto(&block167, phi_bb170_7, phi_bb170_8, phi_bb170_9, phi_bb170_10, phi_bb170_11, phi_bb170_13, phi_bb170_14, phi_bb170_20);
  }

  TNode<IntPtrT> phi_bb166_7;
  TNode<IntPtrT> phi_bb166_8;
  TNode<IntPtrT> phi_bb166_9;
  TNode<IntPtrT> phi_bb166_10;
  TNode<IntPtrT> phi_bb166_11;
  TNode<IntPtrT> phi_bb166_13;
  TNode<BoolT> phi_bb166_14;
  TNode<IntPtrT> phi_bb166_20;
  TNode<Int32T> tmp489;
  TNode<BoolT> tmp490;
  if (block166.is_used()) {
    ca_.Bind(&block166, &phi_bb166_7, &phi_bb166_8, &phi_bb166_9, &phi_bb166_10, &phi_bb166_11, &phi_bb166_13, &phi_bb166_14, &phi_bb166_20);
    tmp489 = FromConstexpr_int32_constexpr_int32_0(state_, wasm::kWasmF64.raw_bit_field());
    tmp490 = CodeStubAssembler(state_).Word32Equal(TNode<Int32T>{tmp304}, TNode<Int32T>{tmp489});
    ca_.Branch(tmp490, &block214, std::vector<compiler::Node*>{phi_bb166_7, phi_bb166_8, phi_bb166_9, phi_bb166_10, phi_bb166_11, phi_bb166_13, phi_bb166_14, phi_bb166_20}, &block215, std::vector<compiler::Node*>{phi_bb166_7, phi_bb166_8, phi_bb166_9, phi_bb166_10, phi_bb166_11, phi_bb166_13, phi_bb166_14, phi_bb166_20});
  }

  TNode<IntPtrT> phi_bb214_7;
  TNode<IntPtrT> phi_bb214_8;
  TNode<IntPtrT> phi_bb214_9;
  TNode<IntPtrT> phi_bb214_10;
  TNode<IntPtrT> phi_bb214_11;
  TNode<IntPtrT> phi_bb214_13;
  TNode<BoolT> phi_bb214_14;
  TNode<IntPtrT> phi_bb214_20;
  TNode<IntPtrT> tmp491;
  TNode<IntPtrT> tmp492;
  TNode<IntPtrT> tmp493;
  TNode<BoolT> tmp494;
  if (block214.is_used()) {
    ca_.Bind(&block214, &phi_bb214_7, &phi_bb214_8, &phi_bb214_9, &phi_bb214_10, &phi_bb214_11, &phi_bb214_13, &phi_bb214_14, &phi_bb214_20);
    tmp491 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp492 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb214_8}, TNode<IntPtrT>{tmp491});
    tmp493 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp494 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb214_8}, TNode<IntPtrT>{tmp493});
    ca_.Branch(tmp494, &block218, std::vector<compiler::Node*>{phi_bb214_7, phi_bb214_9, phi_bb214_10, phi_bb214_11, phi_bb214_13, phi_bb214_14, phi_bb214_20}, &block219, std::vector<compiler::Node*>{phi_bb214_7, phi_bb214_9, phi_bb214_10, phi_bb214_11, phi_bb214_13, phi_bb214_14, phi_bb214_20});
  }

  TNode<IntPtrT> phi_bb218_7;
  TNode<IntPtrT> phi_bb218_9;
  TNode<IntPtrT> phi_bb218_10;
  TNode<IntPtrT> phi_bb218_11;
  TNode<IntPtrT> phi_bb218_13;
  TNode<BoolT> phi_bb218_14;
  TNode<IntPtrT> phi_bb218_20;
  TNode<Object> tmp495;
  TNode<IntPtrT> tmp496;
  TNode<IntPtrT> tmp497;
  TNode<IntPtrT> tmp498;
  if (block218.is_used()) {
    ca_.Bind(&block218, &phi_bb218_7, &phi_bb218_9, &phi_bb218_10, &phi_bb218_11, &phi_bb218_13, &phi_bb218_14, &phi_bb218_20);
    std::tie(tmp495, tmp496) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb218_10}).Flatten();
    tmp497 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_float64_0(state_)));
    tmp498 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb218_10}, TNode<IntPtrT>{tmp497});
    ca_.Goto(&block217, phi_bb218_7, phi_bb218_9, tmp498, phi_bb218_11, phi_bb218_13, phi_bb218_14, phi_bb218_20, tmp495, tmp496);
  }

  TNode<IntPtrT> phi_bb219_7;
  TNode<IntPtrT> phi_bb219_9;
  TNode<IntPtrT> phi_bb219_10;
  TNode<IntPtrT> phi_bb219_11;
  TNode<IntPtrT> phi_bb219_13;
  TNode<BoolT> phi_bb219_14;
  TNode<IntPtrT> phi_bb219_20;
  if (block219.is_used()) {
    ca_.Bind(&block219, &phi_bb219_7, &phi_bb219_9, &phi_bb219_10, &phi_bb219_11, &phi_bb219_13, &phi_bb219_14, &phi_bb219_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block220, phi_bb219_7, phi_bb219_9, phi_bb219_10, phi_bb219_11, phi_bb219_13, phi_bb219_14, phi_bb219_20);
    } else {
      ca_.Goto(&block221, phi_bb219_7, phi_bb219_9, phi_bb219_10, phi_bb219_11, phi_bb219_13, phi_bb219_14, phi_bb219_20);
    }
  }

  TNode<IntPtrT> phi_bb220_7;
  TNode<IntPtrT> phi_bb220_9;
  TNode<IntPtrT> phi_bb220_10;
  TNode<IntPtrT> phi_bb220_11;
  TNode<IntPtrT> phi_bb220_13;
  TNode<BoolT> phi_bb220_14;
  TNode<IntPtrT> phi_bb220_20;
  if (block220.is_used()) {
    ca_.Bind(&block220, &phi_bb220_7, &phi_bb220_9, &phi_bb220_10, &phi_bb220_11, &phi_bb220_13, &phi_bb220_14, &phi_bb220_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block224, phi_bb220_7, phi_bb220_9, phi_bb220_10, phi_bb220_11, phi_bb220_13, phi_bb220_14, phi_bb220_20);
    } else {
      ca_.Goto(&block225, phi_bb220_7, phi_bb220_9, phi_bb220_10, phi_bb220_11, phi_bb220_13, phi_bb220_14, phi_bb220_20);
    }
  }

  TNode<IntPtrT> phi_bb224_7;
  TNode<IntPtrT> phi_bb224_9;
  TNode<IntPtrT> phi_bb224_10;
  TNode<IntPtrT> phi_bb224_11;
  TNode<IntPtrT> phi_bb224_13;
  TNode<BoolT> phi_bb224_14;
  TNode<IntPtrT> phi_bb224_20;
  TNode<Object> tmp499;
  TNode<IntPtrT> tmp500;
  TNode<IntPtrT> tmp501;
  TNode<IntPtrT> tmp502;
  if (block224.is_used()) {
    ca_.Bind(&block224, &phi_bb224_7, &phi_bb224_9, &phi_bb224_10, &phi_bb224_11, &phi_bb224_13, &phi_bb224_14, &phi_bb224_20);
    std::tie(tmp499, tmp500) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb224_11}).Flatten();
    tmp501 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp502 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb224_11}, TNode<IntPtrT>{tmp501});
    ca_.Goto(&block223, phi_bb224_7, phi_bb224_9, phi_bb224_10, tmp502, phi_bb224_13, phi_bb224_14, phi_bb224_20, tmp499, tmp500);
  }

  TNode<IntPtrT> phi_bb225_7;
  TNode<IntPtrT> phi_bb225_9;
  TNode<IntPtrT> phi_bb225_10;
  TNode<IntPtrT> phi_bb225_11;
  TNode<IntPtrT> phi_bb225_13;
  TNode<BoolT> phi_bb225_14;
  TNode<IntPtrT> phi_bb225_20;
  TNode<IntPtrT> tmp503;
  TNode<BoolT> tmp504;
  if (block225.is_used()) {
    ca_.Bind(&block225, &phi_bb225_7, &phi_bb225_9, &phi_bb225_10, &phi_bb225_11, &phi_bb225_13, &phi_bb225_14, &phi_bb225_20);
    tmp503 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp504 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb225_13}, TNode<IntPtrT>{tmp503});
    ca_.Branch(tmp504, &block227, std::vector<compiler::Node*>{phi_bb225_7, phi_bb225_9, phi_bb225_10, phi_bb225_11, phi_bb225_13, phi_bb225_14, phi_bb225_20}, &block228, std::vector<compiler::Node*>{phi_bb225_7, phi_bb225_9, phi_bb225_10, phi_bb225_11, phi_bb225_13, phi_bb225_14, phi_bb225_20});
  }

  TNode<IntPtrT> phi_bb227_7;
  TNode<IntPtrT> phi_bb227_9;
  TNode<IntPtrT> phi_bb227_10;
  TNode<IntPtrT> phi_bb227_11;
  TNode<IntPtrT> phi_bb227_13;
  TNode<BoolT> phi_bb227_14;
  TNode<IntPtrT> phi_bb227_20;
  TNode<Object> tmp505;
  TNode<IntPtrT> tmp506;
  TNode<IntPtrT> tmp507;
  TNode<BoolT> tmp508;
  if (block227.is_used()) {
    ca_.Bind(&block227, &phi_bb227_7, &phi_bb227_9, &phi_bb227_10, &phi_bb227_11, &phi_bb227_13, &phi_bb227_14, &phi_bb227_20);
    std::tie(tmp505, tmp506) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb227_13}).Flatten();
    tmp507 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp508 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block223, phi_bb227_7, phi_bb227_9, phi_bb227_10, phi_bb227_11, tmp507, tmp508, phi_bb227_20, tmp505, tmp506);
  }

  TNode<IntPtrT> phi_bb228_7;
  TNode<IntPtrT> phi_bb228_9;
  TNode<IntPtrT> phi_bb228_10;
  TNode<IntPtrT> phi_bb228_11;
  TNode<IntPtrT> phi_bb228_13;
  TNode<BoolT> phi_bb228_14;
  TNode<IntPtrT> phi_bb228_20;
  TNode<Object> tmp509;
  TNode<IntPtrT> tmp510;
  TNode<IntPtrT> tmp511;
  TNode<IntPtrT> tmp512;
  TNode<IntPtrT> tmp513;
  TNode<IntPtrT> tmp514;
  TNode<BoolT> tmp515;
  if (block228.is_used()) {
    ca_.Bind(&block228, &phi_bb228_7, &phi_bb228_9, &phi_bb228_10, &phi_bb228_11, &phi_bb228_13, &phi_bb228_14, &phi_bb228_20);
    std::tie(tmp509, tmp510) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb228_11}).Flatten();
    tmp511 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp512 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb228_11}, TNode<IntPtrT>{tmp511});
    tmp513 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp514 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp512}, TNode<IntPtrT>{tmp513});
    tmp515 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block223, phi_bb228_7, phi_bb228_9, phi_bb228_10, tmp514, tmp512, tmp515, phi_bb228_20, tmp509, tmp510);
  }

  TNode<IntPtrT> phi_bb223_7;
  TNode<IntPtrT> phi_bb223_9;
  TNode<IntPtrT> phi_bb223_10;
  TNode<IntPtrT> phi_bb223_11;
  TNode<IntPtrT> phi_bb223_13;
  TNode<BoolT> phi_bb223_14;
  TNode<IntPtrT> phi_bb223_20;
  TNode<Object> phi_bb223_22;
  TNode<IntPtrT> phi_bb223_23;
  if (block223.is_used()) {
    ca_.Bind(&block223, &phi_bb223_7, &phi_bb223_9, &phi_bb223_10, &phi_bb223_11, &phi_bb223_13, &phi_bb223_14, &phi_bb223_20, &phi_bb223_22, &phi_bb223_23);
    ca_.Goto(&block217, phi_bb223_7, phi_bb223_9, phi_bb223_10, phi_bb223_11, phi_bb223_13, phi_bb223_14, phi_bb223_20, phi_bb223_22, phi_bb223_23);
  }

  TNode<IntPtrT> phi_bb221_7;
  TNode<IntPtrT> phi_bb221_9;
  TNode<IntPtrT> phi_bb221_10;
  TNode<IntPtrT> phi_bb221_11;
  TNode<IntPtrT> phi_bb221_13;
  TNode<BoolT> phi_bb221_14;
  TNode<IntPtrT> phi_bb221_20;
  TNode<Object> tmp516;
  TNode<IntPtrT> tmp517;
  TNode<IntPtrT> tmp518;
  TNode<IntPtrT> tmp519;
  TNode<BoolT> tmp520;
  if (block221.is_used()) {
    ca_.Bind(&block221, &phi_bb221_7, &phi_bb221_9, &phi_bb221_10, &phi_bb221_11, &phi_bb221_13, &phi_bb221_14, &phi_bb221_20);
    std::tie(tmp516, tmp517) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb221_11}).Flatten();
    tmp518 = FromConstexpr_intptr_constexpr_int31_0(state_, (CodeStubAssembler(state_).ConstexprInt31Mul((FromConstexpr_constexpr_int31_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x2ull))), (SizeOf_intptr_0(state_)))));
    tmp519 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb221_11}, TNode<IntPtrT>{tmp518});
    tmp520 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block217, phi_bb221_7, phi_bb221_9, phi_bb221_10, tmp519, phi_bb221_13, tmp520, phi_bb221_20, tmp516, tmp517);
  }

  TNode<IntPtrT> phi_bb217_7;
  TNode<IntPtrT> phi_bb217_9;
  TNode<IntPtrT> phi_bb217_10;
  TNode<IntPtrT> phi_bb217_11;
  TNode<IntPtrT> phi_bb217_13;
  TNode<BoolT> phi_bb217_14;
  TNode<IntPtrT> phi_bb217_20;
  TNode<Object> phi_bb217_22;
  TNode<IntPtrT> phi_bb217_23;
  TNode<Object> tmp521;
  TNode<IntPtrT> tmp522;
  TNode<Float64T> tmp523;
  TNode<Object> tmp524;
  TNode<IntPtrT> tmp525;
  TNode<IntPtrT> tmp526;
  TNode<UintPtrT> tmp527;
  TNode<UintPtrT> tmp528;
  TNode<BoolT> tmp529;
  if (block217.is_used()) {
    ca_.Bind(&block217, &phi_bb217_7, &phi_bb217_9, &phi_bb217_10, &phi_bb217_11, &phi_bb217_13, &phi_bb217_14, &phi_bb217_20, &phi_bb217_22, &phi_bb217_23);
    std::tie(tmp521, tmp522) = RefCast_float64_0(state_, TorqueStructReference_intptr_0{TNode<Object>{phi_bb217_22}, TNode<IntPtrT>{phi_bb217_23}, TorqueStructUnsafe_0{}}).Flatten();
    tmp523 = CodeStubAssembler(state_).LoadReference<Float64T>(CodeStubAssembler::Reference{tmp521, tmp522});
    std::tie(tmp524, tmp525, tmp526) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp66}).Flatten();
    tmp527 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb217_20});
    tmp528 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp526});
    tmp529 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp527}, TNode<UintPtrT>{tmp528});
    ca_.Branch(tmp529, &block233, std::vector<compiler::Node*>{phi_bb217_7, phi_bb217_9, phi_bb217_10, phi_bb217_11, phi_bb217_13, phi_bb217_14, phi_bb217_20, phi_bb217_22, phi_bb217_23, phi_bb217_20, phi_bb217_20, phi_bb217_20, phi_bb217_20}, &block234, std::vector<compiler::Node*>{phi_bb217_7, phi_bb217_9, phi_bb217_10, phi_bb217_11, phi_bb217_13, phi_bb217_14, phi_bb217_20, phi_bb217_22, phi_bb217_23, phi_bb217_20, phi_bb217_20, phi_bb217_20, phi_bb217_20});
  }

  TNode<IntPtrT> phi_bb233_7;
  TNode<IntPtrT> phi_bb233_9;
  TNode<IntPtrT> phi_bb233_10;
  TNode<IntPtrT> phi_bb233_11;
  TNode<IntPtrT> phi_bb233_13;
  TNode<BoolT> phi_bb233_14;
  TNode<IntPtrT> phi_bb233_20;
  TNode<Object> phi_bb233_22;
  TNode<IntPtrT> phi_bb233_23;
  TNode<IntPtrT> phi_bb233_29;
  TNode<IntPtrT> phi_bb233_30;
  TNode<IntPtrT> phi_bb233_34;
  TNode<IntPtrT> phi_bb233_35;
  TNode<IntPtrT> tmp530;
  TNode<IntPtrT> tmp531;
  TNode<Object> tmp532;
  TNode<IntPtrT> tmp533;
  TNode<Number> tmp534;
  if (block233.is_used()) {
    ca_.Bind(&block233, &phi_bb233_7, &phi_bb233_9, &phi_bb233_10, &phi_bb233_11, &phi_bb233_13, &phi_bb233_14, &phi_bb233_20, &phi_bb233_22, &phi_bb233_23, &phi_bb233_29, &phi_bb233_30, &phi_bb233_34, &phi_bb233_35);
    tmp530 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb233_35});
    tmp531 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp525}, TNode<IntPtrT>{tmp530});
    std::tie(tmp532, tmp533) = NewReference_Object_0(state_, TNode<Object>{tmp524}, TNode<IntPtrT>{tmp531}).Flatten();
    tmp534 = Convert_Number_float64_0(state_, TNode<Float64T>{tmp523});
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp532, tmp533}, tmp534);
    ca_.Goto(&block216, phi_bb233_7, tmp492, phi_bb233_9, phi_bb233_10, phi_bb233_11, phi_bb233_13, phi_bb233_14, phi_bb233_20);
  }

  TNode<IntPtrT> phi_bb234_7;
  TNode<IntPtrT> phi_bb234_9;
  TNode<IntPtrT> phi_bb234_10;
  TNode<IntPtrT> phi_bb234_11;
  TNode<IntPtrT> phi_bb234_13;
  TNode<BoolT> phi_bb234_14;
  TNode<IntPtrT> phi_bb234_20;
  TNode<Object> phi_bb234_22;
  TNode<IntPtrT> phi_bb234_23;
  TNode<IntPtrT> phi_bb234_29;
  TNode<IntPtrT> phi_bb234_30;
  TNode<IntPtrT> phi_bb234_34;
  TNode<IntPtrT> phi_bb234_35;
  if (block234.is_used()) {
    ca_.Bind(&block234, &phi_bb234_7, &phi_bb234_9, &phi_bb234_10, &phi_bb234_11, &phi_bb234_13, &phi_bb234_14, &phi_bb234_20, &phi_bb234_22, &phi_bb234_23, &phi_bb234_29, &phi_bb234_30, &phi_bb234_34, &phi_bb234_35);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb215_7;
  TNode<IntPtrT> phi_bb215_8;
  TNode<IntPtrT> phi_bb215_9;
  TNode<IntPtrT> phi_bb215_10;
  TNode<IntPtrT> phi_bb215_11;
  TNode<IntPtrT> phi_bb215_13;
  TNode<BoolT> phi_bb215_14;
  TNode<IntPtrT> phi_bb215_20;
  TNode<IntPtrT> tmp535;
  TNode<IntPtrT> tmp536;
  TNode<IntPtrT> tmp537;
  TNode<BoolT> tmp538;
  if (block215.is_used()) {
    ca_.Bind(&block215, &phi_bb215_7, &phi_bb215_8, &phi_bb215_9, &phi_bb215_10, &phi_bb215_11, &phi_bb215_13, &phi_bb215_14, &phi_bb215_20);
    tmp535 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp536 = CodeStubAssembler(state_).IntPtrSub(TNode<IntPtrT>{phi_bb215_7}, TNode<IntPtrT>{tmp535});
    tmp537 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp538 = CodeStubAssembler(state_).IntPtrGreaterThan(TNode<IntPtrT>{phi_bb215_7}, TNode<IntPtrT>{tmp537});
    ca_.Branch(tmp538, &block238, std::vector<compiler::Node*>{phi_bb215_8, phi_bb215_9, phi_bb215_10, phi_bb215_11, phi_bb215_13, phi_bb215_14, phi_bb215_20}, &block239, std::vector<compiler::Node*>{phi_bb215_8, phi_bb215_9, phi_bb215_10, phi_bb215_11, phi_bb215_13, phi_bb215_14, phi_bb215_20});
  }

  TNode<IntPtrT> phi_bb238_8;
  TNode<IntPtrT> phi_bb238_9;
  TNode<IntPtrT> phi_bb238_10;
  TNode<IntPtrT> phi_bb238_11;
  TNode<IntPtrT> phi_bb238_13;
  TNode<BoolT> phi_bb238_14;
  TNode<IntPtrT> phi_bb238_20;
  TNode<Object> tmp539;
  TNode<IntPtrT> tmp540;
  TNode<IntPtrT> tmp541;
  TNode<IntPtrT> tmp542;
  if (block238.is_used()) {
    ca_.Bind(&block238, &phi_bb238_8, &phi_bb238_9, &phi_bb238_10, &phi_bb238_11, &phi_bb238_13, &phi_bb238_14, &phi_bb238_20);
    std::tie(tmp539, tmp540) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb238_9}).Flatten();
    tmp541 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp542 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb238_9}, TNode<IntPtrT>{tmp541});
    ca_.Goto(&block237, phi_bb238_8, tmp542, phi_bb238_10, phi_bb238_11, phi_bb238_13, phi_bb238_14, phi_bb238_20, tmp539, tmp540);
  }

  TNode<IntPtrT> phi_bb239_8;
  TNode<IntPtrT> phi_bb239_9;
  TNode<IntPtrT> phi_bb239_10;
  TNode<IntPtrT> phi_bb239_11;
  TNode<IntPtrT> phi_bb239_13;
  TNode<BoolT> phi_bb239_14;
  TNode<IntPtrT> phi_bb239_20;
  if (block239.is_used()) {
    ca_.Bind(&block239, &phi_bb239_8, &phi_bb239_9, &phi_bb239_10, &phi_bb239_11, &phi_bb239_13, &phi_bb239_14, &phi_bb239_20);
    if (((CodeStubAssembler(state_).Is64()))) {
      ca_.Goto(&block241, phi_bb239_8, phi_bb239_9, phi_bb239_10, phi_bb239_11, phi_bb239_13, phi_bb239_14, phi_bb239_20);
    } else {
      ca_.Goto(&block242, phi_bb239_8, phi_bb239_9, phi_bb239_10, phi_bb239_11, phi_bb239_13, phi_bb239_14, phi_bb239_20);
    }
  }

  TNode<IntPtrT> phi_bb241_8;
  TNode<IntPtrT> phi_bb241_9;
  TNode<IntPtrT> phi_bb241_10;
  TNode<IntPtrT> phi_bb241_11;
  TNode<IntPtrT> phi_bb241_13;
  TNode<BoolT> phi_bb241_14;
  TNode<IntPtrT> phi_bb241_20;
  TNode<Object> tmp543;
  TNode<IntPtrT> tmp544;
  TNode<IntPtrT> tmp545;
  TNode<IntPtrT> tmp546;
  if (block241.is_used()) {
    ca_.Bind(&block241, &phi_bb241_8, &phi_bb241_9, &phi_bb241_10, &phi_bb241_11, &phi_bb241_13, &phi_bb241_14, &phi_bb241_20);
    std::tie(tmp543, tmp544) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb241_11}).Flatten();
    tmp545 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp546 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb241_11}, TNode<IntPtrT>{tmp545});
    ca_.Goto(&block240, phi_bb241_8, phi_bb241_9, phi_bb241_10, tmp546, phi_bb241_13, phi_bb241_14, phi_bb241_20, tmp543, tmp544);
  }

  TNode<IntPtrT> phi_bb242_8;
  TNode<IntPtrT> phi_bb242_9;
  TNode<IntPtrT> phi_bb242_10;
  TNode<IntPtrT> phi_bb242_11;
  TNode<IntPtrT> phi_bb242_13;
  TNode<BoolT> phi_bb242_14;
  TNode<IntPtrT> phi_bb242_20;
  TNode<IntPtrT> tmp547;
  TNode<BoolT> tmp548;
  if (block242.is_used()) {
    ca_.Bind(&block242, &phi_bb242_8, &phi_bb242_9, &phi_bb242_10, &phi_bb242_11, &phi_bb242_13, &phi_bb242_14, &phi_bb242_20);
    tmp547 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp548 = CodeStubAssembler(state_).WordNotEqual(TNode<IntPtrT>{phi_bb242_13}, TNode<IntPtrT>{tmp547});
    ca_.Branch(tmp548, &block244, std::vector<compiler::Node*>{phi_bb242_8, phi_bb242_9, phi_bb242_10, phi_bb242_11, phi_bb242_13, phi_bb242_14, phi_bb242_20}, &block245, std::vector<compiler::Node*>{phi_bb242_8, phi_bb242_9, phi_bb242_10, phi_bb242_11, phi_bb242_13, phi_bb242_14, phi_bb242_20});
  }

  TNode<IntPtrT> phi_bb244_8;
  TNode<IntPtrT> phi_bb244_9;
  TNode<IntPtrT> phi_bb244_10;
  TNode<IntPtrT> phi_bb244_11;
  TNode<IntPtrT> phi_bb244_13;
  TNode<BoolT> phi_bb244_14;
  TNode<IntPtrT> phi_bb244_20;
  TNode<Object> tmp549;
  TNode<IntPtrT> tmp550;
  TNode<IntPtrT> tmp551;
  TNode<BoolT> tmp552;
  if (block244.is_used()) {
    ca_.Bind(&block244, &phi_bb244_8, &phi_bb244_9, &phi_bb244_10, &phi_bb244_11, &phi_bb244_13, &phi_bb244_14, &phi_bb244_20);
    std::tie(tmp549, tmp550) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb244_13}).Flatten();
    tmp551 = FromConstexpr_intptr_constexpr_IntegerLiteral_0(state_, IntegerLiteral(false, 0x0ull));
    tmp552 = FromConstexpr_bool_constexpr_bool_0(state_, false);
    ca_.Goto(&block240, phi_bb244_8, phi_bb244_9, phi_bb244_10, phi_bb244_11, tmp551, tmp552, phi_bb244_20, tmp549, tmp550);
  }

  TNode<IntPtrT> phi_bb245_8;
  TNode<IntPtrT> phi_bb245_9;
  TNode<IntPtrT> phi_bb245_10;
  TNode<IntPtrT> phi_bb245_11;
  TNode<IntPtrT> phi_bb245_13;
  TNode<BoolT> phi_bb245_14;
  TNode<IntPtrT> phi_bb245_20;
  TNode<Object> tmp553;
  TNode<IntPtrT> tmp554;
  TNode<IntPtrT> tmp555;
  TNode<IntPtrT> tmp556;
  TNode<IntPtrT> tmp557;
  TNode<IntPtrT> tmp558;
  TNode<BoolT> tmp559;
  if (block245.is_used()) {
    ca_.Bind(&block245, &phi_bb245_8, &phi_bb245_9, &phi_bb245_10, &phi_bb245_11, &phi_bb245_13, &phi_bb245_14, &phi_bb245_20);
    std::tie(tmp553, tmp554) = NewReference_intptr_0(state_, TNode<Object>{tmp287}, TNode<IntPtrT>{phi_bb245_11}).Flatten();
    tmp555 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp556 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb245_11}, TNode<IntPtrT>{tmp555});
    tmp557 = FromConstexpr_intptr_constexpr_int31_0(state_, (SizeOf_intptr_0(state_)));
    tmp558 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp556}, TNode<IntPtrT>{tmp557});
    tmp559 = FromConstexpr_bool_constexpr_bool_0(state_, true);
    ca_.Goto(&block240, phi_bb245_8, phi_bb245_9, phi_bb245_10, tmp558, tmp556, tmp559, phi_bb245_20, tmp553, tmp554);
  }

  TNode<IntPtrT> phi_bb240_8;
  TNode<IntPtrT> phi_bb240_9;
  TNode<IntPtrT> phi_bb240_10;
  TNode<IntPtrT> phi_bb240_11;
  TNode<IntPtrT> phi_bb240_13;
  TNode<BoolT> phi_bb240_14;
  TNode<IntPtrT> phi_bb240_20;
  TNode<Object> phi_bb240_22;
  TNode<IntPtrT> phi_bb240_23;
  if (block240.is_used()) {
    ca_.Bind(&block240, &phi_bb240_8, &phi_bb240_9, &phi_bb240_10, &phi_bb240_11, &phi_bb240_13, &phi_bb240_14, &phi_bb240_20, &phi_bb240_22, &phi_bb240_23);
    ca_.Goto(&block237, phi_bb240_8, phi_bb240_9, phi_bb240_10, phi_bb240_11, phi_bb240_13, phi_bb240_14, phi_bb240_20, phi_bb240_22, phi_bb240_23);
  }

  TNode<IntPtrT> phi_bb237_8;
  TNode<IntPtrT> phi_bb237_9;
  TNode<IntPtrT> phi_bb237_10;
  TNode<IntPtrT> phi_bb237_11;
  TNode<IntPtrT> phi_bb237_13;
  TNode<BoolT> phi_bb237_14;
  TNode<IntPtrT> phi_bb237_20;
  TNode<Object> phi_bb237_22;
  TNode<IntPtrT> phi_bb237_23;
  TNode<Object> tmp560;
  TNode<IntPtrT> tmp561;
  TNode<IntPtrT> tmp562;
  TNode<UintPtrT> tmp563;
  TNode<UintPtrT> tmp564;
  TNode<BoolT> tmp565;
  if (block237.is_used()) {
    ca_.Bind(&block237, &phi_bb237_8, &phi_bb237_9, &phi_bb237_10, &phi_bb237_11, &phi_bb237_13, &phi_bb237_14, &phi_bb237_20, &phi_bb237_22, &phi_bb237_23);
    std::tie(tmp560, tmp561, tmp562) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp66}).Flatten();
    tmp563 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb237_20});
    tmp564 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp562});
    tmp565 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp563}, TNode<UintPtrT>{tmp564});
    ca_.Branch(tmp565, &block250, std::vector<compiler::Node*>{phi_bb237_8, phi_bb237_9, phi_bb237_10, phi_bb237_11, phi_bb237_13, phi_bb237_14, phi_bb237_20, phi_bb237_20, phi_bb237_20, phi_bb237_20, phi_bb237_20}, &block251, std::vector<compiler::Node*>{phi_bb237_8, phi_bb237_9, phi_bb237_10, phi_bb237_11, phi_bb237_13, phi_bb237_14, phi_bb237_20, phi_bb237_20, phi_bb237_20, phi_bb237_20, phi_bb237_20});
  }

  TNode<IntPtrT> phi_bb250_8;
  TNode<IntPtrT> phi_bb250_9;
  TNode<IntPtrT> phi_bb250_10;
  TNode<IntPtrT> phi_bb250_11;
  TNode<IntPtrT> phi_bb250_13;
  TNode<BoolT> phi_bb250_14;
  TNode<IntPtrT> phi_bb250_20;
  TNode<IntPtrT> phi_bb250_26;
  TNode<IntPtrT> phi_bb250_27;
  TNode<IntPtrT> phi_bb250_31;
  TNode<IntPtrT> phi_bb250_32;
  TNode<IntPtrT> tmp566;
  TNode<IntPtrT> tmp567;
  TNode<Object> tmp568;
  TNode<IntPtrT> tmp569;
  TNode<Object> tmp570;
  TNode<Object> tmp571;
  TNode<IntPtrT> tmp572;
  TNode<IntPtrT> tmp573;
  TNode<UintPtrT> tmp574;
  TNode<UintPtrT> tmp575;
  TNode<BoolT> tmp576;
  if (block250.is_used()) {
    ca_.Bind(&block250, &phi_bb250_8, &phi_bb250_9, &phi_bb250_10, &phi_bb250_11, &phi_bb250_13, &phi_bb250_14, &phi_bb250_20, &phi_bb250_26, &phi_bb250_27, &phi_bb250_31, &phi_bb250_32);
    tmp566 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb250_32});
    tmp567 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp561}, TNode<IntPtrT>{tmp566});
    std::tie(tmp568, tmp569) = NewReference_Object_0(state_, TNode<Object>{tmp560}, TNode<IntPtrT>{tmp567}).Flatten();
    tmp570 = CodeStubAssembler(state_).LoadReference<Object>(CodeStubAssembler::Reference{tmp568, tmp569});
    std::tie(tmp571, tmp572, tmp573) = FieldSliceFixedArrayObjects_0(state_, TNode<FixedArray>{tmp66}).Flatten();
    tmp574 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{phi_bb250_20});
    tmp575 = Convert_uintptr_intptr_0(state_, TNode<IntPtrT>{tmp573});
    tmp576 = CodeStubAssembler(state_).UintPtrLessThan(TNode<UintPtrT>{tmp574}, TNode<UintPtrT>{tmp575});
    ca_.Branch(tmp576, &block258, std::vector<compiler::Node*>{phi_bb250_8, phi_bb250_9, phi_bb250_10, phi_bb250_11, phi_bb250_13, phi_bb250_14, phi_bb250_20, phi_bb250_20, phi_bb250_20, phi_bb250_20, phi_bb250_20}, &block259, std::vector<compiler::Node*>{phi_bb250_8, phi_bb250_9, phi_bb250_10, phi_bb250_11, phi_bb250_13, phi_bb250_14, phi_bb250_20, phi_bb250_20, phi_bb250_20, phi_bb250_20, phi_bb250_20});
  }

  TNode<IntPtrT> phi_bb251_8;
  TNode<IntPtrT> phi_bb251_9;
  TNode<IntPtrT> phi_bb251_10;
  TNode<IntPtrT> phi_bb251_11;
  TNode<IntPtrT> phi_bb251_13;
  TNode<BoolT> phi_bb251_14;
  TNode<IntPtrT> phi_bb251_20;
  TNode<IntPtrT> phi_bb251_26;
  TNode<IntPtrT> phi_bb251_27;
  TNode<IntPtrT> phi_bb251_31;
  TNode<IntPtrT> phi_bb251_32;
  if (block251.is_used()) {
    ca_.Bind(&block251, &phi_bb251_8, &phi_bb251_9, &phi_bb251_10, &phi_bb251_11, &phi_bb251_13, &phi_bb251_14, &phi_bb251_20, &phi_bb251_26, &phi_bb251_27, &phi_bb251_31, &phi_bb251_32);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb258_8;
  TNode<IntPtrT> phi_bb258_9;
  TNode<IntPtrT> phi_bb258_10;
  TNode<IntPtrT> phi_bb258_11;
  TNode<IntPtrT> phi_bb258_13;
  TNode<BoolT> phi_bb258_14;
  TNode<IntPtrT> phi_bb258_20;
  TNode<IntPtrT> phi_bb258_27;
  TNode<IntPtrT> phi_bb258_28;
  TNode<IntPtrT> phi_bb258_32;
  TNode<IntPtrT> phi_bb258_33;
  TNode<IntPtrT> tmp577;
  TNode<IntPtrT> tmp578;
  TNode<Object> tmp579;
  TNode<IntPtrT> tmp580;
  TNode<NativeContext> tmp581;
  TNode<Object> tmp582;
  if (block258.is_used()) {
    ca_.Bind(&block258, &phi_bb258_8, &phi_bb258_9, &phi_bb258_10, &phi_bb258_11, &phi_bb258_13, &phi_bb258_14, &phi_bb258_20, &phi_bb258_27, &phi_bb258_28, &phi_bb258_32, &phi_bb258_33);
    tmp577 = TimesSizeOf_Object_0(state_, TNode<IntPtrT>{phi_bb258_33});
    tmp578 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp572}, TNode<IntPtrT>{tmp577});
    std::tie(tmp579, tmp580) = NewReference_Object_0(state_, TNode<Object>{tmp571}, TNode<IntPtrT>{tmp578}).Flatten();
    tmp581 = WasmBuiltinsAssembler(state_).LoadContextFromInstanceData(TNode<WasmTrustedInstanceData>{parameter0});
    tmp582 = WasmToJSObject_0(state_, TNode<NativeContext>{tmp581}, TNode<Object>{tmp570}, TNode<Int32T>{tmp304});
    CodeStubAssembler(state_).StoreReference<Object>(CodeStubAssembler::Reference{tmp579, tmp580}, tmp582);
    ca_.Goto(&block216, tmp536, phi_bb258_8, phi_bb258_9, phi_bb258_10, phi_bb258_11, phi_bb258_13, phi_bb258_14, phi_bb258_20);
  }

  TNode<IntPtrT> phi_bb259_8;
  TNode<IntPtrT> phi_bb259_9;
  TNode<IntPtrT> phi_bb259_10;
  TNode<IntPtrT> phi_bb259_11;
  TNode<IntPtrT> phi_bb259_13;
  TNode<BoolT> phi_bb259_14;
  TNode<IntPtrT> phi_bb259_20;
  TNode<IntPtrT> phi_bb259_27;
  TNode<IntPtrT> phi_bb259_28;
  TNode<IntPtrT> phi_bb259_32;
  TNode<IntPtrT> phi_bb259_33;
  if (block259.is_used()) {
    ca_.Bind(&block259, &phi_bb259_8, &phi_bb259_9, &phi_bb259_10, &phi_bb259_11, &phi_bb259_13, &phi_bb259_14, &phi_bb259_20, &phi_bb259_27, &phi_bb259_28, &phi_bb259_32, &phi_bb259_33);
    CodeStubAssembler(state_).Unreachable();
  }

  TNode<IntPtrT> phi_bb216_7;
  TNode<IntPtrT> phi_bb216_8;
  TNode<IntPtrT> phi_bb216_9;
  TNode<IntPtrT> phi_bb216_10;
  TNode<IntPtrT> phi_bb216_11;
  TNode<IntPtrT> phi_bb216_13;
  TNode<BoolT> phi_bb216_14;
  TNode<IntPtrT> phi_bb216_20;
  if (block216.is_used()) {
    ca_.Bind(&block216, &phi_bb216_7, &phi_bb216_8, &phi_bb216_9, &phi_bb216_10, &phi_bb216_11, &phi_bb216_13, &phi_bb216_14, &phi_bb216_20);
    ca_.Goto(&block167, phi_bb216_7, phi_bb216_8, phi_bb216_9, phi_bb216_10, phi_bb216_11, phi_bb216_13, phi_bb216_14, phi_bb216_20);
  }

  TNode<IntPtrT> phi_bb167_7;
  TNode<IntPtrT> phi_bb167_8;
  TNode<IntPtrT> phi_bb167_9;
  TNode<IntPtrT> phi_bb167_10;
  TNode<IntPtrT> phi_bb167_11;
  TNode<IntPtrT> phi_bb167_13;
  TNode<BoolT> phi_bb167_14;
  TNode<IntPtrT> phi_bb167_20;
  if (block167.is_used()) {
    ca_.Bind(&block167, &phi_bb167_7, &phi_bb167_8, &phi_bb167_9, &phi_bb167_10, &phi_bb167_11, &phi_bb167_13, &phi_bb167_14, &phi_bb167_20);
    ca_.Goto(&block147, phi_bb167_7, phi_bb167_8, phi_bb167_9, phi_bb167_10, phi_bb167_11, phi_bb167_13, phi_bb167_14, phi_bb167_20);
  }

  TNode<IntPtrT> phi_bb147_7;
  TNode<IntPtrT> phi_bb147_8;
  TNode<IntPtrT> phi_bb147_9;
  TNode<IntPtrT> phi_bb147_10;
  TNode<IntPtrT> phi_bb147_11;
  TNode<IntPtrT> phi_bb147_13;
  TNode<BoolT> phi_bb147_14;
  TNode<IntPtrT> phi_bb147_20;
  if (block147.is_used()) {
    ca_.Bind(&block147, &phi_bb147_7, &phi_bb147_8, &phi_bb147_9, &phi_bb147_10, &phi_bb147_11, &phi_bb147_13, &phi_bb147_14, &phi_bb147_20);
    ca_.Goto(&block127, phi_bb147_7, phi_bb147_8, phi_bb147_9, phi_bb147_10, phi_bb147_11, phi_bb147_13, phi_bb147_14, phi_bb147_20);
  }

  TNode<IntPtrT> phi_bb127_7;
  TNode<IntPtrT> phi_bb127_8;
  TNode<IntPtrT> phi_bb127_9;
  TNode<IntPtrT> phi_bb127_10;
  TNode<IntPtrT> phi_bb127_11;
  TNode<IntPtrT> phi_bb127_13;
  TNode<BoolT> phi_bb127_14;
  TNode<IntPtrT> phi_bb127_20;
  TNode<IntPtrT> tmp583;
  TNode<IntPtrT> tmp584;
  if (block127.is_used()) {
    ca_.Bind(&block127, &phi_bb127_7, &phi_bb127_8, &phi_bb127_9, &phi_bb127_10, &phi_bb127_11, &phi_bb127_13, &phi_bb127_14, &phi_bb127_20);
    tmp583 = FromConstexpr_intptr_constexpr_int31_0(state_, 1);
    tmp584 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{phi_bb127_20}, TNode<IntPtrT>{tmp583});
    ca_.Goto(&block122, phi_bb127_7, phi_bb127_8, phi_bb127_9, phi_bb127_10, phi_bb127_11, phi_bb127_13, phi_bb127_14, tmp584);
  }

  TNode<IntPtrT> phi_bb121_7;
  TNode<IntPtrT> phi_bb121_8;
  TNode<IntPtrT> phi_bb121_9;
  TNode<IntPtrT> phi_bb121_10;
  TNode<IntPtrT> phi_bb121_11;
  TNode<IntPtrT> phi_bb121_13;
  TNode<BoolT> phi_bb121_14;
  TNode<IntPtrT> phi_bb121_20;
  if (block121.is_used()) {
    ca_.Bind(&block121, &phi_bb121_7, &phi_bb121_8, &phi_bb121_9, &phi_bb121_10, &phi_bb121_11, &phi_bb121_13, &phi_bb121_14, &phi_bb121_20);
    CodeStubAssembler(state_).Return(parameter1);
  }
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=382&c=47
int31_t SizeOf_intptr_0(compiler::CodeAssemblerState* state_) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  if (block0.is_used()) {
    ca_.Bind(&block0);
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return kIntptrSize;
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=390&c=32
int31_t SizeOf_float64_0(compiler::CodeAssemblerState* state_) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  if (block0.is_used()) {
    ca_.Bind(&block0);
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return kDoubleSize;
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=448&c=24
TNode<WasmExportedFunctionData> UnsafeCast_WasmExportedFunctionData_0(compiler::CodeAssemblerState* state_, TNode<Context> p_context, TNode<Object> p_o) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block6(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<WasmExportedFunctionData> tmp0;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = TORQUE_CAST(TNode<Object>{p_o});
    ca_.Goto(&block6);
  }

    ca_.Bind(&block6);
  return TNode<WasmExportedFunctionData>{tmp0};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=463&c=23
TorqueStructReference_int32_0 GetRefAt_int32_RawPtr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_int32_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_int32_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=467&c=17
TorqueStructReference_RawPtr_0 GetRefAt_RawPtr_RawPtr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_RawPtr_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_RawPtr_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=469&c=20
TorqueStructSlice_int32_ConstReference_int32_0 NewOffHeapConstSlice_int32_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_startPointer, TNode<IntPtrT> p_length) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<TaggedIndex> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<IntPtrT> tmp2;
  TNode<IntPtrT> tmp3;
  TNode<IntPtrT> tmp4;
  TNode<Object> tmp5;
  TNode<IntPtrT> tmp6;
  TNode<IntPtrT> tmp7;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = kZeroBitPattern_0(state_);
    tmp1 = Convert_RawPtr_RawPtr_int32_0(state_, TNode<RawPtrT>{p_startPointer});
    tmp2 = Convert_intptr_RawPtr_0(state_, TNode<RawPtrT>{tmp1});
    tmp3 = FromConstexpr_intptr_constexpr_int31_0(state_, kHeapObjectTag);
    tmp4 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp2}, TNode<IntPtrT>{tmp3});
    std::tie(tmp5, tmp6, tmp7) = (TorqueStructSlice_int32_ConstReference_int32_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp4}, TNode<IntPtrT>{p_length}, TorqueStructUnsafe_0{}}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructSlice_int32_ConstReference_int32_0{TNode<Object>{tmp5}, TNode<IntPtrT>{tmp6}, TNode<IntPtrT>{tmp7}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=539&c=19
TorqueStructReference_intptr_0 NewOffHeapReference_intptr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_ptr) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<TaggedIndex> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<IntPtrT> tmp2;
  TNode<IntPtrT> tmp3;
  TNode<IntPtrT> tmp4;
  TNode<Object> tmp5;
  TNode<IntPtrT> tmp6;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = kZeroBitPattern_0(state_);
    tmp1 = Convert_RawPtr_RawPtr_intptr_0(state_, TNode<RawPtrT>{p_ptr});
    tmp2 = Convert_intptr_RawPtr_0(state_, TNode<RawPtrT>{tmp1});
    tmp3 = FromConstexpr_intptr_constexpr_int31_0(state_, kHeapObjectTag);
    tmp4 = CodeStubAssembler(state_).IntPtrAdd(TNode<IntPtrT>{tmp2}, TNode<IntPtrT>{tmp3});
    std::tie(tmp5, tmp6) = (TorqueStructReference_intptr_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp4}, TorqueStructUnsafe_0{}}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_intptr_0{TNode<Object>{tmp5}, TNode<IntPtrT>{tmp6}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=556&c=19
TorqueStructReference_intptr_0 NewReference_intptr_0(compiler::CodeAssemblerState* state_, TNode<Object> p_object, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Object> tmp0;
  TNode<IntPtrT> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    std::tie(tmp0, tmp1) = (TorqueStructReference_intptr_0{TNode<Object>{p_object}, TNode<IntPtrT>{p_offset}, TorqueStructUnsafe_0{}}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_intptr_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp1}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=590&c=8
TorqueStructReference_float64_0 RefCast_float64_0(compiler::CodeAssemblerState* state_, TorqueStructReference_intptr_0 p_i) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Object> tmp0;
  TNode<IntPtrT> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    std::tie(tmp0, tmp1) = NewReference_float64_0(state_, TNode<Object>{p_i.object}, TNode<IntPtrT>{p_i.offset}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_float64_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp1}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=665&c=4
TorqueStructReference_int32_0 GetRefAt_int32_RawPtr_intptr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_int32_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_int32_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=666&c=4
TorqueStructReference_bool_0 GetRefAt_bool_RawPtr_intptr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_bool_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_bool_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=667&c=4
TorqueStructReference_RawPtr_0 GetRefAt_RawPtr_RawPtr_intptr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_RawPtr_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_RawPtr_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=668&c=4
TorqueStructReference_intptr_0 GetRefAt_intptr_RawPtr_intptr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_intptr_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_intptr_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=671&c=4
TorqueStructReference_RawPtr_intptr_0 GetRefAt_RawPtr_intptr_RawPtr_intptr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_RawPtr_intptr_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_RawPtr_intptr_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=698&c=23
TNode<Int32T> Convert_int32_int16_0(compiler::CodeAssemblerState* state_, TNode<Int16T> p_i) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  if (block0.is_used()) {
    ca_.Bind(&block0);
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TNode<Int32T>{p_i};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=777&c=11
TorqueStructReference_float32_0 GetRefAt_float32_RawPtr_intptr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_float32_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_float32_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=781&c=11
TorqueStructReference_float64_0 GetRefAt_float64_RawPtr_intptr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_float64_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_float64_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=798&c=23
TorqueStructReference_uintptr_0 GetRefAt_uintptr_RawPtr_uintptr_0(compiler::CodeAssemblerState* state_, TNode<RawPtrT> p_base, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<RawPtrT> tmp0;
  TNode<RawPtrT> tmp1;
  TNode<Object> tmp2;
  TNode<IntPtrT> tmp3;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    tmp0 = CodeStubAssembler(state_).RawPtrAdd(TNode<RawPtrT>{p_base}, TNode<IntPtrT>{p_offset});
    tmp1 = (TNode<RawPtrT>{tmp0});
    std::tie(tmp2, tmp3) = NewOffHeapReference_uintptr_0(state_, TNode<RawPtrT>{tmp1}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_uintptr_0{TNode<Object>{tmp2}, TNode<IntPtrT>{tmp3}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=861&c=20
TorqueStructReference_int32_0 RefCast_int32_0(compiler::CodeAssemblerState* state_, TorqueStructReference_intptr_0 p_i) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Object> tmp0;
  TNode<IntPtrT> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    std::tie(tmp0, tmp1) = NewReference_int32_0(state_, TNode<Object>{p_i.object}, TNode<IntPtrT>{p_i.offset}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_int32_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp1}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=865&c=20
TorqueStructReference_float32_0 RefCast_float32_0(compiler::CodeAssemblerState* state_, TorqueStructReference_intptr_0 p_i) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Object> tmp0;
  TNode<IntPtrT> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    std::tie(tmp0, tmp1) = NewReference_float32_0(state_, TNode<Object>{p_i.object}, TNode<IntPtrT>{p_i.offset}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_float32_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp1}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=145&c=10
TorqueStructReference_float32_0 NewReference_float32_0(compiler::CodeAssemblerState* state_, TNode<Object> p_object, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Object> tmp0;
  TNode<IntPtrT> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    std::tie(tmp0, tmp1) = (TorqueStructReference_float32_0{TNode<Object>{p_object}, TNode<IntPtrT>{p_offset}, TorqueStructUnsafe_0{}}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_float32_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp1}, TorqueStructUnsafe_0{}};
}

// https://source.chromium.org/chromium/chromium/src/+/main:v8/src/builtins/js-to-wasm.tq?l=145&c=10
TorqueStructReference_int64_0 NewReference_int64_0(compiler::CodeAssemblerState* state_, TNode<Object> p_object, TNode<IntPtrT> p_offset) {
  compiler::CodeAssembler ca_(state_);
  compiler::CodeAssembler::SourcePositionScope pos_scope(&ca_);
  compiler::CodeAssemblerParameterizedLabel<> block0(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
  compiler::CodeAssemblerParameterizedLabel<> block2(&ca_, compiler::CodeAssemblerLabel::kNonDeferred);
    ca_.Goto(&block0);

  TNode<Object> tmp0;
  TNode<IntPtrT> tmp1;
  if (block0.is_used()) {
    ca_.Bind(&block0);
    std::tie(tmp0, tmp1) = (TorqueStructReference_int64_0{TNode<Object>{p_object}, TNode<IntPtrT>{p_offset}, TorqueStructUnsafe_0{}}).Flatten();
    ca_.Goto(&block2);
  }

    ca_.Bind(&block2);
  return TorqueStructReference_int64_0{TNode<Object>{tmp0}, TNode<IntPtrT>{tmp1}, TorqueStructUnsafe_0{}};
}

} // namespace internal
} // namespace v8
